const vscode = require('vscode');

function activate(context) {
  const status = vscode.window.createStatusBarItem(vscode.StatusBarAlignment.Right, 100);
  context.subscriptions.push(status);

  function update() {
    const wsConfig = vscode.workspace.getConfiguration();
    const runonsave = wsConfig.get('emeraldwalk.runonsave');
    if (runonsave) {
      status.text = 'Auto-compile: On';
      status.color = 'lightgreen';
      status.tooltip = 'Auto-compile on save is enabled (click to toggle)';
    } else {
      status.text = 'Auto-compile: Off';
      status.color = undefined;
      status.tooltip = 'Auto-compile on save is disabled (click to toggle)';
    }
    status.show();
  }

  update();

  const disposable = vscode.workspace.onDidChangeConfiguration(e => {
    if (e.affectsConfiguration('emeraldwalk.runonsave') || e.affectsConfiguration('amiga.compilerImage')) {
      update();
    }
  });
  context.subscriptions.push(disposable);

  const toggleCommand = 'autoCompileStatus.toggle';
  context.subscriptions.push(vscode.commands.registerCommand(toggleCommand, async () => {
    try {
      await vscode.commands.executeCommand('workbench.action.tasks.runTask', 'Toggle auto-compile');
    } catch (err) {
      vscode.window.showErrorMessage('Failed to run Toggle auto-compile task: ' + String(err));
    }
  }));

  status.command = toggleCommand;
}

function deactivate() {}

module.exports = { activate, deactivate };
