// Sprite-Analyse
// 4 Steuerbytes
// 1. Steuerbyte VSTART    --> SPRxPOS H  (sprite control word)
// 2. Steuerbyte HSTART    --> SPRxPOS L
// 3. Steuerbyte VSTOP     --> SPRxCTL H 
// 4. Steuerbyte Control   --> SPRxCTL L

int VSTART;     // 15-08 SV7-SVO Start vertical value. High bit (SV8) is in SPRxCTL reg below.
int HSTART;     // 07-00 SH8-SH1 Start horizontal value. Low bit(SHO) is in SPRxCTL reg. below.
int VSTOP;      // 15-08 End (stop) vert. value. low 8 bits
int Control;    // 07-00
int SV8;
int EV8;
int SH0;
int ATT;

// Bits 15-8  EV7-EVO the low 8 bits of VSTOP
// Bit 7      Sprite attach control bit (odd sprites)
// Bits 6-3   Not used unused (make zero)
// Bit 2      SV8 the VSTART high bit (Start vert. value high bit)
// Bit 1      EV8 the VSTOP high bit (End (stop) vert. value high bit)
// Bit 0      SH0 the HSTART low bit (Start horiz. value Low bit)
// attached bit immer in ungerade sprites

void setup() { 
  parser(); 
  ausgabe();
}

void parser(){ 
// ---------------------------hier ändern !!!-----------------------------------------
  //String copperinstr = "30B5 3100";    // Eingabe als "50B8 5D00" von >sp 6a55c
  String copperinstr = "1a80 3880";
//------------------------------------------------------------------------------------     
  VSTART = unhex(copperinstr.substring(0, 2));     //println(hex(VSTART,2)); 
  HSTART = unhex(copperinstr.substring(2, 4));     //println(hex(HSTART,2));
  VSTOP = unhex(copperinstr.substring(5, 7));      //println(hex(VSTOP,2));
  Control = unhex(copperinstr.substring(7, 9));    //println(hex(Control,2));  
 }
 
// 15-08 SV7-SVO Start vertical value. High bit (SV8)
// 07-00 SH8-SH1 Start horizontal value. Low bit (SHO)
// EV7-EVO the low 8 bits of VSTOP. High bit (EV8)
  
void ausgabe(){
    int vertStop=0; int vertStart=0;  println("Sprite-Analyse");    

  if ((Control & 0x01) == 0x01)   // Bit 0      SH0 the HSTART low bit (Start horiz. value Low bit)
    println("StartX --> HSTART = "+int((HSTART)+1)+"  "+hex((int(HSTART)+1),3));
  else   println("StartX --> HSTART = "+int(HSTART)+"  "+hex(int(HSTART),3));
 
  if ((Control & 0x04) == 0x04) { // Bit 2      SV8 the VSTART high bit (Start vert. value high bit)  
    println("StartY --> VSTART = "+int(VSTART+255)+"  "+hex(int(VSTART+255),3)); vertStart=int(VSTART+255);}
  else { println("StartY --> VSTART = "+VSTART+"  "+hex(int(VSTART),3)); vertStart=int(VSTART);}
     
    if ((Control & 0x02) == 0x02) { // Bit 1     EV8 the VSTOP high bit (End (stop) vert. value high bit)
    println("EndY   -->  VSTOP = "+int(VSTOP+255)+"  "+hex(int(VSTOP+255),3)); vertStop=int(VSTOP+255);} 
  else { println("EndY   -->  VSTOP = "+VSTOP+"  "+hex(int(VSTOP),3));vertStop=int(VSTOP); }
  
  if ((Control & 0x80) == 0x80)  // Bit 7      Sprite attach control bit (odd sprites)
   println("Attached = 1");  else    println("Attached = 0");  
 
   println("Spritehöhe="+(vertStop-vertStart));  
}
