// Zyklenberechner
// by Göran Strack

static int [][] blit_cycle_diagram = {
  { 2, 0, 0, 0, 0 }, /* 0   -- */
  { 2, 0, 0, 0, 4 }, /* 1   -D */
  { 2, 0, 3, 0, 3 }, /* 2   -C */
  { 3, 0, 3, 0, 0, 3, 4 }, /* 3  -CD */
  { 3, 0, 2, 0, 0, 2, 0 }, /* 4  -B- */
  { 3, 0, 2, 0, 0, 2, 4 }, /* 5  -BD */
  { 3, 0, 2, 3, 0, 2, 3 }, /* 6  -BC */
  { 4, 0, 2, 3, 0, 0, 2, 3, 4 }, /* 7 -BCD */
  { 2, 1, 0, 1, 0 }, /* 8   A- */
  { 2, 1, 0, 1, 4 }, /* 9   AD */
  { 2, 1, 3, 1, 3 }, /* A   AC */
  { 3, 1, 3, 0, 1, 3, 4, }, /* B  ACD */
  { 3, 1, 2, 0, 1, 2, 0 }, /* C  AB- */
  { 3, 1, 2, 0, 1, 2, 4 }, /* D  ABD */
  { 3, 1, 2, 3, 1, 2, 3 }, /* E  ABC */
  { 4, 1, 2, 3, 0, 1, 2, 3, 4 }  /* F ABCD */
};

static int[][] bitplane_cycle_diagram_lowres ={
  {  0, 0, 0, 0, 0, 0, 0, 0 }, // 0-Bitplane
  {  0, 0, 0, 0, 0, 0, 0, 1 }, // 1-Bitplane
  {  0, 0, 0, 2, 0, 0, 0, 1 }, // 2-Bitplane
  {  0, 0, 0, 2, 0, 3, 0, 1 }, // 3-Bitplane
  {  0, 4, 0, 2, 0, 3, 0, 1 }, // 4-Bitplane
  {  0, 4, 0, 2, 0, 3, 5, 1 }, // 5-Bitplane
  {  0, 4, 6, 2, 0, 3, 5, 1 }, // 6-Bitplane
};

static int[][] bitplane_cycle_diagram_hires ={
  {  0, 0, 0, 1, 0, 0, 0, 1 }, // 0-Bitplane
  {  0, 0, 0, 1, 0, 0, 0, 1 }, // 1-Bitplane
  {  0, 2, 0, 1, 0, 2, 0, 1 }, // 2-Bitplane
  {  0, 2, 3, 1, 0, 2, 3, 1 }, // 3-Bitplane
  {  4, 2, 3, 1, 4, 2, 3, 1 }, // 4-Bitplane
};

static int[][] sprite_anzahl={
   {  0, 0, 0, 0, 0, 0, 0, 0 }, // 0-Sprites
   {  1, 0, 0, 0, 0, 0, 0, 0 }, // 1-Sprites
   {  1, 1, 0, 0, 0, 0, 0, 0 }, // 2-Sprites
   {  1, 1, 1, 0, 0, 0, 0, 0 }, // 3-Sprites
   {  1, 1, 1, 1, 0, 0, 0, 0 }, // 4-Sprites
   {  1, 1, 1, 1, 1, 0, 0, 0 }, // 5-Sprites
   {  1, 1, 1, 1, 1, 1, 0, 0 }, // 6-Sprites
   {  1, 1, 1, 1, 1, 1, 1, 0 }, // 7-Sprites
   {  1, 1, 1, 1, 1, 1, 1, 1 }, // 8-Sprites
};

static int[][] disk_anzahl={
   {  0, 0, 0 }, // 0-Disk
   {  1, 0, 0 }, // 1-Disk
   {  1, 1, 0 }, // 2-Disk
   {  1, 1, 1 }, // 3-Disk  
};

static int[][] audio_anzahl={
   {  0, 0, 0, 0 }, // 0-Audio
   {  1, 0, 0, 0 }, // 1-Audio
   {  1, 1, 0, 0 }, // 2-Audio
   {  1, 1, 1, 0 }, // 3-Audio
   {  1, 1, 1, 1 }, // 4-Audio
};


/*
ungerade Zyklen: laut WinUAE (abweichend zu HRM)

Refresh:
R0 - $3  - 3
R1 - $5  - 5
R2 - $7  - 7
R3 - $9  - 9

Disk:
D1 - $B  - 11
D2 - $D  - 13 
D3 - $F  - 15

Audio:
A1 - $11 - 17
A2 - $13 - 19
A3 - $15 - 21
A4 - $17 - 23

Sprite: 
S0 - 25,27 $19,$1B wait: dc.w vv09,$fffe (latest wait with three copper-moves)
S1 - 29,31 $1D,$1F wait: dc.w vv(09+4*n),$fffe
S2 - 33,35 $21,$23
S3 - 37,39 $25,$27
S4 - 41,43 $29,$2B
S5 - 45,47 $2D,$2F
S6 - 49,51 $31,$33
S7 - 53,55 $35,$37
*/

void setup() {  
  size(100, 100);  
  blitter_cpu_bitplane_zyklen_alles();
}


void blitter_cpu_bitplane_zyklen_alles() {
// Eingaben erforderlich------------------------------------------------------------------
    int zyklen_gesamt=4*227;                                 // 227 um eine Scanlinie zu untersuchen
    int use_bpl=5;                                         // Anzahl Bitebenen von 0 bis 6
    int use_code = 15;                                      // Kanalkombination A,B,C,D
    int blitpri=0;                                         // Blitter Priorität  0 oder 1
    
    int coppersize=10;                                      // Anzahl Wörter der Copperliste    
    int blitsize=640;                                      // Größe des Blitts (zu lesende Wörter)   
    int cpusize=29;                                        // Anzahl Speicherzugriffe
        
    int copper_pro_line=1;                                 // Copperbefehle pro Scanlinie
    int disk_pro_line=1;
    int audio_pro_line=1;    
    int sprite_pro_line=1;                                 // z.B. Höhe 16
    
    int bitplane_pro_line=1;                               // z.B. 256 Zeilen
    int N_Gruppen=20;                                      // N-Pixelgruppen 20*16Pixel=320Pixel   
    int ddfstrt=56+1;                                      // DDFSTRT $38=56
    
    
// Variablen für Display/ Bitebenen-------------------------------------------------------   
    int bpl_cycle=0;                                       // Nr. der Bitplane die diesen Zyklus Zugriff hat von BPL1 bis BPL6  
    int dma_cycle=0;                                       // pro Bitplane Gruppe (16Pixel = 8 Zugriffe auf Bus) 
    int zyklus_besetzt=0;                                  // Zustand wenn Zyklus von höherem DMA besetzt ist
    int N=N_Gruppen;                                       // gilt für Displaybereich also jede Zeile neu setzen 
    int N_flag=0;                                          // für Anzeige wenn neue Pixel Gruppe
    int pixelgruppe=0;
    
// Variablen für Display/ Bitebenen-------------------------------------------------------      
    int anzahl_kanaele=blit_cycle_diagram[use_code][0];    // gibt Anzahl der Zyklen der Kombination (erster Wert)
    int kanal=1;                                           // es fängt immer mit dem ersten Kanal an bzw. idle
    int pipeline_phase = 0;                                // 0 - für Startphase, danach 1 - für "normale" Pipelinephase 
    int blitter_cycle;                                     // 0 - idle, 1-A, 2-B, 3-C, 4-D 
    
// Variablen für Zaehler/Counter------------------------------------------------------- 
    int zykluszaehler=0;
    int wartezyklen=0;     
    int cpu_count=0;
    int blitter_count=0;
    int bitplane_count=0;
    int scanline_count=0;
    int scanline_dma_nr=0;                                  // von  0 bis 226   d.h.227
    
    int cpu_flag=0;                                         // wenn CPU Ende erreicht = 1 
    int bf_flag=0;                                          // wenn Blitter Ende erreicht = 1   
    int i2=0;
    
    String text="";                                         // hier soll der gesamt Text rein
    String[] textf = new String[zyklen_gesamt+7+2] ;        // test field
    
    for(int i=0;i<zyklen_gesamt+7+2;i++){
      textf[i]="";
    }
    
//-----------------------------------------------------------------------  
// gegeben:
    text = "--- Zyklusberechner ---";   textf[0] = text;
    text = "CPU_Size ="+cpusize;        textf[1] = text;
    text = "Blitter_Size ="+blitsize;   textf[2] = text;
    text = "use_bpl ="+use_bpl;         textf[3] = text;
    text = "use_code ="+use_code;       textf[4] = text;
    text = "Blipri = "+blitpri;         textf[5] = text;
    text = "-------------------------------------------------"; textf[6] = text;   
//-----------------------------------------------------------------------  
    for (int i=0; i<zyklen_gesamt; i++) {                 // Schleife über Gesamtzyklen      
      text = "cy: "+ i + "\t Rz: " + scanline_count+ "\t  DMA: "+ scanline_dma_nr + "\t Hex " + hex(scanline_dma_nr,2); 
      print(text);      
      textf[i+7] = text;
      
      wartezyklen++;            // für CPU (entweder 2 oder 5)
      zykluszaehler++;          // Gesamtzyklen
      scanline_dma_nr++;        // 0 bis 226 (227 - eine Rasterzeile)
      
//----------------------------------------------------------------------- 
// refresh (3,5,7,9)
    int k=scanline_dma_nr-1;                          // -1 um mit dem Zyklus synchron zu sein
    if((k==3)||(k==5)||(k==7)||(k==9)){
      text= "\t  REF "; textf[i+7] += text;
      print(text); zyklus_besetzt=1;
    }
//----------------------------------------------------------------------- 
// Copper nur alle geraden Zyklen bis Aufgabe erledigt
  if (zyklus_besetzt==0) {
    if ((i%2 == 0) && (coppersize>0)){
      text= "\t  COP "; textf[i+7] += text;
      print(text); zyklus_besetzt=1; coppersize--;
    }    
  }
//----------------------------------------------------------------------- 
// Disk-DMA (11,13,15)
  if (zyklus_besetzt==0) {
     k=scanline_dma_nr-1;                          // -1 um mit dem Zyklus synchron zu sein
     //if((i==11)||(i==13)||(i==15)){              // nicht im Focus
      //print("  Disk_Zyklus "); zyklus_besetzt=1;      
    //}    
  }

//----------------------------------------------------------------------- 
// Audio-DMA  (17,19,21,23)
    if (zyklus_besetzt==0) {
      k=scanline_dma_nr-1;                          // -1 um mit dem Zyklus synchron zu sein
      //if((i==17)||(i==19)||(i==21)||(i==23)){     // nicht im Focus 
      //print("  Audio_Zyklus "); zyklus_besetzt=1;      
    //}    
  }

//----------------------------------------------------------------------- 
// Bitplane-DMA
    if ((zyklus_besetzt==0) && (scanline_dma_nr>=ddfstrt)) {
      if ((N>0)&(use_bpl>0)){
        bpl_cycle=bitplane_cycle_diagram_lowres[use_bpl][dma_cycle];
      if (bpl_cycle>0) {
        text= "\t  BPL " + bpl_cycle; textf[i+7] += text;
        print(text); zyklus_besetzt=1; bitplane_count++;
        } 
      }
      dma_cycle++;
      if (dma_cycle>7) { 
        if (N>0) {N_flag=1;} //print("       N: "+N);}  // wenn Gruppe vollständig        
        dma_cycle=0; N--; pixelgruppe++;
      }      
   } 
    
//-----------------------------------------------------------------------    
// Sprite-DMA (25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55)

 if (zyklus_besetzt==0) {
      k=scanline_dma_nr-1;                          // -1 um mit dem Zyklus synchron zu sein
      //if((i==?)||(i==?)||(i==?)){                 // nicht im Focus 
      //print("  Sprite_Zyklus "); zyklus_besetzt=1;      
    //}    
  }

//-----------------------------------------------------------------------    
// CPU/ Blitter

      if ((zyklus_besetzt==0) && (blitsize>0)){          
        if ((wartezyklen >=5) && (blitpri==0)) {        // wenn mehr als 5 Zyklen gewartet wurde und der Bus frei ist  
          text= "\t  CPU gewartet: " + wartezyklen; textf[i+7] += text;
          print(text); zyklus_besetzt=1; wartezyklen=0; cpu_count++; cpusize--;          
        } else {                                         // ansonsten erhält der Blitter Zugriff, wenn der Bus frei ist 
          blitter_cycle = blit_cycle_diagram[use_code][anzahl_kanaele*pipeline_phase+kanal]; 
          text= "\t  BLT "+ blitter_cycle; textf[i+7] += text;
          print(text); zyklus_besetzt=1; blitter_count++; blitsize--; 
          kanal++;
          if (kanal>anzahl_kanaele) {
            kanal=1; 
            pipeline_phase=1;
        }
         if (blitter_cycle == 0) {                    // Wartezyklen können von CPU genutzt werden
            if (wartezyklen>1) {
              text= " frei für CPU, gewartet: "+ wartezyklen; textf[i+7] += text; 
              print(text); wartezyklen=0; cpu_count++; cpusize--;  blitter_count--; blitsize++;              
            }
          }          
        }
      }
          
//-----------------------------------------------------------------------    
// CPU ohne Blitter
      if (zyklus_besetzt==0) { 
        if (wartezyklen>1) {
            text= "\t  CPU, gewartet: "+ wartezyklen; textf[i+7] += text; 
              print(text); wartezyklen=0; cpu_count++; cpusize--;              
            }        
      }
//----------------------------------------------------------------------- 
      if (blitsize==0) {bf_flag=1; blitsize--;}
      if (cpusize==0) {cpu_flag=1; cpusize--; }
// Extrazeichen für  DDFSTRT, N, Blitter Ende, CPU Ende
      if (ddfstrt==scanline_dma_nr) {text= "\t DDFSTRT"; textf[i+7] += text; print(text);}
      if (N_flag==1) {text= "\t 16 Pixelgruppe="+pixelgruppe;  textf[i+7] += text; print(text); N_flag=0;}   
      
      if ((bf_flag==1) && (bf_flag==1)) {text= "\t Blitter Ende-------------------------------"; textf[i+7] += text; print(text); bf_flag=0; }
      if (cpu_flag==1) {text= "\t CPU Ende-------------------------------"; textf[i+7] += text; print(text); cpu_flag=0; }      
//-----------------------------------------------------------------------      
      println("");  zyklus_besetzt=0;   
      if(scanline_dma_nr>226) {scanline_dma_nr = 0; scanline_count++; N=N_Gruppen; pixelgruppe=0; dma_cycle=0; bpl_cycle=0;}
      
      if((blitsize <0) || (cpusize<0)) {break;}    // einer ist eher fertig
      //if((blitsize <0))  {break;}                  // Blitter ist eher fertig
      //if((blitsize <0) && (cpusize<0)) {break;}    // beide sind fertig   
      i2=i;
    } // for
    
//Ende---------------------------------------------------
    text = "Das waren: " + cpu_count +" CPU Speicherzugriffe, " + blitter_count + " Blitter Speicherzugriffe, " + bitplane_count + " Bitplane Speicherzugriffe "; textf[i2+7+1] = text;  println(text);
    cpusize++; blitsize++;
    text = "Blitter-Speicherzugriffe übrig: " + blitsize +"            CPU-Speicherzugriffe übrig: " + cpusize; textf[i2+7+2] = text;  println(text);
       
    saveStrings("Zyklenberechner.txt", textf);
  
} // void

/*
void draw(){ }  
*/
