// Bsp. Würfel-Wireframe, inkl. Tiefe verstellen
int xt=0; int yt=0; int zt=0;    // Translationswerte die zu den XYZ-Koordinaten addiert werden
int flag_xt=0; int xdir; int x_geschw=2; int xt_max=100; int xt_min=-100;
int flag_yt=0; int ydir; int y_geschw=2; int yt_max=100; int yt_min=-100;
int flag_zt=0; int zdir; int z_geschw=2; int zt_max=50; int zt_min=-50;
float winkel_x=0; float winkel_y=0; float winkel_z=0; 
int winkel_x_geschw=2; int winkel_y_geschw=2; int winkel_z_geschw=2; 
int prevmeineSekunde = 0;

/*
CubeObject:  ; Mega Simple Mythical Cube, 8 Punkte.
; Hier sind die 8 Punkte, die durch die Koordinaten X, Y, Z definiert sind.

  dc.w  -50,-50,-50  ; P0 (X,Y,Z)
  dc.w  +50,-50,-50  ; P1 (X,Y,Z)
  dc.w  +50,+50,-50  ; P2 (X,Y,Z)
  dc.w  -50,+50,-50  ; P3 (X,Y,Z)
  dc.w  -50,-50,+50  ; P4 (X,Y,Z)
  dc.w  +50,-50,+50  ; P5 (X,Y,Z)
  dc.w  +50,+50,+50  ; P6 (X,Y,Z)
  dc.w  -50,+50,+50  ; P7 (X,Y,Z)

NPuntiOggetto  = 8
*/

// 8 Ecken, 3 Koordinaten x,y,z
float [][] wuerfel3D ={
   {  -50,-50,-50 }, // P0 (X,Y,Z)
   {   50,-50,-50 }, // P1 (X,Y,Z)
   {  +50,+50,-50 }, // P2 (X,Y,Z)
   {  -50,+50,-50 }, // P3 (X,Y,Z)  
   {  -50,-50,+50 }, // P4 (X,Y,Z)
   {  +50,-50,+50 }, // P5 (X,Y,Z)
   {  +50,+50,+50 }, // P6 (X,Y,Z)
   {  -50,+50,+50 }, // P7 (X,Y,Z)
};


float [][] wuerfel3D_rot ={            // beinhaltet die rotierten Koordinaten
   {  -50,-50,-50 }, // P0 (X,Y,Z)
   {   50,-50,-50 }, // P1 (X,Y,Z)
   {  +50,+50,-50 }, // P2 (X,Y,Z)
   {  -50,+50,-50 }, // P3 (X,Y,Z)  
   {  -50,-50,+50 }, // P4 (X,Y,Z)
   {  +50,-50,+50 }, // P5 (X,Y,Z)
   {  +50,+50,+50 }, // P6 (X,Y,Z)
   {  -50,+50,+50 }, // P7 (X,Y,Z)
};



int NPunkteObjekt = 8;  // 8 Ecken

float [][] wuerfel2D = new float[8][2];
int connect[][]={
  {0,1}, {1,2}, {2,3}, {3,0}, // Fläche vorn
  {4,5}, {5,6}, {6,7}, {7,4}, // Fläche hinten
  {0,4}, {1,5}, {2,6}, {3,7}, // Seitenflächen 
};


void setup() {  
  size(320,256);   //<>//
  frameRate(30);
}

void draw(){
  //int meineSekunde = second();  
  //if (prevmeineSekunde != meineSekunde)
  {
  
  background(0);  
  winkel();
  rotation();
  //translation();      // P4 - verschiebt den Körper im Raum
  perspektive();      // P1 - Berechnung der XY-Koordinaten aus den XYZ-Koordinaten
  kanten();           // P2 - ein Würfel hat 8 Ecken, 6 Flächen und 12 Kanten - die Verbindungen der einzelnenen Ecken 
  //prevmeineSekunde=meineSekunde;
  }
}

void mousePressed()
{
switch(mouseButton)
 {
case LEFT:
  zdir=-1; flag_zt=1; break;
case RIGHT:
  zdir=1; flag_zt=1; break;
 }
}

void winkel(){
 // Funktion sin() arbeitet mit Bogenmass // 360°=2*Pi  (2*Pi=6,28)=
 winkel_x=winkel_x+0.005*winkel_x_geschw;
 winkel_y=winkel_y+0.005*winkel_y_geschw;
 winkel_z=winkel_z+0.005*winkel_z_geschw;
}

/*
2) Erhalten Sie den SINUS und KOSINUS der 3 Winkel,  
   Berechnungen für die Rotation erforderlich: 

* rotation az
* x1 = x0*cos(az) - y0*sin(az)
* y1 = x0*sin(az) + y0*cos(az) 
* z1 = z0

* rotation ax
* y2 = y1*cos(ax) - z1*sin(ax)
* z2 = y1*sin(ax) + z1*cos(ax)
* x2 = x1

* rotation ay
* z3 = z2*cos(ay) - x2*sin(ay)
* x3 = z2*sin(ay) + x2*cos(ay)
* y3 = y2

*/

void rotation(){
  // Eingang Koordinaten X,Y,Z des Punktes als x0,y0,z0
  // Ausgang Koordinaten X,Y,Z des Punktes als x3,y3,z3

  for(int i=0;i<NPunkteObjekt;i++){
  
  float x0=wuerfel3D[i][0];
  float y0=wuerfel3D[i][1];
  float z0=wuerfel3D[i][2];
    
  float x1 =(x0)* cos(winkel_z) - (y0)* sin(winkel_z);
  float y1 =(x0)* sin(winkel_z) + (y0)* cos(winkel_z); 
  float z1 = z0;
  
  // X rotation
  float y2 =(y1)* cos(winkel_x) - (z1)* sin(winkel_x);
  float z2 =(y1)* sin(winkel_x) + (z1)* cos(winkel_x); 
  float x2 = x1;
    
  // Y rotation
  float z3 =(z2)* cos(winkel_y) - (x2)* sin(winkel_y);
  float x3 =(z2)* sin(winkel_y) + (x2)* cos(winkel_y); 
  float y3 = y2;
  
  wuerfel3D_rot[i][0]=x3;
  wuerfel3D_rot[i][1]=y3;
  wuerfel3D_rot[i][2]=z3;  
  }
}

void translation(){
  int x_diff=mouseX-pmouseX;  int y_diff=mouseY-pmouseY;  //<>//
  xt+=x_diff; if (xt>=xt_max) {xt=xt_max; } if (xt<=xt_min) {xt=xt_min; } flag_xt=0; // println("xt "+xt);
  yt+=y_diff; if (yt>=yt_max) {yt=yt_max; } if (yt<=yt_min) {yt=yt_min; } flag_yt=0; // println("yt "+yt);
  if (flag_zt==1) { zt+=(zdir*z_geschw); if (zt>=zt_max) {zt=zt_max; } if (zt<=zt_min) {zt=zt_min; }  println("zt "+zt);  } flag_zt=0; 
}

// P1 - Berechnung der XY-Koordinaten aus den XYZ-Koordinaten
void perspektive(){

// für Perspektive
// Eingang  wuerfel3D
// Ausgang wuerfel2D
int X_Mitte_Bildschirm = 320/2;
int Y_Mitte_Bildschirm = 256/2;
int Abstand_Auge_Bildschirm = 256;

for(int i=0;i<NPunkteObjekt;i++){
  float x=wuerfel3D_rot[i][0]+xt;             // x + Translation
  float y=wuerfel3D_rot[i][1]+yt;             // y + Translation
  float z=wuerfel3D_rot[i][2]+zt;             // z + Translation
  float xp=Abstand_Auge_Bildschirm *x;    // DistSchermoOss*Xogg
  float yp=Abstand_Auge_Bildschirm *y;    // DistSchermoOss*Yogg
  float zp=Abstand_Auge_Bildschirm +z;    // Zogg+DistZossSchermo  
  xp=xp/zp;    // (DistZossSchermo*Xogg)/(Zogg+DistZossSchermo)
  yp=yp/zp;    // (DistZossSchermo*Yogg)/(Zogg+DistZossSchermo)
  xp=xp+X_Mitte_Bildschirm;             // + X Bildschirmmitte (zur Mitte)
  yp=yp+Y_Mitte_Bildschirm;             // + Y Bildschirmmitte (zur Mitte)
  wuerfel2D[i][0]=xp;
  wuerfel2D[i][1]=yp;  
 //-----------------
  plotPixel(xp,yp);
 //-----------------    
 }
}

// P2 - 12 Kanten - die Verbindungen der einzelnenen Ecken
void kanten(){
  for(int i=0; i<12;i++){     // über alle 12 Kanten (Linien) des Körpers zeichnen
    int a = connect[i][0];      // von Ecke
    int b = connect[i][1];      // zu Ecke
    float xp1 = wuerfel2D[a][0]; float yp1 = wuerfel2D[a][1];
    float xp2 = wuerfel2D[b][0]; float yp2 = wuerfel2D[b][1];
    octantLineDraw(xp1, yp1, xp2, yp2);  // Linie zeichnen
  }
}


void octantLineDraw(float x1, float y1, float x2, float y2){  
  //print("drawline: x1="+x1+" y1="+y1+" x2="+x2+" y2="+y2+"   "); 
  int octant; int octantcode; //int Sign_Bit=0;
  float dx = x2 - x1; //
  float dy = y2 - y1; //
  
  float a = (float) dy/dx; //println("a "+a);
  float fraction; 
  
  if (abs(dy) <= abs(dx)){
    if (dx < 0) {
//----------------------------------------------------   
      if (dy < 0) {
        octant = 3; octantcode = 0x1C;
        fraction = 0.5 + a;  
            while (x1 > x2){ x1 = x1 - 1;
              if (fraction < 1) {  fraction = fraction + a; }
              else { y1 = y1 - 1;  fraction = fraction + a - 1;}
              plotPixel(x1, y1);    
            }  
      }else{
        // dy >= 0
        octant = 4; octantcode = 0x14;
        fraction = 0.5 + (-a);  
            while (x1 > x2) { x1 = x1 - 1;
              if (fraction < 1)  { fraction = fraction + (-a);}
              else { y1 = y1 + 1; fraction = fraction + (-a) - 1; }
              plotPixel(x1, y1);    
            }
           }
//----------------------------------------------------
  } else {
      // dx >= 0
      if (dy < 0)   {
        octant = 0; octantcode = 0x18;
        fraction = 0.5 + (-a);  
            while (x1 < x2) { x1 = x1 + 1;
              if (fraction < 1) { fraction = fraction + (-a); }
              else { y1 = y1 - 1; fraction = fraction + (-a) - 1; }
              plotPixel(x1, y1);    
              }
      }else{
        // dy >= 0
        octant = 7; octantcode = 0x10;      
        fraction = 0.5 + a;  
            while (x1 < x2)  { x1 = x1 + 1;
              if (fraction < 1) { fraction = fraction + a; }
              else { y1 = y1 + 1; fraction = fraction + a - 1; }
              plotPixel(x1, y1);    
              }
           }
    }
               
//---------------------------------------------------- 
}else {
    // abs(dy) > abs(dx)
    if (dx < 0) {
      if (dy < 0)  {
        octant = 2; octantcode = 0x0C;
        
        fraction = 0.5 + (1/a);  
              while (y1 > y2) { y1 = y1 - 1;
                if (fraction < 1) { fraction = fraction + (1/a); }
                else { x1 = x1 - 1; fraction = fraction + (1/a) - 1; }
                plotPixel(x1, y1);    
                } 
      }else{
        // dy >= 0
        octant = 5; octantcode = 0x08;
        fraction = 0.5 + (-1/a);  
                while (y1 < y2) { y1 = y1 + 1;
                  if (fraction < 1) { fraction = fraction + (-1/a); }
                  else { x1 = x1 - 1; fraction = fraction + (-1/a) - 1; }
                  plotPixel(x1, y1);    
                } 
           }
//----------------------------------------------------
    } else {
      // dx >= 0
      if (dy < 0)  {
        octant = 1; octantcode = 0x04;
        fraction = 0.5 + (-1/a);  
              while (y1 > y2) { y1 = y1 - 1;
                if (fraction < 1) { fraction = fraction + (-1/a); }
                else { x1 = x1 + 1; fraction = fraction + (-1/a) - 1; }
                plotPixel(x1, y1);    
              }  
      }else{
        // dy >= 0
        octant = 6; octantcode = 0x0;      
        fraction =  0.5 + 1/a;  
              while (y1 < y2) { y1 = y1 + 1;
                if (fraction < 1) { fraction = fraction + 1/a; }
                else { x1 = x1 + 1; fraction = fraction + 1/a - 1; }                                                      
                plotPixel(x1, y1);    
                }
            }
     }
}
  //println("Oktant ="+octant);
}


//---------------------------------------------------------
// Punkt
//---------------------------------------------------------
void plotPixel(float x, float y){
   stroke(255,0,0);   point(x,y);    
}
