// Bsp. Würfel-Wireframe, inkl. Tiefe verstellen

/*
CubeObject:  ; Mega Simple Mythical Cube, 8 Punkte.
; Hier sind die 8 Punkte, die durch die Koordinaten X, Y, Z definiert sind.

  dc.w  -50,-50,-50  ; P0 (X,Y,Z)
  dc.w  +50,-50,-50  ; P1 (X,Y,Z)
  dc.w  +50,+50,-50  ; P2 (X,Y,Z)
  dc.w  -50,+50,-50  ; P3 (X,Y,Z)
  dc.w  -50,-50,+50  ; P4 (X,Y,Z)
  dc.w  +50,-50,+50  ; P5 (X,Y,Z)
  dc.w  +50,+50,+50  ; P6 (X,Y,Z)
  dc.w  -50,+50,+50  ; P7 (X,Y,Z)

NPuntiOggetto  = 8
*/

// 8 Ecken, 3 Koordinaten x,y,z
int [][] wuerfel3D ={
   {  -50,-50,-50 }, // P0 (X,Y,Z)
   {   50,-50,-50 }, // P1 (X,Y,Z)
   {  +50,+50,-50 }, // P2 (X,Y,Z)
   {  -50,+50,-50 }, // P3 (X,Y,Z)  
   {  -50,-50,+50 }, // P4 (X,Y,Z)
   {  +50,-50,+50 }, // P5 (X,Y,Z)
   {  +50,+50,+50 }, // P6 (X,Y,Z)
   {  -50,+50,+50 }, // P7 (X,Y,Z)
};

int NPunkteObjekt = 8;  // 8 Ecken

int [][] wuerfel2D = new int[8][2];
int connect[][]={
  {0,1}, {1,2}, {2,3}, {3,0}, // Fläche vorn
  {4,5}, {5,6}, {6,7}, {7,4}, // Fläche hinten
  {0,4}, {1,5}, {2,6}, {3,7}, // Seitenflächen 
};


void setup() {  
  size(320,256);
  perspektive();      // P1 - Berechnung der XY-Koordinaten aus den XYZ-Koordinaten
  kanten();           // P2 - ein Würfel hat 8 Ecken, 6 Flächen und 12 Kanten - die Verbindungen der einzelnenen Ecken //<>//
}

// P1 - Berechnung der XY-Koordinaten aus den XYZ-Koordinaten
void perspektive(){

// für Perspektive
// Eingang  wuerfel3D
// Ausgang wuerfel2D
int X_Mitte_Bildschirm = 320/2;
int Y_Mitte_Bildschirm = 256/2;
int Abstand_Auge_Bildschirm = 256;

for(int i=0;i<NPunkteObjekt;i++){ //<>//
  int x=wuerfel3D[i][0];                // x   // Koord. X in d0, Y in d1, Z in d2
  int y=wuerfel3D[i][1];                // y
  int z=wuerfel3D[i][2];                // z 
  int xp=Abstand_Auge_Bildschirm *x;    // DistSchermoOss*Xogg
  int yp=Abstand_Auge_Bildschirm *y;    // DistSchermoOss*Yogg
  int zp=Abstand_Auge_Bildschirm +z;    // Zogg+DistZossSchermo  
  xp=xp/zp;    // (DistZossSchermo*Xogg)/(Zogg+DistZossSchermo)
  yp=yp/zp;    // (DistZossSchermo*Yogg)/(Zogg+DistZossSchermo)
  xp=xp+X_Mitte_Bildschirm;             // + X Bildschirmmitte (zur Mitte)
  yp=yp+Y_Mitte_Bildschirm;             // + Y Bildschirmmitte (zur Mitte)
  wuerfel2D[i][0]=xp;
  wuerfel2D[i][1]=yp;  
 //-----------------
  plotPixel(xp,yp);
 //-----------------    
 }
}

// P2 - 12 Kanten - die Verbindungen der einzelnenen Ecken
void kanten(){
  for(int i=0; i<12;i++){     // über alle 12 Kanten (Linien) des Körpers zeichnen
    int a = connect[i][0];      // von Ecke
    int b = connect[i][1];      // zu Ecke
    int xp1 = wuerfel2D[a][0]; int yp1 = wuerfel2D[a][1];
    int xp2 = wuerfel2D[b][0]; int yp2 = wuerfel2D[b][1];
    octantLineDraw(xp1, yp1, xp2, yp2);  // Linie zeichnen
  }
}


void octantLineDraw(int x1, int y1, int x2, int y2){  
  print("drawline: x1="+x1+" y1="+y1+" x2="+x2+" y2="+y2+"   "); 
  int octant; int octantcode; //int Sign_Bit=0;
  int dx = x2 - x1; //
  int dy = y2 - y1; //
  
  float a = (float) dy/dx; //println("a "+a);
  float fraction; 
  
  if (abs(dy) <= abs(dx)){
    if (dx < 0) {
//----------------------------------------------------   
      if (dy < 0) {
        octant = 3; octantcode = 0x1C;
        fraction = 0.5 + a;  
            while (x1 > x2){ x1 = x1 - 1;
              if (fraction < 1) {  fraction = fraction + a; }
              else { y1 = y1 - 1;  fraction = fraction + a - 1;}
              plotPixel(x1, y1);    
            }  
      }else{
        // dy >= 0
        octant = 4; octantcode = 0x14;
        fraction = 0.5 + (-a);  
            while (x1 > x2) { x1 = x1 - 1;
              if (fraction < 1)  { fraction = fraction + (-a);}
              else { y1 = y1 + 1; fraction = fraction + (-a) - 1; }
              plotPixel(x1, y1);    
            }
           }
//----------------------------------------------------
  } else {
      // dx >= 0
      if (dy < 0)   {
        octant = 0; octantcode = 0x18;
        fraction = 0.5 + (-a);  
            while (x1 < x2) { x1 = x1 + 1;
              if (fraction < 1) { fraction = fraction + (-a); }
              else { y1 = y1 - 1; fraction = fraction + (-a) - 1; }
              plotPixel(x1, y1);    
              }
      }else{
        // dy >= 0
        octant = 7; octantcode = 0x10;      
        fraction = 0.5 + a;  
            while (x1 < x2)  { x1 = x1 + 1;
              if (fraction < 1) { fraction = fraction + a; }
              else { y1 = y1 + 1; fraction = fraction + a - 1; }
              plotPixel(x1, y1);    
              }
           }
    }
               
//---------------------------------------------------- 
}else {
    // abs(dy) > abs(dx)
    if (dx < 0) {
      if (dy < 0)  {
        octant = 2; octantcode = 0x0C;
        
        fraction = 0.5 + (1/a);  
              while (y1 > y2) { y1 = y1 - 1;
                if (fraction < 1) { fraction = fraction + (1/a); }
                else { x1 = x1 - 1; fraction = fraction + (1/a) - 1; }
                plotPixel(x1, y1);    
                } 
      }else{
        // dy >= 0
        octant = 5; octantcode = 0x08;
        fraction = 0.5 + (-1/a);  
                while (y1 < y2) { y1 = y1 + 1;
                  if (fraction < 1) { fraction = fraction + (-1/a); }
                  else { x1 = x1 - 1; fraction = fraction + (-1/a) - 1; }
                  plotPixel(x1, y1);    
                } 
           }
//----------------------------------------------------
    } else {
      // dx >= 0
      if (dy < 0)  {
        octant = 1; octantcode = 0x04;
        fraction = 0.5 + (-1/a);  
              while (y1 > y2) { y1 = y1 - 1;
                if (fraction < 1) { fraction = fraction + (-1/a); }
                else { x1 = x1 + 1; fraction = fraction + (-1/a) - 1; }
                plotPixel(x1, y1);    
              }  
      }else{
        // dy >= 0
        octant = 6; octantcode = 0x0;      
        fraction =  0.5 + 1/a;  
              while (y1 < y2) { y1 = y1 + 1;
                if (fraction < 1) { fraction = fraction + 1/a; }
                else { x1 = x1 + 1; fraction = fraction + 1/a - 1; }                                                      
                plotPixel(x1, y1);    
                }
            }
     }
}
  println("Oktant ="+octant);
}


//---------------------------------------------------------
// Punkt
//---------------------------------------------------------
void plotPixel(int x, int y){
   //fill(255, 0, 0);
   stroke(255,0,0);
   point(x,y);    
}
