
; Listing28c.s - Zeichen seriell empfangen (mit Interrupt)
; mit senden von 'A' oder 'B' oder 'C' ndern wir die Hintergrundfarbe
; ansonsten werden die Daten in einen Puffer geschrieben

	SECTION	SERIAL,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; Speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ %1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	lea		$dff000,a6			; Custom Register Base in a6
	move.l	#Copperlist,$80(a6)	; Zeiger Copperlist	
	move.w	#DMASET,$96(a6)		; DMACON - aktivieren Copper und Bitplane DMA
	;move.w	#0,$1fc(a6)			; AGA "deaktivieren"
	;move.w	#$c00,$106(a6)		; AGA "deaktivieren"
	;move.w	#$11,$10c(a6)		; AGA "deaktivieren"
	move.w  #$7fff,$9a(a6)		; INTENA - disable all interrupts
	move.w  #$7fff,$9c(a6)		; INTREQ - clear all pending interrupts
	
	move.l	BaseVBR(pc),a0	    ; in a0 ist der Wert des VBR	
	move.l	#IrqRBF,$74(a0)		; ich lege meinen Interrupt-Level 5 fest
	
Init:
	; *** SET SERIAL PORT SETTINGS
	move.w	#368,$32(a6)		; SERPER	; set baud rate (bit 15=parity bit) 9600 on PAL
	move.w  #$0800,d7			; RBF
	move.w	#$c800,$9a(a6)		; INTENA - "Exter"-Interrupt aktivieren per Level 6 ($78)	
	
Mouse:
	btst	#6,$bfe001			; Maus gedrckt? (Der Prozessor 
	bne.s	Mouse				; unterbricht die Schleife alle 10ms um die Farbe zu ndern
	
	rts							; Exit


*******************************************************************************
* In dieser Routine wird das Zeichen empfangen				                  *
*******************************************************************************

	;lea $dff000,a6			; Custom Base
	;move.w #$0800,d7		; RBF 
IrqRBF:
	move.l a0,-(a7)

	lea RxPut(pc),a0		; Anfangsadresse Buffer	
	addq.b #1,1(a0)			; Zeiger Empfangspuffer um eins erhhen fr nchstes Byte
	adda.w (a0)+,a0			; ich hole den Wert der dort steht und addiere ihn zu a0
							; und anschlieend erhhe ich noch a0 um zwei
	move.b $19(a6),d0		; SERDATR.b	
	move.b d0,(a0)			; SERDATR.b im Puffer ablegen	

	bsr		Zeichen			; empfangenes Zeichen auswerten
	move.w d7,$9c(a6)		; INTREQ - quittieren 

	move.l (a7)+, a0
	rte

RxPut: dc.w 0
RxBuf: ds.b 256

*******************************************************************************
* In dieser Routine wird das Zeichen ausgewertet			                  *
*******************************************************************************

Zeichen:	
	cmp.b	#'A',d0
	beq	Red
	cmp.b	#'B',d0
	beq	Green
	cmp.b	#'C',d0
	beq	Blue
	rts
Red:
	move.w	#$f00,Col
	rts
Green:
	move.w	#$0f0,Col
	rts
Blue:
	move.w	#$00f,Col
	rts

*******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:						
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180				; COLOR00
Col:
	dc.w	$00e				; COLOR00 blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end
