		
; Listing27h2.s - CPU/DMA-Zyklen -> Zyklenberechner

; Das Listing ist ein zusammenkopierter Haufen zum Testen der CPU/DMA-Zyklen
; mit dem WinUAE Debugger (DMA-Debugger)
; Dabei wurde nicht auf Schnheit geachtet. Auch Programmabstrze sind mglich.

; Was ist einzustellen?
; 1. DMASET-> DMASET	EQU
; 2. MOVEQ	#5-1,D1				; Anzahl der Bitplanes
; 3. cmp.l #$000001000,d0		; $10  (mit oder ohne Bitplanearea) 
; 3. bsr blit_D					; welche Blitter-Routine
; 4. das BPLCON0 ($dff100) fr einen Bildschirm mit x Bitplanes
; 5. BPLPOINTERS:

	SECTION	DMA_CYCLE,CODE

;	Include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "WO"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
;DMASET	EQU	%1000001000000000	; DMA OFF
;DMASET	EQU	%1000001001000000	; Blitter
;DMASET	EQU	%1000011001000000	; Blitter + blitpri
;DMASET	EQU	%1000001101000000	; Blitter + bitplane
;DMASET	EQU	%1000001010000000	; copper DMA aktivieren
;DMASET	EQU	%1000001110000000	; copper, bitplane DMA aktivieren
DMASET	EQU	%1000001111000000	; copper, bitplane, blitter DMA
;DMASET	EQU	%1000001111100000	; copper, bitplane, blitter, sprite DMA
;DMASET	EQU	%1000011111100000	; copper, bitplane, blitter, sprite DMA, + blitpri

WaitDisk	EQU	30				; 50-150 zur Rettung (je nach Fall)

START:
	MOVE.L	#BITPLANE,d0		; Zeiger auf die "leere" Bitplane
	LEA	BPLPOINTERS,A1			; Bitplanepointer
	MOVEQ	#2-1,D1				; Anzahl der Bitplanes (hier sind es 2)
POINTBP:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	ADD.L	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,POINTBP

;	Pointen auf die Sprite

	MOVE.L	#MEINSPRITE0,d0	; Adresse des Sprite in d0
	LEA	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE1,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE2,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE3,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE4,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE5,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE6,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	MOVE.L	#MEINSPRITE7,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; CUSTOM REGISTER in a5
	MOVE.W	#DMASET,$96(a5)		; DMACON - einschalten bitplane, copper, blitter
	move.l	#COPPERLIST,$80(a5)	; Zeiger COP
	move.w	d0,$88(a5)			; Start COP
	move.w	#0,$1fc(a5)			; AGA deaktivieren
	move.w	#$c00,$106(a5)		; AGA deaktivieren
	move.w	#$11,$10c(a5)		; AGA deaktivieren


;------------------------------------------------------------------------------
	MOVEQ	#$60,d0			; Anfangskoordinate HSTART
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
						    ; (zu Bemerken, da das Byte HSTART immer 2 Pixel
						    ; nimmt, wenn wir uns also um 10 Pixel verstellen
						    ; wollen mssen wir nur 5 zu HSTART dazuzhlen!)
	MOVE.B	d0,HSTART1
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
	MOVE.B	d0,HSTART2
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
	MOVE.B	d0,HSTART3
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
	MOVE.B	d0,HSTART4
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
	MOVE.B	d0,HSTART5
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
	MOVE.B	d0,HSTART6
	ADDQ.B	#(10/2),d0		; Abstand zum nchsten Sprite
	MOVE.B	d0,HSTART7
	
WaitWblank:
	move.l $dff004,d0
	and.l #$000fff00,d0
	cmp.l #$00006000,d0			; $50
	;cmp.l #$000001000,d0		; $10  (ohne Bitplanearea) 
	bne.s	WaitWblank

	;bsr blit_D
	;bsr blit_A_D
	;bsr blit_B_D
	;bsr blit_C_D
	;bsr blit_A_B_D
	bsr blit_A_B_C_D
	
;mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	;bne.s	mouse				; wenn nicht, gehe zurck zu mouse2
	bne.s	WaitWblank
	rts
	
******************************************************************************
; Blitter-Part
	
blit_D:	; Listing10a1.s
	btst	#6,$dff002			; warte auf das Ende des Blitters (leerer Test)
								; fr den BUG von Agnus
waitblit:
	btst	#6,$dff002			; freier Blitter?
	bne.s	waitblit

; Hier ist, wie man eine Blittata macht !!! 
; Nur 5 Anweisungen zum Zurcksetzen !!!
;	     __
;	__  /_/\   __
;	\/  \_\/  /\_\
;	 __   __  \/_/   __
;	/\_\ /\_\  __   /\_\
;	\/_/ \/_/ /_/\  \/_/
;	     __   \_\/
;	    /\_\  __
;	    \/_/  \/

	move.w	#$0100,$dff040		; BLTCON0: nur Ziel D ist aktiviert				
								; die MINTERMS (dh die Bits 0-7) sind alle
								; zurckgesetzt. Auf diese Weise ist die 
								; Lschoperation definiert					

	move.w	#$0000,$dff042		; BLTCON1: Wir werden dieses Register spter erklren
	move.l	#START1,$dff054		; BLTDPT: Adresse des Zielkanals
	move.w	#$0000,$dff066		; BLTDMOD: Wir werden dieses Register spter erklren
	move.w	#(3*64)+$20,$dff058 ; BLTSIZE: definiert die Dimension des
								; Rechtecks. In diesem Fall haben wir
								; $10 Wrter Breite und 1 Zeilenhhe.
								; Weil die Hhe des Rechtecks in die Bits 6-15 von 
								; BLTSIZE ??geschrieben wird
								; mssen wir es 6 Bits nach links verschieben.
								; Dies entspricht der Multiplikation seines Wertes
								; mit 64. Die Breite wird in die niedrigen
								; 6 Bits geschrieben und werden daher nicht
								; gendert.
								; Auerdem beginnt diese Anweisung die Blittata	
	
	rts

;------------------------------------------------------------------------------
blit_A_D:

;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm.
; Es braucht als Parameter
; A0 - Quelladresse
; A1 - Zieladresse
;****************************************************************************

;Copia: Listing10a2.s
	lea	FiguraPlane2,a0
	lea	BITPLANE2+14,a1
	;bsr.s	copia				; kopiere die zweite Bitplane, normal

	btst	#6,2(a5)			; dmaconr
WBlit1:
	btst	#6,2(a5)			; dmaconr - warte auf das Ende des Blitters
	bne.s	wblit1

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 (A+D)
								; normale Kopie
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$50(a5)			; BLTAPT  Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT  Zeiger Ziel
	move.w	#(64*25)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 word
	rts							; Hhe 25 Zeilen

;------------------------------------------------------------------------------
blit_B_D:

	lea	FiguraPlane2,a0
	lea	BITPLANE2+14,a1
	;bsr.s	copia				; kopiere die zweite Bitplane, normal

	btst	#6,2(a5)			; dmaconr
WBlit1b:
	btst	#6,2(a5)			; dmaconr - warte auf das Ende des Blitters
	bne.s	wblit1b

	;move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$05CC0000,$40(a5)	; BLTCON0 und BLTCON1 (B+D)
								; normale Kopie
	move.w	#0,$62(a5)			; BLTBMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$4c(a5)			; BLTBPT  Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT  Zeiger Ziel
	move.w	#(64*25)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 word
	rts							; Hhe 25 Zeilen

;------------------------------------------------------------------------------
blit_C_D:

	lea	FiguraPlane2,a0
	lea	BITPLANE2+14,a1
	;bsr.s	copia				; kopiere die zweite Bitplane, normal

	btst	#6,2(a5)			; dmaconr
WBlit1c:
	btst	#6,2(a5)			; dmaconr - warte auf das Ende des Blitters
	bne.s	wblit1c

	;move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$03AA0000,$40(a5)	; BLTCON0 und BLTCON1 (C+D)
								; normale Kopie
	move.w	#0,$60(a5)			; BLTCMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$48(a5)			; BLTCPT  Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT  Zeiger Ziel
	move.w	#(64*25)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 word
	rts							; Hhe 25 Zeilen

;------------------------------------------------------------------------------
blit_A_B_D: ; Listing10b2.s

	;lea	Figura2,a0
	;lea	BITPLANE1+20,a1

;****************************************************************************
; diese Routine fhrt das AND zwischen 2 Figuren auf dem Bildschirm aus
;****************************************************************************

;	        _*_
;	       /   \
;	      (_____)
;	      o_o  '\
;	     (___,   )
;	     _\_____/__
;	    /          \
;	   /  .         \
;	  /  /      Y    |
;	  X_/       |____|
;	  \(________/  /
;	   \_/      \_/\
;	 __.\   Y      /
;	 )_| \  |     /
;	.---. \_|____/
;	|TaG|_/o|o  %\_
;	|___|___|______)

BlitAND:
	btst	#6,2(a5)			; dmaconr
WBlit2:
	btst	#6,2(a5)			; dmaconr - warte auf das Ende des Blitters
	bne.s	wblit2

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$0dc00000,$40(a5)	; BLTCON0 und BLTCON1
								; benutze A, B und D
								; fhre ein AND zwischen A und B aus (LF=$C0)
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#0,$62(a5)			; BLTBMOD (=0)
	move.w	#30,$66(a5)			; BLTDMOD (40-10=30)

	move.l	#Figura1,$50(a5)	; BLTAPT Zeiger Quelle
	move.l	#Figura2,$4c(a5)	; BLTBPT Zeiger Quelle
	move.l	#BITPLANE1+100*40+10,$54(a5)	; BLTDPT Zeiger Ziel
	move.w	#(64*71)+5,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 5 word, Hhe 71 Zeilen
	rts						 

;------------------------------------------------------------------------------
blit_A_B_C_D:
	; ODER aller Bitebenen

	lea	FiguraPlane1a,a0
	lea	FiguraPlane2a,a1
	lea	FiguraPlane3a,a2
	lea	BITPLANE1+14,a3
	;bsr.s	BlitOR				; fhrt ein ODER zwischen den Ebenen der Figur durch
								; und kopiert das Ergebnis


;****************************************************************************
; Diese Routine fhrt ein ODER zwischen den 3 Kanlen A, B und C durch.
;
; A0 - Adresse Kanal A
; A1 - Adresse Kanal B
; A2 - Adresse Kanal C
; A3 - Adresse Ziel
;****************************************************************************

;	                 _____
;	                (_____)
;	                  ,,,
;	 __n____________.|o o|.____________n__
;	== _o_|         |  -  |         |_o_ ==
;	  . |   ____  |\ O /|  ____   |   
;	      |__/    \ ||`*'|| /    \_#| :
;	    :         | ||   || |      `:
;	    .         |#._______|         .
;	              ! |  o  |
;	                (     )
;	                |  U  |
;	                :  !  :

;BlitOR:
	btst	#6,2(a5)			; dmaconr
WBlit3:
	btst	#6,2(a5)			; dmaconr - warte auf das Ende des Blitters
	bne.s	wblit3

	move.l	#$FFFFFFFF,$44(a5)	; BLTFWM und BLTLWM
	move.l	#$0FFE0000,$40(a5)	; BLTCON0 und BLTCON1
								; Aktiviere alle Kanle
								; fhrt ein OR zwischen A, B und C aus
								; D=A OR B OR C
	move.w	#0,$60(a5)			; BLTCMOD (=0)
	move.w	#0,$62(a5)			; BLTBMOD (=0)
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$48(a5)			; BLTCPT  Zeiger Quelle
	move.l	a1,$4c(a5)			; BLTBPT  Zeiger Quelle
	move.l	a2,$50(a5)			; BLTAPT  Zeiger Quelle
	move.l	a3,$54(a5)			; BLTDPT  Zeiger Ziel
	move.w	#(64*42)+3,$58(a5)	; BLTSIZE (Blitter starten!)
								; Breite 3 word, Hhe 42 Zeilen
	rts

;------------------------------------------------------------------------------	


	SECTION GRAPHIC,DATA_C

PIC:
	;incbin	"/Sources/320x256x1_raster.raw"	; Bild im RAW 1 Bitplane

COPPERLIST:

	; Die Sprites lassen wir auf NULL zeigen, also pointen, um sie zu 
	; eliminieren ansonsten geistern sie umher uns stren uns nur!!!
SpritePointers:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000
	
	dc.w	$8e,$2c81	; DiwStrt	Register mit Standartwerten
	dc.w	$90,$2cc1	; DiwStop	
	dc.w	$92,$0038	; DdfStart
	dc.w	$94,$00d0	; DdfStop
	dc.w	$102,0		; BplCon1
	dc.w	$104,0		; BplCon2
	dc.w	$108,0		; Bpl1Mod
	dc.w	$10a,0		; Bpl2Mod

	; das BPLCON0 ($dff100) fr einen Bildschirm mit 1 Bitplane: (2 Farben)
				; 5432109876543210
	;dc.w	$100,%0000001000000000	;
	;dc.w	$100,%0001001000000000	; bit 12 an!!		  (1 = %001)	1 Bitplanes: (2 Farben)
	dc.w	$100,%0010001000000000	; bit 13 an!!		  (2 = %010)	2 Bitplanes: (4 Farben)
	;dc.w	$100,%0011001000000000	; bits 13 und 12 an!! (3 = %011)	3 Bitplanes: (8 Farben)
	;dc.w	$100,%0100001000000000	; bit 14 an!!		  (4 = %100)	4 Bitplanes: (16 Farben)
	;dc.w	$100,%0101001000000000	; bits 14 und 12 an!! (5 = %101)	5 Bitplanes: (32 Farben)
	;dc.w	$100,%0110001000000000	; bits 14 und 13 an!! (6 = %110)	6 Bitplanes: (64 Farben)


;	Wir lassen die Bitplanes direkt anpointen, indem wir die Register
;	$dff0e0 und folgende hier in der Copperlist einfgen. Die
;	Adressen der Bitplanes werden dann von der Routine POINTBP
;	automatisch eingetragen

BPLPOINTERS:
	dc.w $e0,$0000,$e2,$0000	; erste	Bitplane - BPL0PT
	dc.w $e4,$0000,$e6,$0000	; zweite Bitplane - BPL1PT
	;dc.w $e8,$0000,$ea,$0000	; dritte Bitplane - BPL2PT
	;dc.w $ec,$0000,$ee,$0000	; vierte Bitplane - BPL3PT
	;dc.w $f0,$0000,$f2,$0000	; fnfte Bitplane - BPL4PT
	;dc.w $f4,$0000,$f6,$0000	; sechste Bitplane - BPL5PT

	
; Die 8 Farben des Bildes werden hier definiert:
	dc.w	$0180,$000	; color0
	dc.w	$0182,$f00	; color1
	dc.w	$0184,$0f0	; color2
	dc.w	$0186,$00f	; color3
	dc.w	$0188,$999	; color4
	dc.w	$018a,$232	; color5
	dc.w	$018c,$777	; color6
	dc.w	$018e,$444	; color7


	;dc.w	$6107,$fffe
; die weiteren Farben
	dc.w	$0190,$444	; color08
	dc.w	$0192,$444	; color09
	dc.w	$0194,$444	; color10
	dc.w	$0196,$444	; color11
	dc.w	$0198,$444	; color12
	dc.w	$019a,$444	; color13
	dc.w	$019c,$444	; color14
	dc.w	$019e,$444	; color15
	dc.w	$01a0,$444	; color16
	;dc.w	$01a2,$444	; color17
	;dc.w	$01a4,$444	; color18
	;dc.w	$01a6,$444	; color19
	;dc.w	$01a8,$444	; color20
	;dc.w	$01aa,$444	; color21
	;dc.w	$01ac,$444	; color22
	;dc.w	$01ae,$444	; color23
	;dc.w	$01b0,$444	; color24
	;dc.w	$01b2,$444	; color25
	;dc.w	$01b4,$444	; color26
	;dc.w	$01b6,$444	; color27
	;dc.w	$01b8,$444	; color28
	;dc.w	$01ba,$444	; color29
	;dc.w	$01bc,$444	; color30
	;dc.w	$01be,$444	; color31
	
	dc.w	$1A2,$F00		; Color17, - Color1 der Sprite0/1 -ROT
	dc.w	$1A4,$0F0		; Color18, - Color2 der Sprite0/1 -GRN
	dc.w	$1A6,$FF0		; Color19, - Color3 der Sprite0/1 -GELB

	dc.w	$1AA,$FFF		; Color21, - Color1 der Sprite2/3 -WEI
	dc.w	$1AC,$0BD		; Color22, - Color2 der Sprite2/3 -WASSER
	dc.w	$1AE,$D50		; Color23, - Color3 der Sprite2/3 -ORANGE

	dc.w	$1B2,$00F		; Color25, - Color1 der Sprite4/5 -BLAU
	dc.w	$1B4,$F0F		; Color26, - Color2 der Sprite4/5 -VIOLETT
	dc.w	$1B6,$BBB		; Color27, - Color3 der Sprite4/5 -GRAU

	dc.w	$1BA,$8E0		; Color29, - Color1 der Sprite6/7 -HELLGRN
	dc.w	$1BC,$a70		; Color30, - Color2 der Sprite6/7 -BRAUN
	dc.w	$1BE,$d00		; Color31, - Color3 der Sprite6/7 -DUNKELROT


	dc.w	$FFFF,$FFFE			; Ende copperlist


; ************ Hier die Sprite: KLARERWEISE in CHIP RAM! ************

; Referenztabelle zur Definition der Farben:


; fr die Sprite 0 und 1
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (ROT)
; BINR 01=COLOR 2 (GRN)
; BINR 11=COLOR 3 (GELB)

MEINSPRITE0:				; Lnge: 8 Zeilen
VSTART0:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART0:
	dc.b $60				; Horizontale Pos. (von $40 bis $d8)
VSTOP0:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite


MEINSPRITE1:				; Lnge: 8 Zeilen
VSTART1:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART1:
	dc.b $60+14				; Horizontale Pos. (von $40 bis $d8)
VSTOP1:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000010001111
 dc.w	%0011111111111100,%1100000110000011
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0011111111111100,%1100000010000011
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

 ; fr die Sprite 2 und 3
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (WEI)
 ; BINR 01=COLOR 2 (WASSER)
 ; BINR 11=COLOR 3 (ORANGE)

MEINSPRITE2:				; Lnge: 8 Zeilen
VSTART2:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART2:
	dc.b $60+(14*2)			; Horizontale Pos. (von $40 bis $d8)
VSTOP2:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0011111111111100,%1100001000100011
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0111111111111110,%1000000111000001
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MEINSPRITE3:				; Lnge: 8 Zeilen
VSTART3:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART3:
	dc.b $60+(14*3)			; Horizontale Pos. (von $40 bis $d8)
VSTOP3:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0111111111111110,%1000000111100001
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0				; Ende des Sprite

 ; fr die Sprite 4 und 5
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (BLAU)
 ; BINR 01=COLOR 2 (VIOLETT)
 ; BINR 11=COLOR 3 (GRAU)

MEINSPRITE4:				; Lnge: 8 Zeilen
VSTART4:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART4:
	dc.b $60+(14*4)			; Horizontale Pos. (von $40 bis $d8)
VSTOP4:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001001001111
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MEINSPRITE5:				; Lnge: 8 Zeilen
VSTART5:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART5:
	dc.b $60+(14*5)			; Horizontale Pos. (von $40 bis $d8)
VSTOP5:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

 ; fr die Sprite 6 und 7
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (HELLGRN)
 ; BINR 01=COLOR 2 (BRAUN)
 ; BINR 11=COLOR 3 (DUNKELROT)

MEINSPRITE6:				; Lnge: 8 Zeilen
VSTART6:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART6:
	dc.b $60+(14*6)			; Horizontale Pos. (von $40 bis $d8)
VSTOP6:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000001001000001
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MEINSPRITE7:				; Lnge: 8 Zeilen
VSTART7:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
HSTART7:
	dc.b $60+(14*7)			; Horizontale Pos. (von $40 bis $d8)
VSTOP7:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite


;****************************************************************************
START1:
	dcb.b	$20,$fe
THEEND:
	dc.b	'Hier loeschen wir nicht'

	even

;****************************************************************************

FiguraPlane1:
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$c000,$0000,$0003,$c000
	dc.w	$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000
	dc.w	$0003,$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003
	dc.w	$c25c,$3bbb,$bb83,$c354,$22aa,$a283,$c2d4,$22bb,$b303,$c254
	dc.w	$22a2,$2283,$c25c,$3ba2,$3a83,$c000,$0000,$0003,$c000,$0000
	dc.w	$0003,$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003
	dc.w	$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff

FiguraPlane2:
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff

;****************************************************************************

; Das ist die Figur

FiguraPlane1a:
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,0

FiguraPlane2a:
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0

FiguraPlane3a:
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$ffffff80
	dc.l	$ffffffff,$ff80ffff,$ffffff80,$ffffffff,$ff80ffff,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$ffffffff,$ff800000,0
	
;****************************************************************************

Figura1:
	dc.w	$ffc0,0,0,$0007,$fe00,$8000,0,$1000,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$7c00,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,$0001,$ff00,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$0007,$ffc0,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$001f,$fff0,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$007f,$fffc,0,$0200,$8000,$007f,$fffc,0,$0200
	dc.w	$8000,$007f,$fffc,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$001f,$fff0,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$0007,$ffc0,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,$0001,$ff00,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$7c00,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$1000,0,$0200
	dc.w	$ffc0,0,0,$0007,$fe00

Figura2:
	dc.w	$ffff,$ffff,$ffff,$ffff,$fe00,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,$3800,0,0
	dc.w	0,$0003,$ff80,0,0,0,$001f,$fff0,0,0
	dc.w	0,$01ff,$ffff,0,0,0,$0fff,$ffff,$e000,0
	dc.w	0,$ffff,$ffff,$fe00,0,$0007,$ffff,$ffff,$ffc0,0
	dc.w	$007f,$ffff,$ffff,$fffc,0,$03ff,$ffff,$ffff,$ffff,$8000
	dc.w	$3fff,$ffff,$ffff,$ffff,$f800,$7fff,$ffff,$ffff,$ffff,$fc00
	dc.w	$3fff,$ffff,$ffff,$ffff,$f800,$03ff,$ffff,$ffff,$ffff,$8000
	dc.w	$007f,$ffff,$ffff,$fffc,0,$0007,$ffff,$ffff,$ffc0,0
	dc.w	0,$ffff,$ffff,$fe00,0,0,$0fff,$ffff,$e000,0
	dc.w	0,$01ff,$ffff,0,0,0,$001f,$fff0,0,0
	dc.w	0,$0003,$ff80,0,0,0,0,$3800,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$ffff,$ffff,$ffff,$ffff,$fe00

;****************************************************************************


BITPLANE:
BITPLANE1:
	blk.b 10240,$01		; 1. Bitplane
BITPLANE2:
	blk.b 10240,$02		; 2. Bitplane
	blk.b 10240,$04		; 3. Bitplane
	blk.b 10240,$08		; 4. Bitplane
	blk.b 10240,$10		; 5. Bitplane
	blk.b 10240,$20		; 6. Bitplane

;****************************************************************************

	SECTION	bitplane,BSS_C
BITPLANEx:
	ds.b	40*256

	end
;****************************************************************************

	