
; Listing27h.s - https://eab.abime.net/showthread.php?t=117203

Code:
;; Cycle-exact 68000 CPU screen routine / clock calculator by !ZAJC!/GDS
;; Credits to ross for the most excellent brute force nop post on EAB
;; SPDX-License-Identifier: 0BSD
;; Probably a good emulator test? Tested on real hardware
;; See you @ Revision 2024 :)

    ROSS_SCREEN=1        ; <- ultra hyper mega overscan by ross
    WANT_MOUSE=0         ; <- can click lmb to exit, minor jitter if set
    MARK_YPOS=$2A        ; <- where to show the mark
    NBPLS=0              ; <- screen colordepth in bitplanes

    IF ROSS_SCREEN        ; resolution: 376*286 + 24 px hscroll
DIWSTRT_Y        equ        $1a
DIWSTRT_X        equ        $5c
DIWSTOP_Y        equ        $38
DIWSTOP_X        equ        $c8
DDFSTRT          equ        $18
DDFSTOP          equ        $d8
    ELSE                ; resolution: 320*256 + no extra scroll
DIWSTRT_Y        equ        $2c
DIWSTRT_X        equ        $81
DIWSTOP_Y        equ        $2c
DIWSTOP_X        equ        $c1
DDFSTRT          equ        $38
DDFSTOP          equ        $d0
    ENDC
       
DIWSTRT     equ        (DIWSTRT_Y<<8)!(DIWSTRT_X)
DIWSTOP     equ        (DIWSTOP_Y<<8)!(DIWSTOP_X)
Y_END       equ        ((~DIWSTOP_Y&$80)<<1)!DIWSTOP_Y

BPL_LINES        equ  Y_END-DIWSTRT_Y				; how many lines of display?
BPL_DMA_WORDS    equ  1+((DDFSTOP-DDFSTRT)>>3)		; how many words per line will be fetched for a single bitplane:
NUM_COLOR_REGS   equ  (1<<NBPLS)-((5-NBPLS)>>3)&32	; how many color registers do we need to set for this screen?
ODD_CCKSperWORD  equ  ((NBPLS&4)*(NBPLS-4))>>2		; for each 16 pixels, how many dma fetches will fall on an odd cycle?
ODD_CCKSperLINE  equ  ODD_CCKSperWORD*BPL_DMA_WORDS	; for each line of display, how many odd cycle dma fetches do we have?
ODD_NOPSperLINE  equ  ODD_CCKSperLINE				; how many nops will we fail to do during a bitplane dma fetch per line?
PAL_LINES_LOF    equ  313							; number of long frame PAL lines (standard PAL mode setup by Kickstart)
NOT_BPL_LINES    equ  PAL_LINES_LOF-BPL_LINES		; number of lines that are not used for bitplane display
CCKS_PER_LINE    equ  227							; color clocks / dma slots per PAL line
CLKS_PER_LINE    equ  CCKS_PER_LINE*2				; CPU clock ticks per PAL line
NOPS_PER_NBLINE  equ  CLKS_PER_LINE/4				; Number of NOP instructions fitting into a non-display line
NOPS_PER_BLINE   equ  NOPS_PER_NBLINE-ODD_NOPSperLINE; Number of NOP instructions fitting into a display line
NBLINE_NOPS      equ  NOPS_PER_NBLINE*NOT_BPL_LINES	; Calculate the number of NOPs and available CPU clocks/frame
BLINE_NOPS       equ  NOPS_PER_BLINE*BPL_LINES
NOPS_PER_FRAME   equ  NBLINE_NOPS+BLINE_NOPS
CLKS_PER_FRAME   equ  NOPS_PER_FRAME*4
SETCOLORS_CLKS   equ  2*8							; count non-nop code that we have to do in each frame
JMP_IMM_CLKS     equ  12
MOUSETST_CLKS    equ  WANT_MOUSE*28
INSN_CLKS        equ  SETCOLORS_CLKS+JMP_IMM_CLKS+MOUSETST_CLKS
INSN_NOPS        equ  INSN_CLKS/4
nops             equ  NOPS_PER_FRAME-INSN_NOPS		; number of nops we will generate for our per-frame code

    SECTION        main,code_c
    moveq      #0,d2
    lea        $dff000,a6
    move.w     #$4000,$9a(a6)         ; all interrupts off
    move.w     #$03ff,$96(a6)         ; all dma off
    move.w     #$0200,$100(a6)        ; no bitplanes
    move.w     d2,$102(a6)            ; BPLCON1 <- 0
    move.w     #DIWSTRT,$8e(a6)
    move.w     #DIWSTOP,$90(a6)
    move.w     #DDFSTRT,$92(a6)
    move.w     #DDFSTOP,$94(a6)
    lea        $180(a6),a0            ; all colors to black
    moveq       #NUM_COLOR_REGS-1,d0
.all_black       
	move.w     d2,(a0)+
    dbf        d0,.all_black
    move.l     d2,$140(a6)             ; mouse sprite to 0,0
    move.w     #$8300,$96(a6)          ; turn on bitplane DMA
    move.w     #(NBPLS<<12)!$200,$100(a6)     ; NBPLS bitplanes
    move.w     #$4e71,d0               ; d0 <- NOP instruction
    move.w     #nops-1,d1              ; fill .code with NOPs
    lea        .code(pc),a0
.cn            
	move.w     d0,(a0)+
    dbf        d1,.cn
    lea        6(a6),a0                ; A0 <- VHPOSR
    lea        $180(a6),a1             ; A1 <- COLOR00
    lea        5(a6),a2                ; A2 <- lobyte of VPOSR
    lea        $bfe001,a3              ; A3 <- CIAA pra for mouse

.in_ntsc_lines        
	btst        #0,(a2)                ; wait until we pass
    beq.s        .in_ntsc_lines        ; all NTSC lines
.in_pal_lines        
	btst        #0,(a2)                ; and then PAL lines, so
    bne.s       .in_pal_lines          ; that we are at TOF here
.line           
	cmp.b        #MARK_YPOS,(a0)       ; then wait for MARK_YPOS
    bne.b        .line
    REPT        20                     ; get closer to middle
    add.l        d0,d0
    ENDR
.setcolors        
	move.w        d1,(a1)
    move.w        d2,(a1)

.code                
	ds.w        nops
    IF WANT_MOUSE
    btst        #6,(a3)
    beq.s        .exit
    ENDC
    jmp        .setcolors

.exit
    move.w        #$0080,$096(a6)     ; copper off
    move.l        $04,a5              ; a5 <- execbase
    move.l        156(a5),a5          ; blittervec
    move.l        38(a5),$080(a6)     ; restore coplist
    move.w        #$83ff, $096(a6)    ; all dma on
    move.w        #$c000, $09a(a6)    ; interrupts on
    rts
	
	end

Erklrung:

This program needs cycle-exact is set in WinUAE.

Some WinUAE debugger hints from my side:
I tested without mouse. To go back to shell/asmone I make following steps:
Shift+F12	; opens debugger
>d pc		; see the nop-code
>fi 4ef9	; debugger runs to the jmp
>g <adress> ; run further on the .exit move.w #$0080,$096(a6)

;------------------------------------------------------------------------------
>d pc
00042e4c 4e71                     nop
00042e4e 4e71                     nop
00042e50 4e71                     nop
00042e52 4e71                     nop
00042e54 4e71                     nop
00042e56 4e71                     nop
00042e58 4e71                     nop
00042e5a 4e71                     nop
00042e5c 4e71                     nop
00042e5e 4e71                     nop
;------------------------------------------------------------------------------
>f 42e52
Breakpoint added.
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 7 Chip, 14 CPU. (V=105 H=0 -> V=105 H=7)
VPOS: 105 ($069) HPOS: 007 ($007) COP: $0001ede4
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5F8B0
USP  00C5F8B0 ISP  00C608B0
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 00004E71
00042e52 4e71                     nop
Next PC: 00042e54
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 71051 Chip, 142102 CPU. (V=105 H=7 -> V=105 H=7)						; 141476 cycles
VPOS: 105 ($069) HPOS: 007 ($007) COP: $0001ede4
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5F8B0
USP  00C5F8B0 ISP  00C608B0
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 00004E71
00042e52 4e71                     nop
Next PC: 00042e54
>g
;------------------------------------------------------------------------------
Breakpoint 0 triggered.
Cycles: 71051 Chip, 142102 CPU. (V=105 H=7 -> V=105 H=7)
VPOS: 105 ($069) HPOS: 007 ($007) COP: $0001ede4
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5F8B0
USP  00C5F8B0 ISP  00C608B0
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 00004E71
00042e52 4e71                     nop
Next PC: 00042e54
;------------------------------------------------------------------------------
>fi 4ef9																		; go to the jmp
Cycles: 27639 Chip, 55278 CPU. (V=105 H=7 -> V=226 H=179)
VPOS: 226 ($0e2) HPOS: 179 ($0b3) COP: $0001ede4
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5F8B0
USP  00C5F8B0 ISP  00C608B0
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4ef9 (JMP) 0003 (OR) Chip latch 00000003
000499d0 4ef9 0003 8588           jmp $00038588
Next PC: 000499d6
;------------------------------------------------------------------------------
>fd
All breakpoints removed.
;------------------------------------------------------------------------------
>f 499d0
Breakpoint added.
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
; Cycles info line is missed now												; sometimes this happens, it needs a WinUAE restart
VPOS: 226 ($0e2) HPOS: 179 ($0b3) COP: $0001ede4
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5F8B0
USP  00C5F8B0 ISP  00C608B0
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4ef9 (JMP) 0003 (OR) Chip latch 00000003
000499d0 4ef9 0003 8588           jmp $00038588
Next PC: 000499d6
;------------------------------------------------------------------------------
>d pc
000499d0 4ef9 0003 8588           jmp $00038588
000499d6 3d7c 0080 0096           move.w #$0080,(a6,$0096) == $00dff096
000499dc 2a79 0000 0004           movea.l $00000004 [00c00276],a5
000499e2 2a6d 009c                movea.l (a5,$009c) == $0000009c [00fc0844],a5
000499e6 2d6d 0026 0080           move.l (a5,$0026) == $00000026 [082600fc],(a6,$0080) == $00dff080
000499ec 3d7c 83ff 0096           move.w #$83ff,(a6,$0096) == $00dff096
000499f2 3d7c c000 009a           move.w #$c000,(a6,$009a) == $00dff09a
000499f8 4e75                     rts  == $00c4f190
000499fa 0000 0000                or.b #$00,d0
000499fe 0000 0000                or.b #$00,d0
;------------------------------------------------------------------------------
>g 499f8																		; to leave the endless loop



2nd test: and without cycle-exact
;------------------------------------------------------------------------------
>d pc
0007217c 4e71                     nop
0007217e 4e71                     nop
00072180 4e71                     nop
00072182 4e71                     nop
00072184 4e71                     nop
00072186 4e71                     nop
00072188 4e71                     nop
0007218a 4e71                     nop
0007218c 4e71                     nop
0007218e 4e71                     nop
;------------------------------------------------------------------------------
>f 72188
Breakpoint added.
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 70736 Chip, 141472 CPU. (V=103 H=155 -> V=102 H=67)
VPOS: 102 ($066) HPOS: 067 ($043) COP: $0001edf0
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 0000FFFE
00072188 4e71                     nop
Next PC: 0007218a
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 70738 Chip, 141476 CPU. (V=102 H=67 -> V=100 H=208)						; 141476
VPOS: 100 ($064) HPOS: 208 ($0d0) COP: $0001edf0
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 0000FFFE
00072188 4e71                     nop
Next PC: 0007218a
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 70738 Chip, 141476 CPU. (V=100 H=208 -> V=99 H=122)						; 141476
VPOS: 099 ($063) HPOS: 122 ($07a) COP: $0001edf0
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 0000FFFE
00072188 4e71                     nop
Next PC: 0007218a
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 70738 Chip, 141476 CPU. (V=99 H=122 -> V=98 H=36)						; 141476
VPOS: 098 ($062) HPOS: 036 ($024) COP: $0001edf0
  D0 E7100000   D1 0000FFFF   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00DFF006   A1 00DFF180   A2 00DFF005   A3 00BFE001
  A4 00000000   A5 00000000   A6 00DFF000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 0000FFFE
00072188 4e71                     nop
Next PC: 0007218a
>