
; Listing27g.s - sind wir auf NTSC oder PAL?

	SECTION	NTSC_PAL,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; Speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)


Start:
	lea		$dff000,a6			; Custom Register Base in a6
	move.l	#Copperlist,$80(a6)	; Zeiger Copperlist	
	move.w	#DMASET,$96(a6)		; DMACON - aktivieren Copper und Bitplane DMA

	bsr	PalOrNtsc				; Variante 1
	
Mouse:
	btst	#6,$bfe001			; Maus gedrckt? 
	bne.s	Mouse				
	
	bsr	PalOrNtsc2				; Variante 2

	rts							; Exit

*******************************************************************************
* In dieser Routine wird ermittelt ob wir auf einem NTSC oder PAL-System sind *
*******************************************************************************
	
	; $212   530  VBlankFrequency
	; $213   531  PowerSupplyFrequency	

PalOrNtsc:
	move.l 4.w,a6
	cmp.b #50,$212(a6)			;cmp.b #50,VBlankFrequency(a6)
	;cmp.b #50,$213(a6)			;cmp.b #50,PowerSupplyFrequency(a6)
	beq.s Pal	
Ntsc:
	move.w	#$0f0,COL			; grn
	rts
Pal:
	move.w	#$f00,COL			; rot
	rts

*******************************************************************************
* In dieser Routine wird ermittelt ob wir auf einem NTSC oder PAL-System sind *
*******************************************************************************

PalOrNtsc2:
	move.w	4(a6),d0			; VPOSR $dff004
	and.w	#$2000,d0
	;btst	#8,d0				; testet ob das angegebene Bit ZERO ist	
	beq.s	Pal2	
Ntsc1:
	move.w	#$0f0,COL			; grn
	rts
Pal2:
	move.w	#$f00,COL			; rot

	rts

*******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180				; COLOR00
COL:
	dc.w	$00f				; COLOR00 blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end

Fr dieses Programm ist erforderlich eine Konfiguration fr A500 oder A1200 mit
NTSC einzurichten und dann diese zu starten. (Es reicht nicht aus bei einer
laufenden Emualtion unter Chipset nur das NTSC auszuwhlen.)

1. Variante: Frequenz aus Execbase

Richtiges NTSC und richtiges PAL verwenden unterschiedliche Systemuhren und die
horizontale Taktung ist unterschiedlich - Vblank ist keine gltige Quelle.

Das Lesen von VFreq aus Execbase ist zuverlssig - es zeigt, ob das Motherboard 
(und damit der Kristall, wenn Paula verwendet wird) PAL oder NTSC ist.
Man kann also VBlankFrequency und/ oder PowerSupplyFrequency lesen und berprfen
ob es 50 oder 60 ist.

2. Variante: VPOSR

VPOSR
 BIT#  15  14  13  12  11  10  09  08     07  06  05  04  03  02  01  00
 USE LOF   I6  I5  I4  I3  I2  I1  I0 LOL --  --  --  --  --  V10 V9  V8
 
LOF = Long frame(auto toggle control bit in BPLCON0)
		 
I0-I6 Chip identitication:
	
8361 (Regular) or 8370 (Fat) (Agnus-ntsc) = 10
8367 (Pal) or 8371 (Fat-Pal) (Agnus-pal)  = 00
8372 (Fat-hr) (agnushr),thru rev4         = 20 Pal, 30 NTSC		%0010.0000	; % 0011.0000
8372 (Fat-hr) (agnushr),rev 5             = 21 Pal, 31 NTSC		%0010.0001	; % 0011.0001
8374 (Alice) thru rev 2                   = 22 Pal, 32 NTSC		%0010.0010	; % 0011.0010
8374 (Alice) rev 3 thru rev 4             = 23 Pal, 33 NTSC		%0010.0011	; % 0011.0011
																and $100	 => NTSC

LOL = Long line bit. When low, it indicates short raster line.
v9,10 -- hires chips only (20,30 identifiers)

Es sagt Ihnen, welche Version von Agnus/Alice Sie installiert haben, und der 
Chip sollte normalerweise den dazu zugehrigen Kristall haben. Es hat nichts
mit dem aktiven Videomodus zu tun, da Sie mit beiden Kristallen und Versionen
von Agnus-hr/Alice NTSC- oder PAL-Zeilen haben knnen.
		              