
; Listing27e.s	=> (modifizierte Variante von Listing11n2.s) 
; Timing-Routine, mit der Sie auf eine bestimmte Anzahl Hertz warten knnen

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; disable
	lea	$dff000,a5
		
	bsr.s	CiaVsync			; Warten Sie ein paar Sekunden
	;bsr.s   CiaHsync		
	
	move.l	4.w,a6				; Execbase in a6
	jsr	-$7e(a6)				; enable
	rts
	

*******************************************************************************
* Timer ToD des CIA-A als Vsync oder 50/60Hz Ereigniszhler					  *
*******************************************************************************

; bfe801 todlo	-	1=~0,02 secs oder 1/50 sec (PAL) oder 1/60 sec (NTSC)
; bfe901 todmid	-	1=~3 secs
; bfea01 todhi	-	1=~21 mins
;
; In der Praxis handelt es sich um einen Timer, der eine 24-Bit-Zahl 
; enthalten kann.
; geteilt: 0-7 Bits in TODLO, Bits 8-15 in TODMID und Bits 16-23 in TODHI.

CiaVsync:
	move.l	a2,-(sp)
	lea	$bfe001,a2				; CIAA base -> verwendet

	move.b	#0,$800(a2)			; TODLO - Bit 7-0 fr Timer zu 50-60Hz
								; reset timer!
WciaV:
	cmpi.b	#50*2,$800(a2)		; TODLO - Wait time = 2 Sekunden...
	;bge.s	DoneV				; vorzeichenbehaftet bis 127 => 2,54s 
	bhi.s	DoneV				; vorzeichenlos bis 255 => 5,1s 
	bra.s	WciaV
DoneV:
	move.l	(sp)+,a2
	rts

*******************************************************************************
* Timer ToD des CIA-B als Hsync oder 15625Hz Ereigniszhler					  *
*******************************************************************************

; Beachten Sie, dass, wenn Sie CIAB verwenden mchten, zu einem horizontalen
; und nicht vertikalen Sync-Timer wechseln, so ist es sehr schnell. Um
; ungefhr 2 Sekunden zu warten mssen die TODMID bemhen:

CiaHsync:
	move.l	a2,-(sp)
	lea	$bfd000,a2				; CIAB base -> verwendet

	move.b	#0,$900(a2)			; TODMID - Bits 15-8
	move.b	#0,$800(a2)			; TODLO - Bits 7-0
								; reset timer!

; 1s mit Hsync sind 312,5*50=15625 ticks
; >?!15625 = $3D09 -> $3=61 -> 2s=122
; $00003D09 = %00000000`00000000`00111101`00001001 = 15625 = 15625

WciaH:
	cmpi.b	#122,$900(a2)		; TODMID - Wait time = 2 Sekunden...
	bge.s	DoneH
	bra.s	WciaH
DoneH:
	move.l	(sp)+,a2
	rts

	end
	

Beachten Sie, dass der CIAA TOD von timer.device verwendet wird,
TOD des CIAB wird von graphics.library verwendet!

Wenn Sie knnen, warten Sie fr eine kurze Zeit mit der klassischen Routine:

	lea	$dff006,a0				; VHPOSR
	moveq	#XXX-1,d0			; Anzahl der zu wartenden Zeilen
WaitLines:
	move.b	(a0),d1				; $dff006 - aktuelle vertikale Linie in d1
StepLine:
	cmp.b	(a0),d1				; sind wir immer noch auf der gleichen Zeile?
	beq.s	StepLine			; wenn ja warten
	dbra	d0,WaitLines		; Zeile "warten", warten d0-1 Zeilen
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ta 0
