
; Listing27c3.s
; Timer A des CIAB zur Zeitmessung verwendet

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; disable
	lea		$dff000,a5

	bsr.s	CiaInit				; CIA Zeitmessung vorbereiten
		
WarteY:
	move.l	4(a5),d0			; $dff004 - VPOSR/VHPOSR
	andi.l	#$1ff00,d0			; wirkt sich nur auf die Bits der vertikalen Zeile aus
	cmpi.l	#$08000,d0			; warte auf Zeile $080
	bne.s	WarteY

	move.b  #$11,$e00(a4)		; CRA - Force Load und Start timer!!
								; Timer is running now, do the test
WarteY2:
	move.l	4(a5),d0			; $dff004 - VPOSR/VHPOSR
	andi.l	#$1ff00,d0			; wirkt sich nur auf die Bits der vertikalen Zeile aus
	cmpi.l	#$0a800,d0			; warte auf Zeile $0a8 ($80+40 Zeilen) 
	bne.s	WarteY2

	bclr    #0,$e00(a4)			; CRA - Stop timer!!
	
	moveq   #0,d6				; und Ergebnis sichern
	moveq   #0,d7
	move.b  $400(a4),d6			; TALO 
	move.b  $500(a4),d7			; TAHI 
	asl.w   #8,d7
	or.w    d7,d6				; Ergebnis in d6 
								; 1 tick = 1,409683 s PAL
								; 1 tick = 1,396825 s NTSC
								; 1 Rasterzeile ~ 63,5s  
								; 1 Rasterzeile ~ 45 ticks (Timer-clock)
	moveq	#-1,d5
	sub.w	d6,d5
	and.l	#$0000ffff,d5
	divu.w	#45,d5				; 1 Rasterzeile = 45 ticks
;---------						
; das Programm an dieser Stelle warten lassen um mit dem Debugger den Wert
; in d6 (ticks) und in d5 Anzahl in Rasterzeilen auszulesen 
 		
Mouse:
	btst	#2,$dff016			; rechte Maustaste
	bne.s	Mouse
			
	move.b	OldCiaaCra,$e00(a4)		; CRA wiederherstellen
	move.b  #%01111111,$d00(a4)		; ICR - alles aus
	move.b	OldCiaaIcr,$d00(a4)		; ICR wiederherstellen

	move.l	4.w,a6				; Execbase in a6
	jsr	-$7e(a6)				; enable
	rts
	
*******************************************************************************

CiaInit:
	lea		$bfd000,a4				; CIA-B base
	
	move.b	$d00(a4),d0				; ICR
	or.b	#$80,d0
	move.b	d0,OldCiaaIcr			; ICR - alten ICR-Wert speichern
	move.b  #%01111111,$d00(a4)		; ICR - alle CIA interrupts	lschen

	move.b	$e00(a4),d0				; CRA
	move.b	d0,OldCiaaCra
	and.b   #%11000000,d0           ; Bits 6 und 7 bleiben erhalten
	or.b    #%00001000,d0           ; One-Shot mode
	move.b  d0,$e00(a4)				; CRA
	    
	move.b  #$ff,$400(a4)			; TALO - Setzen Sie das Low-Byte der Zeit
    move.b  #$ff,$500(a4)			; TAHI - das Schreiben in Timer Hi startet den Timer	
	;bclr    #0,$e00(a4)			; CRA - Stop timer!! 
	rts
	
OldCiaaCra:		dc.b 0
OldCiaaIcr:		dc.b 0

	end
	
;------------------------------------------------------------------------------
>r
VPOS: 210 ($0d2) HPOS: 003 ($003) COP: $0001ede4
  D0 0000A800   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 0000F8E7   D7 0000F800
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00BFD000   A5 00DFF000   A6 00C00276   A7 00C5FA28
USP  00C5FA28 ISP  00C60A28
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66f6 (Bcc) 1979 (MOVE) Chip latch 00000000
000216b0 66f6                     bne.b #$f6 == $000216a8 (T)
Next PC: 000216b2
;------------------------------------------------------------------------------
>c
A: CRA 00 CRB 08 ICR 00 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00
   TOD 0038c0 (0038c0) ALARM 000000 -- CYC=000004D45C208800
B: CRA 00 CRB 80 ICR 04 IM 00 TA f8e7 (ffff) TB ffff (ffff)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 0000d2 (00ffff) ALARM 0000ac --
DEBUG: drive 0 motor off cylinder  0 sel no ro mfmpos 0/101344
side 0 dma 0 off 5 word 0000 pt 00000000 len 4000 bytr 8000 adk 1100 sync 0000
DMACON: $23f0 INTENA: $602c ($602c) INTREQ: $1040 ($1040) VPOS: 210 ($0d2) HPOS: 003 ($003)
INT: $0000 IPL: 0
COP1LC: $00000420, COP2LC: $0001ed50 COPPTR: $0001ede4
DIWSTRT: $0581 DIWSTOP: $40c1 DDFSTRT: $003c DDFSTOP: $00d0
BPLCON 0: $a200 1: $0000 2: $0024 3: $0c00 4: $0011 LOF=1/1 HDIW=1 VDIW=1
Average frame time: 1870284.39 ms [frames: 143192 time: 1897998670]
;------------------------------------------------------------------------------
>?$ffff-$F8E7
$00000718 = %00000000`00000000`00000111`00011000 = 1816 = 1816
>

Das 1800 ticks entsprechen 40 Rasterzeilen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   t der zweiten Zeile beginnen rechts
	move.b #$80,d0					; senkrechte Linie links
	move.b #$01,d1					; senkrechte Linie rechts
	move.w #SCR_H-2-1,d2			; Hhe-2 Zeilen