
; Listing27c.s (modifizierte Variante von Listing11n1.s)
; Timing Routine, mit der Sie eine bestimmte Anzahl von 
; Mikrosekunden unter Verwendung eines Timers A von CIAA/B warten knnen

; Mit dieser Testroutine knnen Sie berprfen, wie viele Videozeilen vorhanden sind
; Sie entsprechen einer bestimmten Anzahl von Mikrosekunden.
; (Der ROTE Teil des Bildschirms ist derjenige, in dem die Routine ausgefhrt wird.)


LINES:	equ 40					; 40 Rasterzeilen mit Timer A oder B warten
MICS:	equ LINES*45			; 1800 ticks

; 1 Rasterzeile dauert in PAL:  64,0s/ 1,409683 s = 45,40 ~ 45 ticks
; 1 Rasterzeile dauert in NTSC: 63,5s/ 1,396825 s = 45,46 ~ 45 ticks

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; disable
	lea	$dff000,a5

WarteY:
	move.l	4(a5),d0			; $dff004 - VPOSR/VHPOSR
	andi.l	#$1ff00,d0			; wirkt sich nur auf die Bits der vertikalen Zeile aus
	cmpi.l	#$08000,d0			; warte auf Zeile $080
	bne.s	WarteY

	move.w	#$f00,$180(a5)		; COLOR00 rot

	bsr.s	CiaMic

	move.w	#$0f0,$180(a5)		; COLOR00 grn

WarteY2:
	move.l	4(a5),d0			; $dff004 - VPOSR/VHPOSR
	andi.l	#$1ff00,d0			; wirkt sich nur auf die Bits der vertikalen Zeile aus
	cmpi.l	#$0a900,d0			; warte auf Zeile $0ad (169) + 41 Zeilen
	bne.s	WarteY2

	move.w	#$00f,$180(a5)		; COLOR00 blau
	
	btst	#6,$bfe001
	bne.s	WarteY
	
	move.l	4.w,a6				; Execbase in a6
	jsr	-$7e(a6)				; enable
	rts

;	Hier ist die Routine, die eine bestimmte Anzahl von Mikrosekunden mit dem,
;   Timer A des CIAB wartet. Zur Verwendung des Timer A des CIAA reicht es aus
;   "lea $bfd000,a4" durch "lea $bfe001,a4" zu ersetzen. Im Listing ist es
;   bereits vorhanden. Entfernen Sie einfach das Semikolon und setzen Sie 
;   stattdessen den CIAB ein. Es ist jedoch besser, die CIAB zu verwenden, 
;   da der CIAA-Timer vom Betriebssystem fr verschiedene Aufgaben verwendet wird.

CiaMic:
	movem.l	d0/a4,-(sp)			; speichern der verwendeten Register
 	lea	$bfd000,a4				; CIAB base
 ;	lea	$bfe001,a4				; CIAA base (wenn Sie die B nicht verwenden mchten)
	move.b  $e00(a4),d0			; $bfde00 - CRA, CIAB control reg. A
	andi.b   #%11000000,d0		; setzt Bit 0-5 zurck 
	ori.b    #%00001000,d0		; One-Shot mode (runmode single)
	move.b  d0,$e00(a4)			; CRA - Steuerregister festlegen
	move.b  #%01111110,$d00(a4)	; ICR - lscht die interrupts CIA
	move.b  #(MICS&$ff),$400(a4)	; TALO - Setzen Sie das Low-Byte der Zeit
	move.b  #(MICS>>8),$500(a4)		; TAHI - Setzen Sie das High-Byte der Zeit
	;bset.b  #0,$e00(a4)			; CRA - Start timer!!
Wait:
	btst.b  #0,$d00(a4)			; ICR - Wir warten darauf, dass die Zeit abluft
	beq.s   Wait
	movem.l	(sp)+,d0/a4			; Register wieder herstellen
	rts

	end

Hinweis: Im One-Shot-Modus bertrgt ein Schreibvorgang auf Timer-High den
Timer-Latch auf den Zhler und leitet den Zhlvorgang unabhngig vom Startbit
ein.

; $bfde00
; CIA:	ICR  (Interrupt Control Register)				[d]
;
; 0	TA			underflow
; 1	TB			underflow
; 2	ALARM		TOD alarm
; 3	SP			serial port full/empty
; 4	FLAG		flag
; 5-6			unused
; 7  R			IR
; 7  W			set/clear
;
; $bfdd00 
; CIA:  CRA, CRB  (Control Register)					[e-f]
;
; 0		Start		0 = stop / 1 = start TA; {0}=0 when TA underflow
; 1		PBON		1 = TA output on PB / 0 = normal mode
; 2		OUTMODE		1 = toggle / 0 = pulse
; 3		RUNMODE		1 = one-shot / 0 = continous mode
; 4	  S	LOAD		1 = force load (strobe, always 0)
; 5   A	INMODE		1 = TA counts positive CNT transition
;					0 = TA counts 02 pulses
; 6   A	SPMODE		serial port....
; 7   A	unused
; 6-5 B	INMODE		00 = TB counts 02 pulses
;					01 = TB counts positive CNT transition
;					10 = TB counts TA underflow pulses
;					11 = TB counts TA underflow pulses while CNT is high
; 7   B	ALARM		1 = writing TOD sets alarm
;					0 = writing TOD sets clock
;					Reading TOD always reads TOD clock
