
; Listing27b2.s
; Portausgang schalten - OVL Memory Overlay-Bit
; Achtung der Computer (die Emulation) muss anschlieend neu gestartet werden!

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; disable
	lea	$bfe001,a5				; CIAA base is also CIAAPRA

Mouse:
	btst	#6,$bfe001
	bne.s	Mouse				; linke Maustaste
	
	bset.b #0,(a5)				; Bit 0 - OVL-Bit setzen	

Mouse2:
	btst	#2,$dff016			; rechte Maustaste
	bne.s	Mouse2
			
	bclr.b #0,(a5)				; Bit 0 - OVL-Bit zurcksetzen

	move.l	4.w,a6				; Execbase in a6
	jsr	-$7e(a6)				; enable
	rts
		
	end

$BFE001		CIAAPRA		/FIR1 /FIR0 /RDY /TK0 /WPRO /CHNG /LED OVL
$BFE201		CIAADDRA	Direction for port A (BFE001);1=output (set to 0x03)

Was macht das "Memory Overlay"-Bit (in CIA A Port A Bit 0)? 
Es bewirkt, dass das ROM auf die Adresse 00000000h gespiegelt wird (damit die
CPU den Reset-Vektor aus dem ROM holen kann) Damit der Amiga bei einem Reset
auf eine definierte Reset-Adresse springt. 

Bei Anlegen eines Reset-Signals wird auch OVL aktiv und die CPU kopiert
das Longword von Adresse $0 in den Stack-Pointer und das Longword von
Adresse $4 in den PC. Ab $8 folgen die Exception Vektoren.

Damit Adresse 4 den Einsprungpunkt ins ROM hat (insbesondere bei einem
Kaltstart) wird dort einfach kurz das ROM eingeblendet, und als so ziemlich 
erste Aktion des Reset-Codes im ROM wieder ausgeblendet.

In normalen Anwendugen wird man dieses Bit niemals setzen wollen, da man damit
meist alles Chip-RAM und beim 68000 auch alle Exception Vektoren verliert. Die
bliche Anwendung ist ein Software-Reset: siehe Listing19s2.s

	cnop	0,4
	lea	2.l,a0			; do not optimize to 2.w!
	reset
	jmp	(a0)

Die reset Instruktion sorgt ebenfalls dafr da OVL gesetzt wird und der Sprung
nach Adresse 2 ins ROM klappt.

Durch das 2-Byte JMP klappt der Reset-Code auch aus dem Chip-RAM, das 
eigentlich nach RESET durch das ROM berlagert wrde, denn selbst der 68000 hat
wohl einen Word-Prefetch Buffer, der die nchste Instruktion bereits gelesen 
hat bevor dies passiert.

Ob das JMP an einer 32-Bit alignten Adresse stehen mu ist nicht ganz sicher.
Schadet aber nicht.

;------------------------------------------------------------------------------
>m0
00000000 0000 0000 00C0 0276 00FC 0818 00FC 081A  .......v........
00000010 00FC 081C 00FC 081E 00FC 0820 00FC 0822  ........... ..."
00000020 00FC 090E 00FC 0826 00FC 0828 00FC 082A  .......&...(...*
00000030 00FC 082C 00FC 082E 00FC 0830 00FC 0832  ...,.......0...2
00000040 00FC 0834 00FC 0834 00FC 0834 00FC 0834  ...4...4...4...4
00000050 00FC 0834 00FC 0834 00FC 0834 00FC 0834  ...4...4...4...4
00000060 00FC 0834 00FC 0C8E 00FC 0CE2 00FC 0D14  ...4............
00000070 00FC 0D6C 00FC 0DFA 00FC 0E40 00FC 0E86  ...l.......@....
00000080 00FC 0836 00FC 0838 00FC 083A 00FC 083C  ...6...8...:...<
00000090 00FC 083E 00FC 0840 00FC 0842 00FC 0844  ...>...@...B...D
000000A0 00FC 0846 00FC 0848 00FC 084A 00FC 084C  ...F...H...J...L
000000B0 00FC 084E 00FC 0850 00FC 0852 00FC 0854  ...N...P...R...T
000000C0 00C0 CA14 00C0 CA16 00C0 CA18 00C0 CA1A  ................
000000D0 00C0 CA1C 00C0 CA1E 00C0 CA20 00C0 CA22  ........... ..."
000000E0 00C0 CA24 00C0 CA26 00C0 CA28 00C0 CA2A  ...$...&...(...*
000000F0 00C0 CA2C 00C0 CA2E 00C0 CA30 00C0 CA32  ...,.......0...2
00000100 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000110 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000120 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000130 0000 0000 0000 0000 0000 0000 0000 0000  ................
;------------------------------------------------------------------------------
>m0
00000000 1111 4EF9 00FC 00D2 0000 FFFF 0022 0005  ..N.........."..
00000010 0022 0002 FFFF FFFF 6578 6563 2033 342E  ."......exec 34.
00000020 3220 2832 3820 4F63 7420 3139 3837 290D  2 (28 Oct 1987).
00000030 0A00 0000 FFFF FFFF 0D0A 0A41 4D49 4741  ...........AMIGA
00000040 2052 4F4D 204F 7065 7261 7469 6E67 2053   ROM Operating S
00000050 7973 7465 6D20 616E 6420 4C69 6272 6172  ystem and Librar
00000060 6965 730D 0A43 6F70 7972 6967 6874 2028  ies..Copyright (
00000070 4329 2031 3938 352C 2043 6F6D 6D6F 646F  C) 1985, Commodo
00000080 7265 2D41 6D69 6761 2C20 496E 632E 0D0A  re-Amiga, Inc...
00000090 416C 6C20 5269 6768 7473 2052 6573 6572  All Rights Reser
000000A0 7665 642E 0D0A 0000 6578 6563 2E6C 6962  ved.....exec.lib
000000B0 7261 7279 0000 4AFC 00FC 00B6 00FC 3276  rary..J.......2v
000000C0 0022 0978 00FC 00A8 00FC 0018 00FC 00D2  .".x............
000000D0 4E70 4FF9 0004 0000 203C 0002 0000 5380  NpO..... <....S.
000000E0 6EFC 41FA FF1C 43F9 00F0 0000 B1C9 670E  n.A...C.......g.
000000F0 4BFA 000C 0C51 1111 6604 4EE9 0002 13FC  K....Q..f.N.....
00000100 0003 00BF E201 13FC 0002 00BF E001 49F9  ..............I.
00000110 00DF F000 303C 7FFF 3940 009A 3940 009C  ....0<..9@..9@..
00000120 3940 0096 397C 0200 0100 397C 0000 0110  9@..9|....9|....
00000130 397C 0444 0180 307C 0008 323C 002D 43FA  9|.D..0|..2<.-C.
