
; Listing26d.s		; ProPack (Original siehe Listing4b.s)

 SECTION PACKER,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte COP

*****************************************************************************
*
* IN:	a0, packed data
*		a1, destination
* OUT:	d0.l = length of unpacked file in bytes OR error code
*		 0 = not a packed file
*		-1 = packed data CRC error
*		-2 = unpacked data CRC error
* TRASHED:	d0-d1/a0-a1
*****************************************************************************
	
	lea	PictureRNC,a0
	lea	Bitplane,a1

LIB_RNC_Depack:
	moveq	#0,d0				; No key
	bsr.w	Unpack
	
*******************************************************************************
* Bitplanepointer in der Copperlist einstellen
*******************************************************************************

	;move.l	#Picture,d0			; Original (siehe Listing4b.s)
	move.l	#Bitplane,d0		; in d0 kommt die Adresse von unserer PIC
								; bzw. wo ihre erste Bitplane beginnt

	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitplanes (hier sind es 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; Bitplane-Lnge
	addq.w	#8,a1
	dbra	d1,PointBp			; d1-mal wiederholen (d1 = Anzahl der Bitplanes)
	
	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0
	
GfxBase:
	dc.l	0

OldCop:
	dc.l	0

	
	include "/Packer/PP/RNC_1.S"	

******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
	;dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000
	;dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	;dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	;dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt	Register mit Standartwerten
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod
		
				; 5432109876543210
	dc.w	$100,%0011001000000000	; bits 13 und 12 an!! (3 = %011)
	
Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste	Bitplane - BPL0PT
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane - BPL1PT
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane - BPL2PT

; die 8 Farben des Bildes werden hier definiert:

	dc.w	$0180,$000		; color0
	dc.w	$0182,$475		; color1
	dc.w	$0184,$fff		; color2
	dc.w	$0186,$ccc		; color3
	dc.w	$0188,$999		; color4
	dc.w	$018a,$232		; color5
	dc.w	$018c,$777		; color6
	dc.w	$018e,$444		; color7

; fgt hier eventuelle WAIT-Effekte ein:
	dc.w	$a907,$fffe		; warte auf Zeile $a9
	dc.w	$180,$001		; sehr dunkles blau
	dc.w	$aa07,$fffe		; Zeile $aa
	dc.w	$180,$002		; ein bichen helleres blau
	dc.w	$ab07,$fffe		; Zeile $ab
	dc.w	$180,$003		; ein bichen helleres blau
	dc.w	$ac07,$fffe		; nchste Zeile
	dc.w	$180,$004		; ein bichen helleres blau
	dc.w	$ad07,$fffe		; nchste Zeile
	dc.w	$180,$005		; ein bichen helleres blau
	dc.w	$ae07,$fffe		; nchste Zeile
	dc.w	$180,$006		; blau auf 6
	dc.w	$b007,$fffe		; berspringe 2 Zeilen
	dc.w	$180,$007		; blau auf 7
	dc.w	$b207,$fffe		; berspringe 2 Zeilen
	dc.w	$180,$008		; blau auf 8
	dc.w	$b507,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$009		; blau auf 9
	dc.w	$b807,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$00a		; blau auf 10
	dc.w	$bb07,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$00b		; blau auf 11
	dc.w	$be07,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$00c		; blau auf 12
	dc.w	$c207,$fffe		; berspringe 4 Zeilen
	dc.w	$180,$00d		; blau auf 13
	dc.w	$c707,$fffe		; berspringe 7 Zeilen
	dc.w	$180,$00e		; blau auf 14
	dc.w	$ce07,$fffe		; berspringe 6 Zeilen
	dc.w	$180,$00f		; blau auf 15
	dc.w	$d807,$fffe		; berspringe 10 Zeilen
	dc.w	$180,$11f		; helle auf...
	dc.w	$e807,$fffe		; berspringe 16 Zeilen
	dc.w	$180,$22f		; helle auf...
	dc.w	$ffdf,$fffe		; ENDE DER NTSC-ZONE (Zeile $ff)
	dc.w	$180,$33f		; helle auf...
	dc.w	$2007,$fffe		; Zeile $20+$ff = Zeile $1ff (287)
	dc.w	$180,$44f		; helle auf...

	dc.w	$ffff,$fffe		; Ende der Copperlist

	
Picture:
	;incbin  "/Sources/Amiga_320_256_3.raw"
							; hier laden wir das Bild im RAW
							; Format, das zuvor mit dem
							; KEFCON konvertiert wurde, es
							; besteht aus drei Bitplanes
							; nacheinander	

PictureRNC:
	incbin  "/Packer/Amiga_320_256_3.RNC"

******************************************************************************

	SECTION LEEREPLANE,BSS_C

Bitplane:
	ds.b 3*40*256			; freier Platz Bitplane	

	end


Erklrung:

Wo bekomme ich ProPack?
===============================================================================
Quelle: RNC_ProPack.lha von Aminet - util_pack_RNC_ProPack.lha
Inhalt:
PPAMI.EXE		; Amiga
PPIBM.EXE		; MS-DOS 16-Bit	(funktioniert mit Dosbox-Emulator)	
PROPACK.DOC		

Sourcecode:
RNC_1.S
RNC_1C.S
RNC_2.S
RNC_2C.S

Eine 32Bit bzw. 64Bit-Variante findet man hier:
https://github.com/lab313ru/rnc_propack_source
Diese kann man z.B. mit VisualStudio in eine rnc_propack_x64.exe 
generieren. Diese Variante hat die gleichen Ergebnisse wie PPAMI.EXE
geliefert.

Ansonsten findet man auch noch hier eine Propack Version:
https://codetapper.com/amiga/random-rants/rob-northen-propack/
Diese Variante hat aber im Test nicht 100% das gleiche Ergebnis geliefert
wie die PPAMI.EXE und PPIBM.EXE

Amiga Shell
===============================================================================
1.DH1:>PPAMI.EXE
PRO-PACK 2.88 Software Developers File Compression Utility 3 App 92
Copypright (c) 1991,92 Rob Northen Computing UK. All Rights Reserved
PO Box 17 Bordon Hants GU35 8DY U.K. Tel:0428-713635 Fax:0428-713999

Usage: PP <command> <file type> [-<options>] [.<ext>] <file(s)...>

<Commands> p: Pack u: Unpack v: Verify

<File Types> (file types <psam> are made to unpack when run)

d: Data p: IBM PC s: Atari ST a: CBM Amiga m: MC68000 l: Atari Lynx

<Options> (p=pack command, u=unpack command, v=verify command)
-k: (puv) lock/unluck with Key	 -o: (p) Overwrite input <file>
-k 0x1234 (hex)				     -p: (p) change Pack block size
-l: (p) Lock <file> (stops unpacking) -p 10240 (10240 bytes)
-m: (p) packing Method (default=1)  -v: (p) Validate data when unpacking
-m 1 emphasis on packed size		-x: (p) MC68000 eXec address offset
-m 2 emphasis on unpacking speed	-x 0x100 jumps to start + 0x100

[.<ext>] output file extension
1.DH1:>rename PPAMI.EXE PPAMI

D.h typische Aufrufe wren.
1.DH1:>PPAMI p a -m 1 text.exe
1.DH1:>PPAMI p d Tabelle1

1.DH1:>PPAMI u a - m 1 test.exe.rnc
1.DH1:>PPAMI U D Tabelle1.rnc

Fileformat
===============================================================================
; RNC1.new fileformat:
; 0 BYTE "RNC",$01
; 4 LONG unpacked size
; 8 LONG packed stream size
; c WORD unpacked crc
; e WORD packed crc
; 10 UBYTE required offset if decrunching over itself
; 11 BYTE
; 12 STRUCT packed stream
; decrunching source++ destination++
