
; Listing26a.s = Denibbler102-Example.s
; Quelle: Nibbler102o.lha

; Packer:	Amiga.exe: Nibble
; Packer:	asm: na 
; Depacker: Amiga.exe: Denibble
; Depacker  asm: Denibbler102.s
; info: readme_Nibbler.txt

; verwendete Dateien:
; Sources:  exetest.nib (testexe.nib) 
; Depacker: Denibbler102.s

; Usage: Nibble <filename> [filename.nib] [BOING]
; Usage: Denibble <filename.nib> [filename] [EXECUTE]

;	*-------+---------------------------------------*
;	|Name	| Denibbler Example						|
;	|Version| 1.02o	Comment: Repeated calls option	|
;	+-------+---------------------------------------+
;	| Decompresses a .nib file to a RAM address and |
;	| 	     jumps to that address.					|
;	|												|
;	|      AsmOne 1.02+, set Label :, ;Comment		|
;	|												|
;	|   /_!_\ Don't optimize the jump tables /_!_\	|
;	|												|
;	|    /_!_\ suba must assemble to suba.  /_!_\	|
;	|												|
;	+-----------------------------------------------+
;	| by Henrik Erlandsson  2013 bitBrain Studios.	|
;	*-----------------------------------------------*

;License: You may copy or distribute this unmodified source to anyone freely.
;You may modify the source and include its executable code in any demoscene 
;product for the Commodore Amiga only. For all other uses, read/get your 
;license at bitbrain.se.

;Source is written for Asm-One/AsmTwo/AsmPro, please adapt to the Assembler
;you prefer. :)

;This version is the latest official version of Nibbler 1.02.

;An option was added to support multiple calls. Thanks to Dodke for this 
;feedback!

;NOTE that you will gain compression ratio for any cruncher by combining files
;to a single decrunch.

;The option DEN_BINARY was removed. Assemble your own Denibbler102.bin with the
;options you prefer.

;To achieve its speed, it has no RLE pass and so it is assumed that some TLC 
;has seen to that ends of samples and graphics are cropped, and no dcb n,0.

;It's best practice to achieve the highest compression ratio for any cruncher.


********************  Nibbler Options  ********************

DEN_REPEATEDCALLS=0			;1 FOR REPEATED CALLS! 0 saves 8b.
DEN_CPU68000	=0			;1=speed gain for 68000 ONLY. +12b code
DEN_SIZEOPTI	=0			;1=1.1% slower, -30b code.
DEN_FLASHADDR	=0			;or f.ex. $dff181 to flash a color reg.
DEN_DEST	=$60000			;for code, where the code was ORGed to.



********************  Exe File Start  ********************

	SECTION DENIB102,CODE

	;incdir ""				; only needed for early Asm-One versions

DEN_Example:
	lea NibFile(PC),a0
	lea DEN_DEST,a1
	bsr.b Denibble
	jmp DEN_DEST

	include "/Packer/Nibbler/Denibbler102.S"	;source

NibFile:
	;incbin "exetest.nib"	; see readme_Nibbler.txt
	incbin "testexe.nib"	; own version
DEN_Example_End: