
; Listing25h.s		Verhalten beim Ein-und Ausschalten von Sprite DMA

	SECTION ROCK'NROLL,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte COP
	
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	
	bsr InitCopper				; Copperlist vorbereiten

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0


*******************************************************************************
* Diese Routine erstellt den vertikalen Spritemultiplex in der Copperliste    *
*******************************************************************************

InitCopper:
	move.l	#$2c01fffe,d0		; 1. wait			
	move.l	#$01402c40,d1		; SPR0POS V=$2c, H=$40 
	move.l	#$01423900,d2		; SPR0CTL V=$39, H=0	$2c+13=$39

	move.l	#MeinSprite+4,d4	; Adresse des Sprite in d0 auf Spritedaten!
								; nicht auf die Steuerwrter!		
	lea	CopperSprite,a0			; Anfang des Spritebereichs in der Copperlist 
	move.l	d0,(a0)+			; setzt das erste wait	
;---------------
; Spritepointer setzen in Copperlist
	move.w	#$0120,(a0)+		; SPR0PTH
	swap d4	
	move.w	d4,(a0)+			; hi-Anteil Adresse eintragen
	move.w  #$0122,(a0)+		; SPR0PTL
	swap d4			
	move.w	d4,(a0)+			; low-Anteil Adresse eintragen
;----------------
    move.l	d1,(a0)+			; SPR0POS
	move.l	d2,(a0)+			; SPR0CTL
	move.l	#$fffffffe,(a0)		; Ende der Copperlist
	rts


******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DIWSTRT
	dc.w	$90,$2cc1		; DIWSTOP
	dc.w	$92,$38			; DDFSTRT
	dc.w	$94,$d0			; DDFSTOP
	dc.w	$102,0			; BPLCON1
	dc.w	$104,0			; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR00	; Hintergrund Schwarz
	dc.w	$182,$123		; COLOR01	; Farbe 1 der Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; COLOR17, oder COLOR1 des Sprite0 - rot
	dc.w	$1a4,$0f0		; COLOR18, oder COLOR2 des Sprite0 - grn
	dc.w	$1a6,$ff0		; COLOR19, oder COLOR3 des Sprite0 - gelb

	dc.w	$1915,$fffe		; Zeile 19 - beim ersten Spriet Datenabruf
	dc.w	$0096,$0020		; DMACON Sprite DMA off
	dc.w	$0096,$8020		; DMACON Sprite DMA on

CopperSprite:
	dcb.w	10,0 

	dc.w	$ffff,$fffe	; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ************

MeinSprite:		; Lnge 13 Zeilen
Vstart:
	dc.b $60	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $d0	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $6d	; $60+13=$6d - Vertikale Endposition des Sprite
	dc.b $00
 dc.w	%0000000000000000,%1000110000110001 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; binr 00=Color 0 (durchsichtig)
 dc.w	%0000011111100000,%0110011111100110 ; binr 10=Color 1 (rot)
 dc.w	%0000011111100000,%1100100110010011 ; binr 01=Color 2 (grn)
 dc.w	%0000110110110000,%1111100110011111 ; binr 11=Color 3 (gelb)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0	; 2 word auf NULL definieren das Ende des Sprite.

******************************************************************************

	SECTION LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane auf 0 Lowres

	end


Erklrung:

Das Ergebnis eines kurzen Tests ist, dass Sprite DMA jeweils 3 CCK nach dem
ndern von Sprite DMA on/off in DMACON deaktiviert oder aktiviert wird,
also nicht im nchsten direkt folgenden (Sprite)-DMA Slot, sondern in dem 
danach folgenden. (getestet ber Copperliste)

mit WinUAE Debugger: siehe Lektion 19

>v $19 $18 4
Line: 19  25 HPOS 18  24:
 [18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
              SPR0   140                SPR0   142                SPR1   148                SPR1   14A
                    0000                      0000                      0000                      0000
                00000000                  00000002                  00000000                  00000002

               000   000                 001   000                 000   000                 001   000

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
              SPR2   150                SPR2   152                SPR3   158                SPR3   15A
                    0000                      0000   (                  0000                      0000
                00000000                  00000002                  00000000                  00000002

               000   000                 001   000                 000   000                 001   000

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
              SPR4   160                SPR4   162                SPR5   168                SPR5   16A
                    0000                      0000                      0000                      0000
                00000000                  00000002                  00000000                  00000002

               000   000                 001   000                 000   000                 001   000

 [30 058 -]   [31 05A -]   [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
              SPR6   170                SPR6   172                SPR7   178                SPR7   17A
                    0000                      0000                      0000                      0000
                00000000                  00000002                  00000000                  00000002

               000   000                 001   000                 000   000                 001   000

;------------------------------------------------------------------------------
	dc.w	$1915,$fffe		; Zeile 19 - beim ersten Spriet Datenabruf
	dc.w	$0096,$0020		; DMACON Sprite DMA off
	dc.w	$0096,$8020		; DMACON Sprite DMA on
	
>v $19 $18 4
Line: 19  25 HPOS 18  24:
[18 028 -]   [19 02A -]   [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
 COP    08C   SPR0   140   COP    096   SPR0   142   COP    08C                COP    096
       0096         0000         0020         0000         0096                      8020
   0006A55C     00000000     0006A55E     00000002     0006A560                  0006A562

  1AE   152    000   000    1AF   152    001   000    1B0   152                 1B1   152

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -]   [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
 COP    08C   SPR2   150   COPW   08C   SPR2   152                SPR3   158                SPR3   15A
       2C01         0000         FFFE         0000   (                  0000                      0000
   0006A564     00000000     0006A566     00000002                  00000000                  00000002

  1B2   152    000   000    1B3   152    001   000                 000   000                 001   000

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
              SPR4   160                SPR4   162                SPR5   168                SPR5   16A
                    0000                      0000                      0000                      0000
                00000000                  00000002                  00000000                  00000002

               000   000                 001   000                 000   000                 001   000

 [30 058 -]   [31 05A -]   [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
              SPR6   170                SPR6   172                SPR7   178                SPR7   17A
                    0000                      0000                      0000                      0000
                00000000                  00000002                  00000000                  00000002

               000   000                 001   000                 000   000                 001   000
         