
; Listing25d3.s		horizontales Spritemultiplexing mit wait und SPRxPOS
; mit Copperloop im Bereich der Zeile 255

	SECTION ROCK'NROLL,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte COP

	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	; Pointen auf den Sprite

	move.l	#MeinSprite,d0		; Adresse des Sprite in d0	
	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
		
	move.l	#CopperLoop1,d0
	move	d0,CopPtr1+6
	swap	d0
	move	d0,CopPtr1+2

	move.l	#CopperLoop2,d0
	move	d0,CopPtr2+6
	swap	d0
	move	d0,CopPtr2+2

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0
	
GfxBase:
	dc.l	0

OldCop:
	dc.l	0

******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$1a5c		; DIWSTRT
	dc.w	$90,$1ad4		; DIWSTOP
	dc.w	$92,$20			; DDFSTRT
	dc.w	$94,$d8			; DDFSTOP
	dc.w	$102,0			; BPLCON1
	dc.w	$104,0			; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR00	; Hintergrund Schwarz
	dc.w	$182,$123		; COLOR01	; Farbe 1 der Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; COLOR17, oder COLOR1 des Sprite0 - rot
	dc.w	$1a4,$0f0		; COLOR18, oder COLOR2 des Sprite0 - grn
	dc.w	$1a6,$ff0		; COLOR19, oder COLOR3 des Sprite0 - gelb
	
	dc.w	$0140,$fa40		; SPR0POS Start
	dc.w	$0142,$0702		; SPR0CTL Start

CopPtr1
	dc.w	$084,0			; COP2LCH
	dc.w	$086,0			; COP2LCL
	
	dc.w	$fa01,$fffe		; wait, wo die Sprite beginnen sollen
CopperLoop1:
	dc.w	$0140,$0040		; SPR0POS neue horizontale Startposition	
	dc.w	$8041,$80fe
	dc.w	$0140,$0060		; SPR0POS neue horizontale Startposition		
	dc.w	$8061,$80fe
	dc.w	$0140,$0080		; SPR0POS neue horizontale Startposition		
	dc.w	$8081,$80fe
	dc.w	$0140,$00a0		; SPR0POS neue horizontale Startposition		
	dc.w	$80a1,$80fe
	dc.w	$0140,$00c0		; SPR0POS neue horizontale Startposition			
	dc.w	$80d7,$80fe		; warte auf Ende der Zeile	

	dc.w	$ffdd,$ffff		; skip loop am Ende der Zeile 255
	dc.w	$8a,0			; COPJMP2 Start
		
CopPtr2
	dc.w	$084,0			; COP2LCH
	dc.w	$086,0			; COP2LCL
	dc.w	$180,$0f00		; Farbwechsel an $100
CopperLoop2:
	dc.w	$0140,$0040		; SPR0POS neue horizontale Startposition	
	dc.w	$0041,$80fe
	dc.w	$0140,$0060		; SPR0POS neue horizontale Startposition		
	dc.w	$0061,$80fe
	dc.w	$0140,$0080		; SPR0POS neue horizontale Startposition		
	dc.w	$0081,$80fe
	dc.w	$0140,$00a0		; SPR0POS neue horizontale Startposition		
	dc.w	$00a1,$80fe
	dc.w	$0140,$00c0		; SPR0POS neue horizontale Startposition			
	dc.w	$00e1,$80fe		; warte auf Ende der Zeile			

	dc.w	$07e1,$ffff     ; skip loop am Ende der Zeile $107                                                        
	dc.w	$8a,$0			; COPJMP2 Start
	
	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ************

MeinSprite:		; Lnge 13 Zeilen
Vstart:
	dc.b $fa	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $00	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $07	; $1a+13=$27 - Vertikale Endposition des Sprite
	dc.b $02
 dc.w	%0000000000000000,%1000110000110001 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; binr 00=Color 0 (durchsichtig)
 dc.w	%0000011111100000,%0110011111100110 ; binr 10=Color 1 (rot)
 dc.w	%0000011111100000,%1100100110010011 ; binr 01=Color 2 (grn)
 dc.w	%0000110110110000,%1111100110011111 ; binr 11=Color 3 (gelb)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0	; 2 word auf NULL definieren das Ende des Sprite.

 ******************************************************************************

	SECTION LEEREPLANE,BSS_C	

Bitplane:
	ds.b	80*256				; Bitplane auf 0 Lowres

	end
	

Erklrung:

In diesem Beispiel wird gezeigt wie es mit Copperschleifen mglich ist 
bergangsbereiche wie z.B. von Zeile 255 auf 256 zu berbrcken. Fr den Copper
ist es wieder die Zeile 0.

Das Sprite ist 13 Zeilen hoch und wird bei Zeile $fa gestartet. Das Ende wre
somit bei $107.

>?$fa+!13
$00000107 = %00000000`00000000`00000001`00000111 = 263 = 263
> 

Dies wird durch zwei Copperlisten gelst.
Die erste im Bereich von $fa bis $ff und die zweite von $00 bis $07. Die
Schwierigkeit besteht nur darin, wo der Skip ausgefhrt werden muss. Durch 
Tests wurde hier 'dc.w	$ffdd,$ffff' ermittelt. Danach bernimmt die zweite
Copperschleife.
