
; Listing24c2.s - https://eab.abime.net/showthread.php?t=109211
; Copperlinien mit Skip, ein "Artefakt" am Ende der Zeile berdecken
; Ursprung jobbo

	SECTION	COPPER,CODE
	
	incdir "/Sources/include/"	
	include	"MVstartup.s"		; Startup Code

			;5432109876543210
DMASET	equ	%1000001110000000	; copper DMA


Start:
	move.l	#Bitplane,d0		; Adresse der Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	
	move	#DMASET,dmacon(a5)
	move.l	#Copperlist,cop1lc(a5)

	move.l	#CopLoop1,d0
	move	d0,CopPtr1+6
	swap	d0
	move	d0,CopPtr1+2

	move.l	#CopLoop2,d0
	move	d0,CopPtr2+6
	swap	d0
	move	d0,CopPtr2+2

Mouse:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse

	rts

******************************************************************************

	SECTION	MY_COPPER,CODE_C

Copperlist:
	dc.w	$8e,$1aff		; DIWSTRT
	dc.w	$90,$38d1		; DIWSTOP
	dc.w	$92,$d0			; DDFSTRT
	dc.w	$94,$d8			; DDFSTOP
	dc.w	$102,0			; BPLCON1
	dc.w	$104,0			; BPLCON2
	dc.w	$108,0			; BPL1MOD
	dc.w	$10a,0			; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR00	; Hintergrund Schwarz
	dc.w	$182,$000		; COLOR01	; Farbe 1 der Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint
    dc.w	$1a2,$000		; COLOR17, oder Color1 des Sprite0 - schwarz
	dc.w	$1a4,$0f0		; COLOR18, oder Color2 des Sprite0 - grn
	dc.w	$1a6,$ff0		; COLOR19, oder Color3 des Sprite0 - gelb
	
	dc.w	$1a01,$fffe		; Warte auf Zeile $1a um rechtzeitig das Sprite vorzubereiten
	dc.w	$140,$00e0		; SPR0POS - Horizontale Position
	dc.w	$142,$0000		; SPR0CTL
	dc.w	$146,$0000		; SPR0DATB
	dc.w	$144,$07ff		; SPR0DATA - aktiviert Sprite

CopLines:	
	dc.w	$2c01, $fffe
	dc.w	$0180, $0f00, $00e1, $80fe
	dc.w	$0180, $00f0, $00e1, $80fe
	dc.w	$0180, $000f, $00e1, $80fe
	dc.w	$0180, $0f00, $00e1, $80fe
	dc.w	$0180, $00f0, $00e1, $80fe
	dc.w	$0180, $000f, $00e1, $80fe
	dc.w	$0180, $0f00, $00e1, $80fe
	dc.w	$0180, $00f0, $00e1, $80fe
	dc.w	$0180, $000f, $00e1, $80fe
	dc.w	$0180, $0f00, $00e1, $80fe	
	dc.w	$0180, $0000
		
	dc.w	$8007,$fffe
CopPtr1:
	dc.w	$084,0
	dc.w	$086,0

CopLoop1:	
	dc.w	$8007,$9ffe	
	dc.w	$0180, $0f00, $80e1, $80fe
	dc.w	$0180, $00f0, $80e1, $80fe
	dc.w	$0180, $000f, $80e1, $80fe

	dc.w	$9007,$9ffe	 
	dc.w	$0180, $0f00, $80e1, $80fe
	dc.w	$0180, $00f0, $80e1, $80fe
	dc.w	$0180, $000f, $80e1, $80fe

	dc.w	$9fd7,$9ffe	
	dc.w	$ffdd,$ffff		
	dc.w	$8a,0	
		
CopPtr2:
	dc.w	$084,0
	dc.w	$086,0
	
CopLoop2:		
	dc.w	$0007,$9ffe
	dc.w	$180,$000

	dc.w	$1007, $9ffe	 
	dc.w	$0180, $0f00, $00e1, $80fe
	dc.w	$0180, $00f0, $00e1, $80fe
	dc.w	$0180, $000f, $00e1, $80fe
	dc.w	$0180, $0f00, $00e1, $80fe
	dc.w	$0180, $00f0, $00e1, $80fe
	dc.w	$0180, $000f, $00e1, $80fe
	dc.w	$0180, $0f00, $00e1, $80fe
	dc.w	$0180, $00f0, $00e1, $80fe
	dc.w	$0180, $000f, $00e1, $80fe
	dc.w	$0180, $0f00, $00e1, $80fe	
	dc.w	$0180, $0000

	dc.w	$1fe1,$9ffe

	dc.w	$2007,$ffff
	dc.w	$8a,0
	
	dc.w	$ffff,$fffe

******************************************************************************

	SECTION LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end


Erklrung:

Wenn man mit dem Copper ber die gesamte Bildschirmbreite Copperlinien haben 
mchte und diese mit dem Skip, also durch Copperschleifen erstellt, steht man
augenscheinlich vor dem Problem, dass am Ende der Zeile eine Farbabstufung
erscheint.

Um diese Artefakte loszuwerden, bietet es sich an, es durch Bitplanedaten oder
durch ein Sprite zu berdecken.

Um das Artefakt zu sehen: ;dc.w	$140,$00e0		; SPR0POS - Horizontale Position
Um das Artefakt zu berdecken: dc.w	$140,$00e0	; SPR0POS - Horizontale Position


Erklrt wird die Farbabstufung so:

Ich warte auf das Zeilenende und der Copper Move fr den Farbwechsel erfolgt in 
der nchsten Zeile. Warum erfolgt der Farbwechsel nicht wie erwartet in der
neuen Zeile, sondern noch auf der alten Zeile am rechten Rand? 

ross Antwort:
Was Sie als "Ende der Zeile" bezeichnen, ist eigentlich nur der horizontale
Agnus-Zhler, der seinen fest verdrahteten Hchstwert erreicht, bevor der
vertikale Zhler hochgezhlt wird (tatschlich ist es nicht genau der Zyklus, 
in dem die Erhhung erfolgt, aber das ist eine andere Frage ...).

Das Anzeigegert wei absolut nichts darber, was im Chipsatz passiert, und 
kann daher nur auf die horizontale Leerzeile warten (die die Abdeckung der
Synchronsignale vorbereitet, wenn das Composite-Video im Ausgang verwendet 
wird, darum kmmert sich Denise) und den Hsync-Impuls fr "die Zeile ist
physisch beendet, gehe zurck nach links und zeichne eine neue" (und darum 
kmmert sich Agnus).

Diese Signale liegen recht nahe am Start der Zhler von Agnus/Denise, aber 
sicher nicht im Zyklus 0 :)
[Ich werde nicht beschreiben, wo sie sich tatschlich befinden und wie sie
verwaltet werden, die Diskussion wrde sehr themenfremd und kontextlos sein,
auf jeden Fall gibt es andere Threads, in denen es beschrieben wird, zum 
Beispiel den ber undokumentiertes Zeug] 

Es ist jedoch klar, warum die Zhler und das Zeilenende auf diese Weise
verwaltet werden: Es gibt viele DMA-Zyklen, die sich nicht ausschlielich auf
die Anzeige auswirken, und es ist logisch, dies whrend des horizontalen
Blanks oder besser unmittelbar nach dem letzten mglichen Bitplane-DMA-Zyklus
(Aktualisieren, Disk, Audio usw.) durchzufhren.
Und da die eigentliche Anzeige der abgerufenen Daten auch verzgert werden 
kann (siehe BPLCON1) und daher im uersten rechten Teil der Zeile angezeigt
werden kann, mssen sowohl das Blank als auch die Synchronisierung "spter"
im letzten Zyklus der Zeile durchgefhrt werden.

Ich hoffe, die Grnde fr die Entscheidungen der Designer sind nun etwas
klarer ;)                            