
; Listing24a4.s	vertikal und horizontales Copper-Masking
; Anzeigen eines Bildes in 320*256 mit 1 Plane (2 Farben)
; als 16x16-Raster 

 SECTION COPPER,CODE

Start:
	move.l	4.w,a6				; Execbase in a6 in a6
	jsr	-$78(a6) 				; Disable - verhindert Interrupts - stoppt das Multitasking
	lea	GfxName(pc),a1			; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)				; OldOpenLibrary, Routine der EXEC
	move.l	d0,GfxBase			; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; hier speichern wir die Adresse der Copperlist
								; des Betriebssystemes (immer auf $26 nach GfxBase)

	move.l	#Bitplane,d0		; in d0 kommt die Adresse von unserer Bitplane
	lea	Bplpointers,a1			; in a1 kommt die Adresse der Bitplane-Pointer der Copperlist
	moveq	#1-1,d1				; Anzahl der Bitplanes 0 (hier ist es 1)
PointBp:
	move.w	d0,6(a1)			; niederwertige Word der Plane-Adresse
	swap	d0					; vertauscht die 2 Word in d0 (Z.B.: 1234 > 3412)			     
	move.w	d0,2(a1)			; hochwertige Word der Adresse des 			      
	swap	d0					; orginale Adresse wieder hergestellt
	add.l	#40*256,d0			; Zhlen 10240 zu d0 dazu, nchste Bitplane
	addq.w	#8,a1				; Adresse der nchsten bplpointers in der Copperlist
	dbra	d1,PointBp			; Wiederhole d1 mal PointBp (d1=num of bitplanes)
	
	lea	$dff000,a5				; Custom Register Base in a5	
	move.l	#Copperlist,$80(a5)		; Zeiger Copperlist	
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"
	
Mouse:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	
	move.l	OldCop(pc),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts					

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0
	
******************************************************************************

	SECTION GRAPHIC,DATA_C
	
Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000
	
	dc.w	$8e,$2c81	; DIWSTRT	Register mit Standartwerten
	dc.w	$90,$2cc1	; DIWSTOP	
	dc.w	$92,$0038	; DDFSTRT
	dc.w	$94,$00d0	; DDFSTOP
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2
	dc.w	$108,0		; BPL1MOD
	dc.w	$10a,0		; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000	; bit 12 an!!	 (1 = %001)	1 Bitplane: (2 Farben)

Bplpointers:
	dc.w $e0,$0000,$e2,$0000	; erste	Bitplane - BPL0PT

;	Die 8 Farben des Bildes werden hier definiert:

	dc.w	$0180,$000	; COLOR00
	dc.w	$0182,$fff	; COLOR01
	
CopPos:	
;------------------------------------------------------------------------------
; 3. vertikale Maske $6c
;------------------------------------------------------------------------------

	dc.w	$1a07,$fffe
	dc.w	$180,$444	; COLOR00 - grau

	dc.w	$2c07,$fffe	; lasse es weg oder ndere es in dc.w	$2307,$fffe
						; und sehe selbst 
						; der Grund, das maskierte wait wird auch bei
						; $04, $0c, $14, $1c; $24 ausgefhrt	
;--- 1. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $2c
	dc.w	$180,$f00	; rot
	dc.w	$2f07,$fffe	;
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe	; auf das Ende der Zeile warten
;--- 2. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $34
	dc.w	$180,$00f	; rot
	dc.w	$3707,$fffe	; Zeile $37
	dc.w	$180,$444	; grau

    dc.w	$00e1,$80fe	; auf das Ende der Zeile warten
;--- 3. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $3c
	dc.w	$180,$f00	; rot
	dc.w	$3f07,$fffe	; Zeile $3f
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe	; auf das Ende der Zeile warten
;--- 4. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $44
	dc.w	$180,$00f	; rot
	dc.w	$4707,$fffe	; Zeile $47
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe	; auf das Ende der Zeile warten
;--- 5. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $4c
	dc.w	$180,$f00	; rot
	dc.w	$4f07,$fffe	; Zeile $4f
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe	; auf das Ende der Zeile warten
;--- 6. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $54
	dc.w	$180,$00f	; rot
	dc.w	$5707,$fffe	; Zeile $57
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------

	dc.w	$ffff,$fffe	; Ende der Copperlist


Bitplane:
	incbin	"/Sources/320x256x1_raster.raw"	; Bild im RAW 1 Bitplane

	end


Beispiele:

;------------------------------------------------------------------------------
; 1. horizontale Maske
;------------------------------------------------------------------------------

	dc.w	$40c1,$ff7e	;				; $10 ; $18 ; $90 ; $98
	dc.w	$180,$f00	; rot
	
	dc.w	$40c1,$ff7e	;
	dc.w	$180,$444	; grau

	dc.w	$4091,$fffe	;
	dc.w	$180,$444	; grau

	dc.w	$40c1,$ff7e	;				; $10 ; $18 ; $90 ; $98
	dc.w	$180,$f00	; rot
	
	dc.w	$40c1,$ff7e	;
	dc.w	$180,$444	; grau


;--- Alle horizontalen maskierten Positionen ---
;40   01000000   dez= 64
;41   01000001   dez= 65
;C0   11000000   dez= 192
;C1   11000001   dez= 193
;Das sind 4 Treffer.
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; 2. vertikale Maske $2c
;------------------------------------------------------------------------------

	dc.w	$1a07,$fffe
	dc.w	$180,$444	; COLOR00 - grau

	dc.w	$2c07,$fffe	; lasse es weg oder ndere es in dc.w	$2307,$fffe
						; und sehe selbst 
						; der Grund, das maskierte wait wird auch bei
						; $04, $0c, $14, $1c; $24 ausgefhrt	
;--- 1. maskiertes wait	----
	dc.w	$2c07,$87fe	; maskiertes wait		; $2c
	dc.w	$180,$f00	; rot
	dc.w	$2f07,$fffe	;
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 2. maskiertes wait	----
	dc.w	$2c07,$87fe	; maskiertes wait		; $34
	dc.w	$180,$00f	; rot
	dc.w	$3707,$fffe	; Zeile $37
	dc.w	$180,$444	; grau

    dc.w	$00e1,$80fe
;--- 3. maskiertes wait	----
	dc.w	$2c07,$87fe	; maskiertes wait		; $3c
	dc.w	$180,$f00	; rot
	dc.w	$3f07,$fffe	; Zeile $3f
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 4. maskiertes wait	----
	dc.w	$2c07,$87fe	; maskiertes wait		; $44
	dc.w	$180,$00f	; rot
	dc.w	$4707,$fffe	; Zeile $47
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 5. maskiertes wait	----
	dc.w	$2c07,$87fe	; maskiertes wait		; $4c
	dc.w	$180,$f00	; rot
	dc.w	$4f07,$fffe	; Zeile $4f
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 6. maskiertes wait	----
	dc.w	$2c07,$87fe	; maskiertes wait		; $54
	dc.w	$180,$00f	; rot
	dc.w	$5707,$fffe	; Zeile $57
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------

Maskieren = ausblenden, verdecken

Mit der Maske bleiben bestimmte Bitpositionen unbercksichtigt. Nur, die Bits
die in den VP und HP-Bitfeldern auf 1 eingestellt sind werden bercksichtigt.

Bei jeder Gleichheit von Strahlposition zur maskierten Wait-Position wird der
Wait ausgefhrt egal ob die Strahlposition gleich oder grer der 
eingestellten Wait-Position ist.

Wer es nicht glaubt ersetzt das $2c z.B. durch $6c. Das wrde das Wait vertikal
nach unten verschieben. Die maskierten waits bleiben aber gleich.

;------------------------------------------------------------------------------
; 3. vertikale Maske $6c
;------------------------------------------------------------------------------

	dc.w	$1a07,$fffe
	dc.w	$180,$444	; COLOR00 - grau

	dc.w	$6c07,$fffe	; lasse es weg oder ndere es in dc.w	$2307,$fffe
						; und sehe selbst 
						; der Grund, das maskierte wait wird auch bei
						; $04, $0c, $14, $1c; $24 ausgefhrt	
;--- 1. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $2c
	dc.w	$180,$f00	; rot
	dc.w	$2f07,$fffe	;
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 2. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $34
	dc.w	$180,$00f	; rot
	dc.w	$3707,$fffe	; Zeile $37
	dc.w	$180,$444	; grau

    dc.w	$00e1,$80fe
;--- 3. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $3c
	dc.w	$180,$f00	; rot
	dc.w	$3f07,$fffe	; Zeile $3f
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 4. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $44
	dc.w	$180,$00f	; rot
	dc.w	$4707,$fffe	; Zeile $47
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 5. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $4c
	dc.w	$180,$f00	; rot
	dc.w	$4f07,$fffe	; Zeile $4f
	dc.w	$180,$444	; grau

	dc.w	$00e1,$80fe
;--- 6. maskiertes wait	----
	dc.w	$6c07,$87fe	; maskiertes wait		; $54
	dc.w	$180,$00f	; rot
	dc.w	$5707,$fffe	; Zeile $57
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------

Eine Anwendung von maskierten Waits ist, es in Copperschleifen zu verwenden. 
(z.B. in allen geraden Zeilen oder in sich wiederholenden Abstnden.)

dc.w $0001,$80fe	; wait for the next scanline, unabhngig von vertikaler Position
dc.w $2c07,$fffe 	; wait bestimmte vertikale und horizontale Position
dc.w $2c07,$ff00	; wait bestimmte vertikale Position, ignoriere horizontale Position                                                                                                                                                                                          091,$fffe	; x+24 Pixel
	