
; Listing24a3.s	Copper-Positionen
; Anzeigen eines Bildes in 320*256 mit 1 Plane (2 Farben)
; als 16x16-Raster 

 SECTION COPPER,CODE

Start:
	move.l	4.w,a6				; Execbase in a6 in a6
	jsr	-$78(a6) 				; Disable - verhindert Interrupts - stoppt das Multitasking
	lea	GfxName(pc),a1			; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)				; OldOpenLibrary, Routine der EXEC
	move.l	d0,GfxBase			; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; hier speichern wir die Adresse der Copperlist
								; des Betriebssystemes (immer auf $26 nach GfxBase)
	
	move.l	#Bitplane,d0		; in d0 kommt die Adresse von unserer Bitplane
	lea	Bplpointers,a1			; in a1 kommt die Adresse der Bitplane-Pointer der Copperlist
	moveq	#1-1,d1				; Anzahl der Bitplanes 0 (hier ist es 1)
PointBp:
	move.w	d0,6(a1)			; niederwertige Word der Plane-Adresse
	swap	d0					; vertauscht die 2 Word in d0 (Z.B.: 1234 > 3412)			     
	move.w	d0,2(a1)			; hochwertige Word der Adresse des 			      
	swap	d0					; orginale Adresse wieder hergestellt
	add.l	#40*256,d0			; Zhlen 10240 zu d0 dazu, nchste Bitplane
	addq.w	#8,a1				; Adresse der nchsten bplpointers in der Copperlist
	dbra	d1,PointBp			; Wiederhole d1 mal PointBp (d1=num of bitplanes)
	
	lea	$dff000,a5				; Custom Register Base in a5	
	move.l	#Copperlist,$80(a5)		; Zeiger Copperlist	
	move.l	#Copperlist2,$84(a5)	; Zeiger Copperlist2
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"
	
Mouse:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	
	move.l	OldCop(pc),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts					

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0
	
******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000
	
	dc.w	$8e,$2c81	; DIWSTRT	Register mit Standartwerten
	dc.w	$90,$2cc1	; DIWSTOP	
	dc.w	$92,$0038	; DDFSTRT
	dc.w	$94,$00d0	; DDFSTOP
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2
	dc.w	$108,0		; BPL1MOD
	dc.w	$10a,0		; BPL2MOD

	; das BPLCON0 ($dff100) fr einen Bildschirm mit 1 Bitplane: (2 Farben)
				; 5432109876543210
	dc.w	$100,%0001001000000000	; bit 12 an!!		  (1 = %001)	1 Bitplanes: (2 Farben)
	;dc.w	$100,%0010001000000000	; bit 13 an!!		  (2 = %010)	2 Bitplanes: (4 Farben)
	;dc.w	$100,%0011001000000000	; bits 13 und 12 an!! (3 = %011)	3 Bitplanes: (8 Farben)
	;dc.w	$100,%0100001000000000	; bit 14 an!!		  (4 = %100)	4 Bitplanes: (16 Farben)
	;dc.w	$100,%0101001000000000	; bits 14 und 12 an!! (5 = %101)	5 Bitplanes: (32 Farben)
	;dc.w	$100,%0110001000000000	; bits 14 und 13 an!! (6 = %110)	6 Bitplanes: (64 Farben)
	
Bplpointers:
	dc.w $e0,$0000,$e2,$0000	; erste	Bitplane - BPL0PT
	;dc.w $e4,$0000,$e6,$0000	; zweite Bitplane - BPL1PT
	;dc.w $e8,$0000,$ea,$0000	; dritte Bitplane - BPL2PT
	;dc.w $ec,$0000,$ee,$0000	; vierte Bitplane - BPL3PT
	;dc.w $f0,$0000,$f2,$0000	; fnfte Bitplane - BPL4PT
	;dc.w $f4,$0000,$f6,$0000	; sechste Bitplane - BPL5PT


; Die 8 Farben des Bildes werden hier definiert:
	dc.w	$0180,$000	; COLOR00
	dc.w	$0182,$fff	; COLOR01
	;dc.w	$0184,$fff	; COLOR02
	;dc.w	$0186,$ccc	; COLOR03
	;dc.w	$0188,$999	; COLOR04
	;dc.w	$018a,$232	; COLOR05
	;dc.w	$018c,$777	; COLOR06
	;dc.w	$018e,$444	; COLOR07

; die weiteren Farben
	;dc.w	$0190,$444	; COLOR08
	;dc.w	$0192,$444	; COLOR09
	;dc.w	$0194,$444	; COLOR10
	;dc.w	$0196,$444	; COLOR11
	;dc.w	$0198,$444	; COLOR12
	;dc.w	$019a,$444	; COLOR13
	;dc.w	$019c,$444	; COLOR14
	;dc.w	$019e,$444	; COLOR15
	;dc.w	$01a0,$444	; COLOR16
	;dc.w	$01a2,$444	; COLOR17
	;dc.w	$01a4,$444	; COLOR18
	;dc.w	$01a6,$444	; COLOR19
	;dc.w	$01a8,$444	; COLOR20
	;dc.w	$01aa,$444	; COLOR21
	;dc.w	$01ac,$444	; COLOR22
	;dc.w	$01ae,$444	; COLOR23
	;dc.w	$01b0,$444	; COLOR24
	;dc.w	$01b2,$444	; COLOR25
	;dc.w	$01b4,$444	; COLOR26
	;dc.w	$01b6,$444	; COLOR27
	;dc.w	$01b8,$444	; COLOR28
	;dc.w	$01ba,$444	; COLOR29
	;dc.w	$01bc,$444	; COLOR30
	;dc.w	$01be,$444	; COLOR31

	
CopPos:	
	dc.w	$0101,$fffe
	dc.w	$180,$003	; COLOR0 - blau
;------------------------------------------------------------------------------
; 1. Welche Zeile kann als erstes angesprochen werden?
; Ergebnis:	yy=20
;------------------------------------------------------------------------------
	;dc.w	$1921fffe	; 19 geht nicht
	;dc.w	$180,$f00	; rot
	;dc.w	$193ffffe	
	;dc.w	$180,$444	; grau	
; ----------------
	dc.w	$2021,$fffe	; $20 ist die erste Zeile die angesprochen werden kann
	dc.w	$180,$f00	; rot
	dc.w	$203f,$fffe	; $3e - Ende der ersten Linie 
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 2. Welcher horizontale Startpunkt kann als erstes angesprochen werden?	
; Ergebnis: von xx=01 bis xx=27 ist alles gleich
;------------------------------------------------------------------------------
	;dc.w	$2201,$fffe	; wie 21
	;dc.w	$2207,$fffe	; wie 21
	dc.w	$2221,$fffe
	;dc.w	$2223,$fffe	; wie 21
	;dc.w	$2225,$fffe	; wie 21
	;dc.w	$2227,$fffe	; wie 21
	;dc.w	$2229,$fffe	; anders 
	dc.w	$180,$0f0	; grn
	dc.w	$2233,$fffe	; $33 ist der Punkt der angesprochen werden muss
						; damit eine Linie sichtbar wird, d.h.$33-$27=$6)
	dc.w	$180,$444	; grau 
;------------------------------------------------------------------------------
; 3. Welcher horizontale Punkt kann als letztes angesprochen werden?
; Ergebnis: xx=e0, d.h. von e2 bis 30
;------------------------------------------------------------------------------
	dc.w	$22e1,$fffe	; $22 noch Zeile $22
	dc.w	$180,$00f	; blau
	dc.w	$2331,$fffe	; $23 eine Zeile tiefer
	dc.w	$180,$444	; grau
; ----------------	
	dc.w	$24e1,$fffe	; $24 eine Zeile tiefer 
	dc.w	$180,$ff0	; gelb
	dc.w	$2533,$fffe	; endet in der nchsten Zeile
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 4. Welcher Welche Werte liegen ausserhalb des sichtbaren Bereichs?
; Ergebnis: von e2 bis 30
;------------------------------------------------------------------------------
	dc.w	$27e3,$fffe	; $27 noch Zeile $27
	dc.w	$180,$00f	; blau
	dc.w	$2831,$fffe	; $28 eine Zeile tiefer
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 5. Untersuchung copper execution time - move - wait
;------------------------------------------------------------------------------
	dc.w	$3031,$fffe								; bei bis zu 4 bitplanes
	;dc.w	$3031,$fffe		; gleich				; + 4 CCK
	;dc.w	$3007,$fffe		; schon berschritten	; + 4 CCK
	dc.w	$180,$444								; + 4 CCK 
	;dc.w	$180,$555								; + 2 CCK
	;dc.w	$180,$666								; + 2 CCK
	;dc.w	$180,$777								; + 2 CCK
	dc.w	$3033,$fffe								; + 4 CCK
	dc.w	$3035,$fffe								; + 4 CCK
	dc.w	$3037,$fffe								; + 4 CCK	
;------------------------------------------------------------------------------
; 6. Untersuchung copper execution time - move - skip
;------------------------------------------------------------------------------
	dc.w	$3121,$fffe		; ohne diese wait-Anweisung ist Sprungbedingung 
							; immer erfllt
	dc.w	$0180,$00f		
	dc.w	$0180,$0f0
	dc.w	$3131,$ffff		; skip hat diese Position erreicht
	;dc.w	$3181,$ffff		; skip hat diese Position noch nicht erreicht
	dc.w	$8a,0			; copjmp2 start
	dc.w	$0180,$666			
	dc.w	$0180,$444
;------------------------------------------------------------------------------
; 7. lngste Strecke mit Anfangs- und Endpunkt 
; Ergebnis: lngste Strecke von xx=32 bis xx=e0
;------------------------------------------------------------------------------
	dc.w	$3833,$fffe	; 
	dc.w	$180,$f0f	; lila
	dc.w	$38e1,$fffe	;
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 8. lngste volle Strecke
; Ergebnis: lngste Strecke von xx=30 bis xx=e2
;------------------------------------------------------------------------------
	dc.w	$4031,$fffe	; 
	dc.w	$180,$f0f	; lila
	dc.w	$40e3,$fffe	;
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 9. Linie auf Rahmen (Punkte vom Rahmen 320x256)
; Ergebnis: yy=4c   (x1 liegt zwischen xx=3f und xx=41 (2Pixel Genauigkeit)
;					(x2 liegt zwischen xx=df und xx=e1 (2Pixel Genauigkeit) 
;------------------------------------------------------------------------------
	dc.w	$4c3f,$fffe	; 
	dc.w	$182,$f00	; rot, diesmal auf $182 (Zeichenfarbe)
	dc.w	$4cdf,$fffe	;
	dc.w	$182,$fff	; wei
;------------------------------------------------------------------------------
; 10. Welcher Wert ist die Mitte?
; (($e0-$3e)/2)+$3e  (Endpunkt-Anfangspunkt)/2 + Rand links
; jeder wait und move - bentigt selbst 24 Pixel
;------------------------------------------------------------------------------
	dc.w	$5091,$fffe	; 
	dc.w	$180,$f00	; rot
	dc.w	$5091,$fffe	; x+24 Pixel
	dc.w	$180,$444	; grau
	
	dc.w	$5091,$fffe	; 
	dc.w	$180,$f00	; rot, x+24 Pixel
	dc.w	$5091,$fffe	;
	dc.w	$180,$444	; grau, x+24 Pixel (3x8)
;------------------------------------------------------------------------------
; 11. 2 Pixel Genauigkeit - Punkt am 320x256 Bildschirm
;------------------------------------------------------------------------------
	dc.w	$a021,$fffe
	dc.w	$180,$0f0	; grn
	dc.w	$a03f,$fffe	; 1.Punkt
	dc.w	$180,$444	; grau
; ----------------	
	dc.w	$a421,$fffe
	dc.w	$180,$00f	; blau	
	dc.w	$a441,$fffe	; 2.Punkt
	dc.w	$180,$444	; grau
; ----------------		
	dc.w	$a821,$fffe
	dc.w	$180,$ff0	; gelb
	dc.w	$a843,$fffe	; 3.Punkt
	dc.w	$180,$444	; grau
; ----------------	
	dc.w	$ac21,$fffe
	dc.w	$180,$f0f	; lila
	dc.w	$ac45,$fffe	; 4.Punkt
	dc.w	$180,$444	; grau
; ----------------		
	dc.w	$b021,$fffe
	dc.w	$180,$0ff	; cyan
	dc.w	$b047,$fffe	; 5.Punkt
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 12.  Copper bentigt Zeit fr Ausfhrung
;------------------------------------------------------------------------------	
	dc.w	$b441,$fffe	; Linie vom ersten Punkt
	dc.w	$180,$f00	; rot (von $40, $42, $44, $46, $50)
	dc.w	$b451,$fffe	; alle Lngen gleich, ab $52 anders)
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------
; 13. jeder move bentigt 8 Pixel
;------------------------------------------------------------------------------
	dc.w	$bb37,$fffe	; 
	dc.w	$180,$0f0	; grn
	dc.w	$bb41,$fffe	;
	dc.w	$180,$00f	; blau	
	dc.w	$180,$ff0	; gelb
	dc.w	$180,$f0f	; lila
	dc.w	$180,$0ff	; cyan
	dc.w	$180,$444
;------------------------------------------------------------------------------	
; 14. Zeile 255
;------------------------------------------------------------------------------		
	dc.w	$ff37,$fffe	; Zeile: $ff
	dc.w	$180,$f00	; rot
	dc.w	$ff41,$fffe	;
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------		
; 15. nach Zeile 255
;------------------------------------------------------------------------------	
	dc.w	$ffdf,$fffe	; > nach Zeile 255
	dc.w	$0531,$fffe	; Zeile 260
	dc.w	$180,$0f0	; grn
	dc.w	$0541,$fffe	;
	dc.w	$180,$444	; grau
;------------------------------------------------------------------------------	
; 16. Zeile 256 vom 320x256 bildschirm (255+$28)
;------------------------------------------------------------------------------	
	dc.w	$2c3f,$fffe	; 
	dc.w	$180,$00f	; blau
	dc.w	$2cdf,$fffe	;			; das erklrt auch warum wir dc.w	$ffdf,$fffe whlen	
	dc.w	$180,$444	; grau		; wir sind am Ende des Screens
;------------------------------------------------------------------------------		
; 17. tiefster Punkt
;------------------------------------------------------------------------------	
	dc.w	$3763,$fffe	; 
	dc.w	$180,$ff0	; gelb
	dc.w	$37df,$fffe	;			
	dc.w	$180,$444	; grau		
;------------------------------------------------------------------------------	
	dc.w	$ffff,$fffe	; Ende der copperlist
	

Copperlist2:			; Copperlist 2
	dc.w	$8007,$fffe	 
	dc.w	$180,$000	; schwarz
	dc.w	$a007,$fffe	 
	dc.w	$180,$fff	; wei
	dc.w	$c007,$fffe	 
	dc.w	$180,$ff0	; gelb
	;dc.w	$88,0	
	dc.w	$ffff,$fffe


Bitplane:
	incbin	"/Sources/320x256x1_raster.raw"	; Bild im RAW 1 Bitplane

	end


Erklrung:

Das ganze dient eher so einer Art Copper-Grundlagenforschung.

WinUAE Debugger:	
- ffnen mit Shift+F12
- v startet den DMA_Debugger
- v $30 $20		- Rasterzeile $30, ab horizontaler Position $20 anzeigen

Warum horizontale Wait-Position $de? 

	dc.w	$2cdf,$fffe	; letzte horizontale Position des Screens

Es ist die letzte horizontale Position eines 320x256 Screens mit DIWSTRT bei
$81. ($81+$140=$1c1) (129+320=449) 449/2=224	bzw. $e0

Um auf die Zeile $2d zu warten kann man in der vorhergehenden Zeile warten wo
der Raster aus dem Screen geht. Nun hat man mehr Rasterzeit um z.B. die Palette
zu ndern. 

Oder allgemein sollten Copperanweisungen ausserhalb von DDFSTOP und vor Beginn
DDFSTRT platziert werden.