
; Listing23e.s		hires, interlace, overscan - max screensize
;					(736x566) experimentell ermittelt

	SECTION	INTERLACE,CODE

;	Include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "WO"

*****************************************************************************
	include "/Sources/startup2.s"	; speichern copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

WAITDISK	equ	30

SCRBYTES	= 92				; Anzahl der Bytes fr jede horizontale Zeile.
								; Daraus berechnen wir die Bildschirmbreite,
								; Multiplizieren von Bytes mit 8: normaler Bildschirm 320/8 = 40
								; z.B. fr einen 336 Pixel breiten Bildschirm 336/8 = 42
								; Beispielbreiten:
								; 264 pixel = 33 / 272 pixel = 34 / 280 pixel = 35
								; 360 pixel = 45 / 368 pixel = 46 / 376 pixel = 47
								; ... 640 pixel = 80 / 648 pixel = 81 ...

SCR_H		= 566				; Bildschirmhhe in Zeilen
SCR_X		= $59				; Startbildschirm, XX-Position (normal $xx81) (129)
SCR_Y		= $1a				; Startbildschirm, YY-Position (normal $2cxx) (44)
SCR_RES		= 2					; 2 = HighRes (640*xxx) / 1 = LowRes (320*xxx)
SCR_LACE	= 1					; 0 = non interlace (xxx*256) / 1 = interlace (xxx*512)
HAM			= 0					; 0 = non HAM / 1 = HAM
SCR_BPL		= 1					; Anzahl Bitplanes

; Parameter automatisch berechnet

SCR_W		= SCRBYTES*8		; Bildschirmbreite
SCR_SIZE	= SCRBYTES*SCR_H	; Gre in Bytes des Bildschirms
BPLC0		= ((SCR_RES&2)<<14)+(SCR_BPL<<12)+$200+(SCR_LACE<<2)+(HAM<<11)		; BPLCON0
DIWS		= (SCR_Y<<8)+SCR_X													; DIWSTRT
DIWST		= ((SCR_Y+SCR_H/(SCR_LACE+1))&255)<<8+((SCR_X+SCR_W/SCR_RES)&255) 	; DIWSTOP
DDFS		= (SCR_X-(16/SCR_RES+1))/2											; DDFSTRT
DDFST		= DDFS+(8/SCR_RES)*(SCRBYTES/2-SCR_RES)								; DDFSTOP

Start:
	move.l	#Bitplane,d0		; Adresse der Bitplane in d0
	lea	Bplpointers1,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)	

	move.l	#Bitplane+SCRBYTES,d0		; Adresse der Bitplane in d0
	lea	Bplpointers2,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	
	move.l	#Copperlist2,d0		; Adresse der Copperlist in d0
	lea	CopPtr1,a1				; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist1,d0		; Adresse der Copperlist in d0
	lea	CopPtr2,a1				; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$dff084 ; COPL2
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	bsr	BitplaneFrame			; Bilderrahmen (Aussengrenzen) hinzufgen
	bsr LaceInt					; LOF-Bit testen und Copperpointer eintragen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$01000,d2			; warte auf Zeile $010
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	andi.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmpi.l	d2,d0				; warte auf Zeile $010
	bne.s	WarteY1
Waity2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	andi.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmpi.l	d2,d0				; warte auf Zeile $010
	Beq.S	Waity2
	
	;bsr.w	effekt				; hier irgendeinen Effekt hinzufgen

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse

	rts

******************************************************************************
; INTERLACE ROUTINE - Test Bit LOF (Long Frame) um zu wissen, ob Sie
; gerade oder ungerade Zeilen anzeigen und entsprechend wechseln mssen.
******************************************************************************

LaceInt:
	btst.b	#15-8,4(a5)			; VPOSR LOF bit?
	beq.s	MakeOdd				; wenn ja, zeigen Sie auf ungerade Zeilen
	
								; Starten der Ansicht von den geraden Zeilen!
	move.l	#Copperlist1,$dff080	; unsere COP
	rts

MakeOdd:
	move.l	#Copperlist2,$dff080	; unsere COP
	rts

******************************************************************************
; Bildrahmen
******************************************************************************

BitplaneFrame:
	lea Bitplane,a0					; erste Zeile
	lea BitplaneEnd-SCRBYTES,a1		; letzte Zeile
	move.b #$ff,d0					; die Bitplane mit Linien fllen	
	move.w #SCRBYTES-1,d1			; Anzahl Bytes (Bildschirmbreite)
Pf1:
	move.b d0,(a0)+					; obere Linie
	move.b d0,(a1)+					; untere Linie
	dbf d1,Pf1

	lea Bitplane+SCRBYTES,a0		; mit der zweiten Zeile beginnen links
	lea Bitplane+SCRBYTES+SCRBYTES-1,a1	; mit der zweiten Zeile beginnen rechts
	move.b #$80,d0					; senkrechte Linie links
	move.b #$01,d1					; senkrechte Linie rechts
	move.w #SCR_H-2-1,d2			; Hhe-2 Zeilen
Pf2:
	move.b d0,(a0)
	move.b d1,(a1)
	lea SCRBYTES(a0),a0				; nchste Zeile (SCRBYTES=80)
	lea SCRBYTES(a1),a1				; nchste Zeile (SCRBYTES=80)
	dbf d2,Pf2
	
	rts

******************************************************************************

	SECTION	GRAPHIC,DATA_C
	
Copperlist1:
Bplpointers1:
	dc.w	$e0,0,$e2,0		; erste Bitplane
CopPtr1:
	dc.w 	$80,$0,$82,$0	; auf Copperlist2 setzen 
	dc.w 	$8a,$0			; COPJMP2

Copperlist2:
Bplpointers2:
	dc.w	$e0,0,$e2,0		; erste Bitplane+80
CopPtr2:
	dc.w 	$80,$0,$82,$0	; auf Copperlist1 setzen 

Copperlist:	
	dc.w	$8e,DIWS		; DIWSTRT
	dc.w	$90,DIWST		; DIWSTOP
	dc.w	$92,DDFS		; DDFSTRT
	dc.w	$94,DDFST		; DDFSTOP

	dc.w	$102,$33			; BPLCON1	etwas nach rechts verschieben
	dc.w	$104,0				; BPLCON2
	dc.w	$108,SCRBYTES		; BPL1MOD \ INTERLACE: modulo = Lnge Zeile!
	dc.w	$10a,SCRBYTES		; BPL2MOD / um sie zu berspringen (die geraden)

				; 5432109876543210
;	dc.w	$100,%1001001000000100	; 1 Bitplane, HIRES LACE 640x512
;								; Beachten Sie das Bit 2 Set fr LACE!!

	dc.w	$100,BPLC0			; BplCon0 -> lassen Sie es uns automatisch berechnen!
	
	dc.w	$180,$226			; COLOR00 - Hintergrund
	dc.w	$182,$0b0			; color1 - plane 1 Position normal, und
								; der "klebende" Teil an der Spitze.

	dc.w	$ffff,$fffe			; Ende Copperlist


******************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	SCRBYTES*SCR_H		; 92*566 eine Bitplane Hires int. 736x566
BitplaneEnd:

	end

Erklrung:

WinUAE bietet unter Display/ Overscan folgende Einstellmglichkeiten:
-TV (narrow)
-TV (standard)
-TV (wide)
-Overscan					; zeigt rechts den Rand
-Overscan+					; zeigt links den Rand
-Extreme
-Ultra extreme debug
-Ultra extreme debug (HV)
-Ultra extreme debug (C)

Das Bild zeigt einen schmalen Rahmen um den Screen, der in die usseren 
Pixelreihen und -spalten in die Bitplane gezeichnet wurden. Der Screen wurde 
mit dem BPLCON1 etwas nach rechts verschoben.

;------------------------------------------------------------------------------
Ergebnis: (736x) - 46*16=736	(mod 92)

scr_bytes = 92
scr_x = $5c
DIWSTRT: $1a5c DIWSTOP: $35cc DDFSTRT: $0028 DDFSTOP: $00d8

Es sind gute und richtige Werte. Es gibt keine Probleme. (DDFSTOP_ex =D8)
Es ist keine Modulo Korrektur notwendig.

The first pixel after the blank is with DDFSTRT=$28 and BPLCON1=$33.
Of course changing BPLCON1 you can 'move' the covered part and use some of the
unused space at the extreme right (not completely, but in any case it is 
usually off-screen).

