
; Listing23a2.s
; vertikale Positionierung eines Lowres-Screens 320x256
; dynamisch
; keine nderung der DDFSTRT-DDFSTOP Werte

	SECTION SCREEN,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; wir speichern die alte Copperlist

	move.l	#Bitplane,d0		; Adresse des Bitplane in d0
	lea	Bplpointers,a1			; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist	
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Init:
	move.b #$20,d0				; Start DIWSTRT Y-Position
	move.b #1,d1				; Y-Position add

MainLoop:
	cmpi.b	#$aa,$dff006		; Zeile $aa?
	bne.s	MainLoop
Warte:
	cmpi.b	#$aa,$dff006		; Zeile $aa?
	beq.s	Warte
	
	bsr.w	BewegeDIW			; Bewege Screen vertikal (ber $ff)
		
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	MainLoop	
	
	move.l	OldCop(PC),$dff080	; Pointen auf die alte System Copperlist
	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	GfxBase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

*******************************************************************************
* In dieser Routine werden die DIW Y-Werte in der Copperliste gendert        *
*******************************************************************************

BewegeDIW:
	add.b d1,d0
	cmp.b #$80,d0		; bottom check - sind wir unten?	$37		;$7f	;$ff	;$80
	bne Ok1				; 				
	neg d1				; change direction	1 wird -1
Ok1:
	cmp.b #$ff,d0		; sind wir oben?					$1a		;$0		;$1a	;$ff
	bne Ok2				; 
	neg d1				; change direction	-1 wird 1
Ok2:	
	move.b d0,WaitDiw1
	;move.b d0,WaitDiw2 ; teste das
	rts

******************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e
WaitDiw1:
	dc.w	$3781		; DIWSTRT
	dc.w	$90
WaitDiw2:
	dc.w	$37c1		; DIWSTOP
	dc.w	$92,$38		; DDFSTRT
	dc.w	$94,$d0		; DDFSTOP
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2
	dc.w	$108,0		; BPL1MOD
	dc.w	$10a,0		; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres	

Bplpointers:
	dc.w	$e0,0,$e2,0	; erste Bitplane

	dc.w	$180,$000	; COLOR00	; Hintergrund schwarz
	dc.w	$182,$0f0	; COLOR01	; Farbe 1 der Bitplane

; ein paar Orientierungsmarken setzen
	dc.w	$2021,$fffe	; 20 ist die erste Zeile die angesprochen werden kann
	dc.w	$180,$aaa
	dc.w	$203f,$fffe	
	dc.w	$180,$000

	dc.w	$7f21,$fffe	; $7f bis hier kann DIWSTRT VV verschoben werden
	dc.w	$180,$aaa
	dc.w	$7f3f,$fffe	
	dc.w	$180,$000	
		
	dc.w	$ffdf,$fffe	; > Zeile 255
			
	dc.w	$3721,$fffe	; 37 ist die letzt Zeile die angesprochen werden kann
	dc.W	$180,$aaa
	dc.w	$373f,$fffe	
	dc.w	$180,$000
							
	dc.w	$ffff,$fffe	; Ende der Copperlist

	
Bitplane:
	;blk.b 10240,$55
	incbin "/Sources/320x256x1_raster.raw"
	blk.b 10240,$00		; Bildschirm reinigen

	end


Erklrung:

In diesem Listing wird der Screen (320x256) vom oberen zum unteren Bereich und zurck
verschoben.

BewegeDIW:
	add.b d1,d0
	cmp.b #$80,d0		; bottom check - sind wir unten?	$37		;$7f	;$ff	;$80
	bne Ok1				; 				
	neg d1				; change direction	1 wird -1
Ok1:
	cmp.b #$ff,d0		; sind wir oben?					$1a		;$0		;$1a	;$ff
	bne Ok2				; 
	neg d1				; change direction	-1 wird 1
Ok2:	
	move.b d0,WaitDiw1
	;move.b d0,WaitDiw2 ; teste das
	rts

;------------------------------------------------------------------------------	
	cmp.b #$37,d7		; bottom check - sind wir unten?	$37		;$7f	;$ff	$80
	cmp.b #$1a,d7		; sind wir oben?					$1a		;$0		;$1a	$ff

$37 und $1a sind die vertikalen Positionswerte zwischen denen sich der Screen auf dem
Monitor bewegt und dabei immer voll sichtbar ist.

Die vertikale Startposition von DIWSTRT kann nicht grer als 255 sein.
Die vertikale Startposition von DIWSTRT kann nicht kleiner als 128 sein.

also: 
DIWSTRT: VV: von $1a bis $ff mglich
DIWSTOP: VV: von $80 bis $7f ($17f)

V7=0 --> V8=1
1.0000.0000 bis 1.0111.1111	= 256 bis 511  
--> $00 bis $7f	--> resultierend: $100 bis $17f	d.h. Zeile 256 bis 383
V7=1 --> V8=0
0.1000.0000 bis 0.1111.1111 = 128 bis 255
--> $80 bis $ff	--> resultierend: $80 bis $ff	d.h. Zeile 128 bis 255

$80	= %1000.0000	= 128
$81 = %1000.0001	= 129
$ff = %1111.1111	= 255
$00 = %0000.0000	= 256
$01 = %0000.0001	= 257
$7f = %0111.1111	= 383

Eine vertikale Endposition kleiner als 128 ist nicht mglich!
Eine vertikale Position ber 311 ($137) ist nicht sichtbar.
