
; Listing19m1.s
; debugging an assembler program to analyze the ROM-routines with H 'History'
; start and run from asmone	
;
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  H[H] <cnt>            Show PC history (HH=full CPU info) <cnt> instructions.
;  f <address>           Add/remove breakpoint.
;  fl                    List breakpoints.
;  fd                    Remove all breakpoints.
;  d <address> [<lines>] Disassembly starting at <address>.
;  t [instructions]      Step one or more instructions.
;  g [<address>]         Start execution at the current address or <address>.
;  z   Step through one instruction - useful for JSR, DBRA etc.
;  m <address> [<lines>] Memory dump starting at <address>.
;------------------------------------------------------------------------------
;

start:

waitmouse:  
	btst	#6,$bfe001			; left mousebutton?
	bne.s	Waitmouse	
	
anfang:
	move.l	4.w,a6				; Execbase
	jsr	-$78(a6)				; Disable
	lea	GfxName(PC),a1			; Libname
	jsr	-$198(a6)				; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop		; save old COP

;mouse:
;	btst	#6,$bfe001			; left mousebutton?
;	bne.s	mouse

	;...
	move.l	OldCop(PC),$dff080	; Pointer to old SystemCopperlist
	move.w	d0,$dff088			; Starten old SystemCopperlist

	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	gfxbase(PC),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

	end

;------------------------------------------------------------------------------
>r
Filename:Listing19c5.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is waiting for the left mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - set a breakpoint
>d pc
00025ff4 66f6                     bne.b #$f6 == $00025fec (T)
00025ff6 2c78 0004                movea.l $0004.w [00c00276],a6
00025ffa 4eae ff88                jsr (a6,-$0078) == $ffffff88
00025ffe 43fa 0036                lea.l (pc,$0036) == $00026036,a1
00026002 4eae fe68                jsr (a6,-$0198) == $fffffe68
00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]
0002600c 2c40                     movea.l d0,a6
0002600e 23ee 0026 0002 604c      move.l (a6,$0026) == $00000026 [082600fc],$0002604c [00000000]
00026016 23fa 0034 00df f080      move.l (pc,$0034) == $0002604c [00000000],$00dff080
0002601e 33c0 00df f088           move.w d0,$00dff088
>f 25ff6																		; step 2 - set a breakpoint
Breakpoint added.
>x																				; leave the debugger
;------------------------------------------------------------------------------			
																				; now click left mouse and the Debugger reopens and wait on this line
>d pc																			; the actual program
00025ff6 2c78 0004                movea.l $0004.w [00c00276],a6
00025ffa 4eae ff88                jsr (a6,-$0078) == $ffffff88
00025ffe 43fa 0036                lea.l (pc,$0036) == $00026036,a1
00026002 4eae fe68                jsr (a6,-$0198) == $fffffe68
00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]
0002600c 2c40                     movea.l d0,a6
0002600e 23ee 0026 0002 604c      move.l (a6,$0026) == $00000026 [082600fc],$0002604c [00000000]
00026016 23fa 0034 00df f080      move.l (pc,$0034) == $0002604c [00000000],$00dff080
0002601e 33c0 00df f088           move.w d0,$00dff088
00026024 2c78 0004                movea.l $0004.w [00c00276],a6
;------------------------------------------------------------------------------	
>t																				; step  3 - trace (step one)	
Cycles: 8 Chip, 16 CPU. (V=210 H=22 -> V=210 H=30)
VPOS: 210 ($0d2) HPOS: 030 ($01e) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FDF0
USP  00C5FDF0 ISP  00C60DF0
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4eae (JSR) ff88 (ILLEGAL) Chip latch 00000000
00025ffa 4eae ff88                jsr (a6,-$0078) == $00c001fe					; jsr	-$78(a6) --> $78+00C0 0276  = $00 C0 01 FE
Next PC: 00025ffe
;------------------------------------------------------------------------------	
>m 0 4																			; memory from beginning adress 0
00000000 0000 0000 00C0 0276 00FC 0818 00FC 081A  .......v........				; on adress 4: 00C0 0276		
00000010 00FC 081C 00FC 081E 00FC 0820 00FC 0822  ........... ..."
00000020 00FC 090E 00FC 0826 00FC 0828 00FC 082A  .......&...(...*
00000030 00FC 082C 00FC 082E 00FC 0830 00FC 0832  ...,.......0...2
>m C00276 1																		; A6 00C00276	(move.l $4.w,a6)
00C00276 00C0 192E 00C0 03F0 0900 00FC 00A8 0400  ................
;------------------------------------------------------------------------------	
>z																				; step 4 - Step through one instruction - useful for JSR
Cycles: 41 Chip, 82 CPU. (V=210 H=30 -> V=210 H=71)
VPOS: 210 ($0d2) HPOS: 071 ($047) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FDF0
USP  00C5FDF0 ISP  00C60DF0
SR=0015 T=00 S=0 M=0 X=1 N=0 Z=1 V=0 C=1 IM=0 STP=0
Prefetch 43fa (LEA) 0036 (OR) Chip latch 00000000
00025ffe 43fa 0036                lea.l (pc,$0036) == $00026036,a1
Next PC: 00026002
;------------------------------------------------------------------------------
>m 26036 2
00026036 6772 6170 6869 6373 2E6C 6962 7261 7279  graphics.library				; lea.l (pc,$0036) == $00026036,a1
00026046 0000 0000 0000 0000 0000 1234 5678 0101  ...........4Vx..				; lea	GfxName(PC),a1			; Libname
;------------------------------------------------------------------------------	
>t																				; step  5 - trace (step one)
Cycles: 4 Chip, 8 CPU. (V=210 H=71 -> V=210 H=75)
VPOS: 210 ($0d2) HPOS: 075 ($04b) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00026036   A2 00000000   A3 00000000							; A1 00026036
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FDF0
USP  00C5FDF0 ISP  00C60DF0
SR=0015 T=00 S=0 M=0 X=1 N=0 Z=1 V=0 C=1 IM=0 STP=0
Prefetch 4eae (JSR) fe68 (ILLEGAL) Chip latch 00000000
00026002 4eae fe68                jsr (a6,-$0198) == $00c000de					; jsr (a6,-$0198) == $00c000de ; OpenLibraryNext PC: 00026006
;------------------------------------------------------------------------------	
>d pc																			; where are we now?
00026002 4eae fe68                jsr (a6,-$0198) == $00c000de
00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]				; set 2nd breakpoint after subroutine	
0002600c 2c40                     movea.l d0,a6
0002600e 23ee 0026 0002 604c      move.l (a6,$0026) == $00c0029c [ff3ffd89],$0002604c [00000000]
00026016 23fa 0034 00df f080      move.l (pc,$0034) == $0002604c [00000000],$00dff080
0002601e 33c0 00df f088           move.w d0,$00dff088
00026024 2c78 0004                movea.l $0004.w [00c00276],a6
00026028 4eae ff82                jsr (a6,-$007e) == $00c001f8
0002602c 227a 001a                movea.l (pc,$001a) == $00026048 [00000000],a1
00026030 4eae fe62                jsr (a6,-$019e) == $00c000d8
;------------------------------------------------------------------------------	
>f 26006																		; step 6 - set breakpoint
Breakpoint added.
>fl																				; list breakpoints
0: PC == 00025ff6 [00000000 00000000]
1: PC == 00026006 [00000000 00000000]											; 2nd breakpoint										
;------------------------------------------------------------------------------																			
>g																				; run
Breakpoint 1 triggered.															; breakpoint 1 
Cycles: 941 Chip, 1882 CPU. (V=210 H=75 -> V=214 H=108)
VPOS: 214 ($0d6) HPOS: 108 ($06c) COP: $0001ede4
  D0 00C028F6   D1 00026036   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00C028F6   A1 00026036   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FDF0
USP  00C5FDF0 ISP  00C60DF0
SR=0010 T=00 S=0 M=0 X=1 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 23c0 (MOVE) 0002 (OR) Chip latch 00000000
00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]				; move.l d0,$00026048	-> move.l	d0,GfxBase
Next PC: 0002600c

;------------------------------------------------------------------------------
>H 200																			; show the last 200 instructions
...
 0 071/210 00025ffe 43fa 0036                lea.l (pc,$0036) == $00026036,a1	; lea	GfxName(PC),a1			; Libname
 0 075/210 00026002 4eae fe68                jsr (a6,-$0198) == $00c000de		; jsr	-$198(a6)				; OpenLibrary
 0 084/210 00c000de 4ef9 00fc 146c           jmp $00fc146c
 0 090/210 00fc146c 7000                     moveq #$00,d0
 0 092/210 00fc146e 4eae fdd8                jsr (a6,-$0228) == $00c0004e
 0 101/210 00c0004e 4ef9 00c0 66b2           jmp $00c066b2
 0 107/210 00c066b2 518f                     subaq.l #$08,a7
 0 111/210 00c066b4 4879 00fe 46be           pea.l $00fe46be
 0 121/210 00c066ba 6034                     bra.b #$34 == $00c066f0 (T)
 0 126/210 00c066f0 2f4d 0008                move.l a5,(a7,$0008) == $00c5fde4 [00000000]
 0 134/210 00c066f4 4bfa 000c                lea.l (pc,$000c) == $00c06702,a5
 0 138/210 00c066f8 2f4d 0004                move.l a5,(a7,$0004) == $00c5fde0 [00c06702]
 0 146/210 00c066fc 4bfa ff7c                lea.l (pc,$ff7c) == $00c0667a,a5
 0 150/210 00c06700 4e75                     rts  == $00000000
 0 158/210 00fe46be 4e52 ffe0                link.w a2,#$ffe0
 0 166/210 00fe46c2 48ea 1b03 ffe8           movem.l d0-d1/a0-a1/a3-a4,(a2,-$0018) == $00c5fdc4
 0 196/210 00fe46c8 47ed 008c                lea.l (a5,$008c) == $00c06706,a3
 0 200/210 00fe46cc 2549 ffe0                move.l a1,(a2,-$0020) == $00c5fdbc [00026036]
 0 208/210 00fe46d0 6012                     bra.b #$12 == $00fe46e4 (T)
 0 213/210 00fe46e4 6100 01b8                bsr.w #$01b8 == $00fe489e
 0 222/210 00fe489e 4cea 0303 ffe8           movem.l (a2,-$0018) == $00c5fdc4,d0-d1/a0-a1
 0 019/211 00fe48a4 2f2b 0000                move.l (a3,$0000) == $00c06706 [00fe48c0],-(a7) [00fe48c8]
 0 031/211 00fe48a8 2c6d 0022                movea.l (a5,$0022) == $00c0669c [00c00276],a6
 0 039/211 00fe48ac 4e75                     rts  == $00fe48c8
 0 047/211 00fe48c0 226a ffe0                movea.l (a2,-$0020) == $00c5fdbc [00026036],a1
 0 055/211 00fe48c4 4ead ffdc                jsr (a5,-$0024) == $00c06656
 0 064/211 00c06656 4ef9 00fc 1474           jmp $00fc1474
 0 070/211 00fc1474 2f02                     move.l d2,-(a7) [00000000]
 0 076/211 00fc1476 2400                     move.l d0,d2
 0 078/211 00fc1478 522e 0127                addq.b #$01,(a6,$0127) == $00c0039d [ff]
 0 086/211 00fc147c 41ee 017a                lea.l (a6,$017a) == $00c003f0,a0
 0 090/211 00fc1480 6100 0214                bsr.w #$0214 == $00fc1696
 0 099/211 00fc1696 2f0a                     move.l a2,-(a7) [00fc1498]
 0 105/211 00fc1698 2448                     movea.l a0,a2
 0 107/211 00fc169a 2209                     move.l a1,d1
 0 109/211 00fc169c 2012                     move.l (a2) [00c00276],d0
 0 115/211 00fc169e 6718                     beq.b #$18 == $00fc16b8 (F)
 0 119/211 00fc16a0 2440                     movea.l d0,a2
 0 121/211 00fc16a2 2012                     move.l (a2) [00c0192e],d0
 0 127/211 00fc16a4 6712                     beq.b #$12 == $00fc16b8 (F)
 0 131/211 00fc16a6 206a 000a                movea.l (a2,$000a) == $00c00280 [00fc00a8],a0
 0 139/211 00fc16aa 2241                     movea.l d1,a1
 0 141/211 00fc16ac b308                     cmpm.b (a0)+ [65],(a1)+ [67]
 0 147/211 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 152/211 00fc16a0 2440                     movea.l d0,a2
 0 154/211 00fc16a2 2012                     move.l (a2) [00c028f6],d0
 0 160/211 00fc16a4 6712                     beq.b #$12 == $00fc16b8 (F)
 0 164/211 00fc16a6 206a 000a                movea.l (a2,$000a) == $00c01938 [00fc4bb0],a0
 0 172/211 00fc16aa 2241                     movea.l d1,a1
 0 174/211 00fc16ac b308                     cmpm.b (a0)+ [65],(a1)+ [67]
 0 180/211 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 185/211 00fc16a0 2440                     movea.l d0,a2
 0 187/211 00fc16a2 2012                     move.l (a2) [00c04466],d0
 0 193/211 00fc16a4 6712                     beq.b #$12 == $00fc16b8 (F)
 0 197/211 00fc16a6 206a 000a                movea.l (a2,$000a) == $00c02900 [00fc53fe],a0
 0 205/211 00fc16aa 2241                     movea.l d1,a1
 0 207/211 00fc16ac b308                     cmpm.b (a0)+ [67],(a1)+ [67]				; $67 = g	the ascii-numbers		
 0 213/211 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 217/211 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc53fe [67]
 0 223/211 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 001/212 00fc16ac b308                     cmpm.b (a0)+ [72],(a1)+ [72]				; $72 = r
 0 007/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 011/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc53ff [72]
 0 017/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 022/212 00fc16ac b308                     cmpm.b (a0)+ [61],(a1)+ [61]				; $61 = a
 0 028/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 032/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5400 [61]
 0 038/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 043/212 00fc16ac b308                     cmpm.b (a0)+ [70],(a1)+ [70]				; $70 = p
 0 049/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 053/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5401 [70]
 0 059/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 064/212 00fc16ac b308                     cmpm.b (a0)+ [68],(a1)+ [68]				; $68 = h
 0 070/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 074/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5402 [68]
 0 080/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 085/212 00fc16ac b308                     cmpm.b (a0)+ [69],(a1)+ [69]				; $69 = i
 0 091/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 095/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5403 [69]
 0 101/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 106/212 00fc16ac b308                     cmpm.b (a0)+ [63],(a1)+ [63]				; $63 =	c
 0 112/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 116/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5404 [63]
 0 122/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 127/212 00fc16ac b308                     cmpm.b (a0)+ [73],(a1)+ [73]
 0 133/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 137/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5405 [73]
 0 143/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 148/212 00fc16ac b308                     cmpm.b (a0)+ [2e],(a1)+ [2e]
 0 154/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 158/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5406 [2e]
 0 164/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 169/212 00fc16ac b308                     cmpm.b (a0)+ [6c],(a1)+ [6c]
 0 175/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 179/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5407 [6c]
 0 185/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 190/212 00fc16ac b308                     cmpm.b (a0)+ [69],(a1)+ [69]
 0 196/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 200/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5408 [69]
 0 206/212 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 211/212 00fc16ac b308                     cmpm.b (a0)+ [62],(a1)+ [62]
 0 217/212 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 221/212 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc5409 [62]
 0 000/213 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 005/213 00fc16ac b308                     cmpm.b (a0)+ [72],(a1)+ [72]
 0 011/213 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 015/213 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc540a [72]
 0 021/213 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 026/213 00fc16ac b308                     cmpm.b (a0)+ [61],(a1)+ [61]
 0 032/213 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 036/213 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc540b [61]
 0 042/213 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 047/213 00fc16ac b308                     cmpm.b (a0)+ [72],(a1)+ [72]
 0 053/213 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 057/213 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc540c [72]
 0 063/213 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 068/213 00fc16ac b308                     cmpm.b (a0)+ [79],(a1)+ [79]
 0 074/213 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 078/213 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc540d [79]
 0 084/213 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 089/213 00fc16ac b308                     cmpm.b (a0)+ [00],(a1)+ [00]
 0 095/213 00fc16ae 66f0                     bne.b #$f0 == $00fc16a0 (T)
 0 099/213 00fc16b0 4a28 ffff                tst.b (a0,-$0001) == $00fc540e [00]
 0 105/213 00fc16b4 66f6                     bne.b #$f6 == $00fc16ac (T)
 0 109/213 00fc16b6 200a                     move.l a2,d0
 0 111/213 00fc16b8 2241                     movea.l d1,a1
 0 113/213 00fc16ba 245f                     movea.l (a7)+ [00fc1498],a2
 0 119/213 00fc16bc 4e75                     rts  == $00fc149e
 0 127/213 00fc1484 4a80                     tst.l d0
 0 129/213 00fc1486 6712                     beq.b #$12 == $00fc149a (F)
 0 133/213 00fc1488 2040                     movea.l d0,a0
 0 135/213 00fc148a b468 0014                cmp.w (a0,$0014) == $00c0290a [0022],d2
 0 141/213 00fc148e 6ef0                     bgt.b #$f0 == $00fc1480 (T)
 0 145/213 00fc1490 2f0e                     move.l a6,-(a7) [00fc149e]
 0 151/213 00fc1492 2c48                     movea.l a0,a6
 0 153/213 00fc1494 4eae fffa                jsr (a6,-$0006) == $00c028f0
 0 162/213 00c028f0 4ef9 00fc 6d40           jmp $00fc6d40
 0 168/213 00fc6d40 200e                     move.l a6,d0
 0 170/213 00fc6d42 4e75                     rts  == $00fc1498
 0 178/213 00fc1498 2c5f                     movea.l (a7)+ [00fc149e],a6
 0 184/213 00fc149a 4eae ff76                jsr (a6,-$008a) == $00c001ec
 0 193/213 00c001ec 4ef9 00fc 1f9c           jmp $00fc1f9c
 0 199/213 00fc1f9c 532e 0127                subq.b #$01,(a6,$0127) == $00c0039d [ff]
 0 207/213 00fc1fa0 6c1a                     bge.b #$1a == $00fc1fbc (T)
 0 211/213 00fc1fa2 4a2e 0126                tst.b (a6,$0126) == $00c0039c [00]
 0 217/213 00fc1fa6 6c14                     bge.b #$14 == $00fc1fbc (T)
 0 222/213 00fc1fbc 4e75                     rts  == $00fc149e
 0 003/214 00fc149e 241f                     move.l (a7)+ [00000000],d2
 0 009/214 00fc14a0 4e75                     rts  == $00fe48c8
 0 017/214 00fe48c8 2540 ffe4                move.l d0,(a2,-$001c) == $00c5fdc0 [00c028f6]
 0 025/214 00fe48cc 60e0                     bra.b #$e0 == $00fe48ae (T)
 0 030/214 00fe48ae 660e                     bne.b #$0e == $00fe48be (T)
 0 035/214 00fe48be 4e75                     rts  == $00fe46e8
 0 043/214 00fe46e8 6600 0132                bne.w #$0132 == $00fe481c (T)
 0 048/214 00fe481c 202a ffe4                move.l (a2,-$001c) == $00c5fdc0 [00c028f6],d0
 0 056/214 00fe4820 4cea 1800 fff8           movem.l (a2,-$0008) == $00c5fdd4,a3-a4
 0 072/214 00fe4826 4e5a                     unlk.l a2
 0 078/214 00fe4828 4e75                     rts  == $00c06702
 0 086/214 00c06702 2a5f                     movea.l (a7)+ [00000000],a5
 0 092/214 00c06704 4e75                     rts  == $00fc1472
 0 100/214 00fc1472 4e75                     rts  == $00026006
 0 108/214 00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]		; move.l	d0,GfxBase 
;------------------------------------------------------------------------------
>d pc																			; where are we now?
00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]				; move.l	d0,GfxBase
0002600c 2c40                     movea.l d0,a6
0002600e 23ee 0026 0002 604c      move.l (a6,$0026) == $00c0029c [ff3ffd89],$0002604c [00000000]
00026016 23fa 0034 00df f080      move.l (pc,$0034) == $0002604c [00000000],$00dff080
0002601e 33c0 00df f088           move.w d0,$00dff088
00026024 2c78 0004                movea.l $0004.w [00c00276],a6
00026028 4eae ff82                jsr (a6,-$007e) == $00c001f8
0002602c 227a 001a                movea.l (pc,$001a) == $00026048 [00000000],a1
00026030 4eae fe62                jsr (a6,-$019e) == $00c000d8
00026034 4e75                     rts  == $00c4f6d0
;------------------------------------------------------------------------------
>r
VPOS: 214 ($0d6) HPOS: 108 ($06c) COP: $0001ede4
  D0 00C028F6   D1 00026036   D2 00000000   D3 00000000							; D0 = $C028F6
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00C028F6   A1 00026036   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FDF0
USP  00C5FDF0 ISP  00C60DF0
SR=0010 T=00 S=0 M=0 X=1 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 23c0 (MOVE) 0002 (OR) Chip latch 00000000
00026006 23c0 0002 6048           move.l d0,$00026048 [00000000]				; move.l	d0,GfxBase
Next PC: 0002600c
;------------------------------------------------------------------------------
>m 26048 1
00026048 0000 0000 0000 0000 1234 5678 0101 0000  .........4Vx....				; [00000000]			
;------------------------------------------------------------------------------
>t																				; step 7 - trace (step one)
Cycles: 10 Chip, 20 CPU. (V=214 H=108 -> V=214 H=118)
VPOS: 214 ($0d6) HPOS: 118 ($076) COP: $0001ede4
  D0 00C028F6   D1 00026036   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00C028F6   A1 00026036   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FDF0
USP  00C5FDF0 ISP  00C60DF0
SR=0010 T=00 S=0 M=0 X=1 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 2c40 (MOVEA) 23ee (MOVE) Chip latch 00000000
0002600c 2c40                     movea.l d0,a6
Next PC: 0002600e
;------------------------------------------------------------------------------
>m 26048 1
00026048 00C0 28F6 0000 0000 1234 5678 0101 0000  ..(......4Vx....				; move.l	d0,GfxBase		GfxBase = $C0 28F6
>fd
All breakpoints removed.


;------------------------------------------------------------------------------
; History -> ROM Disassembly
;------------------------------------------------------------------------------

 0 084/210 00c000de 4ef9 00fc 146c           jmp $00fc146c
 0 090/210 00fc146c 7000                     moveq #$00,d0
 0 092/210 00fc146e 4eae fdd8                jsr (a6,-$0228) == $00c0004e
 0 101/210 00c0004e 4ef9 00c0 66b2           jmp $00c066b2
 0 107/210 00c066b2 518f                     subaq.l #$08,a7
 0 111/210 00c066b4 4879 00fe 46be           pea.l $00fe46be

>d fc146c																		; jmp $00fc146c
00fc146c 7000                     moveq #$00,d0
00fc146e 4eae fdd8                jsr (a6,-$0228) == $00c0004e
00fc1472 4e75                     rts  == $00c4f6d0
00fc1474 2f02                     move.l d2,-(a7) [00026006]
00fc1476 2400                     move.l d0,d2
00fc1478 522e 0127                addq.b #$01,(a6,$0127) == $00c0039d [ff]
00fc147c 41ee 017a                lea.l (a6,$017a) == $00c003f0,a0
00fc1480 6100 0214                bsr.w #$0214 == $00fc1696
00fc1484 4a80                     tst.l d0
00fc1486 6712                     beq.b #$12 == $00fc149a (F)

>d c0004e																		; jsr (a6,-$0228) == $00c0004e
00c0004e 4ef9 00c0 66b2           jmp $00c066b2

>d c066b2																		; jmp $00c066b2
00c066b2 518f                     subaq.l #$08,a7
00c066b4 4879 00fe 46be           pea.l $00fe46be

;------------------------------------------------------------------------------
from EAB
Ok, then make sure at least one break point is enabled. History is only collected if at least
one break point is enabled (or when debugger is called). It would slow down emulation noticeably.
for example "f 0" is enough.


first field in a History output:
-1 00fc0f94 60e6                     bra.b #$e6 == $00fc0f7c (T)
 0 0002a5a4 0c80 0000 5000           cmp.l #$00005000,d0

It is CPU interrupt mask. (-1 = mask=0, supervisor mode. 0 = mask=0, user mode)
you found the Interrupt mask value here: IM=0
(SR=0014 T=00 S=0 M=0 X=1 N=0 Z=1 V=0 C=0 IM=0 STP=0)  