
; Listing19l4.s
; Copper Debugger, Copper Tracing, Copper Breakpoint, special charakters
; 
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  o <0-2|addr> [<lines>] View memory as Copper instructions.
;  od                    Enable/disable Copper vpos/hpos tracing.
;  ot                    Copper single step trace.
;  ob <addr>             Copper breakpoint.

;------------------------------------------------------------------------------
; source from the danish-asm-course

start:

	move.w #$4000,$dff09a		; Interrupts disable
	lea.l	copperlist,a1		; start up our own copper list.
	move.l	a1,$dff080			; COP1LCH		
	move.w	#$8080,$dff096		; DMACON		

;waitline:
waitmouse:
	cmp.b	#$8F,$dff006		; vhposr - wait for line 144
	add.w	#1,copperlist+6
	sub.w	#1,copperlist+34
	bne.s	waitmouse			; Waitline

	btst	#2,$dff016			; right mousebutton?
	bne.s	waitmouse		 

	move.w	#$0080,$dff096		; DMACON		Retrieving the old copper 
								; settings back (as to reactivate the workbench) and
	move.l	$04,a6				; start the copper.
	move.l	156(a6),a1					
	move.l	38(a1),$dff080		; COP1LCH		
	move.w	#$81a0,$dff096		; DMACON	

	move.w #$C000,$dff09a		; Interrupts enable
	rts

copperlist:						
	dc.w	$9001,$fffe
	dc.w	$0180,$0f00
	dc.w	$a001,$fffe
	dc.w	$0180,$0fff
	dc.w	$0180,$000f
	dc.w	$aa01,$fffe
	dc.w	$0180,$0fff
	dc.w	$ae01,$fffe
	dc.w	$0180,$0f00
	dc.w	$be01,$fffe
	dc.w	$0180,$0000
	dc.w	$ffff,$fffe				
	
table:
	blk.w 1200,$ffff	
				
	end


;------------------------------------------------------------------------------
>r
Filename:Listing19l4.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm
																				; the program is showing the norwegian flag
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12

>o1
 00021964: 9001 fffe [000 008]  ;  Wait for vpos >= 0x90 and hpos >= 0x00
                                ;  VP 90, VE 7f; HP 00, HE fe; BFD 1
*00021968: 0180 b363            ;  COLOR00 := 0xb363
 0002196c: a001 fffe [090 00c]  ;  Wait for vpos >= 0xa0 and hpos >= 0x00
                                ;  VP a0, VE 7f; HP 00, HE fe; BFD 1
 00021970: 0180 0fff            ;  COLOR00 := 0x0fff
 00021974: 0180 000f            ;  COLOR00 := 0x000f
 00021978: aa01 fffe [0a0 010]  ;  Wait for vpos >= 0xaa and hpos >= 0x00
                                ;  VP aa, VE 7f; HP 00, HE fe; BFD 1
 0002197c: 0180 0fff            ;  COLOR00 := 0x0fff
 00021980: ae01 fffe [0aa 00c]  ;  Wait for vpos >= 0xae and hpos >= 0x00
                                ;  VP ae, VE 7f; HP 00, HE fe; BFD 1
 00021984: 0180 6a9d            ;  COLOR00 := 0x6a9d
 00021988: be01 fffe [0ae 00c]  ;  Wait for vpos >= 0xbe and hpos >= 0x00
                                ;  VP be, VE 7f; HP 00, HE fe; BFD 1
 0002198c: 0180 0000            ;  COLOR00 := 0x0000
 00021990: ffff fffe [0be 00c]  ;  Wait for vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
                                ;  End of Copperlist
;------------------------------------------------------------------------------
>od
Copper debugger enabled.
>x																				; close Debugger shortly																		
																				; open the Debugger with Shift+F12
;------------------------------------------------------------------------------
>o1
 000213bc: 9001 fffe [000 008]  ;  Wait for vpos >= 0x90 and hpos >= 0x00
                                ;  VP 90, VE 7f; HP 00, HE fe; BFD 1
*000213c0: 0180 8a32 [090 008]  ;! COLOR00 := 0x8a32
 000213c4: a001 fffe [090 00c]  ;  Wait for vpos >= 0xa0 and hpos >= 0x00
                                ;  VP a0, VE 7f; HP 00, HE fe; BFD 1
 000213c8: 0180 0fff [0a0 008]  ;  COLOR00 := 0x0fff
 000213cc: 0180 000f [0a0 00c]  ;  COLOR00 := 0x000f
 000213d0: aa01 fffe [0a0 010]  ;  Wait for vpos >= 0xaa and hpos >= 0x00
                                ;  VP aa, VE 7f; HP 00, HE fe; BFD 1
 000213d4: 0180 0fff [0aa 008]  ;  COLOR00 := 0x0fff
 000213d8: ae01 fffe [0aa 00c]  ;  Wait for vpos >= 0xae and hpos >= 0x00
                                ;  VP ae, VE 7f; HP 00, HE fe; BFD 1
 000213dc: 0180 9320 [0ae 008]  ;! COLOR00 := 0x9320
 000213e0: be01 fffe [0ae 00c]  ;  Wait for vpos >= 0xbe and hpos >= 0x00
                                ;  VP be, VE 7f; HP 00, HE fe; BFD 1
 000213e4: 0180 0000 [0be 008]  ;  COLOR00 := 0x0000
 000213e8: ffff fffe [0be 00c]  ;  Wait for vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1

"!" = data is different now than it was when copper executed this instruction.
That means copper list was different when it was executed. If copper timing 
information is enabled ("od" command), it also stores copper data and copper
disassembly shows stored data.
