
; Listing19k6.s
; DMA-Debugger - CIA information and Interrupt Debugging
; based on Listing18d.s
;
; Part 1: DMA Debugger shows CIA information
; Part 2: some questions to how to debug an interrupt
; Part 3: Copper and Interrupt information
; Part 4: Breakpoints with counts
;
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger	
;------------------------------------------------------------------------------
; Part 1: DMA Debugger shows CIA information
;------------------------------------------------------------------------------

something like that:

level3:        ; Level 3 interrupt handler.......
        movem.l a0-a6/d0-d7,-(sp)                ; 1.st instruction
        ...

copperlist:
        ...
        dc.w $ffdf,$fffe                        ; wait for end of NTSC
        dc.w $2b09,$fffe                        ; first line after screen
        dc.w intreq,$8010                       ; trigger copper IR
        dc.w $ffff,$fffe

;------------------------------------------------------------------------------

>r
Filename:Listing18d.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm				   
																				; Shift+F12 open the Debugger
;------------------------------------------------------------------------------
VPOS: 105 ($069) HPOS: 014 ($00e) COP: $0002c27e
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C5FE38
USP  00C5FE38 ISP  00C60E38
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66f6 (Bcc) 08b9 (BCLR) Chip latch 00000000
0002c1be 66f6                     bne.b #$f6 == $0002c1b6 (T)
Next PC: 0002c1c0
;------------------------------------------------------------------------------
>v-2
DMA debugger enabled, mode=2.
;------------------------------------------------------------------------------
>d pc
0002c1be 66f6                     bne.b #$f6 == $0002c1b6 (T)
0002c1c0 08b9 0001 00bf e001      bclr.b #$0001,$00bfe001
0002c1c8 3b7c 07e0 0096           move.w #$07e0,(a5,$0096) == $00dff096
0002c1ce 2b7a ff1e 0080           move.l (pc,$ff1e) == $0002c0ee [00000420],(a5,$0080) == $00dff080
0002c1d4 3b7c 0000 0088           move.w #$0000,(a5,$0088) == $00dff088
0002c1da 3b7c 83e0 0096           move.w #$83e0,(a5,$0096) == $00dff096
0002c1e0 3b7c 4010 009a           move.w #$4010,(a5,$009a) == $00dff09a
0002c1e6 21f9 0002 c21e 006c      move.l $0002c21e [00fc0d14],$006c.w [0002c1fc]
0002c1ee 3b7c c020 009a           move.w #$c020,(a5,$009a) == $00dff09a
0002c1f4 4eae ff76                jsr (a6,-$008a) == $00c001ec
;------------------------------------------------------------------------------
>i
$00000000 00:    Reset:SSP $00000000  $00000080 32:      TRAP 00 $00FC0836
$00000004 01:     EXECBASE $00C00276  $00000084 33:      TRAP 01 $00FC0838
$00000008 02:    BUS ERROR $00FC0818  $00000088 34:      TRAP 02 $00FC083A
$0000000C 03:    ADR ERROR $00FC081A  $0000008C 35:      TRAP 03 $00FC083C
$00000010 04:    ILLEG OPC $00FC081C  $00000090 36:      TRAP 04 $00FC083E
$00000014 05:     DIV BY 0 $00FC081E  $00000094 37:      TRAP 05 $00FC0840
$00000018 06:          CHK $00FC0820  $00000098 38:      TRAP 06 $00FC0842
$0000001C 07:        TRAPV $00FC0822  $0000009C 39:      TRAP 07 $00FC0844
$00000020 08:   PRIVIL VIO $00FC090E  $000000A0 40:      TRAP 08 $00FC0846
$00000024 09:        TRACE $00FC0826  $000000A4 41:      TRAP 09 $00FC0848
$00000028 10:    LINEA EMU $00FC0828  $000000A8 42:      TRAP 10 $00FC084A
$0000002C 11:    LINEF EMU $00FC082A  $000000AC 43:      TRAP 11 $00FC084C
$00000038 14:   FORMAT ERR $00FC0830  $000000B0 44:      TRAP 12 $00FC084E
$0000003C 15:   INT Uninit $00FC0832  $000000B4 45:      TRAP 13 $00FC0850
$00000060 24:   INT Unjust $00FC0834  $000000B8 46:      TRAP 14 $00FC0852
$00000064 25:    Lvl 1 Int $00FC0C8E  $000000BC 47:      TRAP 15 $00FC0854
$00000068 26:    Lvl 2 Int $00FC0CE2
$0000006C 27:    Lvl 3 Int $0002C1FC											; Lvl 3 Int $0002C1FC
$00000070 28:    Lvl 4 Int $00FC0D6C
$00000074 29:    Lvl 5 Int $00FC0DFA
$00000078 30:    Lvl 6 Int $00FC0E40
$0000007C 31:          NMI $00FC0E86
;------------------------------------------------------------------------------
>f 2C1FC																		; set a breakpoint on lvl3-routine
Breakpoint added.
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 44094 Chip, 88188 CPU. (V=105 H=14 -> V=299 H=70)
VPOS: 299 ($12b) HPOS: 070 ($046) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60E32
USP  00C5FE38 ISP  00C60E32
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 48e7 (MVMLE) fffe (ILLEGAL) Chip latch 0000FFFE
0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
Next PC: 0002c200
;------------------------------------------------------------------------------
>v !299
Line: 12B 299 HPOS 00   0:
 [00 000 -]   [01 000 -]   [02 000 -]   [03 000 -]   [04 000 -]   [05 000 -]   [06 000 -]   [07 000 -]	; empty






 [08 000 -]   [09 000 -]   [0A 000 -]   [0B 000 -]   [0C 000 -]   [0D 000 -]   [0E 000 -]   [0F 000 -]
;------------------------------------------------------------------------------
 >x																				; close debugger to collect data
 VPOS: 299 ($12b) HPOS: 063 ($03f) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60E32
USP  00C5FE38 ISP  00C60E32
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 48e7 (MVMLE) fffe (ILLEGAL) Chip latch 0000FFFE
0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
Next PC: 0002c200
;------------------------------------------------------------------------------
>v																										; cycle-exact is not enabled
Line: 12B 299 HPOS 00   0:																				; no CPU/CIA information		
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -]
                                        RFS0   03C                RFS1   1FE                RFS2   1FE
                                                                          *F
                                          0001FDE8                  0001FDEA                  0001FDEC

                                         0F4   0FE                 0F5   0FE                 0F6   0FE

 [08 008 -]   [09 00A -]   [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -]   [0E 014 -]   [0F 016 -]
              RFS3   1FE                             COP    08C                COP    09C
                           W                               009C                      8010
                0001FDEE                               0002C282                  0002C284

               0F7   0FE                              141   061                 142   061

 [10 018 -]   [11 01A -]   [12 01C -]   [13 01E -]   [14 020 -]   [15 022 3]   [16 024 3]   [17 026 3]
 COP    08C                COPW   08C
       FFFF                      FFFE
   0002C286                  0002C288

  143   061                 144   061

;------------------------------------------------------------------------------
>fd
All breakpoints removed.
>x																				; close debugger				
;------------------------------------------------------------------------------	
																				; GUI, chipset/cycle-exact
;------------------------------------------------------------------------------
																				; see visual dma debugger shows more info now
																				; Shift+F12 open debugger
;------------------------------------------------------------------------------
>f 2C1FC																		; set a breakpoint on lvl3-routine
Breakpoint added.
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
Cycles: 67245 Chip, 134490 CPU. (V=3 H=0 -> V=299 H=53)
VPOS: 299 ($12b) HPOS: 053 ($035) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60E32
USP  00C5FE38 ISP  00C60E32
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 48e7 (MVMLE) fffe (ILLEGAL) Chip latch 0000FFFE
0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
Next PC: 0002c200
;------------------------------------------------------------------------------
>v
Line: 12B 299 HPOS 00   0:
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -] B
                                        RFS0   03C                RFS1   1FE      CPU-RWI   RFS2   1FE c
                                                                          *F         08B9              c
                                          0004BCC8                  0004BCCA     0002C1C0     0004BCCC
         0            2    RA0   00FE           6            8
                                         064   15E                 065   15E    1E0   060    066   15E

 [08 008 -]   [09 00A -]   [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -]   [0E 014 -] B [0F 016 3]
              RFS3   1FE      CPU-RWI                COP    08C      CPU-RWI   COP    09C T    CPU-RWI
                            W    0839                      009C         0006         8010 S       00BF	 ; dc.w intreq,$8010 - trigger copper IR 
                0004BCCE     0002C1B6                  0002C282     0002C1B8     0002C284 T   0002C1BA

               067   15E    1DB   060                 141   061    1DC   060    142   061    1DD   060

 [10 018 3]   [11 01A 3]   [12 01C 3]   [13 01E 3]   [14 020 3]   [15 022 3]   [16 024 3]   [17 026 3]
 COP    08C      CPU-RWI   COPW   08C      CPU-RWI
       FFFF         E001         FFFE         66F6
   0002C286     0002C1BC     0002C288     0002C1BE
                                                             0            2    RA0   00FE           6	;  0  2  RA0  00FE  6  8
  143   061    1DE   060    144   061    1DF   060

 [18 028 3]   [19 02A 3]   [1A 02C 3]   [1B 02E 3] * [1C 030 3]   [1D 032 3]   [1E 034 3]   [1F 036 3]  ; * = Start of new instruction but opcode is not known. This happens at the start of exception handling.
                              CPU-RWI                                                          CPU-WWD	; This happens at the start of exception handling.
                                 08B9   I                                                         C1BE	; I = CPU started interrupt processing
                             0002C1C0                                                         00C60E36
         8
                            1E0   060                                                        11B   107

 [20 038 3]   [21 03A 3]   [22 03C 3]   [23 03E 3]   [24 040 3]   [25 042 3]   [26 044 3]   [27 046 3]
                                                                     CPU-WWD                   CPU-WWD
                                                     (                  0008                      0002
                                                                    00C60E32                  00C60E34

                                                                   119   107                 11A   107

 [28 048 3]   [29 04A 3]   [2A 04C 3]   [2B 04E 3]   [2C 050 3]   [2D 052 3]   [2E 054 3]   [2F 056 3]
                 CPU-RWD                   CPU-RWD                   CPU-RWD
                    0002                      C1FC                      48E7							; 0002c1fc 48e7 fffe     movem.l d0-d7/a0-a6,-(a7)
                0000006C                  0000006E                  0002C1FC

               036   000                 037   000                 1FE   060

 [30 058 3]   [31 05A 3] M [32 05C 3]   [33 05E 3]   [34 060 3]   [35 062 3]   [36 064 3]   [37 066 3]	; VPOS: 299 ($12b) HPOS: 053 ($035)
    CPU-RWD              O    CPU-RWI                   CPU-WWD                   CPU-WWD
       FFFE              V       4BF9                      0276                      00C0
   0002C1FE              E   0002C200                  00C60E30                  00C60E2E
                         M
  1FF   060                 100   061                 118   107                 117   107

;------------------------------------------------------------------------------

1. I see 0 2 RA0 00FE 6 8. Whats the information for?
CIA accesses line (separate from others because CIA timing is separate from chipset).

Numbers = E-clock state, "-" = CPU waiting for CIA E-clock sync.
"RA0 00FE" = (R)ead cia-(A) register 0, value $FE (BFE001 -> FE)

Code:
BFE001    pra    /FIR1 /FIR0  /RDY /TK0  /WPRO /CHNG /LED  OVL

mouse:        btst #6,ciaa+pra        ; -- Main Mouse Waiting Loop
        bne.s mouse

2. I - stays for Interrupt?
I = CPU started interrupt processing

Quote:
3. What marks the star?
Start of new instruction but opcode is not known. This happens at the start of exception handling.

Quote:
4. Whats with the time from HPOS $14 to $20? What happens here?
Idle cycles. Interrupt (exception) startup has few idle cycles.

Code:
Interrupt:

- 6 idle cycles
- write PC low word
- read exception number byte from (0xfffff1 | (interrupt number << 1))
- 4 idle cycles
- write SR
- write PC high word
- read exception address high word
- read exception address low word
- prefetch
- 2 idle cycles
- prefetch

>m pc 1
0002C1FC 48E7 FFFE 4BF9 00DF F000 082D 0004 001F  H...K......-....
>m C60E34 1
00C60E34 0002 C1BE 00C4 F718 0000 0000 0000 0000  ................

; roughly
HPOS=1B - 6 idle cycles
HPOS=1F - write PC low word			is 'C1BE'
HPOS=20	- read exception number byte from (0xfffff1 | (interrupt number << 1))
21-23	- 4 idle cycles
HPOS=25 - write SR				is '0008'
HPOS=27 - write PC high word			is '0002'	
HPOS=29 - read exception address high word	is '0002'		
HPOS=2B - read exception address low word	is 'C1FC'	
HPOS=2D - prefetch				from '2C1FC'			
HPOS=2F	- 2 idle cycles
HPOS=30	- prefetch				from '2C1FE'	


;------------------------------------------------------------------------------
; Part 2: some questions to how to debug an interrupt
;------------------------------------------------------------------------------

From the interrupt occurences to the interrupt handling some time goes away.
Is there a way to debug the 'interrupt' occurences. 
I can set a breakpoint on my interrupt routine but this is some rasterpositions
later. Short: No.

three methods:
- set a breakpoint on the interrupt routine
- with tx
- with il-command

;------------------------------------------------------------------------------
>g																				; with program breakpoint
Breakpoint 0 triggered.
Cycles: 71042 Chip, 142084 CPU. (V=299 H=53 -> V=299 H=44)
VPOS: 299 ($12b) HPOS: 044 ($02c) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60E32
USP  00C5FE38 ISP  00C60E32
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 48e7 (MVMLE) fffe (ILLEGAL) Chip latch 0000FFFE
0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
Next PC: 0002c200
>fd
All breakpoints removed.
;------------------------------------------------------------------------------
>tx																				; with tx
Exception 27, PC=0002C1BE
Cycles: 0 Chip, 0 CPU. (V=299 H=44 -> V=299 H=44)
VPOS: 299 ($12b) HPOS: 042 ($02a) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60E32
USP  00C5FE38 ISP  00C60E32
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 48e7 (MVMLE) fffe (ILLEGAL) Chip latch 0000FFFE
0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
Next PC: 0002c200
;------------------------------------------------------------------------------
>?1<<27																			; for Exception 27
$08000000 = %00001000`00000000`00000000`00000000 = 134217728 = 134217728
;------------------------------------------------------------------------------
>il $08000000																	; with il
Exception breakpoint mask: 00000000 08000000
;------------------------------------------------------------------------------
>g
Cycles: 71032 Chip, 142064 CPU. (V=299 H=42 -> V=299 H=23)
VPOS: 299 ($12b) HPOS: 109 ($06d) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60DF6
USP  00C5FE38 ISP  00C60DF6
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 4bf9 (LEA) 00df (ILLEGAL) Chip latch 000000DF
0002c200 4bf9 00df f000           lea.l $00dff000,a5
Next PC: 0002c206
;------------------------------------------------------------------------------
>H 2
 3 042/299 0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
 ...
;------------------------------------------------------------------------------
>il
Exception breakpoint mask: 00000000 00000000


;------------------------------------------------------------------------------
; Part 3: Copper and Interrupt information
;------------------------------------------------------------------------------

																				; Added CPU interrupt level information to visual DMA debugger. Each scanline
																				; has extra pixel on left side of DMA usage image that shows scanline's highest
																				; CPU interrupt level	
>x																				; close the debugger
																				; F12 open GUI/Hardware/Chipset 	
																				; switch cycle exact off
																				; Shift+F12 open debugger
;------------------------------------------------------------------------------
>v-2
DMA debugger enabled, mode=2.
>vm 3 1 0000ff00
3,0: 0000ff00 * Copper		; green - copper wait, move, skip
>vm 3 2 00ff0000
3,1: 00ff0000 * Copper		; red - copper jump (strobe extra cycle)
																				; see yellow line on the left side
																				; and green or red copper pixels 			
;------------------------------------------------------------------------------
>vm
0,0: 00222222 * -
1,0: 00444444 * Refresh
1,1: 00444444 * Refresh
1,2: 00444444 * Refresh
1,3: 00444444 * Refresh
2,0: 00a25342 * CPU
2,1: 00ad98d6 * CPU
3,0: 0000ff00 * Copper
3,1: 00ff0000 * Copper
3,2: 00ff0000 * Copper
4,0: 00ff0000 * Audio
4,1: 00ff0000 * Audio
4,2: 00ff0000 * Audio
4,3: 00ff0000 * Audio
5,0: 00008888 * Blitter
5,1: 00008888 * Blitter
6,0: 000000ff * Bitplane
6,1: 000000ff * Bitplane
6,2: 000000ff * Bitplane
6,3: 000000ff * Bitplane
6,4: 000000ff * Bitplane
6,5: 000000ff * Bitplane
6,6: 000000ff * Bitplane
6,7: 000000ff * Bitplane
7,0: 00ff00ff * Sprite
7,1: 00ff00ff * Sprite
7,2: 00ff00ff * Sprite
7,3: 00ff00ff * Sprite
7,4: 00ff00ff * Sprite
7,5: 00ff00ff * Sprite
7,6: 00ff00ff * Sprite
7,7: 00ff00ff * Sprite
8,0: 00ffffff * Disk
8,1: 00ffffff * Disk
8,2: 00ffffff * Disk
>x																				; look dma-debugger
;------------------------------------------------------------------------------
>vm 3 0																			; disable copper dma in dma debugger
3,0: 0000ff00   Copper
>x																				; look dma-debugger
;------------------------------------------------------------------------------
>vm 3 0																			; enable copper dma in dma debugger
3,0: 0000ff00 * Copper


;------------------------------------------------------------------------------
; Part 4: Breakpoints with counts
;------------------------------------------------------------------------------
>f 2C1FC N10																	; Debugger break point command accepts number of hits before breaking to debugger 
Breakpoint added.																; and look to the cube !		
>g
Breakpoint 0 hit: PC=0002c1fc, count=10.
Breakpoint 0 hit: PC=0002c1fc, count=9.
Breakpoint 0 hit: PC=0002c1fc, count=8.
Breakpoint 0 hit: PC=0002c1fc, count=7.
Breakpoint 0 hit: PC=0002c1fc, count=6.
Breakpoint 0 hit: PC=0002c1fc, count=5.
Breakpoint 0 hit: PC=0002c1fc, count=4.
Breakpoint 0 hit: PC=0002c1fc, count=3.
Breakpoint 0 hit: PC=0002c1fc, count=2.
Breakpoint 0 hit: PC=0002c1fc, count=1.
Breakpoint 0 triggered.															; ok one count to much
VPOS: 299 ($12b) HPOS: 060 ($03c) COP: $0002c28a
  D0 C87C0002   D1 0002C0DC   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 0000FFFF
  A0 00C028F6   A1 00C028F6   A2 00000000   A3 00000000
  A4 00000000   A5 00DFF000   A6 00C00276   A7 00C60E32
USP  00C5FE38 ISP  00C60E32
SR=2308 T=00 S=1 M=0 X=0 N=1 Z=0 V=0 C=0 IM=3 STP=0
Prefetch 48e7 (MVMLE) fffe (ILLEGAL) Chip latch 0000FFFE
0002c1fc 48e7 fffe                movem.l d0-d7/a0-a6,-(a7)
Next PC: 0002c200
;------------------------------------------------------------------------------
>f 2C1FC N4																		; to change the counter 
Breakpoint removed.
>f 2C1FC N4
Breakpoint added.
>