
; Listing19k5.s
; DMA-Debugger - DMA map ; extra characters
; e.g. Listing19s1b.s	(reset-screen)
; cycle-exact not enabled
;
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger	
;
;------------------------------------------------------------------------------
																				; start the programm				   
																				; Shift+F12 open the Debugger
;------------------------------------------------------------------------------
>v-4
DMA debugger enabled, mode=4.
>x																				
;------------------------------------------------------------------------------
																				; Shift+F12 open the Debugger


>v $04 0 1
Line: 04   4 HPOS 00   0:
 [00 110 -]   [01 112 -]   [02 114 -]   [03 116 3]   [04 118 3]   [05 11A 3]   [06 11C 3]   [07 11E 3]
                                        RFS0   038                RFS1   1FE                RFS2   1FE
                                               *SB                        *F
                                          00014410                  00014412                  00014414

                                         008   0A2                 009   0A2                 00A   0A2

;------------------------------------------------------------------------------		
																					; in comparison
																					; WinUAE 4.9.0 A500 configuration 
Line: 04   4 HPOS 00   0:
 [00   0]  [01   1]  [02   2]  [03   3]  [04   4]  [05   5]  [06   6]  [07   7]
                               RFS0 038            RFS1 1FE            RFS2 1FE		; These special slots are marked with '*' 
                                    *SB                  *F							; vertical sync (S)
																					; vertical blanking (B)
																					; long field (F)



;------------------------------------------------------------------------------
>v $2c 0 2
Line: 2C  44 HPOS 00   0:
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -]
                                        RFS0   03C                RFS1   1FE   COP    08C   RFS2   1FE
                                                *=   W                    *F         0100				; *=  vertical diw is open (=)
                                          00012768                  0001276A     0006A564     0001276C  ; *F= long field (F)
																										; marked with * only in refresh slots
                                         0B4   093                 0B5   093    1B2   152    0B6   093	; W - Copper wake up

 [08 008 -]   [09 00A -]   [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -]   [0E 014 -]   [0F 016 -]
 COP    100   RFS3   1FE   COP    08C                COP    180                COP    08C
       2200                      0180                      000F                      8C01
   0006A566     0001276E     0006A568                  0006A56A                  0006A56C

  1B3   152    0B7   093    1B4   152                 1B5   152                 1B6   152



;------------------------------------------------------------------------------
>v $2c 0 20 
...
 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                                                                            BPL2   112
 0                                                                                                0000	; 0 - DDFSTRT (0)
                                                                                              0006C4C4

;------------------------------------------------------------------------------
>v $2c $d0 1
Line: 2C  44 HPOS D0 208:
 [D0 198 -]   [D1 19A -]   [D2 19C -]   [D3 19E -]   [D4 1A0 -]   [D5 1A2 -]   [D6 1A4 -]   [D7 1A6 -]
                                        BPL1   110                                          BPL2   112
 1                                            0000                                                0000	; 1 - DDFSTOP (1)
                                          0006A5A8                                            0006C4EA

                                         1D4   152                                           175   162


;------------------------------------------------------------------------------
; Second row can contain extra characters (from EAB)
;------------------------------------------------------------------------------

--- Screen ---
DMA debugger uses first refresh slot to show if line is
	- vertical blanking (B),
	- vertical sync (S) or 
	- vertical diw is open (=), 
second refresh slot is used for long field (F) and long line (L).

These special slots are marked with '*' to not
(too easily) confuse them with same symbols in other slots.

				Horizontal diw ('(' and ')'), 
programmed horizontal blanking ('[' and ']') 
and programmed horizontal sync ('{' and '}') are also marked.

[0] = DDFSTRT (0)
[1] = DDFSTOP match caused last bitplane 'block' state;
[2] = DDF hard stop (or DDFSTRT==DDFSTOP) caused last bitplane 'block' state.

DMA debugger now includes DDFSTRT (0), DDFSTOP (1) and hardwired DDFSTOP (2)
positions if match caused bitplane DMA to start (DDFSTRT) or stop
(DDFSTRT/hardwired DDFSTOP).

--- Copper ---
W = "Copper wake up" (W)
W =  Skip also shows (W) if SKIP skipped.
c = "Copper wanted this cycle but couldn't get it" (c)
     markers in DMA debugger had disappeared. 
C = Special empty copper cycles where copper allocates the cycle but leaves it
	unused are now marked with "C" in DMA debugger.

	T.W.
	C was originally (I think) meant to show cycle was allocated for copper
	that does not do any DMA transfers. Now it also marks cycle when COPxLC ->
	internal pointer copy happens. It does not really mean anything specific.

--- Blitter ---

b - Blitter finished Bit (after that, no more data is read by the blitter)
(b = blitter interrupt) ?
(b = blitter wanted this cycle but higher priority channel took it.) ?

D = blitter's final D write. (marked because it is special cycle, blitter finished 
    bit was set 2 cycles ago)

N = blitter cycle given for CPU,
N = bus cycle given to CPU due to blitter nasty not enabled. Note that logic of
	blitter nasty is not what you probably think it is: If CPU waits more than 3 cycles,
	it gets next blitter cycle. ANY DMA cycle counts, it does not need to be blitter
	cycle, only requirement is that blitter is also active. In this case result was
	1 lost cycle, CPU got cycle that was originally going to be blitter idle cycle
	which CPU would have gotten automatically. But because priority was given to CPU,
	blitter couldn't use it..

B = blitter idle cycle. Cycle that blitter needs to be free but blitter does
	not use it and it is available for the CPU (Blitter start has always 2 idle
	cycles, purpose unknown)
	So the blitter takes all slots he can get. Even Sprite or Bitplane-Slots, if
	they are not used. I was confused because I have a book here that explicitely
	states "The blitter only uses the even bus cycles."

B = blitter needed this cycle but it is also available for CPU if CPU needs it.
	(=blitter idle cycle which means blitter did some internal operation but it
	didn't need bus hardware = CPU can still access chip bus)

(B = blitter finished. (not necessarily exactly same thing)) ?

- Added DMA debugger non-nasty blitter extra information: 
s = CPU will get next blitter cycle and
S = CPU stole this cycle from blitter

 --- CIA --- 
 ; Listing19k6.s
CIA accesses line (separate from others because CIA timing is separate from chipset).

Numbers		= E-clock state
 "-"		= CPU waiting for CIA E-clock sync.
"RA0 00FE"	= (R)ead cia-(A) register 0, value $FE (BFE001 -> FE)

I = CPU started interrupt processing
* = Start of new instruction but opcode is not known. This happens at the start of
    exception handling.

--- Channel Info ---

DMA debugger blitter slots are now marked as BLT-x (normal), BLF-x (fill) or
BLL-x (line). x = channel. RFS, DSK, AUD, SPR and BPL slots include channel numbers.
(Easier to remember than xxxDAT register address numbers)

  DMA debugger shows CPU memory access type (instruction fetch or data access).
- CPU instruction prefetches are marked with "I" and data accesses with "D" in
  DMA debugger (for example "CPU-RWI")
CPU-WW = CPU Write Word.

| = STOP idle cycle (Added CPU STOP state information to DMA debugger)
    (| = STOP idle cycle,
+ = STOP idle cycle and higher IPL detected = STOP ending soon)

