
; Listing19k3.s
; DMA Debugger - DMA and CPU-Usage
; cycle-exact mode must be activated
;
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger	
;------------------------------------------------------------------------------
	
	ORG $1FFEC				; to align the adresses
	LOAD $1FFEC
	JUMPPTR start

start:

waitmouse:  
	btst	#6,$bfe001		; left mousebutton?
	bne.s	Waitmouse	

WaitWblank:
	cmp.b	#200,$dff006	; vhposr - wait line
	bne.s	WaitWblank

l20000:						; on adress $20000	
	lea	dog,a0
	move.L	#dog,a1
	move.L	dog,a2
	move.l	#$AA,cat1
	move.l	a1,cat2
	move.l	a2,cat3
	move.l	#$BB,cat1
	move.l	a1,cat2
	move.l	a2,cat3

	btst	#2,$dff016		; right mousebutton?
	bne.s	WaitWblank		 
	
	move.w #$C000,$dff09a	; Interrupts enable
	rts

dog:
	dc.l	$12345678		; dog = $20052
cat1:
	dc.l	0				; cat1 = $20056
cat2:
	dc.l	0				; cat2 = $2005a
cat3:
	dc.l	0				; cat3 = $2005e

	end
		
;------------------------------------------------------------------------------
>r
Filename:Listing19k3.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm
																				; the program is waiting for the left mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - set breakpoint
>d pc
0001fff4 66f6                     bne.b #$f6 == $0001ffec (T)
0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
0001fffe 66f6                     bne.b #$f6 == $0001fff6 (T)
00020000 41f9 0002 0052           lea.l $00020052,a0
00020006 227c 0002 0052           movea.l #$00020052,a1
0002000c 2479 0002 0052           movea.l $00020052 [12345678],a2
00020012 23fc 0000 00aa 0002 0056 move.l #$000000aa,$00020056 [00000000]
0002001c 23c9 0002 005a           move.l a1,$0002005a [00000000]
00020022 23ca 0002 005e           move.l a2,$0002005e [00000000]
00020028 23fc 0000 00bb 0002 0056 move.l #$000000bb,$00020056 [00000000]
>f 20000
Breakpoint added.
>g
;------------------------------------------------------------------------------
																				; the program is waiting for the left mouse button
																				; now click left mousebutton and the debugger breaks
>g
Breakpoint 0 triggered.
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=10 -> V=200 H=21)
VPOS: 200 ($0c8) HPOS: 021 ($015) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 41f9 (LEA) 0002 (OR) Chip latch 00000000
00020000 41f9 0002 0052           lea.l $00020052,a0
Next PC: 00020006
;------------------------------------------------------------------------------
>d pc
00020000 41f9 0002 0052           lea.l $00020052,a0
00020006 227c 0002 0052           movea.l #$00020052,a1
0002000c 2479 0002 0052           movea.l $00020052 [12345678],a2
00020012 23fc 0000 00aa 0002 0056 move.l #$000000aa,$00020056 [00000000]
0002001c 23c9 0002 005a           move.l a1,$0002005a [00000000]
00020022 23ca 0002 005e           move.l a2,$0002005e [00000000]
00020028 23fc 0000 00bb 0002 0056 move.l #$000000bb,$00020056 [00000000]
00020032 23c9 0002 005a           move.l a1,$0002005a [00000000]
00020038 23ca 0002 005e           move.l a2,$0002005e [00000000]
0002003e 0839 0002 00df f016      btst.b #$0002,$00dff016
;------------------------------------------------------------------------------
>t																				; we are on line 200
Cycles: 6 Chip, 12 CPU. (V=200 H=21 -> V=200 H=27)
VPOS: 200 ($0c8) HPOS: 027 ($01b) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00020052   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 227c (MOVEA) 0002 (OR) Chip latch 00000000
00020006 227c 0002 0052           movea.l #$00020052,a1
Next PC: 0002000c
;------------------------------------------------------------------------------
>t																				; step through the program	
Cycles: 6 Chip, 12 CPU. (V=200 H=27 -> V=200 H=33)
VPOS: 200 ($0c8) HPOS: 033 ($021) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00020052   A1 00020052   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 2479 (MOVEA) 0002 (OR) Chip latch 00000000
0002000c 2479 0002 0052           movea.l $00020052 [12345678],a2
Next PC: 00020012
>
;------------------------------------------------------------------------------
>v-2
DMA debugger enabled, mode=2.
>v !200																			; empty		
Line: C8 200 HPOS 00   0:
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -]
                                        RFS0   03C                RFS1   1FE                RFS2   1FE
                                                *=                        *F
                                          0001FC08                  0001FC0A                  0001FC0C

                                         004   0FE                 005   0FE                 006   0FE

 [08 008 -]   [09 00A -]   [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -]   [0E 000 -]   [0F 000 -]
              RFS3   1FE

                0001FC0E

               007   0FE

 [10 000 -]   [11 000 -]   [12 000 -]   [13 000 -]   [14 000 -]   [15 000 -]   [16 000 -]   [17 000 -]






;------------------------------------------------------------------------------
>fd
All breakpoints removed.
>x																				; close the debugger to collect some data
;------------------------------------------------------------------------------
>v !200 0 4
Line: C8 200 HPOS 00   0:
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -]
                 CPU-RWI                RFS0   03C      CPU-RWI   RFS1   1FE      CPU-RBD   RFS2   1FE
                    F006                        *=         66F6           *F         00C8
                0001FFFC                  0000A190     0001FFFE     0000A192     00DFF006     0000A194

               0FE   0FF                 0C8   050    0FF   0FF    0C9   050    103   1F8    0CA   050

 [08 008 -]   [09 00A -] B [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -] L [0E 014 -]   [0F 016 -]
    CPU-RWI   RFS3   1FE c                              CPU-RWI              E    CPU-RWI
       41F9              c                                 0002              A       0052
   00020000     0000A196                               00020002                  00020004

  100   000    0CB   050                              101   000                 102   000

 [10 018 -]   [11 01A -]   [12 01C -]   [13 01E -] M [14 020 -]   [15 022 -]   [16 024 -]   [17 026 -]
    CPU-RWI                   CPU-RWI              O    CPU-RWI                   CPU-RWI
       227C                      0002              V       0052                      2479
   00020006                  00020008              E   0002000A                  0002000C
                                                   A
  103   000                 104   000                 105   000                 106   000

 [18 028 -]   [19 02A -] M [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
    CPU-RWI              O    CPU-RWI                   CPU-RWI                   CPU-RWD
       0002              V       0052                      23FC                      1234
   0002000E              E   00020010                  00020012                  00020052					; dog = $20052
                         A
  107   000                 108   000                 109   000                 129   000

;------------------------------------------------------------------------------
; comparison - this was an older view (WinUAE 4.9)
;------------------------------------------------------------------------------
																						; now we look in line 200 where we are
																						; but we see not the actual values from the programm
																						; thats are historical data from the last frame
>v !200																					; debug the line 200
Line: C8 200 HPOS 00   0:
 [00   0]  [01   1]  [02   2]  [03   3]  [04   4]  [05   5]  [06   6]  [07   7]
		   RFS  1FE            RFS  1FE    CPU-RW  RFS  1FE              CPU-RW
			   FFFF                FFFF      0C39      FFFF                0839			; data-or opcode
										 0001FFF6                      0001FFEC			; adresses
 B6957A00  B6957C00  B6957E00  B6958000  B6958200  B6958400  B6958600  B6958800

 [08   8]  [09   9]  [0A  10]  [0B  11]  [0C  12]  [0D  13]  [0E  14]  [0F  15]
			 CPU-RW              CPU-RW              CPU-RW              CPU-RW
			   0006                00BF                E001                66F6			; data-or opcode
		   0001FFEE            0001FFF0            0001FFF2            0001FFF4			; adresses
 B6958A00  B6958C00  B6958E00  B6959000  B6959200  B6959400  B6959600  B6959800

 [10  16]  [11  17]  [12  18]  [13  19]  [14  20]  [15  21]  [16  22]  [17  23]
												   SPR  144            SPR  146
													   7C00                8600
												   00000C94            00000C96
 B6959A00  B6959C00  B6959E00  B695A000  B695A200  B695A400  B695A600  B695A800

 [18  24]  [19  25]  [1A  26]  [1B  27]  [1C  28]  [1D  29]  [1E  30]  [1F  31]
   CPU-RW                        CPU-RW              CPU-RW              CPU-RW
	 0C39                          0839                0006                00BF
 0001FFF6                      0001FFEC            0001FFEE            0001FFF0
 B695AA00  B695AC00  B695AE00  B695B000  B695B200  B695B400  B695B600  B695B800


;------------------------------------------------------------------------------		; Shift+F12
>f 20000
Breakpoint added.
>g
Breakpoint 0 triggered.
Cycles: 21572 Chip, 43144 CPU. (V=105 H=2 -> V=200 H=9)
VPOS: 200 ($0c8) HPOS: 009 ($009) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00020052   A1 00020052   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 41f9 (LEA) 0002 (OR) Chip latch 00000002
00020000 41f9 0002 0052           lea.l $00020052,a0
Next PC: 00020006
;------------------------------------------------------------------------------	
>H 10																			; the last 10 executed instructions
 0 167/199 0001fffe 66f6                     bne.b #$f6 == $0001fff6 (F)		; with all DMA and CPU cycles
 - 00 A7 BPL1   110         3C3C    00017DF2
 - 00 A9 BPL2   112         0000    0001CDF4
 - 00 AA CPU-RWI            0C39    0001FFF6
 - 00 AB BPL1   110         3C3C    00017DF4
 - 00 AC CPU-RWI            00C8    0001FFF8
 0 173/199 0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
 - 00 AD BPL2   112         0000    0001CDF6
 - 00 AE CPU-RWI            00DF    0001FFFA
 - 00 AF BPL1   110         3C3C    00017DF6
 - 00 B0 CPU-RWI            F006    0001FFFC
 - 00 B1 BPL2   112         0000    0001CDF8
 - 00 B2 CPU-RWI            66F6    0001FFFE
 - 00 B3 BPL1   110         3C00    00017DF8
 - 00 B4 CPU-RBD            00C7    00DFF006
 - 00 B5 BPL2   112         0000    0001CDFA
 - 00 B6 CPU-RWI            41F9    00020000
 0 183/199 0001fffe 66f6                     bne.b #$f6 == $0001fff6 (F)
 - 00 B7 BPL1   110         3C3C    00017DFA
 - 00 B9 BPL2   112         0000    0001CDFC
 - 00 BA CPU-RWI            0C39    0001FFF6
 - 00 BB BPL1   110         3C3C    00017DFC
 - 00 BC CPU-RWI            00C8    0001FFF8
 0 189/199 0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
 - 00 BD BPL2   112         0000    0001CDFE
 - 00 BE CPU-RWI            00DF    0001FFFA
 - 00 BF BPL1   110         3C3C    00017DFE
 - 00 C0 CPU-RWI            F006    0001FFFC
 - 00 C1 BPL2   112         0000    0001CE00
 - 00 C2 CPU-RWI            66F6    0001FFFE
 - 00 C3 BPL1   110         3C3C    00017E00
 - 00 C4 CPU-RBD            00C7    00DFF006
 - 00 C5 BPL2   112         0000    0001CE02
 - 00 C6 CPU-RWI            41F9    00020000
 0 199/199 0001fffe 66f6                     bne.b #$f6 == $0001fff6 (F)
 - 00 C7 BPL1   110         003C    00017E02
 - 00 C9 BPL2   112         0000    0001CE04
 - 00 CA CPU-RWI            0C39    0001FFF6
 - 00 CB BPL1   110         3C3C    00017E04
 - 00 CC CPU-RWI            00C8    0001FFF8
 0 205/199 0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
 - 00 CD BPL2   112         0000    0001CE06
 - 00 CE CPU-RWI            00DF    0001FFFA
 - 00 CF BPL1   110         3C3C    00017E06
 - 00 D0 CPU-RWI       1    F006    0001FFFC
 - 00 D1 BPL2   112         0000    0001CE08
 - 00 D2 CPU-RWI            66F6    0001FFFE
 - 00 D3 BPL1   110         3C3C    00017E08
 - 00 D4 CPU-RBD            00C7    00DFF006
 - 00 D5 BPL2   112         0000    0001CE0A
 - 00 D6 CPU-RWI            41F9    00020000
 0 215/199 0001fffe 66f6                     bne.b #$f6 == $0001fff6 (F)
 - 00 D7 BPL1   110         3C00    00017E0A
 - 00 D9 BPL2   112         0000    0001CE0C
 - 00 DA CPU-RWI            0C39    0001FFF6
 - 00 DB BPL1   110         0000    00017E0C
 - 00 DC CPU-RWI            00C8    0001FFF8
 0 221/199 0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
 - 00 DD BPL2   112         0000    0001CE0E
 - 00 DE CPU-RWI            00DF    0001FFFA
 - 00 DF BPL1   110         0000    00017E0E
 - 00 E0 CPU-RWI            F006    0001FFFC
 - 00 E2 CPU-RWI            66F6    0001FFFE
 - 00 01 CPU-RBD            00C8    00DFF006
 - 00 03 RFS0   03C           *=    0000AB58
 - 00 04 CPU-RWI            41F9    00020000
 0 005/200 0001fffe 66f6                     bne.b #$f6 == $0001fff6 (F)
 - 00 05 RFS1   1FE           *F    0000AB5A
 - 00 07 RFS2   1FE                 0000AB5C
 - 00 08 CPU-RWI            0002    00020002
 0 009/200 00020000 41f9 0002 0052           lea.l $00020052,a0
;------------------------------------------------------------------------------
>v !200 0 20
Line: C8 200 HPOS 00   0:
 [00 1BE -]   [01 1C0 -]   [02 1C2 -]   [03 1C4 -]   [04 1C6 -]   [05 002 -]   [06 004 -]   [07 006 -]
                 CPU-RWI                RFS0   03C      CPU-RWI   RFS1   1FE      CPU-RBD   RFS2   1FE
                    F006                        *=         66F6           *F         00C8
                0001FFFC                  0000A190     0001FFFE     0000A192     00DFF006     0000A194

               0FE   0FF                 0C8   050    0FF   0FF    0C9   050    103   1F8    0CA   050

 [08 008 -]   [09 00A -] B [0A 00C -]   [0B 00E -]   [0C 010 -]   [0D 012 -] L [0E 014 -]   [0F 016 -]
    CPU-RWI   RFS3   1FE c                              CPU-RWI              E    CPU-RWI
       41F9              c                                 0002              A       0052
   00020000     0000A196                               00020002                  00020004

  100   000    0CB   050                              101   000                 102   000

 [10 018 -]   [11 01A -]   [12 01C -]   [13 01E -] M [14 020 -]   [15 022 -]   [16 024 -]   [17 026 -]
    CPU-RWI                   CPU-RWI              O    CPU-RWI                   CPU-RWI
       227C                      0002              V       0052                      2479
   00020006                  00020008              E   0002000A                  0002000C
                                                   A
  103   000                 104   000                 105   000                 106   000

 [18 028 -]   [19 02A -] M [1A 02C -]   [1B 02E -]   [1C 030 -]   [1D 032 -]   [1E 034 -]   [1F 036 -]
    CPU-RWI              O    CPU-RWI                   CPU-RWI                   CPU-RWD
       0002              V       0052                      23FC                      1234
   0002000E              E   00020010                  00020012                  00020052
                         A
  107   000                 108   000                 109   000                 129   000

 [20 038 -]   [21 03A -]   [22 03C -]   [23 03E -] M [24 040 -]   [25 042 -]   [26 044 -]   [27 046 -]
    CPU-RWD                   CPU-RWI              O    CPU-RWI                   CPU-RWI
       5678                      0000              V  (    00AA                      0002
   00020054                  00020014              E   00020016                  00020018

  12A   000                 10A   000                 10B   000                 10C   000

 [28 048 -]   [29 04A -]   [2A 04C -]   [2B 04E -]   [2C 050 -]   [2D 052 -]   [2E 054 -]   [2F 056 -]
    CPU-RWI                   CPU-RWI                   CPU-WWD                   CPU-WWD
       0056                      23C9                      0000                      00AA
   0002001A                  0002001C                  00020056                  00020058

  10D   000                 10E   000                 12B   000                 12C   000

 [30 058 -]   [31 05A -] M [32 05C -]   [33 05E -]   [34 060 -]   [35 062 -]   [36 064 -]   [37 066 -]
    CPU-RWI              O    CPU-RWI                   CPU-RWI                   CPU-WWD
       0002              V       005A                      23CA                      0002
   0002001E              E   00020020                  00020022                  0002005A

  10F   000                 110   000                 111   000                 12D   000

 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -] M [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
    CPU-WWD                   CPU-RWI              O    CPU-RWI                   CPU-RWI
       0052                      0002              V  0    005E                      23FC
   0002005C                  00020024              E   00020026                  00020028

  12E   000                 112   000                 113   000                 114   000

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -] M [46 084 -]   [47 086 -]
    CPU-WWD   BPL2   112      CPU-WWD   BPL1   110      CPU-RWI   BPL2   112 O    CPU-RWI   BPL1   110
       1234         0000         5678         6C66         0000         0000 V       00BB         1800
   0002005E     0001CE10     00020060     00017E10     0002002A     0001CE12 E   0002002C     00017E12

  12F   000    008   0E7    130   000    008   0BF    115   000    009   0E7    116   000    009   0BF

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
    CPU-RWI   BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112      CPU-WWD   BPL1   110
       0002         0000         0056         6666         23C9         0000         0000         6666
   0002002E     0001CE14     00020030     00017E14     00020032     0001CE16     00020056     00017E16

  117   000    00A   0E7    118   000    00A   0BF    119   000    00B   0E7    12B   000    00B   0BF
;------------------------------------------------------------------------------


; comparison History and DMA Debugger output 

>H10																			; this are the last 10 executed instructions 						
...
 0 209/199 0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
 - 00 D1 BPL2   112         0000    0001CE08
 - 00 D2 CPU-RWI            00DF    0001FFFA
 - 00 D3 BPL1   110         3C3C    00017E08
 - 00 D4 CPU-RWI            F006    0001FFFC
 - 00 D5 BPL2   112         0000    0001CE0A
 - 00 D6 CPU-RWI            66F6    0001FFFE
 - 00 D7 BPL1   110         3C00    00017E0A
 - 00 D8 CPU-RBD            00C7    00DFF006
 - 00 D9 BPL2   112         0000    0001CE0C
 - 00 DA CPU-RWI            41F9    00020000
 0 219/199 0001fffe 66f6                     bne.b #$f6 == $0001fff6 (F)
 - 00 DB BPL1   110         0000    00017E0C
 - 00 DD BPL2   112         0000    0001CE0E
 - 00 DE CPU-RWI            0C39    0001FFF6
 - 00 DF BPL1   110         0000    00017E0E
 - 00 E0 CPU-RWI            00C8    0001FFF8
 0 225/199 0001fff6 0c39 00c8 00df f006      cmp.b #$c8,$00dff006
 ...

;------------------------------------------------------------------------------
>v !199 !209 5																; this are collected instructions from the previous frame	
Line: C7 199 HPOS D1 209:
 [D1 19A -]   [D2 19C -]   [D3 19E -]   [D4 1A0 -]   [D5 1A2 -]   [D6 1A4 -]   [D7 1A6 -] B [D8 1A8 -]
 BPL2   112      CPU-RWI   BPL1   110      CPU-RBD   BPL2   112      CPU-RWI   BPL1   110 c
       0000         66F6         3C3C         00C7         0000         41F9         3C00 c
   0001CE08     0001FFFE     00017E08     00DFF006     0001CE0A     00020000     00017E0A

  004   0E7    0FF   0FF    004   0BF    103   1F8    005   0E7    100   000    005   0BF

 [D9 1AA -]   [DA 1AC -]   [DB 1AE -]   [DC 1B0 -]   [DD 1B2 -] C [DE 1B4 -]   [DF 1B6 -]   [E0 1B8 -]
 BPL2   112      CPU-RWI   BPL1   110      CPU-RWI   BPL2   112 M    CPU-RWI   BPL1   110      CPU-RWI
       0000         0C39         0000         00C8         0000 P       00DF         0000         F006
   0001CE0C     0001FFF6     00017E0C     0001FFF8     0001CE0E     0001FFFA     00017E0E     0001FFFC

  006   0E7    0FB   0FF    006   0BF    0FC   0FF    007   0E7    0FD   0FF    007   0BF    0FE   0FF

 [E1 1BA -]   [E2 1BC -]
                 CPU-RWI
                    66F6
                0001FFFE

               0FF   0FF

;------------------------------------------------------------------------------
Note:
It is not possible to go through the code step by step and see the actual or
next instruction in the DMA-Debugger. The DMA don't show the latest
cpu-instructions !!! The content of the visible results are from the last
frame. Therfore you have to run the program one frame forward with multiply
g-commands or with fs 314 (one frame).
