
; Listing19i1.s
; Scanline, CCK
; 
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
;
; fc <CCKs to wait>     Wait n color clocks.

;------------------------------------------------------------------------------

start:
	move.w #$4000,$dff09a		; Interrupts disable
loop: 
	move.l $dff004,d0
	and.l #$000fff00,d0
	cmp.l #$00013700,d0
	bne.s loop

	;bsr somethingtodo
	btst #6,$bfe001
	bne loop
	move.w #$C000,$dff09a		; Interrupts enable	
	rts
	
	end

;------------------------------------------------------------------------------
>r
Filename:Listing19i1.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
>d pc																			; step 1 - watch actual programlines
00023d66 0280 000f ff00           and.l #$000fff00,d0
00023d6c 0c80 0001 3700           cmp.l #$00013700,d0
00023d72 66ec                     bne.b #$ec == $00023d60 (T)
00023d74 0839 0006 00bf e001      btst.b #$0006,$00bfe001
00023d7c 6600 ffe2                bne.w #$ffe2 == $00023d60 (T)					; branch to $23d60 
00023d80 33fc c000 00df f09a      move.w #$c000,$00dff09a
00023d88 4e75                     rts  == $00c4f748
00023d8a 0000 1234                or.b #$34,d0
00023d8e 5678 0000                addq.w #$03,$0000.w [0000]
00023d92 0000 0000                or.b #$00,d0
;------------------------------------------------------------------------------
>d 23d60 9																		; start of program	
00023d60 2039 00df f004           move.l $00dff004,d0
00023d66 0280 000f ff00           and.l #$000fff00,d0
00023d6c 0c80 0001 3700           cmp.l #$00013700,d0
00023d72 66ec                     bne.b #$ec == $00023d60 (T)
00023d74 0839 0006 00bf e001      btst.b #$0006,$00bfe001
00023d7c 6600 ffe2                bne.w #$ffe2 == $00023d60 (T)
00023d80 33fc c000 00df f09a      move.w #$c000,$00dff09a
00023d88 4e75                     rts  == $00c4f748
00023d8a 0000 1234                or.b #$34,d0
;------------------------------------------------------------------------------
>f 23d60																		; step 2 - set a breakpoint
Breakpoint added.
;------------------------------------------------------------------------------
>g																				; run the program
Breakpoint 0 triggered.
Cycles: 20 Chip, 40 CPU. (V=105 H=8 -> V=105 H=28)
VPOS: 105 ($069) HPOS: 028 ($01c) COP: $0001ede4
  D0 00006800   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00023d60 2039 00df f004           move.l $00dff004,d0
Next PC: 00023d66
;------------------------------------------------------------------------------
>t																				; step through the program to know the buscycles
Cycles: 10 Chip, 20 CPU. (V=105 H=28 -> V=105 H=38)
VPOS: 105 ($069) HPOS: 038 ($026) COP: $0001ede4
  D0 8000691D   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0280 (AND) 000f (ILLEGAL) Chip latch 00000000
00023d66 0280 000f ff00           and.l #$000fff00,d0
Next PC: 00023d6c
;------------------------------------------------------------------------------
>t
Cycles: 8 Chip, 16 CPU. (V=105 H=38 -> V=105 H=46)
VPOS: 105 ($069) HPOS: 046 ($02e) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0c80 (CMP) 0001 (OR) Chip latch 00000000
00023d6c 0c80 0001 3700           cmp.l #$00013700,d0
Next PC: 00023d72
;------------------------------------------------------------------------------
>t
Cycles: 7 Chip, 14 CPU. (V=105 H=46 -> V=105 H=53)
VPOS: 105 ($069) HPOS: 053 ($035) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 66ec (Bcc) 0839 (BTST) Chip latch 00000000
00023d72 66ec                     bne.b #$ec == $00023d60 (T)
Next PC: 00023d74
;------------------------------------------------------------------------------
>t
Breakpoint 0 triggered.															; breakpoint triggers also in singlestep mode!
Cycles: 5 Chip, 10 CPU. (V=105 H=53 -> V=105 H=58)
VPOS: 105 ($069) HPOS: 058 ($03a) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00023d60 2039 00df f004           move.l $00dff004,d0
Next PC: 00023d66
>
;------------------------------------------------------------------------------
																				;								 buscycles										HPOS
																				; move.l $00dff004,d0			;	10			; Cycles: 10 Chip, 20 CPU. (V=105 H=28 -> V=105 H=38)
																				; and.l #$000fff00,d0			;	8			; Cycles: 8 Chip, 16 CPU. (V=105 H=38 -> V=105 H=46)	
																				; cmp.l #$00013700,d0			;	7			; Cycles: 7 Chip, 14 CPU. (V=105 H=46 -> V=105 H=53)	
																				; bne.b #$ec == $00023d60 (T)	;   5			; Cycles: 5 Chip, 10 CPU. (V=105 H=53 -> V=105 H=58)
																												; Sum = 30
;------------------------------------------------------------------------------
>fc 30																			; fc <CCKs to wait>     Wait n color clocks.	
Breakpoint 0 triggered.
Cycles: 30 Chip, 60 CPU. (V=105 H=58 -> V=105 H=88)								; we start from here: V=105 H=58 and run to V=105 H=88		
VPOS: 105 ($069) HPOS: 088 ($058) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00023d60 2039 00df f004           move.l $00dff004,d0							; one round further , 30 cycles
Next PC: 00023d66
;------------------------------------------------------------------------------											
>t
Cycles: 10 Chip, 20 CPU. (V=105 H=88 -> V=105 H=98)								; now we on H=88	(H=58+30=88)
VPOS: 105 ($069) HPOS: 098 ($062) COP: $0001ede4
  D0 80006959   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0280 (AND) 000f (ILLEGAL) Chip latch 00000000
00023d66 0280 000f ff00           and.l #$000fff00,d0							; now on H=98
Next PC: 00023d6c
>	
;------------------------------------------------------------------------------
>fc 60																			; fc <CCKs to wait>     Wait n color clocks.
Breakpoint 0 triggered.															; a breakpoint interrupts 'fc'
Cycles: 20 Chip, 40 CPU. (V=105 H=98 -> V=105 H=118)							; 20 CCK is ok
VPOS: 105 ($069) HPOS: 118 ($076) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00023d60 2039 00df f004           move.l $00dff004,d0
Next PC: 00023d66
>
;------------------------------------------------------------------------------												
>fd
All breakpoints removed.
;------------------------------------------------------------------------------
>fc 60
Cycles: 40 Chip, 80 CPU. (V=105 H=118 -> V=105 H=158)							; +40 CCK (the rest), two rounds further , 60 cycles
VPOS: 105 ($069) HPOS: 158 ($09e) COP: $0001ede4								; bug found
  D0 80006995   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0280 (AND) 000f (ILLEGAL) Chip latch 00000000
00023d66 0280 000f ff00           and.l #$000fff00,d0
Next PC: 00023d6c
;------------------------------------------------------------------------------
>t
Cycles: 8 Chip, 16 CPU. (V=105 H=158 -> V=105 H=166)
VPOS: 105 ($069) HPOS: 166 ($0a6) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0c80 (CMP) 0001 (OR) Chip latch 00000000
00023d6c 0c80 0001 3700           cmp.l #$00013700,d0
Next PC: 00023d72

;------------------------------------------------------------------------------
																				if a program breakpoint interrupts a 'fc' and the breakpoint is deleted then
																				the waiting CCKs are not correct anymore

																				>f 23d60
																				Breakpoint added.
																				>g
																				Breakpoint 0 triggered.
																				Cycles: 30 Chip, 60 CPU. (V=111 H=106 -> V=111 H=136)		; one loop is 30 CCK
																				...
																				>fd
																				All breakpoints removed.
																				>fc 90
																				Cycles: 90 Chip, 180 CPU. (V=111 H=136 -> V=111 H=226)		; everything ok here
																				...
																				>fc 90
																				Cycles: 90 Chip, 180 CPU. (V=111 H=226 -> V=112 H=89)		; everything ok here
																				...
																				>f 23d60
																				Breakpoint added.
																				>fc 90
																				Breakpoint 0 triggered.										; program breakpoint interrupts a 'fc'
																				Cycles: 30 Chip, 60 CPU. (V=112 H=89 -> V=112 H=119)		; 30 CCK is ok
																				...
																				>fd
																				All breakpoints removed.
																				>fc 90
																				Cycles: 60 Chip, 120 CPU. (V=112 H=119 -> V=112 H=179)		; 60 Chip and not 90, not ok
																				...
																				>fc 90
																				Cycles: 30 Chip, 60 CPU. (V=112 H=179 -> V=112 H=209)		; 30 Chip and not 90, not ok
																				...
																				
;------------------------------------------------------------------------------
; Test 2
;------------------------------------------------------------------------------
>fc 1
Cycles: 1 Chip, 2 CPU. (V=105 H=166 -> V=105 H=167)								; we can not wait only one cck, H=167 is pseudo
VPOS: 105 ($069) HPOS: 173 ($0ad) COP: $0001ede4								; HPOS: 173 program runs the next cck from the actual instruction
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 66ec (Bcc) 0839 (BTST) Chip latch 00000000
00023d72 66ec                     bne.b #$ec == $00023d60 (T)
Next PC: 00023d74																				
;------------------------------------------------------------------------------
>fc 1
Cycles: 5 Chip, 10 CPU. (V=105 H=173 -> V=105 H=178)							; here is the correct elapsed cycles
VPOS: 105 ($069) HPOS: 178 ($0b2) COP: $0001ede4
  D0 00006900   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00023d60 2039 00df f004           move.l $00dff004,d0
Next PC: 00023d66
;------------------------------------------------------------------------------
>fc 1
Cycles: 1 Chip, 2 CPU. (V=105 H=178 -> V=105 H=179)
VPOS: 105 ($069) HPOS: 188 ($0bc) COP: $0001ede4
  D0 800069B3   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0280 (AND) 000f (ILLEGAL) Chip latch 00000000
00023d66 0280 000f ff00           and.l #$000fff00,d0
Next PC: 00023d6c

; end of a scanline
; we can not wait only one cck, it executes the next instruction complete
; CMP.L #$00013700,D0 which needs 7 cycles so, VPOS: d2 HPOS: de	--> VPOS: d3 HPOS: 2
; HPOS=$de=222+7 = 229; if 226 is the last so if are on the next line $de=222+5=227 = $E3
; then next VPOS scanline and HPOS=2


;------------------------------------------------------------------------------
		--- Cycles ---
;------------------------------------------------------------------------------

move.l #3,d0 ; 12 cycles (instruction timing)

>t
; Cycles: 6 Chip = custom chips BUS cycles = CCK, 12 CPU cycles. (V=74 H=180 -> V=74 H=186)
Cycles: 6 Chip, 12 CPU. (V=74 H=180 -> V=74 H=186)		
...

1. What does CCK (Color Clocks) mean?

CPU cycles are doubled in respect to internal/custom chips BUS cycles.
1 CCK = 1 chip cycle = 3546895Hz on PAL (281.94ns).
Of course CPU clock on PAL 68k A500 is 7093790Hz (double this for PAL 020 A1200).

Mainboard main crystal clock is 28375160Hz (chip clock*8); from this all the others
are derived (comprised the submultiple 90/180/270 different phase one).
With this clock you can display the 35ns super-hires pixels on ECS/AGA.

2. also what means cycles? .. Cycles: 6 Chip, 12 CPU

move.l #3,d0 ; 12 cycles (instruction timing)
I can find this value 12(3/0) in the execution times table.
But where can I found this value 6 Chip cycles?

Usually you don't need to know the BUS cycles in relation to the CPU cycles
(which in any case are usually half).
The speech would become complicated because it depends on the DMA activity on
the BUS which on the Amiga is very high (fortunately, because it means that it
is a well-designed architecture!)

That instruction is known from the reported values that requires 3 accesses to
the memory (4 * 3 cycles), that is the duration of 6 internal BUS cycles.
But if the code is in chip memory then there can be contention and access will
take more than 12 CPU cycles (in fast ram this instruction require 12 cycles in
any condition).
However there is the alternative equal instruction which is moveq #3,d0, that
requires 4 cycles and a single access to the BUS.


