
; Listing19g2.s
; AGA Sprite - Ripping
; (WinUAE 5.3.0 A1200 configuration)
; Console-Debugger

; sp <addr> [<addr2][<size>] Dump sprite information.

;------------------------------------------------------------------------------

Before you use the sprite command, you must first determine the sprite pointer
initial addresses beforehand. This is because it is not possible to simply 
address the sprites with their numbers. e.g. sp 1 or sp 1 2, because in this
case 2 would be the width 32px and sp 1 4 the width 64 px.
Attached sprites must be specified as follows: sp 1 0, i.e. first the 
odd-numbered sprite1 and then the even sprite 0. But it works, very well also 
for AGA sprites.

I.e. 
sp <addr sprite1 (3/5/7)> [<addr2 sprite0 (2/4/6)>][<size>] Dump sprite information.
size = 1 = 16px (OCS)
size = 2 = 32px (AGA)
size = 4 = 64px (AGA)

>sp 0c80			; OCS 4 Farben
>sp 0c80 1			; OCS 4 Farben
>sp 687e8 2			; AGA 4 Farben Breite 32px
>sp 687e8 4			; AGA 4 Farben Breite 64px

>sp 0c80 xxxx		; OCS 16 Farben
>sp 0c80 xxxx 1		; OCS 16 Farben
>sp 687e8 xxxx 2	; AGA 16 Farben Breite 32px
>sp 687e8 xxxx 4	; AGA 16 Farben Breite 64px

;------------------------------------------------------------------------------
; Listing7a.s -> OCS 4 Colors

> fs 10 0																		; go to vpos $a and hpos 0
>o1
 0002bcd8: 0120 0002            ;  SPR0PTH := 0x0002
 0002bcdc: 0122 bd5c            ;  SPR0PTL := 0xbd5c

 >sp 2bd5c
    02BD5C 60D0 6D00
 96 02BD60 0000220000220000
 97 02BD64 0000022002200000
 98 02BD68 0000002002000000
 99 02BD6C 0022000330002200
100 02BD70 0220033333300220
101 02BD74 2200211331120022
102 02BD78 2222310330132222
103 02BD7C 0000033333300000
104 02BD80 0002233113322000
105 02BD84 0022203333022200
106 02BD88 0022000330002200
107 02BD8C 2222000000002222
108 02BD90 2222000000002222
Sprite address 0002BD5C, width = 16
OCS: StartX=416 StartY=96 EndY=109
ECS: StartX=1664 (416.0) StartY=96 EndY=109
Attach: 0. AGA SSCAN/SH10 bit: 1

>?$60
$00000060 = %00000000`00000000`00000000`01100000 = 96 = 96
>?$6d
$0000006D = %00000000`00000000`00000000`01101101 = 109 = 109
>?$d0*2
$000001A0 = %00000000`00000000`00000001`10100000 = 416 = 416
>?$d0*8
$00000680 = %00000000`00000000`00000110`10000000 = 1664 = 1664

additional information about the AGA SSCAN/SH10 bit: 1 is showed in Listing15f2b.s

>e																				; Color Register content												
...
0B0 AUD1LCH     0000    1A0 COLOR16     0000
0B2 AUD1LCL     0000    1A2 COLOR17     0F00
0B4 AUD1LEN     0000    1A4 COLOR18     00F0
0B6 AUD1PER     0001    1A6 COLOR19     0FF0
0B8 AUD1VOL     0000    1A8 COLOR20     0444
0BA AUD1DAT     0000    1AA COLOR21     0555
0C0 AUD2LCH     0000    1AC COLOR22     0666
0C2 AUD2LCL     0000    1AE COLOR23     0777
0C4 AUD2LEN     0000    1B0 COLOR24     0888
0C6 AUD2PER     0001    1B2 COLOR25     0999
0C8 AUD2VOL     0000    1B4 COLOR26     0AAA
0CA AUD2DAT     0000    1B6 COLOR27     0BBB
0D0 AUD3LCH     0000    1B8 COLOR28     0CCC
0D2 AUD3LCL     0000    1BA COLOR29     0DDD
0D4 AUD3LEN     0000    1BC COLOR30     0EEE
0D6 AUD3PER     0001    1BE COLOR31     0FFF

;------------------------------------------------------------------------------
; Listing7g.s -> OCS 16 Colors

> fs 10 0																		; go to vpos $a and hpos 0
>o1
 0002bcd8: 0120 0002            ;  SPR0PTH := 0x0002
 0002bcdc: 0122 bd8c            ;  SPR0PTL := 0xbd8c
 0002bce0: 0124 0002            ;  SPR1PTH := 0x0002
 0002bce4: 0126 bdd0            ;  SPR1PTL := 0xbdd0

>sp 2bdd0 2bd8c 1
    02BDD0 E05A EF80
224 02BDD4 00000EB99ACE0000
225 02BDD8 0000C766779AD000
226 02BDDC 000A65454679AD00
227 02BDE0 00C7533445679BE0
228 02BDE4 0E97431345579BD0
229 02BDE8 0D86421334568ACF
230 02BDEC 0C86442345578ABE
231 02BDF0 0B96544445679ACE
232 02BDF4 0C99664556689BCE
233 02BDF8 0DB987666789ACDF
234 02BDFC 0FCB9978798ABDD0
235 02BE00 00ECBA9999BBDDF0
236 02BE04 000ECCAAABCDDF00
237 02BE08 0000FEDDDDDEF000
238 02BE0C 000000FFFFF00000
Sprite address 0002BDD0, width = 16
OCS: StartX=180 StartY=224 EndY=239
ECS: StartX=720 (180.0) StartY=224 EndY=239
Attach: 1. AGA SSCAN/SH10 bit: 0

>e																				; Color Register content
...
08E DIWSTRT     2C81    182 COLOR01     0123
090 DIWSTOP     2CC1    184 COLOR02     0002
092 DDFSTRT     0038    186 COLOR03     0F80
094 DDFSTOP     00D0    188 COLOR04     0FFF
096 DMACON      23F0    18A COLOR05     0FFF
098 CLXCON      0000    18C COLOR06     0FFF
09A INTENA      202C    18E COLOR07     0FFF
09C INTREQ      1068    190 COLOR08     0FFF
09E ADKCON      1100    192 COLOR09     0FFF
0A0 AUD0LCH     0000    194 COLOR10     0FFF
0A2 AUD0LCL     0000    196 COLOR11     0FFF
0A4 AUD0LEN     0000    198 COLOR12     0FFF
0A6 AUD0PER     0001    19A COLOR13     0FFF
0A8 AUD0VOL     0000    19C COLOR14     0FFF
0AA AUD0DAT     0000    19E COLOR15     0FFF
0B0 AUD1LCH     0000    1A0 COLOR16     0000
0B2 AUD1LCL     0000    1A2 COLOR17     0FFC
0B4 AUD1LEN     0000    1A4 COLOR18     0EEB
0B6 AUD1PER     0001    1A6 COLOR19     0CD9
0B8 AUD1VOL     0000    1A8 COLOR20     0AC8
0BA AUD1DAT     0000    1AA COLOR21     08B6
0C0 AUD2LCH     0000    1AC COLOR22     06A5
0C2 AUD2LCL     0000    1AE COLOR23     0494
0C4 AUD2LEN     0000    1B0 COLOR24     0384
0C6 AUD2PER     0001    1B2 COLOR25     0274
0C8 AUD2VOL     0000    1B4 COLOR26     0164
0CA AUD2DAT     0000    1B6 COLOR27     0154
0D0 AUD3LCH     0000    1B8 COLOR28     0044
0D2 AUD3LCL     0000    1BA COLOR29     0033
0D4 AUD3LEN     0000    1BC COLOR30     0012
0D6 AUD3PER     0001    1BE COLOR31     0001

;------------------------------------------------------------------------------
; Listing15f2.s  -> AGA 32px, 4 Colors

> fs 10 0																		; go to vpos $a and hpos 0
>o1
 000686f8: 0120 0006            ;  SPR0PTH := 0x0006
 000686fc: 0122 87e8            ;  SPR0PTL := 0x87e8
 00068700: 0124 0006            ;  SPR1PTH := 0x0006
 00068704: 0126 87d8            ;  SPR1PTL := 0x87d8

>sp 687e8 2
    0687E8 2C40 0000 4600 0000
 44 0687F0 00000000022000000000022000000000
 45 0687F8 00000000022200000000222000000000
 46 068800 00000000002220000002220000000000
 47 068808 00000000000222000022200000000000
 48 068810 00000000000022000022000000000000
 49 068818 00000000000022200222000000000000
 50 068820 00000222000002333320000022200000
 51 068828 00002220000003333330000002220000
 52 068830 00022200000333333333300000222000
 53 068838 00222000003333333333330000022200
 54 068840 02220000023113333331132000002220
 55 068848 22220000231111333311113200002222
 56 068850 22222222331100333300113322222222
 57 068858 02222222333100333300133322222220
 58 068860 00000000033333333333333000000000
 59 068868 00000000223333333333332200000000
 60 068870 00000002223331111113332220000000
 61 068878 00000022222333111133322222000000
 62 068880 00000222220033333333002222200000
 63 068888 00002222200033333333000222220000
 64 068890 00002222000003333330000022220000
 65 068898 00002222000000033000000022220000
 66 0688A0 22222222000000000000000022222222
 67 0688A8 22222222000000000000000022222222
 68 0688B0 22222222000000000000000022222222
 69 0688B8 22222222000000000000000022222222
Sprite address 000687E8, width = 32
OCS: StartX=128 StartY=44 EndY=70
ECS: StartX=512 (128.0) StartY=44 EndY=70
Attach: 0. AGA SSCAN/SH10 bit: 0

;------------------------------------------------------------------------------
>e																				; Color Register content
...
08E DIWSTRT     2C81    182 COLOR01     0123
090 DIWSTOP     2CC1    184 COLOR02     0FFF
092 DDFSTRT     0038    186 COLOR03     068B
094 DDFSTOP     00D0    188 COLOR04     0FFE
096 DMACON      03A0    18A COLOR05     0BB9
098 CLXCON      0000    18C COLOR06     0DE7
09A INTENA      0000    18E COLOR07     0E7D
09C INTREQ      0028    190 COLOR08     07FF
09E ADKCON      1100    192 COLOR09     0DED
0A0 AUD0LCH     0000    194 COLOR10     0DF9
0A2 AUD0LCL     0000    196 COLOR11     0BDC
0A4 AUD0LEN     0000    198 COLOR12     0BF4
0A6 AUD0PER     0000    19A COLOR13     0FF4
0A8 AUD0VOL     0000    19C COLOR14     0E77
0AA AUD0DAT     0000    19E COLOR15     0E77
0B0 AUD1LCH     0000    1A0 COLOR16     0000
0B2 AUD1LCL     0000    1A2 COLOR17     0F00
0B4 AUD1LEN     0000    1A4 COLOR18     00F0
0B6 AUD1PER     0000    1A6 COLOR19     0FF0
0B8 AUD1VOL     0000    1A8 COLOR20     0444
0BA AUD1DAT     0000    1AA COLOR21     0555
0C0 AUD2LCH     0000    1AC COLOR22     0666
0C2 AUD2LCL     0000    1AE COLOR23     0777
0C4 AUD2LEN     0000    1B0 COLOR24     0888
0C6 AUD2PER     0000    1B2 COLOR25     0999
0C8 AUD2VOL     0000    1B4 COLOR26     0AAA
0CA AUD2DAT     0000    1B6 COLOR27     0BBB
0D0 AUD3LCH     0000    1B8 COLOR28     0CCC
0D2 AUD3LCL     0000    1BA COLOR29     0DDD
0D4 AUD3LEN     0000    1BC COLOR30     0EEE
0D6 AUD3PER     0000    1BE COLOR31     0FFF

>ea																				; AGA Color Register content
  0 00000000  64 001FDFFF 128 00FFC3FD 192 0082AB7F
  1 00102030  65 00FDF76F 129 00F5FFDF 193 00EFFFBA
  2 00FFFFFF  66 00D5DF3F 130 00EFDBBF 194 00FEFFEF
  3 006688BB  67 00FFEDF6 131 0044FFFF 195 00DB7FDC
  4 00FEF5ED  68 00AFBEFB 132 0077DFFF 196 00FBCFEB
  5 00BFBF9F  69 0076B7D3 133 007BFB9C 197 00DF93FA
  6 00D7ED70  70 00F3FFD5 134 00F7BFFA 198 00F577FA
  7 00EE7FDD  71 00976CED 135 00FABEBF 199 00BDDDFD
  8 007CFCFF  72 00F3BD7E 136 001EFFDE 200 00EDF8EE
  9 00DDEFDF  73 006EEFFA 137 007997AE 201 007BFFBE
 10 00D7F795  74 00A3FB7E 138 00D67FFA 202 004AFCE7
 11 00B5DDC6  75 00EAFFE8 139 00B7F7FF 203 007EA72F
 12 00BFF74C  76 00DBFEC7 140 00FD777F 204 007EDBEB
 13 00F5FF4F  77 007DCEF6 141 00F09F80 205 00FBEF69
 14 00EB7B7B  78 005BDFF7 142 00FCFFF2 206 00ADCE9A
 15 00EE7F7D  79 00BFFEED 143 00FFE7BF 207 00FBFDCD
 16 00000000  80 00FE1E3F 144 00CD7F7A 208 00FFEABF
 17 00F40602  81 0073FB77 145 00EFF9AF 209 00F3DDB9
 18 0002FE04  82 00DF7FBE 146 00ED77EF 210 00FFFEFB
 19 00F6F702  83 00DFF93F 147 00EE7FEF 211 007EF0FB
 20 00444444  84 00EEBFF7 148 00D76D36 212 00FCF6F9
 21 00555555  85 00FEFFAD 149 00BFCEFF 213 00897F69
 22 00666666  86 00E7FDEF 150 00EFEC1F 214 00FA5FBF
 23 00777777  87 00F1FCDF 151 00BDEEEF 215 00EF4FFF
 24 00888888  88 009DDBFF 152 00E7FF77 216 006BFFFB
 25 00999999  89 00F77B7A 153 00DF55E2 217 00FFFEFF
 26 00AAAAAA  90 00FB8F7F 154 00957FBF 218 00FF5D7D
 27 00BBBBBB  91 008FFFB7 155 0073F4FE 219 007FEBF7
 28 00CCCCCC  92 00D9F9FF 156 00B8B4AF 220 00D3326F
 29 00DDDDDD  93 00BB3B0F 157 006EC9DD 221 00FDDFEF
 30 00EEEEEE  94 00F35AB6 158 00D7DD1F 222 00FDFF0F
 31 00FFFFFF  95 003DEFFF 159 00BBF73D 223 00FF8EF9
 32 002EDDDE  96 00DFFFBF 160 00E9DFBE 224 00FF6F6D
 33 00DFFDBF  97 00FDB5FD 161 007B5E95 225 00ECCABE
 34 00BD66DB  98 00AB7AFF 162 00EEFFF7 226 00F7F3B3
 35 00EFFBED  99 006F6DEE 163 0073B6FE 227 00F7FFFF
 36 00E4FFEC 100 009FFBF3 164 0057FFBB 228 001BEDD8
 37 00FABB6B 101 00BAEFFF 165 00FF16E1 229 00BAF50C
 38 00E7F5EF 102 00FBFFB7 166 00F3FEDC 230 0077CAB9
 39 00FFDF96 103 00E7B4FE 167 00BEBB4F 231 0097B3EE
 40 00F79BFE 104 00FED7FF 168 00BDF97F 232 00AEDFFD
 41 00FFE56F 105 00BFE1FA 169 00752F8A 233 00F6B7FD
 42 00755EF7 106 00FF9FD7 170 00BDEF5F 234 00BD9EFF
 43 00F79B0A 107 009C977B 171 00FFF9FE 235 00FDFEBF
 44 007FDFFD 108 00EB7E6F 172 00FBFCD7 236 007DDFBE
 45 00DBEFFF 109 00B5BEBF 173 00DFDFBE 237 00B75FFF
 46 00FFB7F1 110 002DFF57 174 00FD7FF0 238 00F97EFB
 47 00E5CFDC 111 00DA757F 175 00F93EDF 239 00C7FB57
 48 00AF2DFF 112 0057DDFF 176 002D3FD7 240 00CCB5F7
 49 004AF77F 113 00F34FBA 177 00D776FF 241 00FEFF6F
 50 0089E8AA 114 00EDFBF9 178 00793DFB 242 00D3F3BF
 51 00A73FFF 115 00FD772E 179 00F9F4F3 243 005FFE4F
 52 0067EDEB 116 00677FFC 180 00EEF6BB 244 00E97DEF
 53 00DDEFF6 117 005F2BFF 181 00BEAFEF 245 00E5BFFD
 54 00FFFBE7 118 00F7FDFF 182 00779AFF 246 006AFBD1
 55 00B6DB96 119 005FEBFE 183 0031FC6F 247 00EDB5FB
 56 00DCE59D 120 003FF7FB 184 003B77F5 248 0039D57F
 57 00F77DDF 121 00D7F774 185 006DDFFB 249 00DFDDDF
 58 00FE92EF 122 0073B9EF 186 009D577F 250 00DFC62F
 59 00FF95BE 123 00AF5FCB 187 00FF6FF0 251 00F76E5F
 60 00DFF7F9 124 00F457DE 188 007BB37F 252 00FFF7E1
 61 00F73F3B 125 0097FEE7 189 00BF1A97 253 00EFF6AD
 62 00BFFBFB 126 00FDD7FB 190 00EDADFF 254 006F97FF
 63 00E55951 127 005A98F7 191 00EEDB3F 255 0097F7FB

;------------------------------------------------------------------------------
; Listing15f3.s  -> AGA 64px, 4 Colors

>fs 10 0																		; go to vpos $a and hpos 0
>o1
 000686f8: 0120 0006            ;  SPR0PTH := 0x0006
 000686fc: 0122 87e8            ;  SPR0PTL := 0x87e8
 00068700: 0124 0006            ;  SPR1PTH := 0x0006
 00068704: 0126 87d8            ;  SPR1PTL := 0x87d8

>sp 687e8 4
    0687E8 2C40 0000 0000 0000 6000 0000 0000 0000
 44 0687F8 0000000000000000002200000000000000000000000022000000000000000000
 45 068808 0000000000000000002220000000000000000000000222000000000000000000
 46 068818 0000000000000000000222000000000000000000002220000000000000000000
 47 068828 0000000000000000000022200000000000000000022200000000000000000000
 48 068838 0000000000000000000002220000000000000000222000000000000000000000
 49 068848 0000000000000000000000222000000000000002220000000000000000000000
 50 068858 0000000000000000000000022200000000000022200000000000000000000000
 51 068868 0000000000000000000000002220000000000222000000000000000000000000
 52 068878 0000000000000000000000000222000000002220000000000000000000000000
 53 068888 0000000000000000000000000022200000022200000000000000000000000000
 54 068898 0000000000000000000000000022200000022200000000000000000000000000
 55 0688A8 0000000000000000000000000002220000222000000000000000000000000000
 56 0688B8 0000000000002222000000000002333333332000000000002222000000000000
 57 0688C8 0000000000222222000000000033333333333300000000002222220000000000
 58 0688D8 0000000002222200000000000333333333333330000000000022222000000000
 59 0688E8 0000000022222000000000003333333333333333000000000002222200000000
 60 0688F8 0000000222220000000000033333333333333333300000000000222220000000
 61 068908 0000002222200000000000333333333333333333330000000000022222000000
 62 068918 0000022222000000000003333333333333333333333000000000002222200000
 63 068928 0000222220000000000033333333333333333333333300000000000222220000
 64 068938 0002222200000000000333111133333333333311113330000000000022222000
 65 068948 0022222000000000003331111113333333333111111333000000000002222200
 66 068958 0222220000000000003311111111333333331111111133000000000000222220
 67 068968 2222220000000000033311111111333333331111111133300000000000222222
 68 068978 2222222222222222233311111000333333330001111133322222222222222222
 69 068988 2222222222222222233311110000333333330000111133322222222222222222
 70 068998 2222222222222222233331110000333333330000111333322222222222222222
 71 0689A8 0222222222222222233333110003333333333000113333322222222222222220
 72 0689B8 0000000000000000003333333333333333333333333333000000000000000000
 73 0689C8 0000000000000000003333333333333333333333333333000000000000000000
 74 0689D8 0000000000000000022333333333333333333333333332200000000000000000
 75 0689E8 0000000000000000222333333333333333333333333332220000000000000000
 76 0689F8 0000000000000002222233333111111111111113333322222000000000000000
 77 068A08 0000000000000022222233333311111111111133333322222200000000000000
 78 068A18 0000000000000222222223333331111111111333333222222220000000000000
 79 068A28 0000000000000222222222333333111111113333332222222220000000000000
 80 068A38 0000000000002222222200033333333333333333300022222222000000000000
 81 068A48 0000000000022222222000033333333333333333300002222222200000000000
 82 068A58 0000000000222222220000003333333333333333000000222222220000000000
 83 068A68 0000000000222222220000000333333333333330000000222222220000000000
 84 068A78 0000000002222222200000000033333333333300000000022222222000000000
 85 068A88 0000000002222222200000000003333333333000000000022222222000000000
 86 068A98 0000000022222222000000000000333333330000000000002222222200000000
 87 068AA8 0000000022222222000000000000003333000000000000002222222200000000
 88 068AB8 0000002222222220000000000000000000000000000000000222222222000000
 89 068AC8 0000222222222220000000000000000000000000000000000222222222220000
 90 068AD8 0022222222222220000000000000000000000000000000000222222222222200
 91 068AE8 0222222222222222000000000000000000000000000000002222222222222220
 92 068AF8 2222222222222222000000000000000000000000000000002222222222222222
 93 068B08 2222222222222222200000000000000000000000000000022222222222222222
 94 068B18 2222222222222222200000000000000000000000000000022222222222222222
 95 068B28 2222222222222222200000000000000000000000000000022222222222222222
Sprite address 000687E8, width = 64
OCS: StartX=128 StartY=44 EndY=96
ECS: StartX=512 (128.0) StartY=44 EndY=96
Attach: 0. AGA SSCAN/SH10 bit: 0

;------------------------------------------------------------------------------
>e																				; Color Register content
...
08C COPINS      0000    180 COLOR00     0000
08E DIWSTRT     2C81    182 COLOR01     0123
090 DIWSTOP     2CC1    184 COLOR02     0FFF
092 DDFSTRT     0038    186 COLOR03     068B
094 DDFSTOP     00D0    188 COLOR04     0FFE
096 DMACON      03A0    18A COLOR05     0BB9
098 CLXCON      0000    18C COLOR06     0DE7
09A INTENA      0000    18E COLOR07     0E7D
09C INTREQ      0028    190 COLOR08     07FF
09E ADKCON      1100    192 COLOR09     0DED
0A0 AUD0LCH     0000    194 COLOR10     0DF9
0A2 AUD0LCL     0000    196 COLOR11     0BDC
0A4 AUD0LEN     0000    198 COLOR12     0BF4
0A6 AUD0PER     0000    19A COLOR13     0FF4
0A8 AUD0VOL     0000    19C COLOR14     0E77
0AA AUD0DAT     0000    19E COLOR15     0E77
0B0 AUD1LCH     0000    1A0 COLOR16     0000
0B2 AUD1LCL     0000    1A2 COLOR17     0F00
0B4 AUD1LEN     0000    1A4 COLOR18     00F0
0B6 AUD1PER     0000    1A6 COLOR19     0FF0
0B8 AUD1VOL     0000    1A8 COLOR20     0444
0BA AUD1DAT     0000    1AA COLOR21     0555
0C0 AUD2LCH     0000    1AC COLOR22     0666
0C2 AUD2LCL     0000    1AE COLOR23     0777
0C4 AUD2LEN     0000    1B0 COLOR24     0888
0C6 AUD2PER     0000    1B2 COLOR25     0999
0C8 AUD2VOL     0000    1B4 COLOR26     0AAA
0CA AUD2DAT     0000    1B6 COLOR27     0BBB
0D0 AUD3LCH     0000    1B8 COLOR28     0CCC
0D2 AUD3LCL     0000    1BA COLOR29     0DDD
0D4 AUD3LEN     0000    1BC COLOR30     0EEE
0D6 AUD3PER     0000    1BE COLOR31     0FFF

>ea																				; AGA Color Register content
  0 00000000  64 001FDFFF 128 00FFC3FD 192 0082AB7F
  1 00102030  65 00FDF76F 129 00F5FFDF 193 00EFFFBA
  2 00FFFFFF  66 00D5DF3F 130 00EFDBBF 194 00FEFFEF
  3 006688BB  67 00FFEDF6 131 0044FFFF 195 00DB7FDC
  4 00FEF5ED  68 00AFBEFB 132 0077DFFF 196 00FBCFEB
  5 00BFBF9F  69 0076B7D3 133 007BFB9C 197 00DF93FA
  6 00D7ED70  70 00F3FFD5 134 00F7BFFA 198 00F577FA
  7 00EE7FDD  71 00976CED 135 00FABEBF 199 00BDDDFD
  8 007CFCFF  72 00F3BD7E 136 001EFFDE 200 00EDF8EE
  9 00DDEFDF  73 006EEFFA 137 007997AE 201 007BFFBE
 10 00D7F795  74 00A3FB7E 138 00D67FFA 202 004AFCE7
 11 00B5DDC6  75 00EAFFE8 139 00B7F7FF 203 007EA72F
 12 00BFF74C  76 00DBFEC7 140 00FD777F 204 007EDBEB
 13 00F5FF4F  77 007DCEF6 141 00F09F80 205 00FBEF69
 14 00EB7B7B  78 005BDFF7 142 00FCFFF2 206 00ADCE9A
 15 00EE7F7D  79 00BFFEED 143 00FFE7BF 207 00FBFDCD
 16 00000000  80 00FE1E3F 144 00CD7F7A 208 00FFEABF
 17 00F40602  81 0073FB77 145 00EFF9AF 209 00F3DDB9
 18 0002FE04  82 00DF7FBE 146 00ED77EF 210 00FFFEFB
 19 00F6F702  83 00DFF93F 147 00EE7FEF 211 007EF0FB
 20 00444444  84 00EEBFF7 148 00D76D36 212 00FCF6F9
 21 00555555  85 00FEFFAD 149 00BFCEFF 213 00897F69
 22 00666666  86 00E7FDEF 150 00EFEC1F 214 00FA5FBF
 23 00777777  87 00F1FCDF 151 00BDEEEF 215 00EF4FFF
 24 00888888  88 009DDBFF 152 00E7FF77 216 006BFFFB
 25 00999999  89 00F77B7A 153 00DF55E2 217 00FFFEFF
 26 00AAAAAA  90 00FB8F7F 154 00957FBF 218 00FF5D7D
 27 00BBBBBB  91 008FFFB7 155 0073F4FE 219 007FEBF7
 28 00CCCCCC  92 00D9F9FF 156 00B8B4AF 220 00D3326F
 29 00DDDDDD  93 00BB3B0F 157 006EC9DD 221 00FDDFEF
 30 00EEEEEE  94 00F35AB6 158 00D7DD1F 222 00FDFF0F
 31 00FFFFFF  95 003DEFFF 159 00BBF73D 223 00FF8EF9
 32 002EDDDE  96 00DFFFBF 160 00E9DFBE 224 00FF6F6D
 33 00DFFDBF  97 00FDB5FD 161 007B5E95 225 00ECCABE
 34 00BD66DB  98 00AB7AFF 162 00EEFFF7 226 00F7F3B3
 35 00EFFBED  99 006F6DEE 163 0073B6FE 227 00F7FFFF
 36 00E4FFEC 100 009FFBF3 164 0057FFBB 228 001BEDD8
 37 00FABB6B 101 00BAEFFF 165 00FF16E1 229 00BAF50C
 38 00E7F5EF 102 00FBFFB7 166 00F3FEDC 230 0077CAB9
 39 00FFDF96 103 00E7B4FE 167 00BEBB4F 231 0097B3EE
 40 00F79BFE 104 00FED7FF 168 00BDF97F 232 00AEDFFD
 41 00FFE56F 105 00BFE1FA 169 00752F8A 233 00F6B7FD
 42 00755EF7 106 00FF9FD7 170 00BDEF5F 234 00BD9EFF
 43 00F79B0A 107 009C977B 171 00FFF9FE 235 00FDFEBF
 44 007FDFFD 108 00EB7E6F 172 00FBFCD7 236 007DDFBE
 45 00DBEFFF 109 00B5BEBF 173 00DFDFBE 237 00B75FFF
 46 00FFB7F1 110 002DFF57 174 00FD7FF0 238 00F97EFB
 47 00E5CFDC 111 00DA757F 175 00F93EDF 239 00C7FB57
 48 00AF2DFF 112 0057DDFF 176 002D3FD7 240 00CCB5F7
 49 004AF77F 113 00F34FBA 177 00D776FF 241 00FEFF6F
 50 0089E8AA 114 00EDFBF9 178 00793DFB 242 00D3F3BF
 51 00A73FFF 115 00FD772E 179 00F9F4F3 243 005FFE4F
 52 0067EDEB 116 00677FFC 180 00EEF6BB 244 00E97DEF
 53 00DDEFF6 117 005F2BFF 181 00BEAFEF 245 00E5BFFD
 54 00FFFBE7 118 00F7FDFF 182 00779AFF 246 006AFBD1
 55 00B6DB96 119 005FEBFE 183 0031FC6F 247 00EDB5FB
 56 00DCE59D 120 003FF7FB 184 003B77F5 248 0039D57F
 57 00F77DDF 121 00D7F774 185 006DDFFB 249 00DFDDDF
 58 00FE92EF 122 0073B9EF 186 009D577F 250 00DFC62F
 59 00FF95BE 123 00AF5FCB 187 00FF6FF0 251 00F76E5F
 60 00DFF7F9 124 00F457DE 188 007BB37F 252 00FFF7E1
 61 00F73F3B 125 0097FEE7 189 00BF1A97 253 00EFF6AD
 62 00BFFBFB 126 00FDD7FB 190 00EDADFF 254 006F97FF
 63 00E55951 127 005A98F7 191 00EEDB3F 255 0097F7FB
>