
; Listing19d1.s
; memory-watchpoint: possible combinations and explanations
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
;
; official help text is:
w <num> <address> <length> <R/W/I> <F/C/L/N> [V<value>[.x]] (read/write/opcode) (freeze/mustchange/logonly/nobreak).
                        Add/remove memory watchpoints.
; but better is:
w <num> <address> <length> [<R/W/I>] [<F/C/L/N>] [V<value>[.x]][<channel>]
						(read/write/opcode) (freeze/mustchange/logonly/nobreak).
                        Add/remove memory watchpoints.

1. w
2. w <num>	= w [0 - 7]
3. w <num> <address>
4. w <num> <address> <length>
5. w <num> <address> <length> [<R/W/I>]
6. w <num> <address> <length> [<F/C/L/N>]
7. w <num> <address> <length> [<R/W/I>] [<F/C/L/N>]
8. w <num> <address> <length> [V<value>[.x]]
   w <num> <address> <length> [<R/W/I>] [<F/C/L/N>] [V<value>[.x]] 
   w <num> <address> <length> [V<value>[.x]] [<R/W/I>] [<F/C/L/N>]				; it's the same
9. w <num> <address> <length> [<channel>]
   w <num> <address> <length> [<R/W/I>] [<F/C/L/N>] [V<value>[.x]][<channel>]

numbers:   0x/$/!/%  .b .w .l
;------------------------------------------------------------------------------
>w																				; 1. 
Memwatch breakpoints enabled													; w	list all memory watchpoints
																				; ???? 
																				; answer 'No breakpoints.' expected

;------------------------------------------------------------------------------
																				; 3.
																				; w <num> <address>	
																				; If address is specified, watchpoint <num> is set to address.
																				; To use another watchpoint change the watchpoint number to 1, 2, 3 etc.
>w 0 29052																		; (CPU only is the default)
 0: 00029052 - 00029052 (1) RWI CPU								
>w 1 100
 1: 00000100 - 00000100 (1) RWI CPU
;------------------------------------------------------------------------------
>w																				; 1. 
0: 00029052 - 00029052 (1) RWI CPU												; w	list all memory watchpoints	
1: 00000100 - 00000100 (1) RWI CPU
;------------------------------------------------------------------------------
>wd																				; wd like fd is not possible to delete all mem-breakpoints
Illegal memory access logging enabled. Break=0
;------------------------------------------------------------------------------
																				; 2. 
																				; w <num>	= w [0 - 7]	delete the numbered memory watchpoint
>w 0																			; w <num> deletes watchpoint <num>.
Memwatch 0 removed
>w
 1: 00000100 - 00000100 (1) RWI CPU
>w 1
Memwatch 1 removed
>w
>
;------------------------------------------------------------------------------
																				; 4. 
																				; w <num> <address> <length>
>w 0 100 2																		; length here 2 bytes
 0: 00000100 - 00000101 (2) RWI CPU												; range bytes 100 and 101
>w 0 1000 $1100-$100															; also possible a term for the length
 0: 00001000 - 00001FFF (4096) RWI CPU		
>w 0 1000 $1000																	; its the same												
 0: 00001000 - 00001FFF (4096) RWI CPU
;------------------------------------------------------------------------------
																				; 5. w <num> <address> <length> <R/W/I>
>w 0 1000 10 R
 0: 00001000 - 0000100F (16) R   CPU
>w 0 1000 10 W
 0: 00001000 - 0000100F (16)  W  CPU
>w 0 1000 10 I
 0: 00001000 - 0000100F (16)   I CPU
>w 0 1000 10 RW
String returned: ''
>w 0 1000 10 RI
 0: 00001000 - 0000100F (16) R I CPU
>w 0 1000 10 WI
 0: 00001000 - 0000100F (16)  WI CPU
>w 0 1000 10 WIR
 0: 00001000 - 0000100F (16) RWI CPU
;------------------------------------------------------------------------------
																				; 6. w <num> <address> <length> <F/C/L/N>
>w 0 1000 10 F
 0: 00001000 - 0000100F (16) RWI F CPU
>w 0 1000 10 C
 0: 00001000 - 0000100F (16) RWI C CPU
>w 0 1000 10 L
 0: 00001000 - 0000100F (16) RWI L CPU
>w 0 1000 10 N
 0: 00001000 - 0000100F (16) RWI N CPU

>w 0 1000 10 FC
 0: 00001000 - 0000100F (16) RWI F C CPU
>w 0 1000 10 FL
 0: 00001000 - 0000100F (16) RWI F L CPU
>w 0 1000 10 FN
 0: 00001000 - 0000100F (16) RWI F N CPU

>w 0 1000 10 CL
 0: 00001000 - 0000100F (16) RWI C L CPU
>w 0 1000 10 CF
 0: 00001000 - 0000100F (16) RWI F C CPU
>w 0 1000 10 CN
 0: 00001000 - 0000100F (16) RWI C N CPU

>w 0 1000 10 FCL
 0: 00001000 - 0000100F (16) RWI F C L CPU
>w 0 1000 10 FCN
 0: 00001000 - 0000100F (16) RWI F C N CPU
;------------------------------------------------------------------------------
																				; 7. w <num> <address> <length> <R/W/I> <F/C/L/N>
>w 0 1000 10 W F
 0: 00001000 - 0000100F (16)  W  F CPU
>w 0 1000 10 R L
 0: 00001000 - 0000100F (16) R   L CPU
>w 0 1000 10 I C
 0: 00001000 - 0000100F (16)   I C CPU
>w 0 1000 10 WI CN
 0: 00001000 - 0000100F (16)  WI C N CPU
;------------------------------------------------------------------------------
																				; 8. w <num> <address> <length> [V<value>[.x]
>w 0 1000 10 V5
 0: 00001000 - 0000100F (16) RWI =5.b CPU
>w 0 1000 10 V5.b
 0: 00001000 - 0000100F (16) RWI =5.b CPU
>w 0 1000 10 V5.w
 0: 00001000 - 0000100F (16) RWI =5.w CPU
>w 0 1000 10 V5.l
 0: 00001000 - 0000100F (16) RWI =5.l CPU
>w 0 1000 10 R V5.l
 0: 00001000 - 0000100F (16) R   =5.l CPU
>w 0 1000 10 F V5.l
 0: 00001000 - 0000100F (16) RWI F =5.l CPU
>w 0 1000 10 F V$A.l
 0: 00001000 - 0000100F (16) RWI F =A.l CPU
>w 0 1000 10 F V$BB.w
 0: 00001000 - 0000100F (16) RWI F =BB.w CPU
>w 0 1000 10 F V!100.w
 0: 00001000 - 0000100F (16) RWI F =64.w CPU
>w 0 1000 10 A R VC
 0: 00001000 - 0000100F (16) R   =C.b CPU
>w 0 1000 0x64 %101 I VC.w
 0: 00001000 - 00001063 (100)   I =C.w CPU
>w 0 1000 0x64 %101 VC.w I
 0: 00001000 - 00001063 (100)   I =C.w CPU										; oder anything
>w 0 382d6 1 F V1b.w															; freeze a bytevalue
 0: 000382D6 - 000382D6 (1) RWI F =1B.w CPU

;------------------------------------------------------------------------------

>w 0 1000 COP
 0: 00001000 - 0000100B (12) RWI CPU
>w 0 1000 10 COP
 0: 00001000 - 0000100F (16) RWI COP
>w 0 1000 10 COP
 0: 00001000 - 0000100F (16) RWI COP
>w 0 100 10 W V!345 ALL
 0: 00000100 - 0000010F (16)  W  =159.w ALL
>w 0 $200 1 BLT F
 0: 00000200 - 00000200 (1) RWI F BLT
>w 0 $200 1 BLT F R
 0: 00000200 - 00000200 (1) R   F BLT

																				; Shift+F12	
;------------------------------------------------------------------------------
>w 0 4 4 R
 0: 00000004 - 00000007 (4) R   CPU
>x
;------------------------------------------------------------------------------
; break: this info message is missed											; breaks permanently
VPOS: 114 ($072) HPOS: 079 ($04f) COP: $0001ede4
  D0 00000000   D1 00000000   D2 40000000   D3 579B0C27
  D4 000A1A09   D5 00000000   D6 80000000   D7 C0000000
  A0 00DFF000   A1 00C031DA   A2 00FDFF50   A3 00C00410
  A4 00FC0FE2   A5 00C041E0   A6 00C00276   A7 00C7FFE2
USP  00C04222 ISP  00C7FFE2
SR=2200 T=00 S=1 M=0 X=0 N=0 Z=0 V=0 C=0 IM=2 STP=0
Prefetch 3228 (MOVE) 001c (OR) Chip latch 00000276
00fc0cec 2c78 0004                movea.l $0004.w [00c00276],a6
00fc0cf0 3228 001c                move.w (a0,$001c) == $00dff01c,d1
Next PC: 00fc0cf4
;------------------------------------------------------------------------------
>w 0 4 4 RN																		; no break
 0: 00000004 - 00000007 (4) R   N CPU
>x	
																				; Shift+F12	 
;------------------------------------------------------------------------------
; * message 
>w 0 4 4 RL																		; logonly
String returned: ''
>w 0 4 4 R L
 0: 00000004 - 00000007 (4) R   L CPU
>x
																				; Shift+F12	 
;------------------------------------------------------------------------------
; * message 
>w 0 4 4 R LN																	; logonly and no break					
 0: 00000004 - 00000007 (4) R   L N CPU
>x
																				; Shift+F12	
;------------------------------------------------------------------------------
Memwatch 0: break at 00000006.W R   00000000 PC=00FE93D2 CPUDR (000)			; * message
VPOS: 105 ($069) HPOS: 000 ($000) COP: $0001ede4
  D0 00000000   D1 00000000   D2 40000000   D3 579B0C27
  D4 000A1A09   D5 00000000   D6 80000000   D7 C0000000
  A0 00C0040C   A1 00C031DA   A2 00FDFF50   A3 00C00410
  A4 00FC0FE2   A5 00C041E0   A6 00C00276   A7 00C80000
USP  00C04222 ISP  00C80000
SR=2000 T=00 S=1 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=1
Prefetch 4e72 (STOP) 2000 (MOVE) Chip latch 00000000
00fc0f90 4e72 2000                stop #$2000
Next PC: 00fc0f94
>																																							

;------------------------------------------------------------------------------
; explanation
w <num> <address> <length> [<R/W/I>] [<F/C/L/N>] [V<value>[.x]][<channel>]
						(read/write/opcode) (freeze/mustchange/logonly/nobreak).
                        Add/remove memory watchpoints.

w <watchpoint number> <memory start address> <length in bytes> <flags> <value> <channel>

;------------------------------------------------------------------------------

from EAB:
Notes:
	address, length and value are interpreted as hexadecimal numbers, unless you specify 
	otherwise. Also note that the description in help is slightly incorrect as address, 
	length, trigger, value and channel operation are optional too.
watchpoint number: 
	You can have up to 8 memwatch breakpoints (0-7) and you can have any combination of
	them set/unset, for example watchpoints 2 and 5 set, the remaining ones not set.
memory start address:
	is clear
length in bytes:
	Default value for length is 1.
	Length is a numerical value and specifies the window size in memory where an
	access can trigger the watchpoint.
	Example: if you use w 0 1000 9 W, any longword that is written in the
	range $ffd (last byte of operation is in window) to $1008 (first one) triggers the
	watchpoint, so move.l #123,$ffd, sub.l #234,$1000, or add.l #345,$1008 would trigger.
flags:
	R/W/I	 (read/write/opcode (instruction))
	F/C/L/N  (freeze/mustchange/logonly/nobreak)
	Default value for trigger operation is RWI.						

	Yes, when you've found values you can freeze them with the watchpoint command:
	w <watchpoint number> <memory start address> <length in bytes> <flags>

	To freeze your 1E7E6 address in Crazy Cars 3 you would do:

	Code:
	w 0 1E7E6 2 frw
	This sets freeze watchpoint 0 on the contents of that address and the following one.

	The flags are (from Toni):
	FR = writing changes value in memory normally, reading always return frozen value.
	FW = writing replaces value in memory with frozen value, reading returns original
	value in memory location.
	(of course only if location has not yet been written to)
	FRW = original operation, both reads and writes are frozen.

	Flag L means: Only log the hit, don't break in debugger.

	What exactly is the difference between logonly and no break? 
	Both do not break and only log the break after reopening with Shift+F12.																				
	I suppose that logonly logs in winuae logfile.

	nobreak = don't break but still handle the memwatch point. 
	For example if memwatch is used to modify memory reads. 
	Without logging it if it would cause huge log flood.	

value:
	[V<value>[.x]]
	If you would add 345 for value (w 0 1000 9 W V!345), only the last one would trigger.
	For word sized operands the range would be $fff to $1008, for byte sized $1000 to $1008.
channel:
	All DMA channels have been recently added to memwatch points. CPU only is the default.
	Append extra string parameter(s) at the end of w command to change supported access types.

	"ALL"	 = everything,
	"NONE"	 = ??
	"CPU"	 = CPU only is the default.

	"CPU"  = is CPUDR + CPUDW + CPUI
	"CPUD" = is CPUDR + CPUDW
	"CPUDW" = write
	"CPUDR" = read
	"CPUI"  = instrcution

	"DMA" = "ALL" without CPU_I + CPU_D_R + CPU_D_W

	"COP" = copper only,
	"DSK" = disk only	 
	"AUD" = audio only  (is AUD0 + AUD1 + AUD2 + AUD3)
	"SPR" = sprite only (is SPR0 + SPR1 + SPR2 + SPR3 + SPR4 + SPR5 + SPR6 + SPR7)	
	"BPL" = bitplane    (is BPL0 + BPL1 + BPL2 + BPL3 + BPL4 + BPL5 + BPL6 + BPL7)	

	"BLT"  = ( is BLTA + BLTB + BLTC + BLTD )	= all blitter channels,
	"BLTD" = ( is BLTDN + BLTDL + BLTDF)

	"BLTA" = A only.
	"BLTB"
	"BLTC"
	"BLTD"
	"BLTDN" = normal
	"BLTDL" = line
	"BLTDF"	= fill

	Check debug.cpp memwatch_access_masks for all combinationsQuote:
	Originally Posted by Toni Wilen

	https://github.com/tonioni/WinUAE/blob/master/debug.cpp

	static const struct mw_acc memwatch_access_masks[] = ...
