
; Listing19c6.s
; debugging an assembler program with a conditional register breakpoint
; start and run from asmone	
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  fo <num> <reg> <oper> <val> [<mask> <val2>] Conditional register breakpoint.
;  reg=Dx,Ax,PC,USP,ISP,VBR,SR. oper:!=,==,<,>,>=,<=,-,!- (-=val to val2 range).
;  fl                    List breakpoints.
;  fd                    Remove all breakpoints.
;  d <address> [<lines>] Disassembly starting at <address>.
;  g

;------------------------------------------------------------------------------

start:

loop:
	movea.l	#0,A0
	movea.l #$1,A0			
	movea.l #$2,A0
	movea.l #$21010,A0
	movea.l #$10,A0
	movea.l #$20,A0
	movea.l #$21100,A0
	movea.l #$100,A0
	movea.l #$200,A0
	movea.l #$22000,A0
	movea.l #$1000,A0
	movea.l #$2000,A0
	bra loop

	rts

	end
;------------------------------------------------------------------------------
; Part 1: exit a program with an endless loop
;------------------------------------------------------------------------------
>r
Filename:Listing19c6.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is running in an infinite loop
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - look current programlines
>d
000211ba 207c 0000 0000           movea.l #$00000000,a0
000211c0 207c 0000 0001           movea.l #$00000001,a0
000211c6 207c 0000 0002           movea.l #$00000002,a0
000211cc 207c 0002 1010           movea.l #$00021010,a0
000211d2 207c 0000 0010           movea.l #$00000010,a0
000211d8 207c 0000 0020           movea.l #$00000020,a0
000211de 207c 0002 1100           movea.l #$00021100,a0
000211e4 207c 0000 0100           movea.l #$00000100,a0
>d
000211ea 207c 0000 0200           movea.l #$00000200,a0
000211f0 207c 0002 2000           movea.l #$00022000,a0
000211f6 207c 0000 1000           movea.l #$00001000,a0
000211fc 207c 0000 2000           movea.l #$00002000,a0
00021202 6000 ffb6                bra.w #$ffb6 == $000211ba (T)
00021206 4e75                     rts  == $00c4f748
00021208 1234 5678                move.b (a4,d5.w[*8],$78) == $00000078 (68020+) [00],d1
;------------------------------------------------------------------------------
...
00021202 6000 ffb6                bra.w #$ffb6 == $000211ba (T)					; endlless loop	
00021206 4e75                     rts  == $00c4f748
;------------------------------------------------------------------------------
>g 21206																		; run the program from the address behind the bra
																				; to go back to asmone
;------------------------------------------------------------------------------
	
	

;------------------------------------------------------------------------------
; 
; Test 1: if reg.l == value1.l --> (fo 1 A0==$21010) -> works fine
;------------------------------------------------------------------------------
>r
Filename:Listing19c6.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is running in an infinite loop
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - look current programlines
>d
00022136 207c 0000 0100           movea.l #$00000100,a0
0002213c 207c 0000 0200           movea.l #$00000200,a0
00022142 207c 0002 2000           movea.l #$00022000,a0
00022148 207c 0000 1000           movea.l #$00001000,a0
0002214e 207c 0000 2000           movea.l #$00002000,a0
00022154 6000 ffb6                bra.w #$ffb6 == $0002210c (T)
00022158 4e75                     rts  == $00c4f748
0002215a 0000 1234                or.b #$34,d0
;------------------------------------------------------------------------------
>fo 1 A0==$21010
Breakpoint added.
>fl
1: A0 == 00021010 [ffffffff 00000000]
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 210 ($0d2) HPOS: 065 ($041) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021010   A1 00000000   A2 00000000   A3 00000000							; A0 00021010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022124 207c 0000 0010           movea.l #$00000010,a0
Next PC: 0002212a
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 210 ($0d2) HPOS: 142 ($08e) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021010   A1 00000000   A2 00000000   A3 00000000							; A0 00021010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022124 207c 0000 0010           movea.l #$00000010,a0
Next PC: 0002212a
;------------------------------------------------------------------------------
>d 2210c 10
0002210c 207c 0000 0000           movea.l #$00000000,a0
00022112 207c 0000 0001           movea.l #$00000001,a0
00022118 207c 0000 0002           movea.l #$00000002,a0
0002211e 207c 0002 1010           movea.l #$00021010,a0
00022124 207c 0000 0010           movea.l #$00000010,a0
0002212a 207c 0000 0020           movea.l #$00000020,a0
00022130 207c 0002 1100           movea.l #$00021100,a0
00022136 207c 0000 0100           movea.l #$00000100,a0
0002213c 207c 0000 0200           movea.l #$00000200,a0
00022142 207c 0002 2000           movea.l #$00022000,a0
00022148 207c 0000 1000           movea.l #$00001000,a0
0002214e 207c 0000 2000           movea.l #$00002000,a0
00022154 6000 ffb6                bra.w #$ffb6 == $0002210c (T)
00022158 4e75                     rts  == $00c4f748
0002215a 0000 1234                or.b #$34,d0
0002215e 5678 0000                addq.w #$03,$0000.w [0000]
>
;------------------------------------------------------------------------------
>fd
All breakpoints removed.
>fo 0 A0==$10
Breakpoint added.
>g
Breakpoint 0 triggered.
VPOS: 210 ($0d2) HPOS: 148 ($094) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000010   A1 00000000   A2 00000000   A3 00000000							; A0 00000010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002212a 207c 0000 0020           movea.l #$00000020,a0
Next PC: 00022130
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
VPOS: 210 ($0d2) HPOS: 225 ($0e1) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000010   A1 00000000   A2 00000000   A3 00000000							; A0 00000010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002212a 207c 0000 0020           movea.l #$00000020,a0
Next PC: 00022130
>
;------------------------------------------------------------------------------
>fd
All breakpoints removed.

;------------------------------------------------------------------------------
; Test 2: if reg.l != value1.l --> (fo 0 A0!=$0) -> works fine
;------------------------------------------------------------------------------
>fo 0 A0!=$0
Breakpoint added.
;------------------------------------------------------------------------------
>d pc
00022130 207c 0002 1100           movea.l #$00021100,a0
00022136 207c 0000 0100           movea.l #$00000100,a0
0002213c 207c 0000 0200           movea.l #$00000200,a0
00022142 207c 0002 2000           movea.l #$00022000,a0
00022148 207c 0000 1000           movea.l #$00001000,a0
0002214e 207c 0000 2000           movea.l #$00002000,a0
00022154 6000 ffb6                bra.w #$ffb6 == $0002210c (T)
00022158 4e75                     rts  == $00c4f748
;------------------------------------------------------------------------------
>g
...
>g
Breakpoint 0 triggered.
VPOS: 211 ($0d3) HPOS: 045 ($02d) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00002000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002210c 207c 0000 0000           movea.l #$00000000,a0
Next PC: 00022112
;------------------------------------------------------------------------------
>g
Breakpoint 0 triggered.
VPOS: 211 ($0d3) HPOS: 057 ($039) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000001   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022118 207c 0000 0002           movea.l #$00000002,a0
Next PC: 0002211e
;------------------------------------------------------------------------------
>fd
All breakpoints removed.

;------------------------------------------------------------------------------
; Test 3: if reg.l >= value1.l --> (fo 4 A0>=$21000) -> works fine
;------------------------------------------------------------------------------
>fo 4 A0>=$21000
Breakpoint added.
>g
Breakpoint 4 triggered.
VPOS: 211 ($0d3) HPOS: 069 ($045) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021010   A1 00000000   A2 00000000   A3 00000000							; A0 00021010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022124 207c 0000 0010           movea.l #$00000010,a0
Next PC: 0002212a
;------------------------------------------------------------------------------
>g
Breakpoint 4 triggered.
VPOS: 211 ($0d3) HPOS: 087 ($057) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021100   A1 00000000   A2 00000000   A3 00000000							; A0 00021100
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022136 207c 0000 0100           movea.l #$00000100,a0
Next PC: 0002213c
;------------------------------------------------------------------------------
>g
Breakpoint 4 triggered.
VPOS: 211 ($0d3) HPOS: 105 ($069) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00022000   A1 00000000   A2 00000000   A3 00000000							; A0 00022000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022148 207c 0000 1000           movea.l #$00001000,a0
Next PC: 0002214e
>
;------------------------------------------------------------------------------
>fd
All breakpoints removed.

;------------------------------------------------------------------------------
; Test 4: in-range -> fo 1 A0 - $21000 $FFFFFFFF $22000
; if reg.l >= value1.l &&  reg.l <= value2.l -> works fine
;------------------------------------------------------------------------------
>fo 1 A0 - $21000 $FFFFFFFF $22000
Breakpoint added.
>fl
1: A0 < 00021000 [ffffffff 00022000]
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 211 ($0d3) HPOS: 164 ($0a4) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021100   A1 00000000   A2 00000000   A3 00000000							; A0 00021100
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022136 207c 0000 0100           movea.l #$00000100,a0
Next PC: 0002213c
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 211 ($0d3) HPOS: 182 ($0b6) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00022000   A1 00000000   A2 00000000   A3 00000000							; A0 00022000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022148 207c 0000 1000           movea.l #$00001000,a0
Next PC: 0002214e
>g
;------------------------------------------------------------------------------
Breakpoint 1 triggered.
VPOS: 211 ($0d3) HPOS: 223 ($0df) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021010   A1 00000000   A2 00000000   A3 00000000							; A0 00021010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022124 207c 0000 0010           movea.l #$00000010,a0
Next PC: 0002212a
;------------------------------------------------------------------------------
>fd
All breakpoints removed.

;------------------------------------------------------------------------------
; Test 5: not in-range -> fo 1 A0 !- $21000 $FFFFFFFF $22000
; if reg.l <= value1.l &&  reg.l >= value2.l -> works fine
;------------------------------------------------------------------------------
>fo 1 A0 !- $21000 $FFFFFFFF $22000
Breakpoint added.
>fl
1: A0 > 00021000 [ffffffff 00022000]

>g
Breakpoint 1 triggered.
VPOS: 212 ($0d4) HPOS: 002 ($002) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000010   A1 00000000   A2 00000000   A3 00000000							; A0 00000010
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002212a 207c 0000 0020           movea.l #$00000020,a0
Next PC: 00022130
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 212 ($0d4) HPOS: 008 ($008) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000020   A1 00000000   A2 00000000   A3 00000000							; A0 00000020 
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0002 (OR) Chip latch 00000000
00022130 207c 0002 1100           movea.l #$00021100,a0
Next PC: 00022136
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 212 ($0d4) HPOS: 020 ($014) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000100   A1 00000000   A2 00000000   A3 00000000							; A0 00000100	
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002213c 207c 0000 0200           movea.l #$00000200,a0
Next PC: 00022142
;------------------------------------------------------------------------------
>fd
All breakpoints removed.

;------------------------------------------------------------------------------
; Test 6: with bitmask
; if reg.l == value1.l --> (fo 1 A0==$21010 $FF) -> works fine
;------------------------------------------------------------------------------
>fo 1 A0==$21010 $FF
Breakpoint added.
>fl
1: A0 == 00021010 [000000ff 00022000]											; 22000 is ignored here
;------------------------------------------------------------------------------
>fo 1 A0==$21010 $FF $0
Breakpoint added.
>fl
1: A0 == 00021010 [000000ff 00000000]											; better
;------------------------------------------------------------------------------
>g
Breakpoint 1 triggered.
VPOS: 212 ($0d4) HPOS: 073 ($049) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021010   A1 00000000   A2 00000000   A3 00000000							; A0 xxxxxx10
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022124 207c 0000 0010           movea.l #$00000010,a0
Next PC: 0002212a
>g
;------------------------------------------------------------------------------
Breakpoint 1 triggered.
VPOS: 212 ($0d4) HPOS: 079 ($04f) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000010   A1 00000000   A2 00000000   A3 00000000							; A0 xxxxxx10
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002212a 207c 0000 0020           movea.l #$00000020,a0
Next PC: 00022130
>g
;------------------------------------------------------------------------------
Breakpoint 1 triggered.
VPOS: 212 ($0d4) HPOS: 150 ($096) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021010   A1 00000000   A2 00000000   A3 00000000							; A0 xxxxxx10
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
00022124 207c 0000 0010           movea.l #$00000010,a0
Next PC: 0002212a
>fd
All breakpoints removed.

;------------------------------------------------------------------------------
; Test 7: with N
; if reg.l == value1.l --> (fo 1 A0==$21000 N5) -> works fine
;------------------------------------------------------------------------------

>fo 1 A0==$21000 N5
Breakpoint added.
>fl
1: A0 == 00021000 [00000000 00000000] N=5										; it deletes the mask ?
																				; no the mask $FF is always working
>g
Breakpoint 1 hit: PC=00022130, count=5.
Breakpoint 1 hit: PC=00022136, count=4.
Breakpoint 1 hit: PC=0002213c, count=3.
Breakpoint 1 hit: PC=00022142, count=2.
Breakpoint 1 hit: PC=00022148, count=1.
Breakpoint 1 triggered.															; this are 6 times
VPOS: 213 ($0d5) HPOS: 119 ($077) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00001000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002214e 207c 0000 2000           movea.l #$00002000,a0
Next PC: 00022154
>d 2210c !15
0002210c 207c 0000 0000           movea.l #$00000000,a0
00022112 207c 0000 0001           movea.l #$00000001,a0
00022118 207c 0000 0002           movea.l #$00000002,a0
0002211e 207c 0002 1010           movea.l #$00021010,a0
00022124 207c 0000 0010           movea.l #$00000010,a0
0002212a 207c 0000 0020           movea.l #$00000020,a0
00022130 207c 0002 1100           movea.l #$00021100,a0							; 22130
00022136 207c 0000 0100           movea.l #$00000100,a0							; 22136	
0002213c 207c 0000 0200           movea.l #$00000200,a0							; 2213c
00022142 207c 0002 2000           movea.l #$00022000,a0							; 22142
00022148 207c 0000 1000           movea.l #$00001000,a0							; 22148
0002214e 207c 0000 2000           movea.l #$00002000,a0							; 2214e
00022154 6000 ffb6                bra.w #$ffb6 == $0002210c (T)
00022158 4e75                     rts  == $00c4f748
;------------------------------------------------------------------------------
>fl
1: A0 == 00021000 [00000000 00000000]
;------------------------------------------------------------------------------
>fo 1 A0==$21000 $ffff $0 N5
Breakpoint added.
>fl
1: A0 == 00021000 [0000ffff 00000000] N=5
;------------------------------------------------------------------------------
>g
Breakpoint 1 hit: PC=0002214e, count=5.											; this works!
Breakpoint 1 hit: PC=0002214e, count=4.
Breakpoint 1 hit: PC=0002214e, count=3.
Breakpoint 1 hit: PC=0002214e, count=2.
Breakpoint 1 hit: PC=0002214e, count=1.
Breakpoint 1 triggered.
VPOS: 215 ($0d7) HPOS: 127 ($07f) COP: $0001ede4
  D0 00000000   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00001000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 207c (MOVEA) 0000 (OR) Chip latch 00000000
0002214e 207c 0000 2000           movea.l #$00002000,a0
Next PC: 00022154
>