
; Listing19c5.s
; debugging an assembler program with a conditional register breakpoint
; start and run from asmone	
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  fo <num> <reg> <oper> <val> [<mask> <val2>] Conditional register breakpoint.
;  reg=Dx,Ax,PC,USP,ISP,VBR,SR. oper:!=,==,<,>,>=,<=,-,!- (-=val to val2 range).
;  fl                    List breakpoints.
;  fd                    Remove all breakpoints.

;------------------------------------------------------------------------------

help text WinUAE 5.3:
;fo <num> <reg> <oper> <val> [<mask> <val2>] Conditional register breakpoint [Nx] [Hx].
;  reg=Dx,Ax,PC,USP,ISP,VBR,SR. oper:!=,==,<,>,>=,<=,-,!- (-=val to val2 range).

;------------------------------------------------------------------------------
; 1. Set and delete a conditional register breakpoint
;------------------------------------------------------------------------------

>fd
All breakpoints removed.
>fo 0 A0!=$21000
Breakpoint added.
>fo 1 A0==$21000
Breakpoint added.
>fo 2 A0<$21000
Breakpoint added.
>fo 3 A0>$21000
Breakpoint added.
>fo 4 A0>=$21000
Breakpoint added.
>fo 5 A0<=$21000
Breakpoint added.
>fo 6 A0-$21000
Breakpoint added.
>fo 7 A0!-$21000
Breakpoint added.
>fl
0: A0 != 00021000 [ffffffff 00000000]	; != ok							; better: 0: A0 != 00021000 [ffffffff]
1: A0 == 00021000 [ffffffff 00000000]	; == ok							; better: 1: A0 == 00021000 [ffffffff]
2: A0 <= 00021000 [ffffffff 00000000]	; <=  not ok choose <			; better: 2: A0 < 00021000 [ffffffff]
3: A0 >= 00021000 [ffffffff 00000000]	; >=  not ok choose >			; better: 3: A0 >= 00021000 [ffffffff]
4: A0 >= 00021000 [ffffffff 00000000]	; >=  ok						; better: 4: A0 >= 00021000 [ffffffff]
5: A0 <= 00021000 [ffffffff 00000000]	; <=  ok						; better: 5: A0 <= 00021000 [ffffffff]
6: A0 < 00021000 [ffffffff 00000000]	; '-' only with value2 of interest	; better: 6: A0 - 00021000 [ffffffff 00000000]		; in-range		"-" :		val1 <= x <= val2		; --> $21000 <= x <= $0  --> not possible 
7: A0 > 00021000 [ffffffff 00000000]	; '!-' only with value2 of interest	; better: 7: A0 !- 00021000 [ffffffff 00000000]		; not-in-range  "!-":	 x <= val1 OR x >= val2		; --> x <= $21000 OR x >= $0  --> would be ok

I interpret:
breakpoint number: register operation value1 [mask (value2)] 

Operation with only one value: oper: !=,==,<,>,>=,<=  
Operation with two values: oper: -,!-

Then [ffffffff 00000000] the mask and value2 better would be:
1: A0 == 00021000 [ffffffff]			; without this 00000000]
7: A0 !- 00021000 [ffffffff 00000000]	; only if oper in-range or not-in-range is set with value2

to delete only one of this breakpoints eg. >fo 4 it is not possible, only all with >fd

;------------------------------------------------------------------------------
; 2. [Nx] [Hx]
;------------------------------------------------------------------------------

Then with the Option N
>fo 1 A0==$21000 N5
Breakpoint added.
>fl
0: A0 != 00021000 [ffffffff 00000000]
1: A0 == 00021000 [00000000 00000000] N=5
2: A0 <= 00021000 [ffffffff 00000000]

but it deletes the mask to zero? No, the masked is always set but here shown as deleted.

>fo 1 A0==$21000 H5
Breakpoint added.
>fl
0: A0 != 00021000 [ffffffff 00000000]
1: A0 == 00021000 [00000000 00000000] H=5

What makes H ?
>fo 1 A0==$21000 N5 H5
Breakpoint added.
>fl
0: A0 != 00021000 [ffffffff 00000000]
1: A0 == 00021000 [00000000 00000000] N=5 H=5

;------------------------------------------------------------------------------
; 3. change the mask
;------------------------------------------------------------------------------

>fo 0 A0==$21000 $0000FFFF
Breakpoint added.
>?-2
$FFFFFFFE = %11111111`11111111`11111111`11111110 = 4294967294 = -2
>fo 1 A0==$21000 -2
Breakpoint added.
>fo 2 A0<$21000 $F
Breakpoint added.
>fo 3 A0>$21000 $FCBA1E00
Breakpoint added.

0: A0 == 00021000 [0000ffff 00000000]
1: A0 == 00020ffe [ffffffff 00000000]
2: A0 <= 00021000 [0000000f 00000000]
3: A0 >= 00021000 [fcba1e00 00000000]

Better would be to interpret the -2 as $FFFFFFFE

;------------------------------------------------------------------------------
; 4. with Value2
;------------------------------------------------------------------------------

; oper: -,!- (-=val to val2 range).

; val2 is used in "range" tests 
; in-range		"-" :		val1 <= x <= val2		 
; not-in-range  "!-":	 x <= val1 OR x >= val2	

; in-range		"-" :		val1 <= x <= val2	
>fo 0 A0-$21000 $FFFFFFFF $22000
Where a breakpoint triggers if any value from $21000 to $22000 comes in A0
but value2 has to be val2>=val1, otherwise it is not possible

; not-in-range  "!-":	 x <= val1 OR x >= val2	
>fo 0 A0!-$21000 $FFFFFFFF $22000
Where a value lower or equal as $21000 or greater or equal then $22000 triggers a break.
  
;------------------------------------------------------------------------------