
; Listing19c3.s
; debugging an assembler program with a programm breakpoint
; start and run from asmone	
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  f <address>           Add/remove breakpoint.
;  fl                    List breakpoints.
;  fd                    Remove all breakpoints.
;  d <address> [<lines>] Disassembly starting at <address>.
;  t [instructions]      Step one or more instructions.
;  a <address>           Assembler.
;------------------------------------------------------------------------------

start:

waitmouse:  
	btst	#6,$bfe001	; left mousebutton?
	bne.s	Waitmouse	

	move.w	#0,d0		; Set i do 0
	
.loop:	
	cmp.w	#31,d0		; is i = 31?
	beq	.done			; yes, take branch
	add.w	#1,d0		; no, add 1 to i
; do something
	bra	.loop			; continue loop

.done:
	nop
	
.exit:  
	moveq	#0,d0
	rts
	end

;------------------------------------------------------------------------------
>r
Filename:Listing19c4.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is waiting for the left mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; step 1 - look current programlines
>d pc
000227bc 66f6                     bne.b #$f6 == $000227b4 (T)
000227be 303c 0000                move.w #$0000,d0								; set a breakpoint on this line
000227c2 0c40 001f                cmp.w #$001f,d0
000227c6 6700 000a                beq.w #$000a == $000227d2 (F)
000227ca 0640 0001                add.w #$0001,d0
000227ce 6000 fff2                bra.w #$fff2 == $000227c2 (T)
000227d2 4e71                     nop
000227d4 7000                     moveq #$00,d0
000227d6 4e75                     rts  == $00c4f6e8
000227d8 1234 5678                move.b (a4,d5.w[*8],$78) == $00000078 (68020+) [00],d1
>f 227be																		; step 2 - set a breakpoint
Breakpoint added.
>x																				; leave the debugger
;------------------------------------------------------------------------------
																				; the program is waiting for the left mouse button		
																				; now click left mousebutton and the Debugger 
																				; reopens and wait on this line
>d pc																			; the actual program
000227be 303c 0000                move.w #$0000,d0
000227c2 0c40 001f                cmp.w #$001f,d0								; now we want change the line cmp.w	#31,d0	; is i = 31?
000227c6 6700 000a                beq.w #$000a == $000227d2 (T)					; in a nop and BEQ.W in BRA
000227ca 0640 0001                add.w #$0001,d0
000227ce 6000 fff2                bra.w #$fff2 == $000227c2 (T)
000227d2 4e71                     nop
000227d4 7000                     moveq #$00,d0
000227d6 4e75                     rts  == $00c4f6e8
000227d8 1234 5678                move.b (a4,d5.w[*8],$78) == $00000078 (68020+) [00],d1
000227dc 0000 0000                or.b #$00,d0
;------------------------------------------------------------------------------	
>a 227c2																		; step 3 - after insert, don't forget to press Enter
000227C2 >nop																	; a cmp.w is 2 words long
000227c2 4e71                     nop											; a nop is one word 
000227C4 >nop																	; therefore we set 2 nop
000227c4 4e71                     nop
000227C6 >bra 227d2																; for the beq.w we set a bra <adress>
000227c6 6000 000a                bra.w #$000a == $000227d2 (T)
000227CA >																		; Enter															
;------------------------------------------------------------------------------	
>d pc																			; watch the result
000227be 303c 0000                move.w #$0000,d0
000227c2 4e71                     nop											; this was cmp.w #$001f,d0
000227c4 4e71                     nop											; this was cmp.w #$001f,d0
000227c6 6000 000a                bra.w #$000a == $000227d2 (T)					; this was beq.w #$000a == $000227d2 (T)	
000227ca 0640 0001                add.w #$0001,d0
000227ce 6000 fff2                bra.w #$fff2 == $000227c2 (T)
000227d2 4e71                     nop
000227d4 7000                     moveq #$00,d0
000227d6 4e75                     rts  == $00c4f6e8
000227d8 1234 5678                move.b (a4,d5.w[*8],$78) == $00000078 (68020+) [00],d1
;------------------------------------------------------------------------------	
>t																				; step 4 - trace (one step)
Cycles: 4 Chip, 8 CPU. (V=210 H=19 -> V=210 H=23)
VPOS: 210 ($0d2) HPOS: 023 ($017) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 4e71 (NOP) Chip latch 00000000
000227c2 4e71                     nop
Next PC: 000227c4
>t																				; step 5 - trace (one step)
Cycles: 2 Chip, 4 CPU. (V=210 H=23 -> V=210 H=25)
VPOS: 210 ($0d2) HPOS: 025 ($019) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 6000 (Bcc) Chip latch 00000000
000227c4 4e71                     nop
Next PC: 000227c6
>t																				; step 6 - trace (one step)
Cycles: 2 Chip, 4 CPU. (V=210 H=25 -> V=210 H=27)
VPOS: 210 ($0d2) HPOS: 027 ($01b) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 6000 (Bcc) 000a (ILLEGAL) Chip latch 00000000
000227c6 6000 000a                bra.w #$000a == $000227d2 (T)
Next PC: 000227ca
>t																				; step 7 - trace (one step)
Cycles: 5 Chip, 10 CPU. (V=210 H=27 -> V=210 H=32)
VPOS: 210 ($0d2) HPOS: 032 ($020) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 7000 (MOVE) Chip latch 00000000
000227d2 4e71                     nop
Next PC: 000227d4
>t																				; step 8 - trace (one step)
Cycles: 2 Chip, 4 CPU. (V=210 H=32 -> V=210 H=34)
VPOS: 210 ($0d2) HPOS: 034 ($022) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 7000 (MOVE) 4e75 (RTS) Chip latch 00000000
000227d4 7000                     moveq #$00,d0
Next PC: 000227d6
>t																				; step 9 - trace (one step)
Cycles: 2 Chip, 4 CPU. (V=210 H=34 -> V=210 H=36)
VPOS: 210 ($0d2) HPOS: 036 ($024) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e75 (RTS) 1234 (MOVE) Chip latch 00000000
000227d6 4e75                     rts  == $00c4f6e8
Next PC: 000227d8
;------------------------------------------------------------------------------	
>fl
0: PC == 000227be [00000000 00000000]
;------------------------------------------------------------------------------	
>fd
All breakpoints removed.
>
>x																				; leave the debugger	

	end

We hacked this little program.