
; Listing19b3.s
; search and find

1. s "<string>"/<values> [<addr>] [<length>]									; better s "<string>"/<values> [<addr>] [<endaddr>]
                        Search for string/bytes.
2. fa <address> [<start>] [<end>]
                        Find effective address <address>.
3. fi <opcode> Step forward until PC points to <opcode>.
4. fi <opcode> [<w2>] [<w3>] Step forward until PC points to <opcode>
5. f                     Step forward until PC in RAM ("boot block finder").
 
;------------------------------------------------------------------------------
s "<string>"/<values> [<addr>] [<length>]										; 1. 'string'
                        Search for string/bytes.								; better s "<string>"/<values> [<addr>] [<endaddr>]

>s "TRASH'M-One"
Searching from 00000000 to 00C80000..
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)
 00C23344 00C2E8CE 00C2E98B 00C2F2CE 00C3929C 00C3FE14 00C3FE22 00C4BFE4 00C4C0A1 00C4C9E4 00C5633A 00C5D078
>m C23344 5
00C23344 5452 4153 4827 4D2D 4F6E 6500 00C6 0F90  TRASH'M-One.....
00C23354 0001 CA80 0000 0000 00C0 7044 0000 0000  ..........pD....
00C23364 FFFF FFFF FFFF FFFF 00FF 605C 00FF 6148  ..........`\..aH
00C23374 00FF 60EC 0000 0000 0000 0000 00C6 0F90  ..`.............
00C23384 0001 CA50 F4CE 60E0 302C 0F34 B06C 0EFA  ...P..`.0,.4.l..
>

;------------------------------------------------------------------------------
>s "TRASH'M-One" C2E800 C3F000													; s "<string>" [<addr>] [<endaddr>]
Searching from 00C2E800 to 00C3F000..
 00C2E8CE 00C2E98B 00C2F2CE 00C3929C
>														

;------------------------------------------------------------------------------
  s "<string>"/<values> [<addr>] [<length>]										; s "<values> [<addr>] [<endaddr>]
                        Search for string/bytes.

																				; from EAB:
																				; This s-command is a basic search for a hex value in memory.
																				; It will search for a certain value but the value needs to be quite unique or
																				; else too many results are returned. The hex-value could be an instruction or
																				; a value.

>m 1000 1
00001000 3F00 033C 3FFF FF3C 0000 0000 0FFF C000  ?..<?..<........

>s 3F00033C
...

>s 3F00033C 2000
Searching from 00002000 to 00C80000..
 00080D98 00081000 00100D98 00101000 00180D98 00181000Scanning.. 00c00000 - 00c80000 (Slow memory)

>s 3F00033C 0 2000
Searching from 00000000 to 00002000..
Scanning.. 00000000 - 00010000 (Chip memory)
 00000D98 00001000 
 
>s 3F 00 2000
Searching from 00000000 to 00002000..
Scanning.. 00000000 - 00010000 (Chip memory)
 00000C81 00000CF1 00000D78 00000D7E 00000D85 00000D89 00000D8D 00000D91 00000D94 00000D95
 00000D98 00000D9C 00000E30 00000E36 00000E3A 00000E4C 00000E50 00000E54 00000F31 00000F35
 00000F41 00000F45 00000FE0 00000FE6 00000FED 00000FF1 00000FF5 00000FF9 00000FFC 00000FFD 00001000 ....

																				; If you found the adress you can replace the value by: 
>W 1000 FFFF																	; Now set this address to hex FFFF (dec 65535):
;------------------------------------------------------------------------------
																				; search for an instruction
>s bfe001
																				; or
>s 0839000600bfe001
Searching from 00000000 to 00C80000..
Scanning.. 00000000 - 00200000 (Chip memory)
00023656 000A3656 00123656 001A3656Scanning.. 00a80000 - 00b00000 (Non-autoconfig RAM #1)
Scanning.. 00b00000 - 00b80000 (Non-autoconfig RAM #2)
Scanning.. 00c00000 - 00c80000 (Slow memory)

																				; or
>s 0839000600bfe001 20000 30000													; with adress range
Searching from 00020000 to 00030000..
00023656
>

																				; then disassemble
>d 23656
00023656 0839 0006 00bf e001	  btst.b #$0006,$00bfe001
0002365e 66de					  bne.b #$de == $0002363e (T)
00023660 23fa 0092 00df f080	  move.l (pc,$0092) == $000236f4 [00000420],$00dff080

																				; and set a breakpoint on address after the mouse routine
>f 23660																		; set program breakpoint after mouse routine
Breakpoint added.
>g																				; run program
																				; press left mouse button
Breakpoint 0 triggered.															; if breakpoint triggered

																				; You can watch the last executed instructions with
>H																				; up to H 500

																				; or list the dissambled memory part from a previous point
>d pc-100 100																	; d <adress> <lines>

;------------------------------------------------------------------------------

fa <address> [<start>] [<end>]       Find effective address <address>.			; 2. 
																				; where a memory address is references in memory

>d 32426
00032426 41f9 0003 99d0           lea.l $000399d0,A0

>fa 32426
Searching from 00000000 to 00C80000
Scanning.. 00000000 - 00200000 (Chip memory)
0003002A 6100 23fa                bsr.w #$23fa == $00032426
Scanning.. 00c00000 - 00c80000 (Slow memory)
>

>d 224c6
000224c6 4eae ff82                jsr (a6,-$007e) == $00c02878
>fa c02878 0 7ffff
Searching from 00000000 to 0007FFFF
Scanning.. 00000000 - 00080000 (Chip memory)
000224c6 4eae ff82                jsr (a6,-$007e) == $00c02878
000226fe 4eae ff82                jsr (a6,-$007e) == $00c02878

;------------------------------------------------------------------------------ 
fi <opcode> Step forward until PC points to <opcode>.							; 3.

																				; fi <opcode> is usually the best method to set a breakpoint for UAE
																				; in your code,	if you select an opcode which appears nowhere else,
																				; like exg a7,a7 = fi cf4f.
																				; This code would also have no effect on your program.

>fi 4e71																		; stopped at the next nop
>fi nop
>fi cf4f																		; stopped at the next exg a7,a7

;------------------------------------------------------------------------------
fi <opcode> [<w2>] [<w3>] Step forward until PC points to <opcode>				; 4.

000227e6 4e71                     nop											; w1
>fi 4e71
>fi nop

000227de 0640 0001                add.w #$0001,d0								; w1 + w2
>fi 0640 0001
>fi add.w #$0001,d0

0002a5a4 0c80 0000 5000           cmp.l #$00005000,d0							; w1 + w2 + w3
>fi 0c80 0000 5000
>fi and.l #$000fff00,d0

fi 
0002a5e0 33fc 0050 00df f058      move.w #$0050,$00dff058						; w1 + w2 + w3
>fi 33fc 0050 00df f058
>fi move.w #$0050,$00dff058

;------------------------------------------------------------------------------
 
f                     Step forward until PC in RAM ("boot block finder").		; 5.

																				; load configuration that shows the hand with the disk (disc ejected)

Shift+F12, >f																	; open debugger and enable "boot block finder"
>x																				; close debugger
F12																				; open GUI
DF0																				; insert disk and press Start-Button

																				; the boot block finder (breakpoint) opens the debugger

>d pc
00001564 48e7 fffe                MOVEM.L D0-D7/A0-A6,-(A7)						; first RAM-adress	
00001568 2c78 0004                MOVEA.L $0004 [00c00276],A6

																				; also look history data (from ROM to first RAM-adress)
>H 5
 0 00FE85BE 4680                     NOT.L D0
 0 00FE85C0 663e                     BNE.B #$3e == $00fe8600 (F)
 0 00FE85C2 43ed 002c                LEA.L (A5,$002c) == $00c014e2,A1
 0 00FE85C6 4eac 000c                JSR (A4,$000c) == $00001564				; last ROM-adress
 0 00001564 48e7 fffe                MOVEM.L D0-D7/A0-A6,-(A7)					; first RAM-adress		
>

																				; also Reset is possible

																				The f-command is usefull to found the first RAM-adress (eg. boot block)
																				If you want analyze the bootcode (bootloader) you can use this command.

																				After a reset the Amiga is waiting in the ROM. If you now insert a disk, the
																				bootprocess is starting. The f-command stops at the first RAM adress. "until PC
																				in RAM". Now you can trace the bootcode step by step to analyze or modify the
																				code. The f-command is a breakpoint command so you can also look with H the
																				previous instructions. 
;------------------------------------------------------------------------------
>reset																			The reset command is also interesting in this context.
>resetk ; reset keyboard														after a reset it boots again 						
>reseth ; reset hardware