
; Listing19b1.s
; only output information

1.   c                     Dump state of the CIA, disk drives and custom registers.
2.   r                     Dump state of the CPU.	 
3.   m <address> [<lines>] Memory dump starting at <address>.
4.   m r[b/w/l](address/r(register)) [<lines>]	Memory dump indirect

5.   e	                   Dump contents of all custom registers, ea = AGA colors.
6.	 ea					   AGA colors
7.   ex					   Dump contents of all custom registers, extended
8.   i			           Dump contents of interrupt and trap vectors.
9.   dm                    Dump current address space map.
10.  mg <address>          Memory dump starting at <address> in GUI.
11.  dg <address>          Disassembly starting at <address> in GUI.
12.  dppc/do				switch disassembly output from 68k to PPC and backwards
13.  d <address> [<lines>]  Disassembly starting at <address>.
14.  d r[b/w/l](address/r(register)) [<lines>]
15.	 o <0-2|addr> [<lines>] View memory as Copper instructions.
16.  T or Tt                Show exec tasks and their PCs.
	 Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
							residents, interrupts, doslist, memorylist, fsres.
17.  rc[d]                 Show CPU instruction or data cache contents.			; A1200 CPU mit Cache
18.	 seg

;------------------------------------------------------------------------------																								
c		Dump state of the CIA, disk drives and custom registers.				; 1.

>c
A: CRA 00 CRB 08 ICR 00 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00
   TOD 0000c0 (0000c0) ALARM 000000 -- CYC=0000000286E1E00C
B: CRA 00 CRB 80 ICR 00 IM 04 TA ffff (ffff) TB ffff (ffff)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 0000d2 (000000) ALARM 000000 --
DEBUG: drive 0 motor off cylinder  0 sel no ro mfmpos 0/101344
side 0 dma 0 off 15 word 0000 pt 00000000 len 4000 bytr 8000 adk 1100 sync 0000
DMACON: $03f0 INTENA: $602c ($602c) INTREQ: $1040 ($1040) VPOS: 210 ($0d2) HPOS: 007 ($007)
INT: $0000 IPL: 0
COP1LC: $00000420, COP2LC: $00010508 COPPTR: $0001059c
DIWSTRT: $0581 DIWSTOP: $40c1 DDFSTRT: $003c DDFSTOP: $00d0
BPLCON 0: $a200 1: $0000 2: $0024 3: $0c00 4: $0011 LOF=1/1 HDIW=1 VDIW=1
Average frame time: 12289918.55 ms [frames: 298 time: 939025239]

																				; info
																				; 0: $xxxx = BPLCON0 ; misc, control bits
																				; 1: $xxxx = BPLCON1 ; horizontal, scroll counter
																				; 2: $xxxx = BPLCON2 ; priority
																				; 3: $xxxx = BPLCON3 ; enhanced bits
																				; 4: $xxxx = BPLCON4 ; display mask

																				; LOF=X/Y:
																				; (You can change the LOF bit in Agnus many times during the frame, but the 
																				; signals used to define the frame are unique in VSYNC) 
																				; HDIW=0/1 HDIW open or not
																				; VDIW=0/1 VDIW open or not

;##############################################################################

;------------------------------------------------------------------------------
r		 Dump state of the CPU.													; 2.

>r																				; A500
VPOS: 105 ($069) HPOS: 003 ($003) COP: $0006a570
  D0 2C01FFFE   D1 01402C40   D2 01423900   D3 00000000
  D4 0006A5D8   D5 00000000   D6 00000000   D7 00000000
  A0 FFFFFFFE   A1 0006A53C   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C028F6   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0010 T=00 S=0 M=0 X=1 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0839 (BTST) 0002 (OR) Chip latch 00000000
000226c4 0839 0002 00df f016      btst.b #$0002,$00dff016
Next PC: 000226cc
>

																				; D0-D6,A0-A7		Data- and Adressregister
																				; USP=A7			User-Stackpointer
																				; ISP				Supervisor and Interrupt Stackpointer
																				; SR=0010			Statusregister
																				; T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 - Condition Code-Flags
																				; IM				Interrupt-Mask shows current Interrupt
																				; STP				STOP = CPU is in stopped state (STOP instruction)
																				; Prefetch
																				; Chip latch:		Chip latch = last chipset bus accessed value.
																				;					It is generally zero in non-cycle-exact mode.
																				; current instruction
																				; Next PC			NEXT Program counter address

																				; to get the STP=1 state
																				; (every interrupt wakes CPU up from stop state)																				 

																				;		lea     .l(pc),a0
																				;		move.l  a0,$20.w 	; privilege violation handler
																				;.l:
																				;		stop    #$2000
																				;		nop

;------------------------------------------------------------------------------
>r																				; A1200
VPOS: 105 ($069) HPOS: 005 ($005) COP: $00011ec4
  D0 A3006905   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00000000   A1 00000000   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C7C308
USP  00C7C308 ISP  00C7D30A SFC  00000000 DFC  00000000
CACR 00000001 VBR  00000000 CAAR 00000000 MSP  00000000
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 00022afc 0c800001 (1) 000f (ILLEGAL) ff00 (ILLEGAL) 0c80 (CMP) Chip latch 00006905
00022af6 0280 000f ff00           and.l #$000fff00,d0
Next PC: 00022afc
;------------------------------------------------------------------------------
>r
Cycles: 1869636 Chip, 3739273 CPU. (V=210 H=4 -> V=2 H=0)						; A4000
VPOS: 002 ($002) HPOS: 003 ($003) COP: $000010bc
  D0 00000F00   D1 000CF0FF   D2 08028E56   D3 00000000
  D4 080032BA   D5 0000A588   D6 FFFFFFFF   D7 00000000
  A0 080008A0   A1 00F8DBDE   A2 08009D48   A3 000016C2
  A4 08003288   A5 00F8D9D4   A6 08004B0C   A7 080022DC
USP  08003288 ISP  080022DC SFC  00000000 DFC  00000000
CACR 00008000 TC   00000318 ITT0 00FFC000 ITT1 00FFC000
DTT0 0000C040 DTT1 00FFC000 BUSC 00000000 VBR  00000000
URP  00000000 SRP  00000000 PCR  04300602
SR=2319 T=00 S=1 M=0 X=1 N=1 Z=0 V=0 C=1 IM=3 STP=0
0: 7FFF-7FFFFFFF-FFFFF800 +nan 7FFF-7FFFFFFF-FFFFF800 +nan
2: 7FFF-7FFFFFFF-FFFFF800 +nan 7FFF-7FFFFFFF-FFFFF800 +nan
4: 7FFF-7FFFFFFF-FFFFF800 +nan 7FFF-7FFFFFFF-FFFFF800 +nan
6: 7FFF-7FFFFFFF-FFFFF800 +nan 7FFF-7FFFFFFF-FFFFF800 +nan
FPSR: 00000000 FPCR: 00000000 FPIAR: 00f80c9c N=0 Z=0 I=0 NAN=0
00ffebc8 33fc c000 00df f09a      move.w #$c000,$00dff09a
Next PC: 00ffebd0
>
;------------------------------------------------------------------------------
m <address> [<lines>]	Memory dump starting at <address>.						; 3.

>m 420
00000420 0180 005A 00E2 0000 0120 0000 0122 0C80  ...Z..... ..."..
00000430 0124 0000 0126 0478 0128 0000 012A 0478  .$...&.x.(...*.x
00000440 012C 0000 012E 0478 0130 0000 0132 0478  .,.....x.0...2.x
00000450 0134 0000 0136 0478 0138 0000 013A 0478  .4...6.x.8...:.x
00000460 013C 0000 013E 0478 0C01 FFFE 008A 0000  .<...>.x........
00000470 FFFE FFFF FFFF FFFE FE00 FF00 0000 0000  ................
00000480 0000 0000 0007 FB80 0000 0000 0000 0000  ................
00000490 0000 0000 0000 0000 0000 0000 0000 0000  ................

>m 420 1
00000420 0180 005A 00E2 0000 0120 0000 0122 0C80  ...Z..... ..."..

>m 420 2
00000420 0180 005A 00E2 0000 0120 0000 0122 0C80  ...Z..... ..."..
00000430 0124 0000 0126 0478 0128 0000 012A 0478  .$...&.x.(...*.x

>m 1000+8 2
00001008 0000 0000 0FFF C000 0F00 0000 0F00 0000  ................
00001018 0F00 0000 0F00 0000 0F00 0000 0000 0000  ................

>m																				; with every m the next addresses are output from here on

>m dff002 3																		; custom chip registers
00DFF002 **** **** **** ****Custom chipset* ****  ****************				; ?
00DFF012 **** **** **** ****Custom chipset* ****  ****************
00DFF022 **** **** **** ****Custom chipset* ****  ****************

>m bfe000 3																		
00BFE000 **** **** **** ****CIA** **** **** ****  ****************				; ?
00BFE010 **** **** **** ****CIA** **** **** ****  ****************
00BFE020 **** **** **** ****CIA** **** **** ****  ****************

>m bfd000 3
00BFD000 **** **** **** ****CIA** **** **** ****  ****************				; ?
00BFD010 **** **** **** ****CIA** **** **** ****  ****************
00BFD020 **** **** **** ****CIA** **** **** ****  ****************

>m fc0000 3																		; 256KB Kickstart ROM
00FC0000 1111 4EF9 00FC 00D2 0000 FFFF 0022 0005  ..N.........."..
00FC0010 0022 0002 FFFF FFFF 6578 6563 2033 342E  ."......exec 34.
00FC0020 3220 2832 3820 4F63 7420 3139 3837 290D  2 (28 Oct 1987).

;------------------------------------------------------------------------------
m r[b/w/l](addr/r(register)) [<lines>]											; 4.

>m 8 1
00000008 00FC 0818 00FC 081A 00FC 081C 00FC 081E  ................
>m rb(8) 1																		; rb maybe never needed? 
00000000 0000 0000 0000 15FE 00FC 0818 00FC 081A  ................
>m rw(8) 1																		; rw maybe never needed? 
000000FC 0000 0000 0000 907A 0000 90AE 0000 0000  .......z........
>m rl(8) 1																		; rl this is needed
00FC0818 615C 615A 616E 616C 616A 6168 6166 6164  a\aZanalajahafad
>m rl(8)+2 1
00FC081A 615A 616E 616C 616A 6168 6166 6164 6162  aZanalajahafadab


 A4 00000000   A5 00C11FCC   A6 00C00B1C   A7 00C0258C
>m 00C00B1C 1
00C00B1C 00C2 0A30 00C0 00C4 099C 00F8 008F 0400  ...0............
>m rl(ra6) 1
00C20A30 00C0 0C9A 00C0 0B1C 099C 00C1 C8C6 0400  ................
>
																				; from EAB:
																				; - Added debugger calculator rl()/rw()/rb() functions that read value from address, 
																				; for example "m rl(rl(4)+10)" returns address to exec base name.

;------------------------------------------------------------------------------
e[x]		Dump contents of all custom registers								; 5. "e" dumps custom registers
																				; this shows the actual values from current reasterposition	
; better e[a/x]                Dump contents of all custom registers, ea = AGA colors.
>e
002 DMACONR	03F0	102 BPLCON1	0000
004 VPOSR	8000	104 BPLCON2	0024
006 VHPOSR	001F	106 BPLCON3	0C00
00A JOY0DAT	2E15	108 BPL1MOD	0000
00C JOT1DAT	0000	10A BPL2MOD	0000
00E CLXDAT	8022	10C BPLCON4	0011
010 ADKCONR	1100	10E CLXCON2	0000
012 POT0DAT	0000	110 BPL1DAT	0000
014 POT1DAT	0000	112 BPL2DAT	0000
016 POTGOR	0000	114 BPL3DAT	0000
018 SERDATR	0000	116 BPL4DAT	0000
01A DSKBYTR	0000	118 BPL5DAT	0000
01C INTENAR	602C	11A BPL6DAT	0000
01E INTREQR	0060	11C BPL7DAT	0000
020 DSKPTH	0000	11E BPL8DAT	0000
022 DSKPTL	0000	120 SPR0PTH	0000
024 DSKLEN	4000	122 SPR0PTL	0CC8
02A VPOSW	8001	124 SPR1PTH	0000
02C VHPOSW	0000	126 SPR1PTL	0484
02E COPCON	0000	128 SPR2PTH	0000
030 SERDAT	0000	12A SPR2PTL	0484
032 SERPER	0174	12C SPR3PTH	0000
034 POTGO	0F00	12E SPR3PTL	0484
036 JOYTEST	0000	130 SPR4PTH	0000
038 STREQU	0000	132 SPR4PTL	0484
03A STRVBL	0000	134 SPR5PTH	0000
03C STRHOR	0000	136 SPR5PTL	0484
03E STRLONG	0000	138 SPR6PTH	0000
040 BLTCON0	07CA	13A SPR6PTL	0484
042 BLTCON1	3000	13C SPR7PTH	0000
044 BLTAFWM	1FFF	13E SPR7PTL	0484
046 BLTALWM	FFFF	140 SPR0POS	0000
048 BLTCPTH	0000	142 SPR0CTL	0000
04A BLTCPTL	FFAC	144 SPR0DATA	0000
04C BLTBPTH	0000	146 SPR0DATB	0000
04E BLTBPTL	1004	148 SPR1POS	0000
050 BLTAPTH	00C1	14A SPR1CTL	0000
052 BLTAPTL	7194	14C SPR1DATA	0000
054 BPTDPTH	0000	14E SPR1DATB	0000
056 BLTDPTL	FFAC	150 SPR2POS	0000
058 BLTSIZE	0000	152 SPR2CTL	0000
05A BLTCON0L	0000	154 SPR2DATA	0000
05C BLTSIZV	000A	156 SPR2DATB	0000
05E BLTSIZH	0002	158 SPR3POS	0000
060 BLTCMOD	FFAC	15A SPR3CTL	0000
062 BLTBMOD	FFF8	15C SPR3DATA	0000
064 BLTAMOD	0000	15E SPR3DATB	0000
066 BLTDMOD	FFAC	160 SPR4POS	0000
070 BLTCDAT	0000	162 SPR4CTL	0000
072 BLTBDAT	0000	164 SPR4DATA	0000
074 BLTADAT	FFFF	166 SPR4DATB	0000
076 BLTDDAT	0000	168 SPR5POS	0000
07C LISAID	FFFF	16A SPR5CTL	0000
07E DSKSYNC	0000	16C SPR5DATA	0000
080 COP1LCH	0000	16E SPR5DATB	0000
082 COP1LCL	0420	170 SPR6POS	0000
084 COP2LCH	0001	172 SPR6CTL	0000
086 COP2LCL	4FB0	174 SPR6DATA	0000
088 COPJMP1	0000	176 SPR6DATB	0000
08A COPJMP2	0000	178 SPR7POS	0000
08E DIWSTRT	0581	17A SPR7CTL	0000
090 DIWSTOP	40C1	17C SPR7DATA	0000
092 DDFSTRT	003C	17E SPR7DATB	0000
094 DDFSTOP	00D0	180 COLOR00	005A
096 DMACON	03F0	182 COLOR01	0FFF
098 CLXCON	0000	184 COLOR02	0002
09A INTENA	602C	186 COLOR03	0F80
09C INTREQ	0060	188 COLOR04	0000
09E ADKCON	1100	18A COLOR05	0000
0A0 AUD0LCH	0000	18C COLOR06	0000
0A2 AUD0LCL	0000	18E COLOR07	0000
0A4 AUD0LEN	0000	190 COLOR08	0000
0A6 AUD0PER	0004	192 COLOR09	0000
0A8 AUD0VOL	0000	194 COLOR10	0000
0AA AUD0DAT	0000	196 COLOR11	0000
0B0 AUD1LCH	0000	198 COLOR12	0000
0B2 AUD1LCL	0000	19A COLOR13	0000
0B4 AUD1LEN	0000	19C COLOR14	0000
0B6 AUD1PER	0004	19E COLOR15	0000
0B8 AUD1VOL	0000	1A0 COLOR16	0000
0BA AUD1DAT	0000	1A2 COLOR17	0D22
0C0 AUD2LCH	0000	1A4 COLOR18	0000
0C2 AUD2LCL	0000	1A6 COLOR19	0ABC
0C4 AUD2LEN	0000	1A8 COLOR20	0444
0C6 AUD2PER	0004	1AA COLOR21	0555
0C8 AUD2VOL	0000	1AC COLOR22	0666
0CA AUD2DAT	0000	1AE COLOR23	0777
0D0 AUD3LCH	0000	1B0 COLOR24	0888
0D2 AUD3LCL	0000	1B2 COLOR25	0999
0D4 AUD3LEN	0000	1B4 COLOR26	0AAA
0D6 AUD3PER	0004	1B6 COLOR27	0BBB
0D8 AUD3VOL	0000	1B8 COLOR28	0CCC
0DA AUD3DAT	0000	1BA COLOR29	0DDD
0E0 BPL1PTH	0000	1BC COLOR30	0EEE
0E2 BPL1PTL	FFB0	1BE COLOR31	0FFF
0E4 BPL2PTH	0001	1C0 HTOTAL	00E3
0E6 BPL2PTL	4FB0	1C2 HSSTOP	0000
0E8 BPL3PTH	0000	1C4 HBSTRT	0000
0EA BPL3PTL	0000	1C6 HBSTOP	0000
0EC BPL4PTH	0000	1C8 VTOTAL	0138
0EE BPL4PTL	0000	1CA VSSTOP	0000
0F0 BPL5PTH	0000	1CC VBSTRT	0000
0F2 BPL5PTL	0000	1CE VBSTOP	0000
0F4 BPL6PTH	0000	1DC BEAMCON0	0020
0F6 BPL6PTL	0000	1DE HSSTRT	0000
0F8 BPL7PTH	0000	1E0 VSSTRT	0000
0FA BPL7PTL	0000	1E2 HCENTER	0000
0FC BPL8PTH	0000	1E4 DIWHIGH	0000
0FE BPL8PTL	0000	1FC FMODE	0000
100 BPLCON0	0200	1FE NO-OP(NULL)	0180

;------------------------------------------------------------------------------
e[x]		Dump contents of all custom registers								; 6 "ex" dumps custom registers

>ex
000 BLTDDAT     0000    0000 00000000 CPU       108 BPL1MOD     FFF8    FFF8 00068754 COP
002 DMACONR     03A0    0000 00000000 CPU       10A BPL2MOD     FFF8    FFF8 00068758 COP
004 VPOSR       A300    0000 00000000 CPU       10C BPLCON4     0011    0011 00022D2E CPU
006 VHPOSR      0A03    0000 00000000 CPU       10E CLXCON2     0000    0000 00000000 CPU
00A JOY0DAT     323B    0000 00000000 CPU       110 BPL1DAT     4CB8    0000 00000000 CPU
00C JOY1DAT     0000    0000 00000000 CPU       112 BPL2DAT     0000    0000 00000000 CPU
00E CLXDAT      8022    0000 00000000 CPU       114 BPL3DAT     0000    0000 00000000 CPU
010 ADKCONR     1100    0000 00000000 CPU       116 BPL4DAT     0000    0000 00000000 CPU
012 POT0DAT     8500    0000 00000000 CPU       118 BPL5DAT     0000    0000 00000000 CPU
014 POT1DAT     0000    0000 00000000 CPU       11A BPL6DAT     0000    0000 00000000 CPU
016 POTGOR      0000    0000 00000000 CPU       11C BPL7DAT     0000    0000 00000000 CPU
018 SERDATR     0000    0000 00000000 CPU       11E BPL8DAT     0000    0000 00000000 CPU
01A DSKBYTR     8000    0000 00000000 CPU       120 SPR0PTH     0006    0006 000686FC COP
01C INTENAR     0000    0000 00000000 CPU       122 SPR0PTL     87E8    87E8 00068700 COP
01E INTREQR     0028    0000 00000000 CPU       124 SPR1PTH     0006    0006 00068704 COP
020 DSKPTH      0000    0000 00000000 CPU       126 SPR1PTL     87D8    87D8 00068708 COP
022 DSKPTL      0000    0000 00000000 CPU       128 SPR2PTH     0006    0006 0006870C COP
024 DSKLEN      4000    0000 00000000 CPU       12A SPR2PTL     87D8    87D8 00068710 COP
02A VPOSW       8001    A300 00F8BA38 CPU       12C SPR3PTH     0006    0006 00068714 COP
02C VHPOSW      0000    0000 00000000 CPU       12E SPR3PTL     87D8    87D8 00068718 COP
02E COPCON      0000    0000 00000000 CPU       130 SPR4PTH     0006    0006 0006871C COP
030 SERDAT      0000    0000 00000000 CPU       132 SPR4PTL     87D8    87D8 00068720 COP
032 SERPER      0174    0000 00000000 CPU       134 SPR5PTH     0006    0006 00068724 COP
034 POTGO       0F00    0F00 00FC0122 CPU       136 SPR5PTL     87D8    87D8 00068728 COP
036 JOYTEST     0000    0000 00000000 CPU       138 SPR6PTH     0006    0006 0006872C COP
038 STREQU      0000    0000 00000000 CPU       13A SPR6PTL     87D8    87D8 00068730 COP
03A STRVBL      0000    0000 00000000 CPU       13C SPR7PTH     0006    0006 00068734 COP
03C STRHOR      0000    0000 00000000 CPU       13E SPR7PTL     87D8    87D8 00068738 COP
03E STRLONG     0000    0000 00000000 CPU       140 SPR0POS     0000    0000 000004A4 COP
040 BLTCON0     0100    0100 00C670C4 CPU       142 SPR0CTL     0000    0000 00000000 CPU
042 BLTCON1     0000    0000 00C670C4 CPU       144 SPR0DATA    0000    0000 00022B64 CPU
044 BLTAFWM     FFFF    FFFF 00C6709E CPU       146 SPR0DATB    FFFF    0000 00022B64 CPU
046 BLTALWM     FFFF    FFFF 00C6709E CPU       148 SPR1POS     0000    0000 000004A8 COP
048 BLTCPTH     0001    0001 00F9B94E CPU       14A SPR1CTL     0000    0000 00000000 CPU
04A BLTCPTL     8014    8384 00F9B94E CPU       14C SPR1DATA    0000    0000 00000000 CPU
04C BLTBPTH     0001    0001 00F9B948 CPU       14E SPR1DATB    0000    0000 00000000 CPU
04E BLTBPTL     1D7C    1DA8 00F9B948 CPU       150 SPR2POS     0000    0000 000004AC COP
050 BLTAPTH     0001    0001 00C670B4 CPU       152 SPR2CTL     0000    0000 00000000 CPU
052 BLTAPTL     7E88    3608 00C670B4 CPU       154 SPR2DATA    0000    0000 00000000 CPU
054 BLTDPTH     0001    0001 00C670D6 CPU       156 SPR2DATB    0000    0000 00000000 CPU
056 BLTDPTL     7E88    7C08 00C670D6 CPU       158 SPR3POS     0000    0000 000004B0 COP
058 BLTSIZE     0228    0228 00C670DE CPU       15A SPR3CTL     0000    0000 00000000 CPU
05A BLTCON0L    0000    000A 00F9BEDA CPU       15C SPR3DATA    0000    0000 00000000 CPU
05C BLTSIZV     0008    000B 00F9B8C4 CPU       15E SPR3DATB    0000    0000 00000000 CPU
05E BLTSIZH     0028    0002 00F9B956 CPU       160 SPR4POS     0000    0000 000004B4 COP
060 BLTCMOD     FFAC    FFAC 00F9BBFA CPU       162 SPR4CTL     0000    0000 00000000 CPU
062 BLTBMOD     FFF8    FFF8 00F9BBEE CPU       164 SPR4DATA    0000    0000 00000000 CPU
064 BLTAMOD     0000    0000 00C670B8 CPU       166 SPR4DATB    0000    0000 00000000 CPU
066 BLTDMOD     0000    0000 00C670DA CPU       168 SPR5POS     0000    0000 000004B8 COP
070 BLTCDAT     0000    0000 00000000 CPU       16A SPR5CTL     0000    0000 00000000 CPU
072 BLTBDAT     0000    FFFF 00F8787E CPU       16C SPR5DATA    0000    0000 00000000 CPU
074 BLTADAT     0000    FFFF 00F9BC90 CPU       16E SPR5DATB    0000    0000 00000000 CPU
07C LISAID      00F8    0000 00000000 CPU       170 SPR6POS     0000    0000 000004BC COP
07E DSKSYNC     0000    0000 00000000 CPU       172 SPR6CTL     0000    0000 00000000 CPU
080 COP1LCH     0006    0006 00022D16 CPU       174 SPR6DATA    0000    0000 00000000 CPU
082 COP1LCL     86F8    86F8 00022D16 CPU       176 SPR6DATB    0000    0000 00000000 CPU
084 COP2LCH     0000    0000 00F8F79A CPU       178 SPR7POS     0000    0000 000004C0 COP
086 COP2LCL     050C    050C 00F8F79A CPU       17A SPR7CTL     0000    0000 00000000 CPU
088 COPJMP1     0000    0006 00022D1E CPU       17C SPR7DATA    0000    0000 00000000 CPU
08A COPJMP2     0000    0000 00000000 CPU       17E SPR7DATB    0000    0000 00000000 CPU
08C COPINS      0000    0000 00000000 CPU       180 COLOR00     0000    0000 000687C0 COP
08E DIWSTRT     2C81    2C81 0006873C COP       182 COLOR01     0123    0000 000687C4 COP
090 DIWSTOP     2CC1    2CC1 00068740 COP       184 COLOR02     0FFF    0FFF 0000FA00 COP
092 DDFSTRT     0038    0038 00068744 COP       186 COLOR03     068B    068B 0000FA04 COP
094 DDFSTOP     00D0    00D0 00068748 COP       188 COLOR04     0FFE    0000 00000000 CPU
096 DMACON      03A0    83A0 00022D10 CPU       18A COLOR05     0BB9    0000 00000000 CPU
098 CLXCON      0000    0000 00000000 CPU       18C COLOR06     0DE7    0000 00000000 CPU
09A INTENA      0000    7FFF 00022B4E CPU       18E COLOR07     0E7D    0000 00000000 CPU
09C INTREQ      0028    7FFF 00022B4E CPU       190 COLOR08     07FF    0000 00000000 CPU
09E ADKCON      1100    9100 00FC61F8 CPU       192 COLOR09     0DED    0000 00000000 CPU
0A0 AUD0LCH     0000    0000 00000000 CPU       194 COLOR10     0DF9    0000 00000000 CPU
0A2 AUD0LCL     0000    0000 00000000 CPU       196 COLOR11     0BDC    0000 00000000 CPU
0A4 AUD0LEN     0000    0000 00000000 CPU       198 COLOR12     0BF4    0000 00000000 CPU
0A6 AUD0PER     0000    0000 00000000 CPU       19A COLOR13     0FF4    0000 00000000 CPU
0A8 AUD0VOL     0000    0000 00000000 CPU       19C COLOR14     0E77    0000 00000000 CPU
0AA AUD0DAT     0000    0000 00000000 CPU       19E COLOR15     0E77    0000 00000000 CPU
0B0 AUD1LCH     0000    0000 00000000 CPU       1A0 COLOR16     0000    0000 0000FA08 COP
0B2 AUD1LCL     0000    0000 00000000 CPU       1A2 COLOR17     0F00    0462 000687C8 COP
0B4 AUD1LEN     0000    0000 00000000 CPU       1A4 COLOR18     00F0    02E4 000687CC COP
0B6 AUD1PER     0000    0000 00000000 CPU       1A6 COLOR19     0FF0    0672 000687D0 COP
0B8 AUD1VOL     0000    0000 00000000 CPU       1A8 COLOR20     0444    0444 0000FA18 COP
0BA AUD1DAT     0000    0000 00000000 CPU       1AA COLOR21     0555    0555 0000FA1C COP
0C0 AUD2LCH     0000    0000 00000000 CPU       1AC COLOR22     0666    0666 0000FA20 COP
0C2 AUD2LCL     0000    0000 00000000 CPU       1AE COLOR23     0777    0777 0000FA24 COP
0C4 AUD2LEN     0000    0000 00000000 CPU       1B0 COLOR24     0888    0888 0000FA28 COP
0C6 AUD2PER     0000    0000 00000000 CPU       1B2 COLOR25     0999    0999 0000FA2C COP
0C8 AUD2VOL     0000    0000 00000000 CPU       1B4 COLOR26     0AAA    0AAA 0000FA30 COP
0CA AUD2DAT     0000    0000 00000000 CPU       1B6 COLOR27     0BBB    0BBB 0000FA34 COP
0D0 AUD3LCH     0000    0000 00000000 CPU       1B8 COLOR28     0CCC    0CCC 0000FA38 COP
0D2 AUD3LCL     0000    0000 00000000 CPU       1BA COLOR29     0DDD    0DDD 0000FA3C COP
0D4 AUD3LEN     0000    0000 00000000 CPU       1BC COLOR30     0EEE    0EEE 0000FA40 COP
0D6 AUD3PER     0000    0000 00000000 CPU       1BE COLOR31     0FFF    0FFF 0000FA44 COP
0D8 AUD3VOL     0000    0000 00000000 CPU       1C0 HTOTAL      00FF    0000 00000000 CPU
0DA AUD3DAT     0000    0000 00000000 CPU       1C2 HSSTOP      0000    0000 00000000 CPU
0E0 BPL1PTH     0006    0006 00068764 COP       1C4 HBSTRT      0000    0000 00000000 CPU
0E2 BPL1PTL     8B48    8B48 00068768 COP       1C6 HBSTOP      0000    0000 00000000 CPU
0E4 BPL2PTH     0000    0000 0006876C COP       1C8 VTOTAL      0138    0138 00F8F6AC CPU
0E6 BPL2PTL     0000    0000 00068770 COP       1CA VSSTOP      0000    0000 00000000 CPU
0E8 BPL3PTH     0000    0000 00068774 COP       1CC VBSTRT      0001    0001 00F8F796 CPU
0EA BPL3PTL     0000    0000 00068778 COP       1CE VBSTOP      0000    0000 00F8F796 CPU
0EC BPL4PTH     0000    0000 0006877C COP       1D0 SPRHSTRT    0000    0000 00000000 CPU
0EE BPL4PTL     0000    0000 00068780 COP       1D2 SPRHSTOP    0000    0000 00000000 CPU
0F0 BPL5PTH     0000    0000 00068784 COP       1D4 BPLHSTRT    0000    0000 00000000 CPU
0F2 BPL5PTL     0000    0000 00068788 COP       1D6 BPLHSTOP    0000    0000 00000000 CPU
0F4 BPL6PTH     0000    0000 0006878C COP       1D8 HHPOSW      0000    0000 00000000 CPU
0F6 BPL6PTL     0000    0000 00068790 COP       1DA HHPOSR      0002    0000 00000000 CPU
0F8 BPL7PTH     0000    0000 00068794 COP       1DC BEAMCON0    0020    0020 00F8BB72 CPU
0FA BPL7PTL     0000    0000 00068798 COP       1DE HSSTRT      0000    0000 00000000 CPU
0FC BPL8PTH     0000    0000 0006879C COP       1E0 VSSTRT      0000    0000 00000000 CPU
0FE BPL8PTL     0000    0000 000687A0 COP       1E2 HCENTER     0000    0000 00000000 CPU
100 BPLCON0     1201    1201 0006875C COP       1E4 DIWHIGH     4080    0000 00000494 COP
102 BPLCON1     0000    0000 0006874C COP       1FC FMODE       000F    000F 00068760 COP
104 BPLCON2     0000    0000 00068750 COP       1FE NULL        FFFE    0000 00000000 CPU
106 BPLCON3     0000    0000 000687D4 COP       000 (null)      0000    0000 00000000 CPU

;--------

096 DMACON      03A0    83A0 00022D10 CPU       18A COLOR05     0BB9    0000 00000000 CPU
098 CLXCON      0000    0000 00000000 CPU       18C COLOR06     0DE7    0000 00000000 CPU
>d 22D10 1
00022d10 3b7c 83a0 0096           move.w #$83a0,(a5,$0096) == $00dff096

09A INTENA      0000    7FFF 00022B4E CPU       18E COLOR07     0E7D    0000 00000000 CPU
09C INTREQ      0028    7FFF 00022B4E CPU       190 COLOR08     07FF    0000 00000000 CPU
>d 22B4E 1
00022b4e 2b7c 7fff 7fff 009a      move.l #$7fff7fff,(a5,$009a) == $00dff09a
																				; This seems to be ok.
;-------------
																				; But what about COP? It's in the next line?
0E0 BPL1PTH     0006    0006 00068764 COP       1C4 HBSTRT      0000    0000 00000000 CPU
0E2 BPL1PTL     8B48    8B48 00068768 COP       1C6 HBSTOP      0000    0000 00000000 CPU
>o 68764 1
 00068764: 00e2 8b48            ;  BPL1PTL := 0x8b48

000 BLTDDAT     0000    0000 00000000 CPU       108 BPL1MOD     FFF8    FFF8 00068754 COP
002 DMACONR     03A0    0000 00000000 CPU       10A BPL2MOD     FFF8    FFF8 00068758 COP
>o 68754 1
 00068754: 010a fff8            ;  BPL2MOD := 0xfff8
>

;------------------------------------------------------------------------------
ea = AGA colors.																; 7. "ea" dumps all AGA color registers.

>ea
  0 00000000  64 001FDFFF 128 00FFC3FD 192 0082AB7F
  1 00102030  65 00FDF76F 129 00F5FFDF 193 00EFFFBA
  2 00FFFFFF  66 00D5DF3F 130 00EFDBBF 194 00FEFFEF
  3 006688BB  67 00FFEDF6 131 0044FFFF 195 00DB7FDC
  4 00FEF5ED  68 00AFBEFB 132 0077DFFF 196 00FBCFEB
  5 00BFBF9F  69 0076B7D3 133 007BFB9C 197 00DF93FA
  6 00D7ED70  70 00F3FFD5 134 00F7BFFA 198 00F577FA
  7 00EE7FDD  71 00976CED 135 00FABEBF 199 00BDDDFD
  8 007CFCFF  72 00F3BD7E 136 001EFFDE 200 00EDF8EE
  9 00DDEFDF  73 006EEFFA 137 007997AE 201 007BFFBE
 10 00D7F795  74 00A3FB7E 138 00D67FFA 202 004AFCE7
 11 00B5DDC6  75 00EAFFE8 139 00B7F7FF 203 007EA72F
 12 00BFF74C  76 00DBFEC7 140 00FD777F 204 007EDBEB
 13 00F5FF4F  77 007DCEF6 141 00F09F80 205 00FBEF69
 14 00EB7B7B  78 005BDFF7 142 00FCFFF2 206 00ADCE9A
 15 00EE7F7D  79 00BFFEED 143 00FFE7BF 207 00FBFDCD
 16 00000000  80 00FE1E3F 144 00CD7F7A 208 00FFEABF
 17 00F40602  81 0073FB77 145 00EFF9AF 209 00F3DDB9
 18 0002FE04  82 00DF7FBE 146 00ED77EF 210 00FFFEFB
 19 00F6F702  83 00DFF93F 147 00EE7FEF 211 007EF0FB
 20 00444444  84 00EEBFF7 148 00D76D36 212 00FCF6F9
 21 00555555  85 00FEFFAD 149 00BFCEFF 213 00897F69
 22 00666666  86 00E7FDEF 150 00EFEC1F 214 00FA5FBF
 23 00777777  87 00F1FCDF 151 00BDEEEF 215 00EF4FFF
 24 00888888  88 009DDBFF 152 00E7FF77 216 006BFFFB
 25 00999999  89 00F77B7A 153 00DF55E2 217 00FFFEFF
 26 00AAAAAA  90 00FB8F7F 154 00957FBF 218 00FF5D7D
 27 00BBBBBB  91 008FFFB7 155 0073F4FE 219 007FEBF7
 28 00CCCCCC  92 00D9F9FF 156 00B8B4AF 220 00D3326F
 29 00DDDDDD  93 00BB3B0F 157 006EC9DD 221 00FDDFEF
 30 00EEEEEE  94 00F35AB6 158 00D7DD1F 222 00FDFF0F
 31 00FFFFFF  95 003DEFFF 159 00BBF73D 223 00FF8EF9
 32 002EDDDE  96 00DFFFBF 160 00E9DFBE 224 00FF6F6D
 33 00DFFDBF  97 00FDB5FD 161 007B5E95 225 00ECCABE
 34 00BD66DB  98 00AB7AFF 162 00EEFFF7 226 00F7F3B3
 35 00EFFBED  99 006F6DEE 163 0073B6FE 227 00F7FFFF
 36 00E4FFEC 100 009FFBF3 164 0057FFBB 228 001BEDD8
 37 00FABB6B 101 00BAEFFF 165 00FF16E1 229 00BAF50C
 38 00E7F5EF 102 00FBFFB7 166 00F3FEDC 230 0077CAB9
 39 00FFDF96 103 00E7B4FE 167 00BEBB4F 231 0097B3EE
 40 00F79BFE 104 00FED7FF 168 00BDF97F 232 00AEDFFD
 41 00FFE56F 105 00BFE1FA 169 00752F8A 233 00F6B7FD
 42 00755EF7 106 00FF9FD7 170 00BDEF5F 234 00BD9EFF
 43 00F79B0A 107 009C977B 171 00FFF9FE 235 00FDFEBF
 44 007FDFFD 108 00EB7E6F 172 00FBFCD7 236 007DDFBE
 45 00DBEFFF 109 00B5BEBF 173 00DFDFBE 237 00B75FFF
 46 00FFB7F1 110 002DFF57 174 00FD7FF0 238 00F97EFB
 47 00E5CFDC 111 00DA757F 175 00F93EDF 239 00C7FB57
 48 00AF2DFF 112 0057DDFF 176 002D3FD7 240 00CCB5F7
 49 004AF77F 113 00F34FBA 177 00D776FF 241 00FEFF6F
 50 0089E8AA 114 00EDFBF9 178 00793DFB 242 00D3F3BF
 51 00A73FFF 115 00FD772E 179 00F9F4F3 243 005FFE4F
 52 0067EDEB 116 00677FFC 180 00EEF6BB 244 00E97DEF
 53 00DDEFF6 117 005F2BFF 181 00BEAFEF 245 00E5BFFD
 54 00FFFBE7 118 00F7FDFF 182 00779AFF 246 006AFBD1
 55 00B6DB96 119 005FEBFE 183 0031FC6F 247 00EDB5FB
 56 00DCE59D 120 003FF7FB 184 003B77F5 248 0039D57F
 57 00F77DDF 121 00D7F774 185 006DDFFB 249 00DFDDDF
 58 00FE92EF 122 0073B9EF 186 009D577F 250 00DFC62F
 59 00FF95BE 123 00AF5FCB 187 00FF6FF0 251 00F76E5F
 60 00DFF7F9 124 00F457DE 188 007BB37F 252 00FFF7E1
 61 00F73F3B 125 0097FEE7 189 00BF1A97 253 00EFF6AD
 62 00BFFBFB 126 00FDD7FB 190 00EDADFF 254 006F97FF
 63 00E55951 127 005A98F7 191 00EEDB3F 255 0097F7FB
>

;------------------------------------------------------------------------------
i	            Dump contents of interrupt and trap vectors.				; 8.	exception 3 vector points (i)

>i
$00000000 00:    Reset:SSP $00000000  $00000080 32:      TRAP 00 $00FC0836
$00000004 01:     EXECBASE $00C00276  $00000084 33:      TRAP 01 $00FC0838
$00000008 02:    BUS ERROR $00FC0818  $00000088 34:      TRAP 02 $00FC083A
$0000000C 03:    ADR ERROR $00FC081A  $0000008C 35:      TRAP 03 $00FC083C
$00000010 04:    ILLEG OPC $00FC081C  $00000090 36:      TRAP 04 $00FC083E
$00000014 05:     DIV BY 0 $00FC081E  $00000094 37:      TRAP 05 $00FC0840
$00000018 06:          CHK $00FC0820  $00000098 38:      TRAP 06 $00FC0842
$0000001C 07:        TRAPV $00FC0822  $0000009C 39:      TRAP 07 $00FC0844
$00000020 08:   PRIVIL VIO $00FC090E  $000000A0 40:      TRAP 08 $00FC0846
$00000024 09:        TRACE $00FC0826  $000000A4 41:      TRAP 09 $00FC0848
$00000028 10:    LINEA EMU $00FC0828  $000000A8 42:      TRAP 10 $00FC084A
$0000002C 11:    LINEF EMU $00FC082A  $000000AC 43:      TRAP 11 $00FC084C
$0000003C 15:   INT Uninit $00FC0832  $000000B0 44:      TRAP 12 $00FC084E
$00000060 24:   INT Unjust $00FC0834  $000000B4 45:      TRAP 13 $00FC0850
$00000064 25:    Lvl 1 Int $00FC0C8E  $000000B8 46:      TRAP 14 $00FC0852
$00000068 26:    Lvl 2 Int $00FC0CE2  $000000BC 47:      TRAP 15 $00FC0854
$0000006C 27:    Lvl 3 Int $00FC0D14  
$00000070 28:    Lvl 4 Int $00FC0D6C  
$00000074 29:    Lvl 5 Int $00FC0DFA  
$00000078 30:    Lvl 6 Int $00FC0E40  
$0000007C 31:          NMI $00FC0E86  

																				; i [<addr>]	; ?
																				; i 6c ; shows always the complete list
																				; "i 6c" means show vectors like VBR=6c.
																				; If you only want to see contents of 6c, you can simple type "m 6c 1"


;------------------------------------------------------------------------------
dm                    Dump current address space map.							; 9.

>dm
00000000    2048K/4 =     512K ID* C16 Chip memory
00200000    8192K/0 =    8192K --  F16 <none>
00A00000    2048K/0 =    2048K --  CIA CIA
00C00000     512K/1 =     512K ID* C16 Slow memory
00C80000    1024K/0 =    1024K --  F16 Custom chipset
00D80000     256K/0 =     256K --  C16 <none>
00DC0000      64K/0 =      64K --  C16 Battery backed up clock (MSM6242B)
00DD0000      64K/0 =      64K --  C16 <none>
00DE0000     128K/0 =     128K --  C16 Custom chipset
00E00000     512K/2 =     256K ID* F16 Kickstart ROM (C4F0F55F)
=KS ROM v1.3 (A500,A1000,A2000) rev 34.5 (256k) [315093-02]
00E80000      64K/0 =      64K --  F16 <none>
00E90000      64K/1 =      64K --* F16 Filesystem autoconfig
00EA0000     384K/0 =     384K --  F16 <none>
00F00000      64K/1 =      64K --* F16 UAE Boot ROM
00F10000     448K/0 =     448K --  F16 <none>
00F80000     512K/2 =     256K ID* F16 Kickstart ROM (C4F0F55F)
=KS ROM v1.3 (A500,A1000,A2000) rev 34.5 (256k) [315093-02]
>

																				; Then my interpretation to this /0 /1 /2 /4 is:
																				; /0 - not present
																				; /1 - 1x present
																				; /2 - 2x present (mirrored)
																				; /4 - 4x present (mirrored)

																				; What means ID* or '--' or '--*' ?
																				; I - Instruction, D - Data, * - ?

																				; 00000000    2048K/4 =     512K ID C16 Chip memory		; Chip memory
																				; 0800000	copy of chip 
																				; 1000000	copy of chip
																				; 1800000	copy of chip

																				; Maybe an additional info sign about a potential 
																				; 'illegal access area' W, RO, WO would be good.

;------------------------------------------------------------------------------
mg <address>          Memory dump starting at <address> in GUI.					; 10. 
 
>mg <address>																	; no reaction function???
																				
;------------------------------------------------------------------------------
dg <address>          Disassembly starting at <address> in GUI.					; 11.

>dg																				; no reaction function???

;------------------------------------------------------------------------------

>dppc				(>dpc in WinUAE 4.4)										; 12.
0000000C  00FC081A
00000010  00FC081C
00000014  00FC081E
00000018  00FC0820
																				; with 
																				; >dppc and >do you can switch the disassembly output from original 
																				; 68k to PPC and backwards
;------------------------------------------------------------------------------
d <address> [<lines>]  Disassembly starting at <address>.						; 13.

>d C1674c
00C1674C 343c 000f                MOVE.W #$000f,D2
00C16750 363c 000f                MOVE.W #$000f,D3
00C16754 383c 000f                MOVE.W #$000f,D4
00C16758 3a3c 000f                MOVE.W #$000f,D5
00C1675C 3c3c 000f                MOVE.W #$000f,D6
00C16760 303c 00f0                MOVE.W #$00f0,D0
00C16764 323c 00f0                MOVE.W #$00f0,D1

>d C1674c 3
00C1674C 343c 000f                MOVE.W #$000f,D2
00C16750 363c 000f                MOVE.W #$000f,D3
00C16754 383c 000f                MOVE.W #$000f,D4

>d																				; with every d the next disassembly lines are output from here on

A0 FFFFFFFE   A1 0006A53C   A2 00000000   A3 00000000  
>dra0 2
fffffffe 001f 0000                or.b #$00,(a7)+ [00]
00000002 0000 00c0                or.b #$c0,d0

>dpc  ; oder d pc
000226c4 0839 0002 00df f016      btst.b #$0002,$00dff016
000226cc 66f6                     bne.b #$f6 == $000226c4 (T)

;------------------------------------------------------------------------------
d r[b/w/l](address/r(register)) [<lines>]										; 14. Disassembly indirect

>d rl(8) 1
00fc0818 615c                     bsr.b #$5c == $00fc0876
>d rl(8)+1 1
00fc0819 5c61                     addq.w #$06,-(a1) [7607]
>d rl(8)+2 1
00fc081a 615a                     bsr.b #$5a == $00fc0876
>

...
$00000014 05:     DIV BY 0 $00FC081E
...
>m 14 1
00000014 00FC 081E 00FC 0820 00FC 0822 00FC 090E  ....... ..."....
>d FC081E 1
00fc081e 616c                     bsr.b #$6c == $00fc088c
>d rl($14) 1
00fc081e 616c                     bsr.b #$6c == $00fc088c

;------------------------------------------------------------------------------
 o <0-2|addr> [<lines>]		View memory as Copper instructions.					; 15.

>o 420
 00000420: 0180 005a          	;  COLOR00 := 0x005a
 00000424: 00e2 0000          	;  BPL1PTL := 0x0000
 00000428: 0120 0000          	;  SPR0PTH := 0x0000
 0000042c: 0122 0c80          	;  SPR0PTL := 0x0c80
 00000430: 0124 0000          	;  SPR1PTH := 0x0000
 00000434: 0126 0478          	;  SPR1PTL := 0x0478
 00000438: 0128 0000          	;  SPR2PTH := 0x0000
 0000043c: 012a 0478          	;  SPR2PTL := 0x0478
 00000440: 012c 0000          	;  SPR3PTH := 0x0000
 00000444: 012e 0478          	;  SPR3PTL := 0x0478
 00000448: 0130 0000          	;  SPR4PTH := 0x0000
 0000044c: 0132 0478          	;  SPR4PTL := 0x0478
 00000450: 0134 0000          	;  SPR5PTH := 0x0000
 00000454: 0136 0478          	;  SPR5PTL := 0x0478
 00000458: 0138 0000          	;  SPR6PTH := 0x0000
 0000045c: 013a 0478          	;  SPR6PTL := 0x0478
 00000460: 013c 0000          	;  SPR7PTH := 0x0000
 00000464: 013e 0478          	;  SPR7PTL := 0x0478
 00000468: 0c01 fffe          	;  Wait for vpos >= 0x0c and hpos >= 0x00
														;  VP 0c, VE 7f; HP 00, HE fe; BFD 1
 0000046c: 008a 0000          	;  COPJMP2 := 0x0000

 >o 420 2
 00000420: 0180 005a          	;  COLOR00 := 0x005a
 00000424: 00e2 0000          	;  BPL1PTL := 0x0000


 >o 0 2
*00015044: 2c01 fffe          	;  Wait for vpos >= 0x2c and hpos >= 0x00
														;  VP 2c, VE 7f; HP 00, HE fe; BFD 1
 00015048: 0100 0200          	;  BPLCON0 := 0x0200

 >o 1 2							;  actual address of COP1LCH
 00000420: 0180 005a          	;  COLOR00 := 0x005a
 00000424: 00e2 0000          	;  BPL1PTL := 0x0000

 >o 2 2							;  actual address of  COP2LCH
 00014fb0: 2b01 fffe          	;  Wait for vpos >= 0x2b and hpos >= 0x00
														;  VP 2b, VE 7f; HP 00, HE fe; BFD 1
 00014fb4: 0180 005a          	;  COLOR00 := 0x005a
 
;------------------------------------------------------------------------------
T or Tt                Show exec tasks and their PCs.							; 16.
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.

>T
Execbase at 0x00C00276
Current:
00C22288: PROCESS 'TRASH'M-One'

Ready:
Waiting:
00C05750: TASK    'UAE fs automounter'
          Waiting signals: 00002000
          SP: 00c05fa4 PC: 00f00344
00C1D6C8: PROCESS 'SYS:System/CLI'

          Waiting signals: 00000100
          SP: 00c1ae80 PC: 00ff469c
00C1D158: PROCESS 'RAM'

          Waiting signals: 00000100
          SP: 00c1d6ac PC: 00ff469c
00C204E8: PROCESS 'NEWCON'

          Waiting signals: 00000100
          SP: 00c21528 PC: 00ff469c
00C21548: PROCESS 'Background CLI'
 [1, '']
          Waiting signals: 00000100
          SP: 00c22260 PC: 00ff469c
00C06FE8: PROCESS 'DH0'

          Waiting signals: 00002100
          SP: 00c08808 PC: 00f012e0
00C190E0: PROCESS 'Workbench'

          Waiting signals: 80000000
          SP: 00c1a4c8 PC: 00ff36de
00C01AF8: TASK    'UAE fs worker'
          Waiting signals: 00000100
          SP: 00c0234c PC: 00f0040e
00C08818: PROCESS 'DH1'

          Waiting signals: 00002100
          SP: 00c0a038 PC: 00f012e0
00C054C6: TASK    'trackdisk.device'
          Waiting signals: 00000300
          SP: 00c0619c PC: 00feaaf6
00C010C8: PROCESS 'File System'

          Waiting signals: 00000100
          SP: 00c014ac PC: 00ff469c
00C031DA: TASK    'input.device'
          Waiting signals: c0000000
          SP: 00c04226 PC: 00fe5f3c

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.

>Td
00c02b24 3 0 34.1 2 keyboard.device
00c02c5c 3 0 34.1 1 gameport.device
00c02de6 3 0 34.1 8 timer.device (timer 34.1 (18 Aug 1987)
)
00c02ee4 3 0 34.1 0 audio.device (audio 34.1 (18 Aug 1987)
)
00c03184 3 0 34.1 5 input.device
00c044c0 3 0 34.1 3 console.device
00c0459c 3 0 34.1 2 trackdisk.device
00c0526c 3 0 50.1 0 uaehf.device (UAE hardfile.device 0.6)
>

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.

>Tl
00c00276 9 0 34.2 2 exec.library (exec 34.2 (28 Oct 1987)
)
00c0192e 8 0 34.1 2 expansion.library (expansion 34.1 (18 Aug 1987)
)
00c028f6 0 0 34.1 1 graphics.library
00c04466 0 0 34.1 1 layers.library
00c0481c 0 0 34.3 1 intuition.library
00c051b8 9 0 34.1 1 mathffp.library (mathffp 34.1 (18 Aug 1987)
)
00c051fe 0 0 34.1 2 romboot.library
00c06290 0 0 34.3 7 dos.library (dos 34.3 (9 Dec 1987)
)
00c0667a 9 0 34.1 1 ramlib.library (ramlib 34.1 (18 Aug 1987)
)
00c0cfe4 9 0 34.2 2 icon.library (icon 34.2 (22 Jun 1988)
)
00c0d2b0 0 0 1.1 1 environment
>

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.
>Tr
00c023ca 8 0 potgo.resource
00c023f8 8 0 keymap.resource
00c02460 8 0 ciaa.resource
00c024f8 8 0 ciab.resource
00c02596 8 0 disk.resource
00c02634 8 0 misc.resource
00c05126 8 0 uae.resource
00c055a8 8 0 FileSystem.resource
>

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.

>Tp
00c0bc48 4 0 SetPatch-01
00c0bc70 4 0 FF2:)
0001227e 4 0 Workbench
000122a0 4 0 Workbench
00c10850 4 0 IDCMP
00c06b70 4 0 IDCMP
00c156b8 4 0 IDCMP
00c1b240 4 0 IDCMP
00c5ec50 0 0
>

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.

>Ts
;------------------------------------------------------------------------------

>TS

;------------------------------------------------------------------------------

>Ti
 1 1: 00C002CA
  [H] 00000000
 2 1: 00C002D6
  [H] 00C02596
      00C025E4 (C=00FC4AE8 D=00C02596) ''
 3 1: 00C002E2
  [H] 00000000
 4 2: 00C002EE
  [S] 00c0248a +00 (C=00fc4684 D=00C02460) 'ciaa.resource'
  [S] 00c02358 -01 (C=00f007c0 D=00C02372) 'UAE fs'
 5 3: 00C002FA
  [S] <none>
 6 3: 00C00306
  [S] 00c02940 +10 (C=00fc6d48 D=00C028F6) ''
  [S] 00c02d8c +00 (C=00fe5824 D=00C02C5C) 'gameport.device'
  [S] 00c02e88 +00 (C=00fe935a D=00C02E5E) 'timer.device'
  [S] 00c02388 -10 (C=00f00920 D=00C0239E) 'UAE heart beat'
 7 3: 00C00312
  [H] 00C028F6
      00C0296C (C=00FC6DFA D=00C028F6) ''
 8 4: 00C0031E
  [H] 00C02FAE
      00C02FE0 (C=00FC35E4 D=00C02FAE) 'audio.device'
 9 4: 00C0032A
  [H] 00C0301A
      00C0304C (C=00FC35E4 D=00C0301A) 'audio.device'
10 4: 00C00336
  [H] 00C03086
      00C030B8 (C=00FC35E4 D=00C03086) 'audio.device'
11 4: 00C00342
  [H] 00C030F2
      00C03124 (C=00FC35E4 D=00C030F2) 'audio.device'
12 5: 00C0034E
  [H] 00000000
13 5: 00C0035A
  [H] 00C02596
      00C025FA (C=00FC4B00 D=00C02596) ''
14 6: 00C00366
  [S] 00c02522 +00 (C=00fc4678 D=00C024F8) 'ciab.resource'
15 6: 00C00372
  [H] 00000000
16 7: 00C0037E
  [S] <none>
>

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.
>TO
ROOTNODE: 00c05538 DOSINFO: 00c0558c
00c157b4: Type=0 Port=00000000 Lock=00000000 'PIPE'
 - H=00c1579c Stack= 6000 Pri= 5 Start=00000000 Seg=00000000 GV=ffffffff
00c1575c: Type=0 Port=00000000 Lock=00000000 'AUX'
 - H=00c15744 Stack= 1000 Pri= 5 Start=00000000 Seg=00000000 GV=003018f6
00c15704: Type=0 Port=00000000 Lock=00000000 'SPEAK'
 - H=00c156ec Stack= 6000 Pri= 5 Start=00000000 Seg=00000000 GV=ffffffff
00c15a54: Type=1 Port=00c1d1b4 Lock=0030568b 'CLIPS'
00c159fc: Type=1 Port=00c1d1b4 Lock=00305675 'ENV'
00c0dd64: Type=1 Port=00c1d1b4 Lock=00303473 'T'
00c0d19c: Type=2 Port=00c1d1b4 Lock=00000000 'RAM DISK'
 - VolumeDate=00000000 00000000 00000000 LockList=00000000 DiskType=444f5300
00c0bcbc: Type=0 Port=00000000 Lock=00000000 'NEWCON'
 - H=00c0bc2c Stack= 1000 Pri= 5 Start=00000000 Seg=00c1e79c GV=003018f6
00c00b64: Type=0 Port=00c01124 Lock=00000000 'DF0'
 - H=00000000 Stack=    0 Pri= 0 Start=00c00b4c Seg=00000000 GV=00000000
   trackdisk.device:0 003fe25c
    TableSize       12
    SizeBlock       128
    SecOrg          0
    Surfaces        2
    SectorPerBlock  1
    BlocksPerTrack  11
    Reserved        2
    PreAlloc        11
    Interleave      0
    LowCyl          0
    HighCyl         79 (Total 80)
    NumBuffers      5
    BufMemType      0x00000003
    MaxTransfer     0x03444658
    Mask            0x72047018
    BootPri         678035572
    DosType         0x4e952341
00c009f8: Type=2 Port=00c08874 Lock=00000000 'DH1'
 - VolumeDate=00000ed9 00000000 00000000 LockList=003052b9 DiskType=444f5300
00c00944: Type=1 Port=00c07044 Lock=0030025f 'S'
00c008f4: Type=1 Port=00c07044 Lock=0030024b 'L'
00c008a4: Type=1 Port=00c07044 Lock=00300237 'C'
00c0084c: Type=1 Port=00c07044 Lock=00300223 'FONTS'
00c007f4: Type=1 Port=00c07044 Lock=0030020d 'DEVS'
00c0079c: Type=1 Port=00c07044 Lock=003001f7 'LIBS'
00c00714: Type=1 Port=00c07044 Lock=003001e1 'SYS'
00c005c0: Type=2 Port=00c07044 Lock=00000000 'DH0'
 - VolumeDate=00000ed8 00000000 00000000 LockList=00303f5f DiskType=444f5300
00c06fac: Type=0 Port=00000000 Lock=00000000 'PRT'
 - H=00ff8d2c Stack= 1000 Pri= 0 Start=00000008 Seg=00000000 GV=003018f6
00c06f6c: Type=0 Port=00000000 Lock=00000000 'PAR'
 - H=00ff8d2c Stack=  800 Pri= 0 Start=00000004 Seg=00000000 GV=003018f6
00c06f2c: Type=0 Port=00000000 Lock=00000000 'SER'
 - H=00ff8d2c Stack=  800 Pri= 0 Start=00000000 Seg=00000000 GV=003018f6
00c06eec: Type=0 Port=00000000 Lock=00000000 'RAW'
 - H=00000000 Stack=  700 Pri= 5 Start=00000004 Seg=00ff9c1c GV=003018f6
00c06ebc: Type=0 Port=00000000 Lock=00000000 'CON'
 - H=00000000 Stack=  700 Pri= 5 Start=00000000 Seg=00ff9c1c GV=003018f6
00c06e8c: Type=0 Port=00c1d1b4 Lock=00000000 'RAM'
 - H=00000000 Stack=    0 Pri= 0 Start=00000000 Seg=00000000 GV=00000000
00c05600: Type=0 Port=00c07044 Lock=00000000 'DH0'
 - H=00f0fe4c Stack= 6000 Pri=10 Start=00c04de8 Seg=00f00008 GV=ffffffff
   uaehf.device:0 0030158c
    TableSize       16
    SizeBlock       128
    SecOrg          0
    Surfaces        64
    SectorPerBlock  1
    BlocksPerTrack  127
    Reserved        2
    PreAlloc        0
    Interleave      0
    LowCyl          1
    HighCyl         660487 (Total 660487)
    NumBuffers      50
    BufMemType      0x00000001
    MaxTransfer     0x7ffffffe
    Mask            0xfffffffe
    BootPri         0
    DosType         0x444f5300
00c056c8: Type=0 Port=00c08874 Lock=00000000 'DH1'
 - H=00f0fe4c Stack= 6000 Pri=10 Start=00c055e0 Seg=00f00008 GV=ffffffff
   uaehf.device:1 003015be
    TableSize       16
    SizeBlock       128
    SecOrg          0
    Surfaces        16
    SectorPerBlock  1
    BlocksPerTrack  127
    Reserved        2
    PreAlloc        0
    Interleave      0
    LowCyl          1
    HighCyl         14796 (Total 14796)
    NumBuffers      50
    BufMemType      0x00000001
    MaxTransfer     0x7ffffffe
    Mask            0xfffffffe
    BootPri         0
    DosType         0x444f5300
>
;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.

>TM
00c004c2 10 0 Fast Memory
Attributes 0005 First 00c0b958 Lower 00c004e8 Upper 00c7e800 Free 238944
 00c0b958: 00c0b958-00c0b960,00c0bc40,00000008 (8)
 00c0bc40: 00c0bc40-00c0bc48,00c0bce8,00000008 (8)
 00c0bce8: 00c0bce8-00c0bcf0,00c0d388,00000008 (8)
 00c0d388: 00c0d388-00c0d390,00c0fce8,00000008 (8)
 00c0fce8: 00c0fce8-00c0fcf0,00c109e0,00000008 (8)
 00c109e0: 00c109e0-00c109f0,00c14298,00000010 (16)
 00c14298: 00c14298-00c142a0,00c147c8,00000008 (8)
 00c147c8: 00c147c8-00c147d0,00c14898,00000008 (8)
 00c14898: 00c14898-00c148a8,00c156e0,00000010 (16)
 00c156e0: 00c156e0-00c156e8,00c15908,00000008 (8)
 00c15908: 00c15908-00c15910,00c15aa0,00000008 (8)
 00c15aa0: 00c15aa0-00c15aa8,00c16228,00000008 (8)
 00c16228: 00c16228-00c16230,00c1b2a0,00000008 (8)
 00c1b2a0: 00c1b2a0-00c1b2a8,00c1b310,00000008 (8)
 00c1b310: 00c1b310-00c1b320,00c1b348,00000010 (16)
 00c1b348: 00c1b348-00c1b528,00c23350,000001e0 (480)
 00c23350: 00c23350-00c3fdd0,00c60f90,0001ca80 (117376)
 00c60f90: 00c60f90-00c7e800,00000000,0001d870 (120944)

00000400 10 -10 Chip Memory
Attributes 0003 First 00010508 Lower 00000420 Upper 00080000 Free 78488
 00010508: 00010508-000105b0,0006ce10,000000a8 (168)
 0006ce10: 0006ce10-00080000,00000000,000131f0 (78320)

>

;------------------------------------------------------------------------------
	Td,Tl,Tr,Tp,Ts,TS,Ti,TO,TM,Tf Show devs, libs, resources, ports, semaphores,
												residents, interrupts, doslist, memorylist, fsres.
>Tf
00c055a8: 'UAE fs'

;------------------------------------------------------------------------------
rc[d]   Show CPU instruction or data cache contents.  							; 17. A1200 CPU mit Cache

>rc																				; no reaction on A500 configuration
00022B00U:370066EC*00022B04U:08390006*00022B08U:00BFE001*00022B0CU:6600FFE2*
00022B10U:33FCC000*00022B14U:00DFF09A*00C6BC18S:0CAF00C5*00C6BC1CS:C3E20002*
00C65320U:04000020*00C65324U:72001940*00F80B28S:0CAF00F8*00F80B2CS:0B100002*
00F80B30S:660C2F7C*00F80B34S:00F80B3C*00C65338U:001D6200*00F80B3CS:4E75007C*
00F80B40S:07002F3C*00F80B44S:00000008*00F80B48S:6000FF2C*00C6B94CS:368C46FC*
00C6B950S:20004E60*00C6B954S:4CECFFFF*00C6B958S:12882F39*00C6B95CS:00C7903E*
00C6B960S:3F3900C7*00C6B964S:903C4E73*00C6B968S:66042940*00C6B96CU:12CE33FC*
00C6B970U:000100C7*00F80A74S:0002082F*00F80A78S:00050004*00F80A7CS:675A6000*
00F80A80S:25AC0497*00C6B984U:41EC459C*00C6B988U:213C00C6*00C6B98CU:BBE860B0*
00C6B990U:48E780C2*00C6B994U:08390000*00C6B998U:00C72390*00C6B99CU:6700006C*
00C6B9A0U:226C1152*00C6B9A4U:29690026*00C009A8U:4EF900F8*00C653ACU:01E62A5F*
00C653B0U:0C010061*00C653B4U:4E752F0D*00C5EDB8U:67F80C00*00C64ABCU:4E757601*
00C64AC0U:72004E75*00C64AC4U:48E73FF6*00C64AC8U:61CE4A00*00C64ACCU:66000A7A*
00C64AD0U:20034CDF*00C64AD4U:6FFC4A01*00F80AD8S:48E700C0*00F80ADCS:20780004*
00F80AE0S:20680114*00F80AE4S:2F680032*00022AE8U:33FC4000*00022AECU:00DFF09A*
00022AF0U:203900DF*00022AF4U:F0040280*00022AF8U:000FFF00*00022AFCU:0C800001*

>rcd																		; no reaction on A500 configuration
00022B00U:370066EC*00022B04U:08390006*00022B08U:00BFE001*00022B0CU:6600FFE2*
00022B10U:33FCC000*00022B14U:00DFF09A*00C6BC18S:0CAF00C5*00C6BC1CS:C3E20002*
00C65320U:04000020*00C65324U:72001940*00F80B28S:0CAF00F8*00F80B2CS:0B100002*
00F80B30S:660C2F7C*00F80B34S:00F80B3C*00C65338U:001D6200*00F80B3CS:4E75007C*
00F80B40S:07002F3C*00F80B44S:00000008*00F80B48S:6000FF2C*00C6B94CS:368C46FC*
00C6B950S:20004E60*00C6B954S:4CECFFFF*00C6B958S:12882F39*00C6B95CS:00C7903E*
00C6B960S:3F3900C7*00C6B964S:903C4E73*00C6B968S:66042940*00C6B96CU:12CE33FC*
00C6B970U:000100C7*00F80A74S:0002082F*00F80A78S:00050004*00F80A7CS:675A6000*
00F80A80S:25AC0497*00C6B984U:41EC459C*00C6B988U:213C00C6*00C6B98CU:BBE860B0*
00C6B990U:48E780C2*00C6B994U:08390000*00C6B998U:00C72390*00C6B99CU:6700006C*
00C6B9A0U:226C1152*00C6B9A4U:29690026*00C009A8U:4EF900F8*00C653ACU:01E62A5F*
00C653B0U:0C010061*00C653B4U:4E752F0D*00C5EDB8U:67F80C00*00C64ABCU:4E757601*
00C64AC0U:72004E75*00C64AC4U:48E73FF6*00C64AC8U:61CE4A00*00C64ACCU:66000A7A*
00C64AD0U:20034CDF*00C64AD4U:6FFC4A01*00F80AD8S:48E700C0*00F80ADCS:20780004*
00F80AE0S:20680114*00F80AE4S:2F680032*00022AE8U:33FC4000*00022AECU:00DFF09A*
00022AF0U:203900DF*00022AF4U:F0040280*00022AF8U:000FFF00*00022AFCU:0C800001*
>
; example code (Listing19i2.s)
>d 22af0 8
00022af0 2039 00df f004           move.l $00dff004,d0
00022af6 0280 000f ff00           and.l #$000fff00,d0
00022afc 0c80 0001 3700           cmp.l #$00013700,d0
00022b02 66ec                     bne.b #$ec == $00022af0 (T)
00022b04 0839 0006 00bf e001      btst.b #$0006,$00bfe001
00022b0c 6600 ffe2                bne.w #$ffe2 == $00022af0 (T)
00022b10 33fc c000 00df f09a      move.w #$c000,$00dff09a
00022b18 4e75                     rts  == $00c6bbe8

;------------------------------------------------------------------------------

>seg																			; 18. 
No executable loaded

;------------------------------------------------------------------------------
