
; Listing18b3.s = Lezione3d-2c.s

	SECTION	DotCube3d,CODE

; ROTATION X,Y,Z + Translation X,Y,Z (Dot-Cube)
; darauf achten, dass die Rotation immer respektvoll stattfindet
; Wenn Sie also das Objekt in der Mitte bewegen, "dreht" sich das Objekt in der
; Mitte, fast wahnsinnig.

; rechts / links mit Maus fr Auf / Ab: Translation X und Y
; linke / rechte Maustaste = Z bewegen (nher / weiter weg bewegen)

*****************************************************************************
	include "///Sources/startup2.s"		; Copperlist speichern etc.
*****************************************************************************
	
			;5432109876543210
DMASET	equ	%1000001111000000	; Copper, Bitplane und blitter
WaitDisk equ	%0				; wegen startup2
Bildschirmbreite	=	320
Bildschirmhoehe		=	256

Start:
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"
	move.l	#0,$108(a5)

	move.b	$dff00a,MouseY		; JOY0DAT vertikale Mausposition
	move.b	$dff00b,MouseX		; horizontale Mausposition

LoopMain:
	lea	$dff000,a5
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; warte auf Zeile $12c
WaitY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $12c
	bne.s	WaitY1

	bsr.w	SwapClean		; Bildschirme im Doppelpuffer tauschen und
								; alten Bildschirm reinigen

	addq.w	#1,Zangle			; Drehung um die Achse, die auf uns zu kommt
								; wir wrden es als einen Punkt sehen .,
								; daher dreht sich das Objekt wie die Zeiger
								; einer Uhr, wenn SUB oder
								; gegen den Uhrzeigersinn, wenn ADD.
	addq.w	#2,Yangle			; Drehung um die VERTIKALE Achse |
	addq.w	#1,Xangle			; Drehung um eine HORIZONTALE Achse --

	bsr.s	ReadMouse			; Liest die Bewegung der Maus um
								; die X- und Y-Translationswerte zu aktualisieren

; Jetzt mit der rechten und linken Taste der Maus knnen wir eine Translation
; in Bezug auf die Z-Achse ausfhren, die das Objekt nher oder weiter weg bringt.

	btst.b	#6,$bfe001			; linke Maustaste?
	bne.s	NoFurther
	cmp.w	#40*50,Zadd			; sind wir sehr weit weg?
	beq.s	NoFurther		; wenn ja, anhalten
	addq.w	#2,Zadd				; Translation von uns weg
NoFurther:
	btst.b	#2,$dff016			; rechte Maustaste?
	bne.s	NoApproach
	cmp.w	#0,Zadd				; sind wir zu uns sehr nah?
	beq.s	NoApproach			; wenn ja, das reicht!
	SUBQ.W	#2,Zadd				; Translation der Annherung an uns
	btst.b	#6,$bfe001			; wird auch die linke Taste gedrckt?
	beq.s	Exit				; Wenn ja, dann raus!
NoApproach:

	bsr.w	Translation			; TRANSLATION des Objekts gem den Werten
								; der Variablen Xadd, Yadd und Zadd.

	bsr.w	Rotate				; 3D-Bild drehen

	bsr.w	Perspektive			; PERSPEKTIVE PROJEKTION. Die bewegten Punkte
								; werden auf den "Monitor" projiziert.

	bsr.w	DesignObject		; Objekt zeichnen (einfache X-, Y-Punkte)

	bra.w 	LoopMain			; Bereit fr den nchsten Frame

Exit:
	rts


******************************************************************************
; Diese Routine liest die Maus und aktualisiert die Werte in den
; Xadd- und Yadd-Variablen, die fr die Translation verwendet werden.
******************************************************************************

ReadMouse:
	move.b	$dff00a,d1			; JOY0DAT vertikale Mausposition
	move.b	d1,d0				; Kopie in d0
	sub.b	MouseY(pc),d0		; alte Mausposition subtrahieren
	beq.s	NoVert				; wenn die Differenz = 0 ist, wird die Maus gestoppt
	ext.w	d0					; wandelt das Byte in ein Wort um
								; (siehe am Ende der Listings)
	add.w	d0,Yadd				; Wrfelposition ndern
NoVert:
  	move.b	d1,MouseY			; speichern der Mausposition fr das nchste Mal

	move.b	$dff00b,d1			; horizontale Mausposition
	move.b	d1,d0				; Kopie in d0
	sub.b	MouseX(pc),d0		; alte Position subtrahieren
	beq.s	NoHoriz				; wenn die Differenz = 0 ist, wird die Maus gestoppt
	ext.w	d0					; wandelt das Byte in ein Wort um
								; (siehe am Ende der Listings)
	add.w	d0,Xadd				; Wrfelposition ndern 
NoHoriz:
  	move.b	d1,MouseX			; speichern der Mausposition fr das nchste Mal
	rts

MouseY:	dc.b	0			; hier wird das Y der Maus gespeichert
MouseX:	dc.b	0			; Hier wird das X der Maus gespeichert

*************************************************
*	Swap Logical and Physical Screens			*
*************************************************

SwapClean:
	move.l 	Screen(pc),d0
	cmp.l 	DrawPlane(pc),d0	; Is current screen=screen1
	bne.s	SwapIt				; No then branch
	;move.l 	Screen(pc),d0		; Display Screen1
	bsr.s	PointPlaneInCop		; Insert it Into Copper
	move.l 	Screen1(pc),DrawPlane	; Screen2 = Logical 
	move.l 	Screen1(pc),a1		; Address to Clear
	bsr.w	CpuClearScreen		; Do it !!!
  	rts
  	
SwapIt:
	move.l 	Screen1(pc),d0		;Use screen2
	bsr.s	PointPlaneInCop		;Insert screen
	move.l 	Screen(pc),DrawPlane	;screen1=logical
	move.l 	Screen(pc),a1		;address to clear
	bsr.w	CpuClearScreen
	rts
	
PointPlaneInCop:
	lea	BplPointer,a0			; Zeiger Copperlist
	move 	d0,6(a0)			; auf die plane zeigen 
	swap 	d0
	move 	d0,2(a0)
	rts


DrawPlane:
	dc.l	Bitplane

; Zeiger auf die 2 Bildschirme fr das Double Buffering

Screen:
	dc.l Bitplane0
Screen1:
	dc.l Bitplane

******************************************************************************
*	Bildschirm CLEAR-Routine ber den Prozessor
*
*	a1 = Adresse des zu reinigenden Bildschirms
******************************************************************************

CpuClearScreen:
	movem.l	d0-d7/a0-a6,-(sp)	; alle Register speichern
	move.l	sp,OldSp			; Speichern des STACK POINTER, um ihn zu verwenden
	lea	40*Bildschirmhoehe(a1),sp	; Laden Sie die hohe Adresse, also
								; das Ende des Bildschirms, da Movems
								; "rckwrts" reinigen.
	movem.l	ClReg(pc),d0-d7/a0-a6	; Wir setzen alle Register mit nur
								; einem Movem aus einem Puffer von Nullen zurck.

; Lassen Sie uns nun den Speicher mit vielen ausgefhrten "movem.l d0-d7/a0-a6,-(sp)" 
; nacheinander lschen. Jeder Befehl setzt 60 Bytes zurck (15 Register long, das
; macht 15*4=60 Bytes) und schreibe in -(sp). Passen Sie auf, dass es vom Ende des
; Bildschirms (unten) beginnt und "nach oben geht" und so den Speicher zurckgeht.
; In hex wird das Movem als "$48E7FFFE" zusammengesetzt, es ist also genug
; eine "dcb.l number_instructions, $48e7fffe" einzugeben.

	dcb.l	170,$48e7fffe		; 60*170=10200 bytes lschen

	movem.l	d0-d7/a0-a1,-(sp)	; die Letzten 40 bytes... (total 10240)

	move.l	OldSp(pc),sp		; den alten SP zurcksetzen
	movem.l	(sp)+,d0-d7/a0-a6	; Wert der Register zurcksetzen
	rts

; 15 Longs gelscht, um in die Register geladen zu werden, um sie zu lschen

ClReg:
	dcb.l	15,0

OldSp:
	dc.l	0


****************************************************************************
* ROUTINE, DIE DIE PERSPEKTIVE DER ROTATION DURCHFHRT.					   *
*																		   *
* Quelle: Tabelle "PunkteXYZTransl", mit 3 Koordinaten XYZ pro Punkt	   *
*																		   *
* Ziel: Tabelle "PunkteXYPerspek", mit 2 Koordinaten X,Y			       *
*																		   *
* Die einzige andere Variable ist der Abstand Z des Beobachters vom        *
* Bildschirm, was in diesem Fall 256 ist, so dass Sie eine "ASL #8"        *
* anstelle von einer zeitintensiven Multiplikation ausfhren knnen.	   *
****************************************************************************

Perspektive:
	lea	PunkteXYZTransl(pc),a0	 ; Adresse Tab. der X,Y,Z aus
								 ; Projektion (bereits bewegt)
	lea	PunkteXYPerspek(pc),a1 ; Tabelle, wo die  projizierten Koordinaten X,Y
								 ; platziert werden sollen.
	move.w	#Bildschirmbreite/2,d3  ; X Bildschirmmitte (fr Mitte)
	move.w 	#Bildschirmhoehe/2,d4  ; Y Bildschirmmitte (fr Mitte)

	move.w	#NPunkteObjekt-1,d7	; Anzahl der zu projizierenden Punkte
PerspLoop:
	movem.w	(a0)+,d0-d2			; Koord. X in d0, Y in d1, Z in d2
	asl.l	#8,d0				; (MULS #256) DistZossSchermo*Xogg
	asl.l	#8,d1				; (MULS #256) DistZossSchermo*Yogg
	add.w	#256,d2			    ; Zogg+DistZossSchermo
	divs.w	d2,d0				; (DistZoss_Schermo*Xogg)/(Zogg+DistZossSchermo)
	divs.w	d2,d1				; (DistZoss_Schermo*Yogg)/(Zogg+DistZossSchermo)
	add.w	d3,d0				; + Koordinate X Mitte des Bildschirms (zur Mitte)
	add.w 	d4,d1				; + Koordinate Y Mitte des Bildschirms (zur Mitte)
	movem.w	d0-d1,(a1)			; speichern der projizierten und bewegten X- und Y-Werte
	addq.w	#2+2,a1				; zu den nchsten 2 Werten springen
	dbra 	d7,PerspLoop		; Wiederholen Sie NumberPoints-Zeiten fr alle Punkte.
	rts							; bis alle gescreent sind

****************************************************************************
* Translationsroutine, die einfach den Wert der Variablen Xadd, Yadd, Zadd * 
* zu den Objektkoordinaten addiert, wodurch die "Verschiebung" im Raum     *
* verursacht wird.														   * 
****************************************************************************

Translation:
	lea	Objekt1(pc),a0			; Koord x,y,z Objekt (Quelle)
	lea	PunkteXYZTransl(pc),a1	; Tabelle fr gedrehte Punkte X,
								; das ist das Ziel!
	move.w	#NPunkteObjekt-1,d7	; Anzahl der zu bewegenden Punkte
TrLoop:
	movem.w	(a0)+,d0/d1/d2		; X in d0, Y in d1, Z in d2
	add.w	Xadd(pc),d0			; X Translation (+ = rechts, - = links)
	add.w	Yadd(pc),d1			; Y Translation (+ = unten, - = oben)
	add.w	Zadd(pc),d2			; Z Translation (+ = zurck, - = vorwrts)
	move.w	d0,(a1)+			; X speichern in PunkteXYZTransl
	move.w	d1,(a1)+			; Y speichern in PunkteXYZTransl
	move.w	d2,(a1)+			; Z speichern in PunkteXYZTransl
	dbra 	d7,TrLoop			; Fhren Sie Anzahl der Punkte-Male aus, um
	rts							; alle Punkte zu drehen.

Xadd:
	dc.w	0
Yadd:
	dc.w	0
Zadd:
	dc.w	0

*************************************************************************
*	DREHUNG DES BILDES DURCH DIE X-, Y- UND Z-WINKEL					*
*																		*
* 1) Zunchst werden der SINUS und KOSINUS der Winkel X, Y, Z unter		*
*  Verwendung der SinCos-Subroutine gefunden, die sie wiederum von		*
*  einer Tabelle (SinTab), die aus 360 Werten besteht, d.h. 1 Wert      *
*  fr jeden mglichen Grad (von 0 bis 360) ableitet. Beachten Sie,     *
*  dass ein Trick verwendet wird, um Zahlen mit Kommas zu vermeiden:	*
*  die Werte der Sintab, die zwischen -1 und +1 liegen sollten, werden  *
*  mit  16384, was einer 14-Bit-Verschiebung nach links entspricht      *
*  multipliziert. Mit diesen "Integer" -Werten knnen wir die           *
*  Multiplikation ohne Kommas durchfhren, und sobald die Operationen   *
*  abgeschlossen sind, knnen wir die Zahl mit LSRs teilen, in dem wir  *
*  sie um 14 Bit nach rechts verschieben.								*
*																		*
* 2) Erhalten Sie den SINUS und KOSINUS der 3 Winkel,				    *
*   Berechnungen fr die Rotation erforderlich:						    *
*																	    *
*	X rotation X1,Y1 Becomes											*
*																		*
*	X2 = X1 COS(THETA) - Y1 SIN(THETA)									*
*	Y2 = Y1 COS(THETA) + X1 SIN(THETA)									*
*																		*
*	Y rotation X2,Y2 Becomes											*
*																		*
*	X3 = X2 COS(THETA) - Y2 SIN(THETA)									*
*	Y3 = Y2 COS(THETA) + X2 SIN(THETA)									*
*																		*
*	Z rotation X3,Y3 Becomes											*
*																		*
*	X4 = X3 COS(THETA) - Y3 SIN(THETA)									*
*	Y4 = Y3 COS(THETA) + X3 SIN(THETA)									*
*																		*
*	Where THETA is angle to rotate by.									*
*************************************************************************

Rotate:

; den SINUS (Zsin) und den KOSINUS (Zcos) fr den Winkel Z (Zangle) finden

	cmp.w 	#360,Zangle		; ist der Z-Winkel> 360 Grad?
	blt.s	Zok				; weniger als 360? wenn ja Zok
	clr.w	Zangle			; wenn es mehr als 360 sind, Zangle zurcksetzen
Zok:
	cmp.w	#-360,Zangle	; haben wir -360 Grad erreicht?
	BGT.s	Z1ok			; wenn noch nicht, Z1ok
	clr.w	Zangle			; wenn wir kleiner als -360 sind, Zangle zurcksetzen
Z1ok:
	move.w	Zangle(pc),d0
	bsr.w	SinCos			; den SinCos-Wert fr den Winkel in d0 finden 
							; Ausgabe: d1 = SIN, d2 = COS
	move.w	d1,Zsin			; Werte in Variablen einfgen
	move.w	d2,Zcos

; den SIN und COS des Winkels Y finden

	cmp.w	#360,Yangle		; ist der Y-Winkel >360 Grad?
	blt.s	Yok				; wenn <360, OK
	clr.w	Yangle			; sonst zurcksetzen
Yok:
	cmp.w	#-360,Yangle	; sind wir bei -360?
	BGT.s	Y1ok			; wenn >360, OK
	clr.w	Yangle			; sonst zurcksetzen
Y1ok:
	move.w	Yangle(pc),d0
	bsr.w	SinCos			; den SIN und COS der Ecke mit der TABELLE finden
	move.w	d1,Ysin			; und in die Variablen setzen
	move.w	d2,Ycos

; den SIN und COS des Winkels Z finden

	cmp.w	#360,Xangle		; ist der Winkel X > als -360?
	blt.s	Xok				; wenn kleiner, ist das in Ordnung
	clr.w	Xangle			; sonst zurcksetzen
Xok:
	cmp.w	#-360,Xangle	; ist der Winkel X < als -360?
	BGT.s	X1ok			; Wenn ja, ist das in Ordnung
	clr.w	Xangle			; sonst zurcksetzen
X1ok:
	move.w	Xangle(pc),d0
	bsr.w	SinCos			; den SINUS und KOSINUS des Winkels aus der 
	move.w	d1,Xsin			; Tabelle finden und in Xsin und Xcos setzen
	move.w	d2,Xcos

; Quellkoordinaten:
	; Projektion nach Translation und Rotation
	lea	PunkteXYZTransl(pc),a0		; Koordinate X	
	lea	PunkteXYZTransl+2(pc),a1	; Koordinate Y
	lea	PunkteXYZTransl+4(pc),a2	; Koordinate Z

*************************************************************************
* rotation az
* x1 = x0*cos(az) - y0*sin(az)
* y1 = x0*sin(az) + y0*cos(az) 
* z1 = z0

* rotation ax
* y2 = y1*cos(ax) - z1*sin(ax)
* z2 = y1*sin(ax) + z1*cos(ax)
* x2 = x1

* rotation ay
* z3 = z2*cos(ay) - x2*sin(ay)
* x3 = z2*sin(ay) + x2*cos(ay)
* y3 = y2
*************************************************************************

; Als Ziel berschreiben wir den Puffer der verschobenen Punkte

	move.w	#NPunkteObjekt-1,d0	; Anzahl der zu projizierenden Punkte
RotLoop:
; rotation az
; x1 = x0*cos(az) - y0*sin(az)
; y1 = x0*sin(az) + y0*cos(az) 
; z1 = z0 da um die z-Achse gedreht wird

ZRotate:
	move.w	Zsin(pc),d1		; d1=sin(az)
	move.w	Zcos(pc),d2		; d2=cos(az)
	move.w	(a0),d3			; d3=X0
	move.w	(a1),d4			; d4=Y0
	move.w	(a2),d7			; d7=Z1=Z0	hier unverndert
	muls.w	d3,d2			; d2=X0*cos(az)
	muls.w	d4,d1			; d1=Y0*sin(az)
	sub.l 	d1,d2			; d2=X1=X0*cos(az)-Y0*sin(az)
	lsr.l 	#8,d2			; 14-Bit-Shift rechts, geteilt durch 16384,
	lsr.l 	#6,d2			; um den wirklichen Wert zu finden
	move.w	d2,d5			; Ergebnis X1, den erhaltenen Wert in d5 speichern

	move.w	Zsin(pc),d1		; d1=sin(az)
	move.w	Zcos(pc),d2		; d2=cos(az)
	; d3=X0	; d4=Y0	; d5=X1	; d6=frei ; d7=Z1=Z0 hier unverndert
	muls.w	d3,d1			; d1=X0*sin(az)
	muls.w	d4,d2			; d2=Y0*cos(az)
	add.l	d1,d2			; d2=Y1=X0*sin(az)+Y0*cos(az)
	lsr.l 	#8,d2			; 14-Bit-Shift rechts, geteilt durch 16384,
	lsr.l 	#6,d2			; um den wirklichen Wert zu finden
	move 	d2,d6			; Ergebnis Y1, den erhaltenen Wert in d6 speichern

	; d5=X1, d6=Y1, d7=z1

; rotation ax
; y2 = y1*cos(ax) - z1*sin(ax)
; z2 = y1*sin(ax) + z1*cos(ax)
; x2 = x1 da um die x-Achse gedreht wird

XRotate:
	move.w	Xsin(pc),d1		; d1=sin(ax)
	move.w	Xcos(pc),d2		; d2=cos(ax)
	; d3=frei ; d4=frei	; d5=X2=X1	hier unverndert ; d6=Y1 ; d7=Z1	
	muls.w	d6,d2			; d2=Y1*cos(ax)
	muls.w	d7,d1			; d1=Z1*sin(ax)
	sub.l 	d1,d2			; d2=Y2=Y1*cos(ax)-Z1*sin(ax)
	lsr.l 	#8,d2			; 14-Bit-Shift rechts, geteilt durch 16384,
	lsr.l 	#6,d2			; um den wirklichen Wert zu finden
	move.w	d2,d3			; Ergebnis Y2, den erhaltenen Wert in d3 speichern

	move.w	Xsin(pc),d1		; d1=sin(ax)
	move.w	Xcos(pc),d2		; d2=cos(ax)
	; d3=Y2	; d4=frei ; d5=X2=X1 ; d6=Y1 ; d7=Z1	
	muls.w	d6,d1			; d1=Y1*sin(ax)
	muls.w	d7,d2			; d2=Z1*cos(ax)	
	add.l	d1,d2			; d2=Z2=Y1*sin(ax)+Z1*cos(ax)
	lsr.l 	#8,d2			; 14-Bit-Shift rechts, geteilt durch 16384,
	lsr.l 	#6,d2			; um den wirklichen Wert zu finden
	move 	d2,d6			; Ergebnis Z2, den erhaltenen Wert in d6 speichern
	; d5=X2, d3=Y2, d6=Z2 
	
; rotation ay
; z3 = z2*cos(ay) - x2*sin(ay)
; x3 = z2*sin(ay) + x2*cos(ay)
; y3 = y2 da um die y-Achse gedreht wird

YRotate:
	move.w	Ysin(pc),d1		; d1=sin(ay)
	move.w	Ycos(pc),d2		; d2=cos(ay)
	; d3=Y3=Y2 ; d4=frei ; d5=X2 ; d6=Z2 ; d7=frei
	muls.w	d6,d2			; d2=Z2*cos(ay)
	muls.w	d5,d1			; d1=X2*sin(ay)
	sub.l 	d1,d2			; d2=Z3=Z2*cos(ay)-X2*sin(aY)
	lsr.l 	#8,d2			; 14-Bit-Shift rechts, geteilt durch 16384,
	lsr.l 	#6,d2			; um den wirklichen Wert zu finden
	move.w	d2,d4			; Ergebnis Z3, den erhaltenen Wert in d4 speichern

	move.w	Ysin(pc),d1		; d1=sin(ay)
	move.w	Ycos(pc),d2		; d2=cos(ay)
	; d3=Y3=Y2 ; d4=Z3	; d5=X2	; d6=Z2	; d7=frei
	muls.w	d6,d1			; d1=Z2*sin(ay)
	muls.w	d5,d2			; d2=X2*cos(ay)
	add.l	d1,d2			; d2=X3=Z2*sin(ay)+X2*cos(ay)
	lsr.l 	#8,d2			; 14-Bit-Shift rechts, geteilt durch 16384,
	lsr.l 	#6,d2			; um den wirklichen Wert zu finden
	;move 	d2,d6			; Ergebnis X3, den erhaltenen Wert in d6 speichern
	; d2=X3 d3=Y3, d4=Z3 

; hier ist der Unterschied
	move.w	d2,(a0)			; speichern in pointxROT
	move.w	d3,(a1)			; speichern in pointyROT
	move.w	d4,(a2)			; speichern in pointzROT
	addq.w	#2*3,a0			; zum nchsten X gehen
	addq.w	#2*3,a1			; zum nchsten Y gehen
	addq.w	#2*3,a2			; zum nchsten Z gehen

	dbra 	d0,RotLoop		; Fhren Sie NumeroPunti-Zeiten aus, um alle
							; Punkte zu drehen.
	rts


*****************************************************************************
*	Finden Sie den Sin / Cos-Wert fr den Winkel X in d0			        *
*	Verwenden der Tabelle SinTab.w mit 360 Werten fr 360 Grad				*
*   bei der Eingabe mglich													*
*	Ausgabe: d1 = SIN(x), d2 = COS(x)									    *
*****************************************************************************

SinCos:
	tst.w	d0				; Winkel = Null?
	bpl.s	NoAddi			; wenn >0, gehe zu NoAddi
	add.w	#360,d0			; ansonsten fge ich 360 hinzu (der SIN von NULL
							; ist dasselbe wie der SIN von 360)
NoAddi:
	lea	SinTab(pc),a1		; Adresse Tabelle mit vorberechneten Sinus
	move.l 	d0,d2			; Kopieren Sie den Winkel in d2, da Sie 
							; sowohl den Sinus als auch den Cosinus finden mssen

; den Sinus finden

	add.w	d0,d0			; ich multipliziere d0 * 2, das ist der gegebene Winkel
							; da die Tabelle aus Wrtern besteht (2 Bytes)
	move.w	0(a1,d0.w),d1	; um den richtigen Sinuswert des Winkels
							; in der SinTab zu finden
; den Kosinus finden

	cmp.w	#270,d2			; der Winkel betrgt >270 Grad? (270+90=360!)
	blt.s	Plus90			; Wenn nicht, gehen Sie zu Plus90, das 90 Grad hinzufgt
							; zum Erhalten des Kosinuswinkels
	sub.w	#270,d2			; wenn >270, entfernen Sie 270, andernfalls durch Hinzufgen
							; von 90, um den Kosinus abzuleiten, wrden wir den Wert
							; 360 berschreiten; da der Kosinus gleich jedem 
							; k * 360 Grad (oder 2 kPi) ist subtrahieren wir
							; 270, dann addiere 90 (270 + 90 = 360),
							; zuerst den Kosinus des 2kPi finden.
	bra.s	SendSin

Plus90:
	add.w	#90,d2			; Ich fge 90 Grad hinzu, da der KOSINUS 
							; gleich Sinus + 90 Grad ist
SendSin:
	add.w	d2,d2			; Ich multipliziere den Winkel * 2 , da die
							; Tabelle aus Wrtern (2 Bytes) besteht 
	move.w	(a1,d2),d2		; um den richtigen KOSINUS-Wert zu finden
	rts						; aus der Tabelle durch Hinzufgen von d2 zur Adresse
							; Beginn der Tabelle.


******************************************************************************
**	ROUTINE ZUM ZEICNEN DES 3D OBJEKTES AUF DER Bitplane (mit Punkten!)	    **
******************************************************************************

DesignObject:
	lea	PunkteXYPerspek(pc),a4 ; Puffer Koordinate X und Y
	moveq	#NPunkteObjekt-1,d7	; Anzahl der zu zeichnenden Punkte
	move.l	DrawPlane(pc),a0	; aktuelle Bildschirmadresse in a0
PlotLoop:
	movem.w	(a4)+,d0-d1			; Koord X in d0 und Koord Y in d1
	bsr.s	PlotPix				; Punkt drucken auf Koordinate X=d0, Y=d1
	dbra	d7,PlotLoop		; alle Punkte drucken
	rts

*****************************************************************************
;			Routine zur Darstellung von Punkten (dots)
*****************************************************************************

;	Eingabeparameter PlotPix:
;
;	a0 = Adresse Bitplane Ziel
;	d0.w = Koordinate X (0-319)
;	d1.w = Koordinate Y (0-255)

DISPLAYWIDTH	equ	40	; Bildschirmbreite in Bytes

PlotPix:
	cmp.w	#320,d0				; sind wir raus?
	blo.s	Ok1
	rts
Ok1:
	cmp.w	#256,d1				; sind wir raus?
	blo.s	Ok2
	rts
Ok2:
	move.w	d0,d2				; Kopie der X Koordinate in d2
	lsr.w	#3,d0				; In der Zwischenzeit finden Sie den horizontalen Versatz,
								; durch Teilen der X-Koordinate durch 8.
	mulu.w	#DISPLAYWIDTH,d1
	add.w	d1,d0				; Summenversatz vertikal bis horizontal

	and.w	#%111,d2			; Whlen Sie nur die ersten 3 Bits von X
								; (Eigentlich wre es der Rest der Division
								; fr 8 frher gemacht)
	not.w	d2

	bset.b	d2,(a0,d0.w)		; Setzt das d2-Bit des entfernten Bytes d0 Bytes
								; vom Anfang des Bildschirms.
	rts

******************************************************************************
* Definition des 3D-Volumenkrpers durch die X-, Y-, Z-Koordinaten seiner Punkte.  *
******************************************************************************

;	WENIGER< X >MEHR'		WENIGER			MEHR'
;							 ^				/|
;							 Y		       Z
;							 v		     |/
;							MEHR'		   WENIGER

;	      (P4) -50,-50,+50______________+50,-50,+50 (P5)
;					     /|			   /|
;					    / |		      / |
;					   /  |			 /  |
;					  /   |			/   |
;	 (P0) -50,-50,-50/____|________/+50,-50,-50 (P1)
;					|     |       |     |
;				    |     |_______|_____|+50,+50,+50 (P6)
;					|    /-50,+50,+50 (P7)
;					|   /	      |   /
;					|  /	      |  /
;					| /			  | /
;					|/____________|/+50,+50,-50 (P2)
;	 (P3) -50,+50,-50

Objekt1:  ; Hier sind die 8 durch die Koordinate  X, Y, Z definierten Punkte.
	dc.w	-50,-50,-50	; P0 (X,Y,Z)
	dc.w	+50,-50,-50	; P1 (X,Y,Z)
	dc.w	+50,+50,-50	; P2 (X,Y,Z)
	dc.w	-50,+50,-50	; P3 (X,Y,Z)
	dc.w	-50,-50,+50	; P4 (X,Y,Z)
	dc.w	+50,-50,+50	; P5 (X,Y,Z)
	dc.w	+50,+50,+50	; P6 (X,Y,Z)
	dc.w	-50,+50,+50	; P7 (X,Y,Z)

NPunkteObjekt	= 8

******************************************************************************
;		    Daten und Variablen der Routine									 *
******************************************************************************

Xangle:	dc.w	0
Yangle:	dc.w	0
Zangle:	dc.w	0

Xsin:	dc.w 0
Xcos:	dc.w 0

Ysin:	dc.w 0
Ycos:	dc.w 0

Zsin:	dc.w 0
Zcos:	dc.w 0

; X- und Y-Koordinaten des URSPRUNGS der Achsen in Bezug auf den Bildschirm 
; in diesem Fall platzieren wir sie in der Mitte.

; --------------------------------------------------------------------------

; Puffer fr genderte Punkte (gedreht und / oder bewegt im 3D-Raum).

PunkteXYZTransl:
	ds.w	NPunkteObjekt*3

; --------------------------------------------------------------------------

; Koordinaten X und Y projiziert, dh perspektivisch, bereit gezeichnet zu
; werden. Die Koordinaten werden paarweise im Puffer gespeichert
; Aufeinanderfolgende X und Y: XY, XY, XY, XY, XY ..., ein Wort fr jede Koordinate.

PunkteXYPerspek:
	ds.w	NPunkteObjekt*2

*************************************************************************
*		Daten fr die Tabelle der Sinus / Cosinus:						*
*																		*
* Die Verwendung von Gleitkommazahlen macht Berechnungen zu gro,		*
* um  3D-Bilder in Echtzeit erstellen zu knnen.						*
* Zum Beispiel ist der SIN(1) 0,01745, der SIN(2) ist 0,03489 usw.	*
* In diesem Fall haben wir ein "Erweiterung" verwendet, in der Tat alle *
* Werte werden zuerst mit 16384 multipliziert.							*
* Tatschlich ist 0,01745*16384 gleich 286, 0,3489*16384 gleich 572, 	*
* usw. fr die anderen Werte in der SinTab.								*
* Der Trick zur Geschwindigkeit ist das Multiplizieren mit 16384		*
* es bedeutet SHIFT 14 Bit nach links, um die Werte	zu finden			*
* Wert nur SHIFT nach rechts von 14 Bit mit diesen 2 Anweisungen:	    *
*																		*
*	lsr.l 	#8,d2	; 14 bit shift nach rechts							*
*	lsr.l 	#6,d2	; Teilen durch 16384								*
*																		*
* Auf diese Weise entfernen wir das Komma, und multiplizieren und		*
* dividieren mit dem "vergrerten" Wert, dann dividiert man das		*
* Ergebnis durch 16384 mit den zwei zuvor gesehene LSRs.				*
* Diese Tabelle ist im Dezimalformat, um das ihren Inhalt besser zu		*
* verstehen. Wenn Sie es mit "IS" noch einmal machen mchten, 			*
* sind die Parameter natrlich:											*
*																		*
* BEG>0																	*
* end>360																*
* AMOUNT>360															*
* AMPLITUDE>16384														*
* YOFFSET>0																*
* SIZE (B/W/L)>W														*
* MULTIPLIER>1															*
*																		*
*************************************************************************

SinTab:
	dc.w 0,286,572,857,1143,1428,1713,1997,2280
	dc.w 2563,2845,3126,3406,3686,3964,4240,4516
	dc.w 4790,5063,5334,5604,5872,6138,6402,6664
	dc.w 6924,7182,7438,7692,7943,8192,8438,8682	
	dc.w 8923,9162,9397,9630,9860,10087,10311,10531
	dc.w 10749,10963,11174,11381,11585,11786,11982,12176
	dc.w 12365,12551,12733,12911,13085,13255,13421,13583
	dc.w 13741,13894,14044,14189,14330,14466,14598,14726
	dc.w 14849,14968,15082,15191,15296,15396,15491,15582
	dc.w 15668,15749,15826,15897,15964,16026,16083,16135
	dc.w 16182,16225,16262,16294,16322,16344,16362,16374
	dc.w 16382,16384
	dc.w 16382
	dc.w 16374,16362,16344,16322,16294,16262,16225,16182
	dc.w 16135,16083,16026,15964,15897,15826,15749,15668	
	dc.w 15582,15491,15396,15296,15191,15082,14967,14849
	dc.w 14726,14598,14466,14330,14189,14044,13894,13741	
	dc.w 13583,13421,13255,13085,12911,12733,12551,12365
	dc.w 12176,11982,11786,11585,11381,11174,10963,10749
	dc.w 10531,10311,10087,9860,9630,9397,9162,8923
	dc.w 8682,8438,8192,7943,7692,7438,7182,6924
	dc.w 6664,6402,6138,5872,5604,5334,5063,4790
	dc.w 4516,4240,3964,3686,3406,3126,2845,2563
	dc.w 2280,1997,1713,1428,1143,857,572,286,0
	dc.w -286,-572,-857,-1143,-1428,-1713,-1997,-2280
	dc.w -2563,-2845,-3126,-3406,-3686,-3964,-4240,-4516
	dc.w -4790,-5063,-5334,-5604,-5872,-6138,-6402,-6664
	dc.w -6924,-7182,-7438,-7692,-7943,-8192,-8438,-8682	
	dc.w -8923,-9162,-9397,-9630,-9860,-10087,-10311,-10531
	dc.w -10749,-10963,-11174,-11381,-11585,-11786,-11982,-12176
	dc.w -12365,-12551,-12733,-12911,-13085,-13255,-13421,-13583
	dc.w -13741,-13894,-14044,-14189,-14330,-14466,-14598,-14726
	dc.w -14849,-14968,-15082,-15191,-15296,-15396,-15491,-15582
	dc.w -15668,-15749,-15826,-15897,-15964,-16026,-16083,-16135
	dc.w -16182,-16225,-16262,-16294,-16322,-16344,-16362,-16374
	dc.w -16382,-16384
	dc.w -16382
	dc.w -16374,-16362,-16344,-16322,-16294,-16262,-16225,-16182
	dc.w -16135,-16083,-16026,-15964,-15897,-15826,-15749,-15668	
	dc.w -15582,-15491,-15396,-15296,-15191,-15082,-14967,-14849
	dc.w -14726,-14598,-14466,-14330,-14189,-14044,-13894,-13741	
	dc.w -13583,-13421,-13255,-13085,-12911,-12733,-12551,-12365
	dc.w -12176,-11982,-11786,-11585,-11381,-11174,-10963,-10749
	dc.w -10531,-10311,-10087,-9860,-9630,-9397,-9162,-8923
	dc.w -8682,-8438,-8192,-7943,-7692,-7438,-7182,-6924
	dc.w -6664,-6402,-6138,-5872,-5604,-5334,-5063,-4790
	dc.w -4516,-4240,-3964,-3686,-3406,-3126,-2845,-2563
	dc.w -2280,-1997,-1713,-1428,-1143,-857,-572,-286
	dc.w 0

; --------------------------------------------------------------------------

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,0
	dc.w	$122,0
	dc.w	$008e,$2c81
	dc.w	$0090,$20c1
	dc.w	$0092,$0038
	dc.w	$0094,$00d0
	dc.w	$0108,0
	dc.w	$010a,0
	dc.w	$0102,0
	dc.w	$100,%0001001000000000
	dc.w	$180,0,$182,$ffff,$184,$ffff
BplPointer:
	dc.w	$e0,0,$e2,0
	dc.w	$ffff,$fffe

	SECTION	LEEREPLANE,BSS_C

Bitplane0:
	ds.b	40*Bildschirmhoehe

Bitplane:
	ds.b	40*Bildschirmhoehe

	end

