
; Listing173.s = Wind.S

	section	name,code_c

;BASE=$60000-2

Trap_vec0  = $80
Execbase   = $4
Oldopen    = -$198
Intenar    = $01c
Intena     = $09a
Dmaconr    = $002
Dmacon     = $096
Cop1lch    = $080
Copjmp1    = $088
Vposr      = $004

	Move.l	#Start,$80.w	; Trap vector 0
	Trap	#0		; Execute trap 0 to give full control of the
	Rts			; 68000, needs an RTE to return.

Start:
	bsr	copint
	bsr	sprinito
	bsr	KillSys
	bsr	main
	bsr	setupsys

	Rte		; Return from exception 
		

*****************************************************************************
;Killsys - Disable operating system and interrupts
*****************************************************************************
Killsys:
	Move.l	$4.w,a6		; Execbase vector
	Lea	Gfxname(pc),a1	; Pointer to "graphics.library" into a1
	Jsr	Oldopen(a6)	; Open this library
	Lea	$dff000,a6	; Pointer to custom chips
	Move.l	d0,a0		; Address of the graphics library
	Move.l	38(a0),Sys_copl		; Remember the System copperlist
	Move	Intenar(a6),Int_set	; System interrupts
	Move	#$7fff,Intena(a6)	; Now switch off all interrupts
	Move.l	$6c.w,Vbl_vec		; System vertical blanking int.
	Move	Dmaconr(a6),Dma_set	; System DMA
	Move	#$7fff,Dmacon(a6)	; Clear all DMA
	Move	#$87e0,Dmacon(a6)	; Now set the required DMA channels

	Move.l	#cop,Cop1lch(a6)	; Init. our own copperlist
	Clr	Copjmp1(a6)

	Rts

Gfxname:	Dc.b "graphics.library",0
	Even
*****************************************************************************
;Sysreturn - Re-enable operating system and interrupts
*****************************************************************************
Setupsys:
	Lea	$dff000,a6
	Move	#$7fff,Intena(a6)	; Clear all interrupts
	Move.l	Vbl_vec,$6c.w	; Restore VBL interrupt
	Move	Int_set,d0
	Or	#$c000,d0
	Move	d0,Intena(a6)		; Restore system interrupts
	Move	#$7fff,Dmacon(a6)
	Move	Dma_set,d0
	Or	#$8200,d0
	Move	d0,Dmacon(a6)		; Restore system DMA
	Move.l	Sys_copl,Cop1lch(a6)	; Restore system copperlist
	Clr	Copjmp1(a6)
	Rts

Vbl_vec:          dc.l 0
Int_set:          dc.l 0
Dma_set:          dc.l 0
Sys_copl:          dc.l 0


Main:
	LEA	$00DFF000,A6

Main2:	Move.l	Vposr(a6),d0
	And.l	#$1ff00,d0
	Cmp.l	#$0f100,d0	; Wait for vertical position 1
	Bne.s	Main2

	bsr	l0
	bsr	SPRIT


	; ROUTINE ;

	Btst	#6,$bfe001	; Check the left mouse button
	Bne.s	Main

	Rts

TOUCH1:		DC.L	0
TEXTPOINTER:	DC.L	TEXT

ADD2:		DC.W	0
ADD4:		DC.W	0

;A-Z,0-9

TEXT:		DC.B	"HALLO OUT THEREZZZZZZZZZZZZZZZZ",0
EVEN




l0:	BTST	#14,2(A6)
	BNE.S	l0
	MOVE.L	#$FFFFFFFF,$0044(A6)
	MOVE.L	#ZWTAB+8,$0050(A6)	
	MOVE.L	#ZWTAB,$0054(A6)	
	MOVE.L	#$09F00000,$0040(A6)
	CLR.L	$0064(A6)
	MOVE.W	#$3482,$0058(A6)
	MOVE.L	TEXTPOINTER(PC),A0
	LEA	BASELINIE(PC),A1	
	LEA	ENTAB(PC),A2		
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0	
	SUB.W	#$0020,D0
	MULU	#$B8,D0
	LEA	0(A1,D0.W),A1
	ADD.L	TOUCH1(PC),A1
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)
	ADD.L	#8,TOUCH1
	CMP.L	#$000000B8,TOUCH1
	BNE.S	lC8
	CLR.L	TOUCH1
	MOVE.L	A0,TEXTPOINTER
	CMP.B	#00,(A0)
	BNE.S	lC8
	MOVE.L	#TEXT,TEXTPOINTER
lC8:	RTS	

SPRIT:	LEA	SPR0+4(PC),A0	
	LEA	SPR0+852(PC),A1	
	LEA	SINUSOID(PC),A3
	LEA	ZWTAB(PC),A4	
	LEA	COPBLOCK(PC),A5	
	MOVE.W	ADD2(PC),D1	
	MOVE.W	ADD4(PC),D2	
	MOVE.L	#0,D3
	MOVE.W	#$00D2,D7
 
l106:	MOVE.W	0(A3,D1.W),D0
	ADD.W	0(A3,D2.W),D0
	ADDQ.W	#4,D1
	ADDQ.W	#2,D2
	AND.W	#$03FE,D1
	AND.W	#$03FE,D2
	TST.L	(A4)
	BEQ	l1E2
	MOVE.L	(A4)+,A2
	MOVE.L	0(A2,D0.W),(A0)+
	MOVE.L	4(A2,D0.W),(A1)+
	SUB.W	#$1670,D0
	NEG.W	D0
	MOVE.L	0(A2,D0.W),$069C(A0)
	MOVE.L	4(A2,D0.W),$069C(A1)
	LEA	KOOTAB(PC),A6
	LEA	0(A6,D0.W),A6
	MOVE.W	(A6),$002E(A5)
	MOVE.W	2(A6),$0032(A5)
	MOVE.W	4(A6),6(A5)
	MOVE.W	6(A6),10(A5)
	BTST	#6,D0
	BEQ.S	l17E
	MOVE.B	D3,15(A5)
	MOVE.B	D3,$0013(A5)
	MOVE.B	#1,$0017(A5)
	MOVE.B	#1,$001B(A5)
	BRA	l192
 
l17E:	MOVE.B	#1,15(A5)
	MOVE.B	#1,$0013(A5)
	MOVE.B	D3,$0017(A5)
	MOVE.B	D3,$001B(A5)
l192:	LSR.W	#7,D0
	ADD.B	#$5C,D0
	MOVE.B	D0,$0027(A5)
	ADDQ.B	#8,D0
	MOVE.B	D0,$002B(A5)
	NEG.B	D0
	SUB.B	#$EB,D0
	MOVE.B	D0,$001F(A5)
	ADDQ.B	#8,D0
	MOVE.B	D0,$0023(A5)
	LEA	$0038(A5),A5
	DBRA	D7,l106
	SUBQ.W	#4,ADD2
	ADDQ.W	#2,ADD4
	AND.W	#$03FE,ADD2
	AND.W	#$03FE,ADD4
	RTS	
 
l1E2:	ADDQ.L	#4,A4
	MOVE.L  D3,$06A0(A0)
	MOVE.L	D3,(A0)+
	MOVE.L	D3,$06A0(A1)
	MOVE.L	D3,(A1)+
	LEA	$0038(A5),A5
	DBRA	D7,l106
	SUBQ.W	#4,ADD2
	ADDQ.W	#2,ADD4
	AND.W	#$03FE,ADD2
	AND.W	#$03FE,ADD4
	RTS	

COPINT:
	LEA	COPBLOCK(PC),A0
	MOVE.L	#$2C01FFFE,D0
	MOVE.W	#$D2,D7
JACK:
	MOVE.L	D0,(A0)+
	MOVE.L	#$01A20000,(A0)+
	MOVE.L	#$01A40000,(A0)+
	MOVE.L	#$01420000,(A0)+
	MOVE.L	#$014A0000,(A0)+
	MOVE.L	#$01520000,(A0)+
	MOVE.L	#$015A0000,(A0)+
	MOVE.L	#$01400000,(A0)+
	MOVE.L	#$01480000,(A0)+
	MOVE.L	#$01500000,(A0)+
	MOVE.L	#$01580000,(A0)+
	MOVE.L	#$01AA0000,(A0)+
	MOVE.L	#$01AC0000,(A0)+
	MOVE.L	#$01800000,(A0)+
	
	ADD.L	#$01000000,D0
	DBF	D7,JACK
	RTS

SPRINITO:
	MOVE.L	#SPR0,D0
	LEA	SPRBASE(pc),A0
	MOVE.W	D0,6(A0)
	SWAP	D0
	MOVE.W	D0,2(A0)
	SWAP	D0
	ADD.L	#848,D0
	MOVE.W	D0,14(A0)
	SWAP	D0
	MOVE.W	D0,10(A0)
	SWAP	D0
	ADD.L	#848,D0
	MOVE.W	D0,22(A0)
	SWAP	D0
	MOVE.W	D0,18(A0)
	SWAP	D0
	ADD.L	#848,D0
	MOVE.W	D0,30(A0)
	SWAP	D0
	MOVE.W	D0,26(A0)
	RTS


sinusoid:
	DC.L	$05A005B0,$05C005D0,$05E005F8,$06080618,$06280638,$06480660
	DC.L	$06700680,$069006A0,$06B806C8,$06D806E8,$06F80708,$07180728
	DC.L	$07400750,$07600770,$07800790,$07A007B0,$07C007D0,$07E007F0
	DC.L	$08000810,$08200830,$08400850,$08600870,$08800890,$08A008A8
	DC.L	$08B808C8,$08D808E8,$08F00900,$09100920,$09280938,$09480950
	DC.L	$09600970,$09780988,$099009A0,$09B009B8,$09C809D0,$09D809E8
	DC.L	$09F00A00,$0A080A10,$0A200A28,$0A300A40,$0A480A50,$0A580A60
	DC.L	$0A680A78,$0A800A88,$0A900A98,$0AA00AA8,$0AB00AB8,$0AC00AC0
	DC.L	$0AC80AD0,$0AD80AE0,$0AE80AE8,$0AF00AF8,$0AF80B00,$0B000B08
	DC.L	$0B100B10,$0B180B18,$0B200B20,$0B200B28,$0B280B28,$0B300B30
	DC.L	$0B300B30,$0B380B38,$0B380B38,$0B380B38,$0B380B38,$0B380B38
	DC.L	$0B380B38,$0B380B30,$0B300B30,$0B300B28,$0B280B28,$0B200B20
	DC.L	$0B200B18,$0B180B10,$0B100B08,$0B000B00,$0AF80AF8,$0AF00AE8
	DC.L	$0AE80AE0,$0AD80AD0,$0AC80AC0,$0AC00AB8,$0AB00AA8,$0AA00A98
	DC.L	$0A900A88,$0A800A78,$0A680A60,$0A580A50,$0A480A40,$0A300A28
	DC.L	$0A200A10,$0A080A00,$09F009E8,$09D809D0,$09C809B8,$09B009A0
	DC.L	$09900988,$09780970,$09600950,$09480938,$09280920,$09100900
	DC.L	$08F008E8,$08D808C8,$08B808A8,$08A00890,$08800870,$08600850
	DC.L	$08400830,$08200810,$080007F0,$07E007D0,$07C007B0,$07A00790
	DC.L	$07800770,$07600750,$07400728,$07180708,$06F806E8,$06D806C8
	DC.L	$06B806A0,$06900680,$06700660,$06480638,$06280618,$060805F8
	DC.L	$05E005D0,$05C005B0,$05980588,$05780568,$05580540,$05300520
	DC.L	$05100500,$04F004D8,$04C804B8,$04A80498,$04800470,$04600450
	DC.L	$04400430,$04200410,$03F803E8,$03D803C8,$03B803A8,$03980388
	DC.L	$03780368,$03580348,$03380328,$03180308,$02F802E8,$02D802C8
	DC.L	$02B802A8,$02980290,$02800270,$02600250,$02480238,$02280218
	DC.L	$02100200,$01F001E8,$01D801C8,$01C001B0,$01A80198,$01880180
	DC.L	$01700168,$01600150,$01480138,$01300128,$01180110,$010800F8
	DC.L	$00F000E8,$00E000D8,$00D000C0,$00B800B0,$00A800A0,$00980090
	DC.L	$00880080,$00780078,$00700068,$00600058,$00500050,$00480040
	DC.L	$00400038,$00380030,$00280028,$00200020,$00180018,$00180010
	DC.L	$00100010,$00080008,$00080008,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000008,$00080008,$00080010
	DC.L	$00100010,$00180018,$00180020,$00200028,$00280030,$00380038
	DC.L	$00400040,$00480050,$00500058,$00600068,$00700078,$00780080
	DC.L	$00880090,$009800A0,$00A800B0,$00B800C0,$00D000D8,$00E000E8
	DC.L	$00F000F8,$01080110,$01180128,$01300138,$01480150,$01600168
	DC.L	$01780180,$01880198,$01A801B0,$01C001C8,$01D801E8,$01F00200
	DC.L	$02100218,$02280238,$02480250,$02600270,$02800290,$029802A8
	DC.L	$02B802C8,$02D802E8,$02F80308,$03180328,$03380348,$03580368
	DC.L	$03780388,$039803A8,$03B803C8,$03D803E8,$03F80410,$04200430
	DC.L	$04400450,$04600470,$04800498,$04A804B8,$04C804D8,$04F00500
	DC.L	$05100520,$05300540,$05580568,$05780588


KOOTAB:
	DC.L	$00000DFD,$06300FD9,$00000CED,$06300ED9,$00000CED,$06300EC9
	DC.L	$00000CED,$06300EC9,$00000CED,$06300EC9,$00000CED,$06300EC9
	DC.L	$00000CED,$06300EC9,$00000CED,$06300EC9,$00000CED,$06300EC9
	DC.L	$00000CED,$06300EC9,$00000CED,$06300EC9,$00000CED,$06300EC9
	DC.L	$00100CED,$06300EC9,$00100CDD,$06300EC9,$01110BDC,$06300EC9
	DC.L	$01110BDC,$06300EC9,$01110BDC,$06300EC9,$01110BDC,$06300EC9
	DC.L	$01110BDC,$06400EC9,$01110BDC,$06400EC9,$01110BDC,$07410EB8
	DC.L	$01110BDC,$07410DB8,$01110BDC,$07410DB8,$01110BDC,$07410DB8
	DC.L	$01210BDC,$07410DB8,$01210BCC,$07410DB8,$01210BCC,$07410DB8
	DC.L	$01210BCC,$07410DB8,$02220ACB,$07410DB8,$02220ACB,$07410DB8
	DC.L	$02220ACB,$07410DB8,$02220ACB,$07410DB8,$02220ACB,$07410DB8
	DC.L	$02220ACB,$07410DB8,$02220ACB,$07410DB8,$02220ACB,$07410DB8
	DC.L	$02320ACB,$07510DB8,$02320ABB,$07510DB8,$02320ABB,$07510DA8
	DC.L	$02320ABB,$07510DA8,$02320ABB,$08520DA7,$02320ABB,$08520CA7
	DC.L	$033309BA,$08520CA7,$033309BA,$08520CA7,$033309BA,$08520CA7
	DC.L	$033309BA,$08520CA7,$033309BA,$08520CA7,$033309BA,$08520CA7
	DC.L	$034309BA,$08520CA7,$034309AA,$08520CA7,$034309AA,$08520CA7
	DC.L	$034309AA,$08520CA7,$034309AA,$08520CA7,$034309AA,$08520CA7
	DC.L	$034309AA,$08620CA7,$034309AA,$08620CA7,$044408A9,$08620C97
	DC.L	$044408A9,$08620C97,$044408A9,$08620C97,$044408A9,$08620C97
	DC.L	$045408A9,$09630C96,$04540899,$09630B96,$04540899,$09630B96
	DC.L	$04540899,$09630B96,$04540899,$09630B96,$04540899,$09630B96
	DC.L	$04540899,$09630B96,$04540899,$09630B96,$04540899,$09630B96
	DC.L	$04540899,$09630B96,$05550798,$09630B96,$05550798,$09630B96
	DC.L	$05650798,$09730B96,$05650788,$09730B96,$05650788,$09730B86
	DC.L	$05650788,$09730B86,$05650788,$09730B86,$05650788,$09730B86
	DC.L	$05650788,$09730B86,$05650788,$09730B86,$05650788,$0A740B85
	DC.L	$05650788,$0A740A85,$05650788,$0A740A85,$05650788,$0A740A85
	DC.L	$06760687,$0A740A85,$06760677,$0A740A85,$06760677,$0A740A85
	DC.L	$06760677,$0A740A85,$06760677,$0A740A85,$06760677,$0A740A85
	DC.L	$06760677,$0A840A85,$06760677,$0A840A85,$06760677,$0A840A75
	DC.L	$06760677,$0A840A75,$06760677,$0A840A75,$06760677,$0A840A75
	DC.L	$06860677,$0A840A75,$07870566,$0A840A75,$07870566,$0A840A75
	DC.L	$07870566,$0A840A75,$07870566,$0B850A74,$07870566,$0B850974
	DC.L	$07870566,$0B850974,$07870566,$0B850974,$07870566,$0B850974
	DC.L	$07870566,$0B850974,$07870566,$0B850974,$07870566,$0B850974
	DC.L	$07970566,$0B950974,$07970556,$0B950974,$07970556,$0B950964
	DC.L	$08980455,$0B950964,$08980455,$0B950964,$08980455,$0B950964
	DC.L	$08980455,$0B950964,$08980455,$0B950964,$08980455,$0B950964
	DC.L	$08980455,$0B950964,$08980455,$0B950964,$08980455,$0B950964
	DC.L	$08A80455,$0C960963,$08A80445,$0C960863,$08A80445,$0C960863
	DC.L	$08A80445,$0C960863,$08A80445,$0C960863,$09A90344,$0C960863
	DC.L	$09A90344,$0CA60863,$09A90344,$0CA60863,$09A90344,$0CA60853
	DC.L	$09A90344,$0CA60853,$09A90344,$0CA60853,$09A90344,$0CA60853
	DC.L	$09B90344,$0CA60853,$09B90334,$0CA60853,$09B90334,$0CA60853
	DC.L	$09B90334,$0CA60853,$09B90334,$0CA60853,$09B90334,$0CA60853
	DC.L	$09B90334,$0CA60853,$0ABA0233,$0CA60853,$0ABA0233,$0DA70852
	DC.L	$0ABA0233,$0DA70752,$0ABA0233,$0DA70752,$0ABA0233,$0DA70752
	DC.L	$0ACA0233,$0DB70752,$0ACA0223,$0DB70752,$0ACA0223,$0DB70742
	DC.L	$0ACA0223,$0DB70742,$0ACA0223,$0DB70742,$0ACA0223,$0DB70742
	DC.L	$0ACA0223,$0DB70742,$0ACA0223,$0DB70742,$0ACA0223,$0DB70742
	DC.L	$0BCB0122,$0DB70742,$0BCB0122,$0DB70742,$0BCB0122,$0DB70742
	DC.L	$0BDB0122,$0DB70742,$0BDB0112,$0DB70742,$0BDB0112,$0DB70742
	DC.L	$0BDB0112,$0DB70742,$0BDB0112,$0EB80741,$0BDB0112,$0EB80641
	DC.L	$0BDB0112,$0EC80641,$0BDB0112,$0EC80641,$0BDB0112,$0EC80631
	DC.L	$0BDB0112,$0EC80631,$0BDB0112,$0EC80631,$0CDC0011,$0EC80631
	DC.L	$0CEC0011,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0CEC0001,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0CEC0001,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0CEC0001,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0DFD0000,$0FD90630,$0CED0000,$0ED90630,$0CED0000,$0EC90630
	DC.L	$0CED0000,$0EC90630,$0CED0000,$0EC90630,$0CED0000,$0EC90630
	DC.L	$0CED0000,$0EC90630,$0CED0000,$0EC90630,$0CED0000,$0EC90630
	DC.L	$0CED0000,$0EC90630,$0CED0000,$0EC90630,$0CED0000,$0EC90630
	DC.L	$0CED0010,$0EC90630,$0CDD0010,$0EC90630,$0BDC0111,$0EC90630
	DC.L	$0BDC0111,$0EC90630,$0BDC0111,$0EC90630,$0BDC0111,$0EC90630
	DC.L	$0BDC0111,$0EC90640,$0BDC0111,$0EC90640,$0BDC0111,$0EB80741
	DC.L	$0BDC0111,$0DB80741,$0BDC0111,$0DB80741,$0BDC0111,$0DB80741
	DC.L	$0BDC0121,$0DB80741,$0BCC0121,$0DB80741,$0BCC0121,$0DB80741
	DC.L	$0BCC0121,$0DB80741,$0ACB0222,$0DB80741,$0ACB0222,$0DB80741
	DC.L	$0ACB0222,$0DB80741,$0ACB0222,$0DB80741,$0ACB0222,$0DB80741
	DC.L	$0ACB0222,$0DB80741,$0ACB0222,$0DB80741,$0ACB0222,$0DB80741
	DC.L	$0ACB0232,$0DB80751,$0ABB0232,$0DB80751,$0ABB0232,$0DA80751
	DC.L	$0ABB0232,$0DA80751,$0ABB0232,$0DA70852,$0ABB0232,$0CA70852
	DC.L	$09BA0333,$0CA70852,$09BA0333,$0CA70852,$09BA0333,$0CA70852
	DC.L	$09BA0333,$0CA70852,$09BA0333,$0CA70852,$09BA0333,$0CA70852
	DC.L	$09BA0343,$0CA70852,$09AA0343,$0CA70852,$09AA0343,$0CA70852
	DC.L	$09AA0343,$0CA70852,$09AA0343,$0CA70852,$09AA0343,$0CA70852
	DC.L	$09AA0343,$0CA70862,$09AA0343,$0CA70862,$08A90444,$0C970862
	DC.L	$08A90444,$0C970862,$08A90444,$0C970862,$08A90444,$0C970862
	DC.L	$08A90454,$0C960963,$08990454,$0B960963,$08990454,$0B960963
	DC.L	$08990454,$0B960963,$08990454,$0B960963,$08990454,$0B960963
	DC.L	$08990454,$0B960963,$08990454,$0B960963,$08990454,$0B960963
	DC.L	$08990454,$0B960963,$07980555,$0B960963,$07980555,$0B960963
	DC.L	$07980565,$0B960973,$07880565,$0B960973,$07880565,$0B860973
	DC.L	$07880565,$0B860973,$07880565,$0B860973,$07880565,$0B860973
	DC.L	$07880565,$0B860973,$07880565,$0B860973,$07880565,$0B850A74
	DC.L	$07880565,$0A850A74,$07880565,$0A850A74,$07880565,$0A850A74
	DC.L	$06870676,$0A850A74,$06770676,$0A850A74,$06770676,$0A850A74
	DC.L	$06770676,$0A850A74,$06770676,$0A850A74,$06770676,$0A850A74
	DC.L	$06770676,$0A850A84,$06770676,$0A850A84,$06770676,$0A750A84
	DC.L	$06770676,$0A750A84,$06770676,$0A750A84,$06770676,$0A750A84
	DC.L	$06770686,$0A750A84,$05660787,$0A750A84,$05660787,$0A750A84
	DC.L	$05660787,$0A750A84,$05660787,$0A740B85,$05660787,$09740B85
	DC.L	$05660787,$09740B85,$05660787,$09740B85,$05660787,$09740B85
	DC.L	$05660787,$09740B85,$05660787,$09740B85,$05660787,$09740B85
	DC.L	$05660797,$09740B95,$05560797,$09740B95,$05560797,$09640B95
	DC.L	$04550898,$09640B95,$04550898,$09640B95,$04550898,$09640B95
	DC.L	$04550898,$09640B95,$04550898,$09640B95,$04550898,$09640B95
	DC.L	$04550898,$09640B95,$04550898,$09640B95,$04550898,$09640B95
	DC.L	$045508A8,$09630C96,$044508A8,$08630C96,$044508A8,$08630C96
	DC.L	$044508A8,$08630C96,$044508A8,$08630C96,$034409A9,$08630C96
	DC.L	$034409A9,$08630CA6,$034409A9,$08630CA6,$034409A9,$08530CA6
	DC.L	$034409A9,$08530CA6,$034409A9,$08530CA6,$034409A9,$08530CA6
	DC.L	$034409B9,$08530CA6,$033409B9,$08530CA6,$033409B9,$08530CA6
	DC.L	$033409B9,$08530CA6,$033409B9,$08530CA6,$033409B9,$08530CA6
	DC.L	$033409B9,$08530CA6,$02330ABA,$08530CA6,$02330ABA,$08520DA7
	DC.L	$02330ABA,$07520DA7,$02330ABA,$07520DA7,$02330ABA,$07520DA7
	DC.L	$02330ACA,$07520DB7,$02230ACA,$07520DB7,$02230ACA,$07420DB7
	DC.L	$02230ACA,$07420DB7,$02230ACA,$07420DB7,$02230ACA,$07420DB7
	DC.L	$02230ACA,$07420DB7,$02230ACA,$07420DB7,$02230ACA,$07420DB7
	DC.L	$01220BCB,$07420DB7,$01220BCB,$07420DB7,$01220BCB,$07420DB7
	DC.L	$01220BDB,$07420DB7,$01120BDB,$07420DB7,$01120BDB,$07420DB7
	DC.L	$01120BDB,$07420DB7,$01120BDB,$07410EB8,$01120BDB,$06410EB8
	DC.L	$01120BDB,$06410EC8,$01120BDB,$06410EC8,$01120BDB,$06310EC8
	DC.L	$01120BDB,$06310EC8,$01120BDB,$06310EC8,$00110CDC,$06310EC8
	DC.L	$00110CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00010CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00010CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00010CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00000DFD,$06300FD9,$00000CED,$06300ED9,$00000CED,$06300EC9
	DC.L	$00000CED,$06300EC9,$00000CED,$06300EC9,$00000CED,$06300EC9
	DC.L	$00000CED,$06300EC9,$00000CED,$06300EC9,$00000CED,$06300EC9
	DC.L	$00000CED,$06300EC9,$00000CED,$06300EC9,$00000CED,$06300EC9
	DC.L	$00100CED,$06300EC9,$00100CDD,$06300EC9,$01110BDC,$06300EC9
	DC.L	$01110BDC,$06300EC9,$01110BDC,$06300EC9,$01110BDC,$06300EC9
	DC.L	$01110BDC,$06400EC9,$01110BDC,$06400EC9,$01110BDC,$07410EB8
	DC.L	$01110BDC,$07410DB8,$01110BDC,$07410DB8,$01110BDC,$07410DB8
	DC.L	$01210BDC,$07410DB8,$01210BCC,$07410DB8,$01210BCC,$07410DB8
	DC.L	$01210BCC,$07410DB8,$02220ACB,$07410DB8,$02220ACB,$07410DB8
	DC.L	$02220ACB,$07410DB8,$02220ACB,$07410DB8,$02220ACB,$07410DB8
	DC.L	$02220ACB,$07410DB8,$02220ACB,$07410DB8,$02220ACB,$07410DB8
	DC.L	$02320ACB,$07510DB8,$02320ABB,$07510DB8,$02320ABB,$07510DA8
	DC.L	$02320ABB,$07510DA8,$02320ABB,$08520DA7,$02320ABB,$08520CA7
	DC.L	$033309BA,$08520CA7,$033309BA,$08520CA7,$033309BA,$08520CA7
	DC.L	$033309BA,$08520CA7,$033309BA,$08520CA7,$033309BA,$08520CA7
	DC.L	$034309BA,$08520CA7,$034309AA,$08520CA7,$034309AA,$08520CA7
	DC.L	$034309AA,$08520CA7,$034309AA,$08520CA7,$034309AA,$08520CA7
	DC.L	$034309AA,$08620CA7,$034309AA,$08620CA7,$044408A9,$08620C97
	DC.L	$044408A9,$08620C97,$044408A9,$08620C97,$044408A9,$08620C97
	DC.L	$045408A9,$09630C96,$04540899,$09630B96,$04540899,$09630B96
	DC.L	$04540899,$09630B96,$04540899,$09630B96,$04540899,$09630B96
	DC.L	$04540899,$09630B96,$04540899,$09630B96,$04540899,$09630B96
	DC.L	$04540899,$09630B96,$05550798,$09630B96,$05550798,$09630B96
	DC.L	$05650798,$09730B96,$05650788,$09730B96,$05650788,$09730B86
	DC.L	$05650788,$09730B86,$05650788,$09730B86,$05650788,$09730B86
	DC.L	$05650788,$09730B86,$05650788,$09730B86,$05650788,$0A740B85
	DC.L	$05650788,$0A740A85,$05650788,$0A740A85,$05650788,$0A740A85
	DC.L	$06760687,$0A740A85,$06760677,$0A740A85,$06760677,$0A740A85
	DC.L	$06760677,$0A740A85,$06760677,$0A740A85,$06760677,$0A740A85
	DC.L	$06760677,$0A840A85,$06760677,$0A840A85,$06760677,$0A840A75
	DC.L	$06760677,$0A840A75,$06760677,$0A840A75,$06760677,$0A840A75
	DC.L	$06860677,$0A840A75,$07870566,$0A840A75,$07870566,$0A840A75
	DC.L	$07870566,$0A840A75,$07870566,$0B850A74,$07870566,$0B850974
	DC.L	$07870566,$0B850974,$07870566,$0B850974,$07870566,$0B850974
	DC.L	$07870566,$0B850974,$07870566,$0B850974,$07870566,$0B850974
	DC.L	$07970566,$0B950974,$07970556,$0B950974,$07970556,$0B950964
	DC.L	$08980455,$0B950964,$08980455,$0B950964,$08980455,$0B950964
	DC.L	$08980455,$0B950964,$08980455,$0B950964,$08980455,$0B950964
	DC.L	$08980455,$0B950964,$08980455,$0B950964,$08980455,$0B950964
	DC.L	$08A80455,$0C960963,$08A80445,$0C960863,$08A80445,$0C960863
	DC.L	$08A80445,$0C960863,$08A80445,$0C960863,$09A90344,$0C960863
	DC.L	$09A90344,$0CA60863,$09A90344,$0CA60863,$09A90344,$0CA60853
	DC.L	$09A90344,$0CA60853,$09A90344,$0CA60853,$09A90344,$0CA60853
	DC.L	$09B90344,$0CA60853,$09B90334,$0CA60853,$09B90334,$0CA60853
	DC.L	$09B90334,$0CA60853,$09B90334,$0CA60853,$09B90334,$0CA60853
	DC.L	$09B90334,$0CA60853,$0ABA0233,$0CA60853,$0ABA0233,$0DA70852
	DC.L	$0ABA0233,$0DA70752,$0ABA0233,$0DA70752,$0ABA0233,$0DA70752
	DC.L	$0ACA0233,$0DB70752,$0ACA0223,$0DB70752,$0ACA0223,$0DB70742
	DC.L	$0ACA0223,$0DB70742,$0ACA0223,$0DB70742,$0ACA0223,$0DB70742
	DC.L	$0ACA0223,$0DB70742,$0ACA0223,$0DB70742,$0ACA0223,$0DB70742
	DC.L	$0BCB0122,$0DB70742,$0BCB0122,$0DB70742,$0BCB0122,$0DB70742
	DC.L	$0BDB0122,$0DB70742,$0BDB0112,$0DB70742,$0BDB0112,$0DB70742
	DC.L	$0BDB0112,$0DB70742,$0BDB0112,$0EB80741,$0BDB0112,$0EB80641
	DC.L	$0BDB0112,$0EC80641,$0BDB0112,$0EC80641,$0BDB0112,$0EC80631
	DC.L	$0BDB0112,$0EC80631,$0BDB0112,$0EC80631,$0CDC0011,$0EC80631
	DC.L	$0CEC0011,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0CEC0001,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0CEC0001,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0CEC0001,$0EC80631,$0CEC0001,$0EC80631,$0CEC0001,$0EC80631
	DC.L	$0DFD0000,$0FD90630,$0CED0000,$0ED90630,$0CED0000,$0EC90630
	DC.L	$0CED0000,$0EC90630,$0CED0000,$0EC90630,$0CED0000,$0EC90630
	DC.L	$0CED0000,$0EC90630,$0CED0000,$0EC90630,$0CED0000,$0EC90630
	DC.L	$0CED0000,$0EC90630,$0CED0000,$0EC90630,$0CED0000,$0EC90630
	DC.L	$0CED0010,$0EC90630,$0CDD0010,$0EC90630,$0BDC0111,$0EC90630
	DC.L	$0BDC0111,$0EC90630,$0BDC0111,$0EC90630,$0BDC0111,$0EC90630
	DC.L	$0BDC0111,$0EC90640,$0BDC0111,$0EC90640,$0BDC0111,$0EB80741
	DC.L	$0BDC0111,$0DB80741,$0BDC0111,$0DB80741,$0BDC0111,$0DB80741
	DC.L	$0BDC0121,$0DB80741,$0BCC0121,$0DB80741,$0BCC0121,$0DB80741
	DC.L	$0BCC0121,$0DB80741,$0ACB0222,$0DB80741,$0ACB0222,$0DB80741
	DC.L	$0ACB0222,$0DB80741,$0ACB0222,$0DB80741,$0ACB0222,$0DB80741
	DC.L	$0ACB0222,$0DB80741,$0ACB0222,$0DB80741,$0ACB0222,$0DB80741
	DC.L	$0ACB0232,$0DB80751,$0ABB0232,$0DB80751,$0ABB0232,$0DA80751
	DC.L	$0ABB0232,$0DA80751,$0ABB0232,$0DA70852,$0ABB0232,$0CA70852
	DC.L	$09BA0333,$0CA70852,$09BA0333,$0CA70852,$09BA0333,$0CA70852
	DC.L	$09BA0333,$0CA70852,$09BA0333,$0CA70852,$09BA0333,$0CA70852
	DC.L	$09BA0343,$0CA70852,$09AA0343,$0CA70852,$09AA0343,$0CA70852
	DC.L	$09AA0343,$0CA70852,$09AA0343,$0CA70852,$09AA0343,$0CA70852
	DC.L	$09AA0343,$0CA70862,$09AA0343,$0CA70862,$08A90444,$0C970862
	DC.L	$08A90444,$0C970862,$08A90444,$0C970862,$08A90444,$0C970862
	DC.L	$08A90454,$0C960963,$08990454,$0B960963,$08990454,$0B960963
	DC.L	$08990454,$0B960963,$08990454,$0B960963,$08990454,$0B960963
	DC.L	$08990454,$0B960963,$08990454,$0B960963,$08990454,$0B960963
	DC.L	$08990454,$0B960963,$07980555,$0B960963,$07980555,$0B960963
	DC.L	$07980565,$0B960973,$07880565,$0B960973,$07880565,$0B860973
	DC.L	$07880565,$0B860973,$07880565,$0B860973,$07880565,$0B860973
	DC.L	$07880565,$0B860973,$07880565,$0B860973,$07880565,$0B850A74
	DC.L	$07880565,$0A850A74,$07880565,$0A850A74,$07880565,$0A850A74
	DC.L	$06870676,$0A850A74,$06770676,$0A850A74,$06770676,$0A850A74
	DC.L	$06770676,$0A850A74,$06770676,$0A850A74,$06770676,$0A850A74
	DC.L	$06770676,$0A850A84,$06770676,$0A850A84,$06770676,$0A750A84
	DC.L	$06770676,$0A750A84,$06770676,$0A750A84,$06770676,$0A750A84
	DC.L	$06770686,$0A750A84,$05660787,$0A750A84,$05660787,$0A750A84
	DC.L	$05660787,$0A750A84,$05660787,$0A740B85,$05660787,$09740B85
	DC.L	$05660787,$09740B85,$05660787,$09740B85,$05660787,$09740B85
	DC.L	$05660787,$09740B85,$05660787,$09740B85,$05660787,$09740B85
	DC.L	$05660797,$09740B95,$05560797,$09740B95,$05560797,$09640B95
	DC.L	$04550898,$09640B95,$04550898,$09640B95,$04550898,$09640B95
	DC.L	$04550898,$09640B95,$04550898,$09640B95,$04550898,$09640B95
	DC.L	$04550898,$09640B95,$04550898,$09640B95,$04550898,$09640B95
	DC.L	$045508A8,$09630C96,$044508A8,$08630C96,$044508A8,$08630C96
	DC.L	$044508A8,$08630C96,$044508A8,$08630C96,$034409A9,$08630C96
	DC.L	$034409A9,$08630CA6,$034409A9,$08630CA6,$034409A9,$08530CA6
	DC.L	$034409A9,$08530CA6,$034409A9,$08530CA6,$034409A9,$08530CA6
	DC.L	$034409B9,$08530CA6,$033409B9,$08530CA6,$033409B9,$08530CA6
	DC.L	$033409B9,$08530CA6,$033409B9,$08530CA6,$033409B9,$08530CA6
	DC.L	$033409B9,$08530CA6,$02330ABA,$08530CA6,$02330ABA,$08520DA7
	DC.L	$02330ABA,$07520DA7,$02330ABA,$07520DA7,$02330ABA,$07520DA7
	DC.L	$02330ACA,$07520DB7,$02230ACA,$07520DB7,$02230ACA,$07420DB7
	DC.L	$02230ACA,$07420DB7,$02230ACA,$07420DB7,$02230ACA,$07420DB7
	DC.L	$02230ACA,$07420DB7,$02230ACA,$07420DB7,$02230ACA,$07420DB7
	DC.L	$01220BCB,$07420DB7,$01220BCB,$07420DB7,$01220BCB,$07420DB7
	DC.L	$01220BDB,$07420DB7,$01120BDB,$07420DB7,$01120BDB,$07420DB7
	DC.L	$01120BDB,$07420DB7,$01120BDB,$07410EB8,$01120BDB,$06410EB8
	DC.L	$01120BDB,$06410EC8,$01120BDB,$06410EC8,$01120BDB,$06310EC8
	DC.L	$01120BDB,$06310EC8,$01120BDB,$06310EC8,$00110CDC,$06310EC8
	DC.L	$00110CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00010CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00010CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8
	DC.L	$00010CEC,$06310EC8,$00010CEC,$06310EC8,$00010CEC,$06310EC8

BASELINIE:
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A	;0
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002	;5
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002	;9
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$9D4A,BASE+$9D4A	;A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2	;B
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$705A,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$705A
	DC.L	BASE+$705A,BASE+$705A,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$705A,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$705A,BASE+$705A	;G
	DC.L	BASE+$705A,BASE+$705A,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$705A
	DC.L	BASE+$705A,BASE+$705A,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$705A,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2	;N
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$705A,BASE+$705A,BASE+$705A
	DC.L	BASE+$705A,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$167A,BASE+$167A,BASE+$167A
	DC.L	BASE+$167A,BASE+$167A,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$705A,BASE+$705A,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$2CF2,BASE+$2CF2,BASE+$2CF2,BASE+$2CF2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,BASE+$86D2,BASE+$86D2
	DC.L	BASE+$86D2,BASE+$86D2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$9D4A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$59E2,BASE+$59E2	;W
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	$00000000,$00000000,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$59E2,BASE+$59E2
	DC.L	BASE+$59E2,BASE+$59E2,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$9D4A,BASE+$9D4A
	DC.L	BASE+$9D4A,BASE+$9D4A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,BASE+$436A,BASE+$436A
	DC.L	BASE+$436A,BASE+$436A,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002	;Z
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,BASE+$0002,BASE+$0002
	DC.L	BASE+$0002,BASE+$0002,$00000000,$00000000
	DC.L	$00000000,$00000000,$00000000,$00000000


ZWTAB:	BLK.L	840/4,0
ENTAB:	DC.L	0,0


COP:
	DC.W	$0100,$0000,$0102,$0000,$0108,$0000,$010A,$0000
	DC.W	$0096,$8020,$008E,$2C7F,$0090,$2CF1,$0092,$0038
	DC.W	$0094,$00D0,$0104,$003C
	DC.W	$00E0,$0000,$00E2,$0000
	DC.W	$0180,$0000,$0182,$0000
SPRBASE:DC.W	$0120,$0000,$0122,$0000
	DC.W	$0124,$0000,$0126,$0000
	DC.W	$0128,$0000,$012A,$0000
	DC.W	$012C,$0000,$012E,$0000
	DC.W	$0130,$0000,$0132,$0000
	DC.W	$0134,$0000,$0136,$0000
	DC.W	$0138,$0000,$013A,$0000
	DC.W	$013C,$0000,$013E,$0000

	DC.W	$2807,$FFFE,$0180,$0000,$0100,$1200
	DC.W	$2A07,$FFFE,$0180,$0F00
	DC.W	$2B07,$FFFE,$0180,$0000

COPBLOCK:
	BLK.L	14*211,0

	DC.W	$FF01,$FFFE
	DC.W	$0100,$0000
	DC.W	$0180,$0F00
	DC.W	$FFDF,$FFFE,$0007,$FFFE
	DC.W	$0180,$0000
	dc.w	$1fc,0
	dc.w	$106,$c00
	DC.W	$FFFF,$FFFE
	

SPR0:	DC.W	$2C80,$0000
	BLK.L	844/4,0
	DC.W	$2C88,$0000
	BLK.L	844/4,0
	DC.W	$2C80,$0000
	BLK.L	844/4,0
	DC.W	$2C88,$0000
	BLK.L	844/4,0
END:	
	incdir ""
	;incdir	"hd1:caz2/"
BASE:
	incbin	"WIND"

;BASE=$60000-2

