
; Listing17e5.s = GunWriter.s
*************************************************************************
*		Gunwriter for ITALIAN CHART 1992								*
*																		*
* Coder: DDT	(D.Paccaloni)											*
* Date : dd/mm/1992														*
*																		*
* Update and fix: RANDY/RAM JAM (Fabio Ciucci)							*
* Date: 1995															*
*																		*
*************************************************************************

Frames = 100					; Geschwindigkeit (1-254)

	SECTION GunWritoccio,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern interrupt, dma etc.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden

			;5432109876543210
DMASET	equ	%1000001111000000	; Copper,Bitplane,blitter DMA aktivieren

WaitDisk	equ	10	; 50-150 zur Rettung (soweit zutreffend)

Start:

; Zeiger auf Int-level 3

	move.l	BaseVBR(pc),a0	    ; In a0 der Wert der VBR
	move.l	#NewIRQ,$6c(a0)	    ; unsere  Int. Level 3 Routine

	move.l	#plane1,d0			; planes
	lea	BplPointers,a1			; Adresszeiger in der copperliste.
	moveq	#2-1,d1				; 2 planes
Ploop:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a1
	dbra	d1,Ploop

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - abilita Bitplane, Copper
								; und Sprites.
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

			; 5432109876543210
	move.w	#%1100000000100000,$9a(a5)    ; INTENA - nur VERTB aktivieren

;	MAIN PROGRAM

SetLine:
	lea	$dff000,a0
	move.w	#40,$60(a0)
	move.w	#40,$66(a0)
	move.l	#plane1,$48(a0)
	move.l	#plane1,$54(a0)
	move.l	#-1,$44(a0)
	move.w	#$8000,$74(a0)
	move.w	#$ffff,$72(a0)

	lea	MenoUno(pc),a1
	lea	LinesData(pc),a4		; Pointer to line to get
	sf	FrameN					; Reset frame number counter

qTF0:	cmp.b	#$f0,$dff006
	bne.s	qTF0
qTF1:	cmp.b	#$f0,$dff006
	beq.s	qTF1

aTF0:	cmp.b	#$f0,$dff006
	bne.s	aTF0
aTF1:	cmp.b	#$f0,$dff006
	beq.s	aTF1

aTF2:	cmp.b	#$f0,$dff006
	bne.s	aTF2
aTF3:	cmp.b	#$f0,$dff006
	beq.s	aTF3

	btst	#6,$dff002
CLS1:
	btst	#6,$dff002			; Clear text plane
	bne.s	CLS1

	move.w	#0,$dff066			; D modulo
	move.l	#plane2,$dff054		; D pointer
	move.w	#$0000,$dff042		; bltcon 1
	move.w	#$0100,$dff040		; bltcon 0
	move.w	#$4014,$dff058		; bltsize
WBLLI:
	btst	#6,$dff002
	bne.s	WBLLI

NEXTFRAME:
	btst	#10,$dff016
	beq.w	Exit

	tst.w	LastN
	bne.s	ooo

	cmp.w	#-1,(a1)			; Test for end of current Char
	bne.w	Continue

GetNewChar:
	move.w	StrVal(pc),d6		; StretchValue
	moveq	#0,d7				; Clear d7
	move.l	TxtPnt(pc),a0
GetNxt:
	move.b	(a0),d7
	bne.w	NoEOP
CLSP:							; End of PAGE {
	tst.w	LastN
	bne.s	ooo
	move.w	#1,LastN
ooo:
	lea	MenoUno(pc),a1
	cmp.w	#Frames,LastN
	bne.w	Continue
	lea	Text(pc),a0
	move.l	a0,TxtPnt
	clr.w	LastN

lll:	btst	#6,$bfe001		; swap page with left button
	bne.s	lll

	sf	FrameN					; Reset frame number counter
	move.w	#Frames,d0
	mulu.w	#12,d0
	lea	LinesData(pc),a4
SetLDat:
	move.w	#-1,(a4)+
	dbra	d0,SetLDat

	lea	LinesData(pc),a4		; Pointer to line to get

	btst	#6,$dff002			; Clear text plane
	bne.s	CLSP

	move.w	#0,$dff066			; D modulo
	move.l	#plane2,$dff054		; D pointer
	move.w	#$0000,$dff042		; bltcon 1
	move.w	#$0100,$dff040		; bltcon 0
	move.w	#$4014,$dff058		; bltsize
WBLLIP:
	btst	#6,$dff002
	bne.s	WBLLIP		;}.
	bra.w	GetNxt

NoEOP:
	cmp.b	#-1,d7
	bne.s	NoEOF
	lea	Text(pc),a0
	move.l	a0,TxtPnt
	bra.w	GetNxt

NoEOF:
	cmp.b	#9,d7
	bpl.s	NoStr
	move.b	d7,d6
	subq.w	#1,d6
	move.w	d6,StrVal
	addq.w	#1,a0
	bra.w	GetNxt

NoStr:
	cmp.b	#10,d7
	bne.s	NoCR
	st.b	ACapo
	moveq	#8,d7
	lsl.w	d6,d7
	add.w	d7,CurY
	clr.w	CurX
	addq.w	#1,a0
	bra.w	GetNxt

NoCR:
	cmp.b	#11,d7
	bne.s	NoXY
	st.b	ACapo
	clr.w	CurX
	clr.w	CurY
	move.b	1(a0),CurX+1
	move.b	2(a0),CurY+1
	addq.w	#3,a0
	bra.w	GetNxt

NoXY:
	tst.b	ACapo
	beq.s	NoAC
	sf.b	ACapo
	bra.s	Skizz

NoAC:
	moveq	#8,d0				; NormalChar
	lsl.w	d6,d0
	add.w	d0,CurX
Skizz:
	addq.w	#1,a0
	move.l	a0,TxtPnt

	move.w	d7,d0
	sub.w	#32,d0
	lsl.w	#2,d0
	lea	CharsOffs(pc),a5
	move.l	(a5,d0.w),a1		; Start of new_Char data
	cmp.b	#-1,(a1)
	beq.w	GetNxt

Continue:						; Set next line
	tst.w	LastN
	beq.s	Normal
	move.w	#$5000,(a4)
	add.w	#24,a4
	bra.w	GoDraw

Normal:
	moveq	#6,d7				; Shift Value
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d4
	moveq	#0,d5
	move.w	GunX(pc),d0			; Get GunX pos as X0
	move.w	GunY(pc),d1			; Get GunY pos as Y0
	lsl.w	d7,d0				; Make X0 *64
	lsl.w	d7,d1				; Make Y0 *64
	move.w	d0,(a4)+			; Set X0 *64
	move.w	d1,(a4)+			; Set Y0 *64
	move.w	OldGunX(pc),d4		; Get GunX oldpos as X1
	move.w	OldGunY(pc),d5		; Get GunY oldpos as Y1
	lsl.w	d7,d4				; Make X1 *64
	lsl.w	d7,d5				; Make Y1 *64
	move.w	d4,(a4)+			; Set X1 *64
	move.w	d5,(a4)+			; Set Y1 *64

	move.w	(a1)+,d4			; Get abs dX0
	move.w	(a1)+,d5			; Get abs dY0
	lsl.w	d6,d4				; stretchval
	lsl.w	d6,d5
	add.w	CurX(pc),d4			; Make rel dX0
	add.w	CurY(pc),d5			; Make rel dY0
	move.w	d4,(a4)+			; Put dX0
	move.w	d5,(a4)+			; Put dY0
	lsl.w	d7,d4				; Make tsX0 *64
	lsl.w	d7,d5				; Make tsY0 *64
	sub.w	d0,d4				; Find total X0 step *64
	sub.w	d1,d5				; Find total Y0 step *64
	ext.l	d4
	ext.l	d5
	divs.w	#Frames,d4			; Find X0 step *64
	divs.w	#Frames,d5			; Find Y0 step *64

	move.w	(a1)+,d2			; Get abs dX1
	move.w	(a1)+,d3			; Get abs dY1
	lsl.w	d6,d2
	lsl.w	d6,d3
	add.w	CurX(pc),d2			; Make rel dX1
	add.w	CurY(pc),d3			; Make rel dY1
	move.w	d2,(a4)+			; Put dX1
	move.w	d3,(a4)+			; Put dY1
	lsl.w	d7,d2				; Make tsX1 *64
	lsl.w	d7,d3				; Make tsY1 *64
	move.w	OldGunX(pc),d0		; Get GunX oldpos as X1
	move.w	OldGunY(pc),d1		; Get GunY oldpos as Y1
	lsl.w	d7,d0				; Make X1 *64
	lsl.w	d7,d1				; Make Y1 *64
	sub.w	d0,d2				; Find total X1 step *64
	sub.w	d1,d3				; Find total Y1 step *64
	ext.l	d2
	ext.l	d3
	divs	#Frames,d2			; Find X1 step *64
	divs	#Frames,d3			; Find Y1 step *64

	move.w	d4,(a4)+			; Put sX0 *64
	move.w	d5,(a4)+			; Put sY0 *64
	move.w	d2,(a4)+			; Put sX1 *64
	move.w	d3,(a4)+			; Put sY1 *64

;LinesData:	; dc.w	X0,Y0,X1,Y1,dX0,dY0,dX1,dY1,sX0,sY0,sX1,sY1

GoDraw:
;	tst.w	LastN
;	beq.s	Jepa
;	lea	MenoUno,a1
Jepa:
	lea	LinesData(pc),a5		; Add steps
	moveq	#-1,d7
DrawNext:
	cmp.b	#-1,d7
	bne.s	NoFLin
	cmp.b	#Frames-1,FrameN
	bne.s	NoLast
	bra.s	Zump

NoFLin:
	cmp.b	FrameN(pc),d7
	bne.s	NoLast
Zump:
	move.w	8(a5),d0
	move.w	10(a5),d1
	move.w	12(a5),d2
	move.w	14(a5),d3
	move.l	#plane2,CurScreen
	bra.s	WBLL

NoLast:
	tst.w	LastN
	beq.s	NoBlub
	cmp.w	#$5000,(a5)
	beq.w	Blub
NoBlub:
	move.w	16(a5),d0
	add.w	d0,(a5)
	move.w	18(a5),d0
	add.w	d0,2(a5)
	move.w	20(a5),d0
	add.w	d0,4(a5)
	move.w	22(a5),d0
	add.w	d0,6(a5)

	move.w	(a5),d0
	move.w	2(a5),d1
	move.w	4(a5),d2
	move.w	6(a5),d3
	moveq	#6,d4				; to divide /64
	lsr.w	d4,d0				; x0
	lsr.w	d4,d1				; y0
	lsr.w	d4,d2				; x1
	lsr.w	d4,d3				; y1

WBLL:

	movem.l	d0-d7/a0-a6,-(sp)
	lea	$dff000,a5
	btst	#6,2(a5)			; dmaconr
Wblit_Init:
	btst	#6,2(a5)			; dmaconr - wait for the blitter to finish
	bne.s	Wblit_Init

	moveq	#-1,d5
	move.l	d5,$44(a5)			; BLTAFWM/BLTALWM = $ffff
	move.w	#$8000,$74(a5)		; BLTADAT = $8000
	move.w	#40,$60(a5)			; BLTCMOD = 40
	move.w	#40,$66(a5)			; BLTDMOD = 40
	move.l	CurScreen(pc),a0
	bsr.w	DrawLine
	movem.l	(sp)+,d0-d7/a0-a6

;---------

Blub:
	move.l	SwapScreen(pc),CurScreen
	addq.w	#1,d7
	add.w	#24,a5
	cmp.w	#-1,(a5)
	bne.w	DrawNext

WTF0:
	cmp.b	#$f0,$dff006
	bne.s	WTF0
WTF1:
	cmp.b	#$f0,$dff006
	beq.s	WTF1

	not.b	SwapFlag
	beq.s	Evenf
	move.l	#plane1,CurScreen
	move.l	#plane1,SwapScreen
	bra.s	Pluz
Evenf:
	move.l	#plane5,CurScreen
	move.l	#plane5,SwapScreen
Pluz:
	move.l	CurScreen(pc),d0
	lea	BplPointers,a0			; address pointers in the Copperlist.
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)

; Clear Screen

	btst	#6,$dff002
CLS:
	btst	#6,$dff002
	bne.s	CLS

	move.w	#0,$dff066				; D modulo
	move.l	SwapScreen(pc),$dff054	; D pointer
	move.w	#$0000,$dff042			; bltcon 1
	move.w	#$0100,$dff040			; bltcon 0
	move.w	#$4014,$dff058			; bltsize
NoDel:
	tst.w	LastN
	beq.s	Gollum
	addq.w	#1,LastN
Gollum:
	addq.b	#1,FrameN
	cmp.b	#Frames,FrameN
	bne.w	NEXTFRAME
	sf	FrameN
	lea	LinesData(pc),a4
	bra.w	NEXTFRAME

Exit:
	rts


;******************************************************************************
; Diese Routine zieht die Grenze und nimmt als Parameter die Extreme der Linie
; P1 und P2 und die Adresse der Bitebene, auf der sie gezeichnet werden soll.
; d0 - X1 (Koord. X von P1)
; d1 - Y1 (Koord. Y von P1)
; d2 - X2 (Koord. X von P2)
; d3 - Y2 (Koord. Y von P2)
; a0 - Adresse Bitplane
;******************************************************************************

; Konstanten

DL_Fill		=	0				; 0=NOFILL / 1=FILL

	IFEQ	DL_Fill
DL_MInterns	=	$CA
	ELSE
DL_MInterns	=	$4A
	ENDC


DrawLine:
	sub.w	d1,d3				; d3=Y2-Y1

	IFNE	DL_Fill
	beq.s	.end				; fr die Fllung werden keine horizontalen Linien bentigt
	ENDC

	bgt.s	.y2gy1				; berspringen wenn positiv..
	exg	d0,d2					; ..ansonsten Punkte tauschen
	add.w	d3,d1				; setzt das kleinste Y in d1
	neg.w	d3					; d3=DY
.y2gy1:
	mulu.w	#40,d1				; offset Y
	add.l	d1,a0
	moveq	#0,d1				; d1 Index in der Oktantentabelle
	sub.w	d0,d2				; d2=X2-X1
	bge.s	.xdpos				; berspringen wenn positiv..
	addq.w	#2,d1				; ..andernfalls den Index verschieben
	neg.w	d2					; und mach den Unterschied positiv
.xdpos:
	moveq	#$f,d4				; Maske fr die unteren 4 Bits
	and.w	d0,d4				; whle sie aus in d4
		
	IFNE	DL_Fill				; diese Anweisung wird nur assembliert
								; wenn DL_Fill=1
	move.b	d4,d5				; berechnet die Nummer des zu invertierenden Bits
	not.b	d5					; (der BCHG nummeriert die Bits invers)
	ENDC

	lsr.w	#3,d0				; offset X:
								; An Bytes ausrichten (fr BCHG)
	add.w	d0,a0				; ergnzt die Adresse
								; Beachten Sie, dass auch wenn die Adresse
								; seltsam ist, dass es nichts tut, weil
								; der Blitter bercksichtigt nicht die
								; niederwertigstes Bit von BLTxPT

	ror.w	#4,d4				; d4 = shift-Wert A
	or.w	#$B00+DL_MInterns,d4	; fgt die Gelegenheit hinzu
								; Minterm (OR oder EOR)
	swap	d4					; BLTCON0-Wert im High-Word
		
	cmp.w	d2,d3				; vergleichen DiffX und DiffY
	bge.s	.dygdx				; berspringen wenn >=0..
	addq.w	#1,d1				; andernfalls setzt es Bit 0 des Index
	exg	d2,d3					; und tausche das Diff
.dygdx:
	add.w	d2,d2				; d2 = 2*DiffX
	move.w	d2,d0				; Kopie in d0
	sub.w	d3,d0				; d0 = 2*DiffX-DiffY
	addx.w	d1,d1				; multiplizieren Sie den Index mit 2 und
								; fgt es gleichzeitig der Flagge hinzu
								; X was 1 ist, wenn 2*DiffX-DiffY<0
								; (eingestellt von sub.w)
	move.b	Oktants(PC,d1.w),d4	; liest den Oktanten
	swap	d2					; BLTBMOD-Wert im hohen Wort
	move.w	d0,d2				; word unten d2=2*DiffX-DiffY
	sub.w	d3,d2				; word unten d2=2*DiffX-2*DiffY
	moveq	#6,d1				; Verschiebung und Prfwert fr
								; wait blitter 

	lsl.w	d1,d3				; berechnet den Wert von BLTSIZE
	add.w	#$42,d3

	lea	$52(a5),a1				; a1 = Adresse BLTAPTL
								; schreibt einige Register
								; nacheinander mit einigen 
								; MOVE #XX,(Ax)+

	btst	d1,2(a5)			; auf den blitter warten
.wb:
	btst	d1,2(a5)
	bne.s	.wb

	IFNE	DL_Fill				; diese Anweisung wird assembliert
								; nur wenn DL_Fill = 1
	bchg	d5,(a0)				; Das erste Bit der Zeile umkehren
	ENDC

	move.l	d4,$40(a5)			; BLTCON0/1
	move.l	d2,$62(a5)			; BLTBMOD und BLTAMOD
	move.l	a0,$48(a5)			; BLTCPT
	move.w	d0,(a1)+			; BLTAPTL
	move.l	a0,(a1)+			; BLTDPT
	move.w	d3,(a1)				; BLTSIZE
.end:
	rts

; Wenn wir Zeilen fr die Fllung ausfhren mchten, setzt der Oktantencode das Bit auf 1
; SING durch die konstante SML

	IFNE	DL_Fill
SML		= 	2
	ELSE
SML		=	0
	ENDC

; Tabelle Oktanten

Oktants:
	dc.b	SML+1,SML+1+$40
	dc.b	SML+17,SML+17+$40
	dc.b	SML+9,SML+9+$40
	dc.b	SML+21,SML+21+$40

***************************************
***	VBLANK IRQ HANDLER   ($6c)  ***
***************************************

	cnop	0,4

NewIRQ:
	btst.b	#5,$dff01f			; INTREQR - Bit 5, VERTB, ist gelscht?
	beq.w	NOIRQ_6c			; Wenn ja, ist es kein "echtes" int VERTB!
	movem.l	d0-d7/a0-a6,-(sp)

; Lassen Sie uns nun den Generatorpunkt behandeln, der ber den Bildschirm schwingt.
; Lass uns zuerst die Alten beseitigen

	moveq	#0,d0
	moveq	#0,d1
	move.w	GunX(pc),d0
	move.w	GunY(pc),d1
	move.w	d0,OldGunX
	move.w	d1,OldGunY
	move.l	SavedSCR(pc),a0		; plane Ziel

;	a0 = Adresse Bitplane Ziel
;	d0.w = Koordinate X (0-319)
;	d1.w = Koordinate Y (0-255)

	move.w	d0,d2				; Kopiere die Koordinate X in d2
	lsr.w	#3,d0				; in der Zwischenzeit den horizontalen Versatz finden
	mulu.w	#40,d1				; offset y (Y* Bildschirmbreite)
	add.w	d1,d0				; Addieren der vert. Abweichung zum waagerechten
	and.w	#%111,d2			; nur die ersten 3 Bits von X auswhlen , d.h.
	not.w	d2					; die anderen negieren
	bclr.b	d2,(a0,d0.w)		; Bit d2 auf den richtigen Offset setzen

;Jetzt legen wir die neue Position fest: Lesen wir die ADD-Werte

	lea	SinPX0(pc),a0			; Harmonische Bewegung
	move.w	(a0),d0				; x0
	move.w	2(a0),d2			; x1
	move.w	4(a0),d1			; y0
	move.w	6(a0),d3			; y1

; addiamoli

	add.w	#10,d0				; Inc MA pts (EVEN values)
	addq.w	#6,d2
	addq.w	#8,d1
	add.w	#14,d3

	move.w	#2047,d4			; max value
	and.w	d4,d0
	and.w	d4,d2
	and.w	d4,d1
	and.w	d4,d3

; und lass sie uns retten

	move.w	d0,(a0)				; x0
	move.w	d2,2(a0)			; x1
	move.w	d1,4(a0)			; y0
	move.w	d3,6(a0)			; y1

; Jetzt nehmen wir die Werte aus der Sintab und speichern sie fr den nchsten Schritt

	lea	SinTab(pc),a1
	move.w	(a1,d0.w),d0
	move.w	(a1,d2.w),d2
	move.w	(a1,d1.w),d1
	move.w	(a1,d3.w),d3

	add.w	d2,d0				; X
	add.w	d3,d1				; Y
	asr.w	#4,d0				; /16
	asr.w	#4,d1				; /16
	add.w	#160,d0				; Zentrum X
	add.w	#128,d1				; Zentrum Y
	move.w	d0,GunX
	move.w	d1,GunY

; wir zeichnen den neuen Punkt

	move.l	CurScreen(pc),a0	; plane Ziel
	move.l	a0,SavedSCR

;	a0 = Adresse Bitplane Ziel
;	d0.w = Koordinate X (0-319)
;	d1.w = Koordinate Y (0-255)

	move.w	d0,d2				; Kopiere die Koordinate X in d2
	lsr.w	#3,d0				; in der Zwischenzeit den horizontalen Versatz finden
	mulu.w	#40,d1				; offset y (Y* Bildschirmbreite)
	add.w	d1,d0				; Addieren der vert. Abweichung zum waagerechten
	and.w	#%111,d2			; nur die ersten 3 Bits von X auswhlen , d.h.
	not.w	d2					; die anderen negieren
	bset.b	d2,(a0,d0.w)		; Bit d2 auf den richtigen Offset setzen

	movem.l	(sp)+,d0-d7/a0-a6
NOIRQ_6c:
	move.w	#%1110000,$dff09c	; INTREQ - Anforderung lschen BLIT,VERTB und COPER
	rte							; Exit von int COPER/BLIT/VERTB

SavedSCR:
	dc.l	0

	cnop	0,4
SinPX0:	dc.w	1000			; MotArm X0
SinPX1:	dc.w	1800			; MotArm X1
SinPY0:	dc.w	900				; MotArm Y0
SinPY1:	dc.w	0				; MotArm Y1

	cnop	0,4
GunX:	dc.w	0				; Gun X pos

	cnop	0,4
GunY:	dc.w	0				; Gun Y pos

	cnop	0,4
OldGunX:dc.w	0				; Gun X pos old

	cnop	0,4
OldGunY:dc.w	0				; Gun Y pos old

	cnop	0,4
TxtPnt:	dc.l	Text			; Pointer to current character in the text

	cnop	0,4
CurX:	dc.w	0				; Cursor X pos

	cnop	0,4
CurY:	dc.w	0				; Cursor Y pos

	cnop	0,4
StrVal:	dc.w	0				; Stretch value (0 = 1:1)

	cnop	0,4
AtLins:dc.w	0					; Number of lines activated

	cnop	0,4
LastN:	dc.w	0				; Last lines to draw (used at end of page)

	cnop	0,4
MenoUno:dc.w	-1				; Fake location for startup

	cnop	0,4
FrameN:	dc.b	0				; Frame number counter (compare with FRAMES)

	cnop	0,4
SwapFlag: dc.b	0				; Boolean flag for SwapScreen control

	cnop	0,4
ACapo:	dc.b	0				; Flag for CR handling

	cnop	0,4

CurScreen:	dc.l	plane1
SwapScreen:	dc.l	plane1
;---------------------------------------

*****************************************************************************

	cnop	0,4
SinTab:
	dc.w	0,6,13,$13,$19,$1f,$26,$2c,$32,$39,$3f,$45,$4b
	dc.w	$52,$58,$5e,$65,$6b,$71,$77,$7e,$84,$8a,$90,$97
	dc.w	$9d,$a3,$a9,$af,$b6,$bc,$c2,$c8,$ce,$d4,$db,$e1
	dc.w	$e7,$ed,$f3,$f9,$ff,$105,$10b,$112,$118,$11e,$124
	dc.w	$12a,$130,$136,$13c,$142,$148,$14e,$154,$15a,$15f
	dc.w	$165,$16b,$171,$177,$17d,$183,$188,$18e,$194,$19a
	dc.w	$1a0,$1a5,$1ab,$1b1,$1b7,$1bc,$1c2,$1c7,$1cd,$1d3
	dc.w	$1d8,$1de,$1e3,$1e9,$1ef,$1f4,$1f9,$1ff,$204,$20a
	dc.w	$20f,$215,$21a,$21f,$225,$22a,$22f,$235,$23a,$23f
	dc.w	$244,$249,$24e,$254,$259,$25e,$263,$268,$26d,$272
	dc.w	$277,$27c,$281,$286,$28b,$28f,$294,$299,$29e,$2a3
	dc.w	$2a7,$2ac,$2b1,$2b5,$2ba,$2be,$2c3,$2c8,$2cc,$2d1
	dc.w	$2d5,$2d9,$2de,$2e2,$2e7,$2eb,$2ef,$2f3,$2f8,$2fc
	dc.w	$300,$304,$308,$30c,$310,$315,$319,$31c,$320,$324
	dc.w	$328,$32c,$330,$334,$337,$33b,$33f,$343,$346,$34a
	dc.w	$34d,$351,$354,$358,$35b,$35f,$362,$365,$369,$36c
	dc.w	$36f,$372,$376,$379,$37c,$37f,$382,$385,$388,$38b
	dc.w	$38e,$391,$394,$396,$399,$39c,$39f,$3a1,$3a4,$3a6
	dc.w	$3a9,$3ab,$3ae,$3b0,$3b3,$3b5,$3b8,$3ba,$3bc,$3be
	dc.w	$3c1,$3c3,$3c5,$3c7,$3c9,$3cb,$3cd,$3cf,$3d1,$3d3
	dc.w	$3d5,$3d6,$3d8,$3da,$3db,$3dd,$3df,$3e0,$3e2,$3e3
	dc.w	$3e5,$3e6,$3e8,$3e9,$3ea,$3ec,$3ed,$3ee,$3ef,$3f0
	dc.w	$3f1,$3f2,$3f3,$3f4,$3f5,$3f6,$3f7,$3f8,$3f9,$3f9
	dc.w	$3fa,$3fb,$3fb,$3fc,$3fc,$3fd,$3fd,$3fe,$3fe,$3ff
	dc.w	$3ff,$3ff,$3ff,$400,$400,$400,$400,$400,$400,$400
	dc.w	$400,$400,$400,$3ff,$3ff,$3ff,$3ff,$3fe,$3fe,$3fd
	dc.w	$3fd,$3fd,$3fc,$3fb,$3fb,$3fa,$3f9,$3f9,$3f8,$3f7
	dc.w	$3f6,$3f5,$3f4,$3f4,$3f3,$3f1,$3f0,$3ef,$3ee,$3ed
	dc.w	$3ec,$3ea,$3e9,$3e8,$3e6,$3e5,$3e4,$3e2,$3e1,$3df
	dc.w	$3dd,$3dc,$3da,$3d8,$3d7,$3d5,$3d3,$3d1,$3cf,$3cd
	dc.w	$3cb,$3c9,$3c7,$3c5,$3c3,$3c1,$3bf,$3bc,$3ba,$3b8
	dc.w	$3b6,$3b3,$3b1,$3ae,$3ac,$3a9,$3a7,$3a4,$3a2,$39f
	dc.w	$39c,$399,$397,$394,$391,$38e,$38b,$388,$385,$382
	dc.w	$37f,$37c,$379,$376,$373,$370,$36c,$369,$366,$363
	dc.w	$35f,$35c,$358,$355,$351,$34e,$34a,$347,$343,$33f
	dc.w	$33c,$338,$334,$330,$32d,$329,$325,$321,$31d,$319
	dc.w	$315,$311,$30d,$309,$305,$301,$2fd,$2f8,$2f4,$2f0
	dc.w	$2ec,$2e7,$2e3,$2de,$2da,$2d6,$2d1,$2cd,$2c8,$2c4
	dc.w	$2bf,$2bb,$2b6,$2b1,$2ad,$2a8,$2a3,$29e,$29a,$295
	dc.w	$290,$28b,$286,$281,$27d,$278,$273,$26e,$269,$264
	dc.w	$25f,$259,$254,$24f,$24a,$245,$240,$23a,$235,$230
	dc.w	$22b,$225,$220,$21b,$215,$210,$20b,$205,$200,$1fa
	dc.w	$1f5,$1ef,$1ea,$1e4,$1df,$1d9,$1d4,$1ce,$1c8,$1c3
	dc.w	$1bd,$1b7,$1b2,$1ac,$1a6,$1a0,$19b,$195,$18f,$189
	dc.w	$184,$17e,$178,$172,$16c,$166,$160,$15a,$154,$14f
	dc.w	$149,$143,$13d,$137,$131,$12b,$125,$11f,$118,$112
	dc.w	$10c,$106,$100,$fa,$f4,$ee,$e8,$e2,$db,$d5,$cf
	dc.w	$c9,$c3,$bd,$b6,$b0,$aa,$a4,$9e,$97,$91,$8b,$85
	dc.w	$7e,$78,$72,$6c,$65,$5f,$59,$53,$4c,$46,$40,$3a
	dc.w	$33,$2d,$27,$20,$1a,$14,13,7,1,$fffb,$fff4,$ffee
	dc.w	$ffe8,$ffe1,$ffdb,$ffd5,$ffcf,$ffc8,$ffc2,$ffbc
	dc.w	$ffb5,$ffaf,$ffa9,$ffa3,$ff9c,$ff96,$ff90,$ff8a
	dc.w	$ff83,$ff7d,$ff77,$ff71,$ff6a,$ff64,$ff5e,$ff58
	dc.w	$ff52,$ff4b,$ff45,$ff3f,$ff39,$ff33,$ff2c,$ff26
	dc.w	$ff20,$ff1a,$ff14,$ff0e,$ff08,$ff02,$fefb,$fef5
	dc.w	$feef,$fee9,$fee3,$fedd,$fed7,$fed1,$fecb,$fec5
	dc.w	$febf,$feb9,$feb3,$fead,$fea7,$fea1,$fe9b,$fe96
	dc.w	$fe90,$fe8a,$fe84,$fe7e,$fe78,$fe73,$fe6d,$fe67
	dc.w	$fe61,$fe5b,$fe56,$fe50,$fe4a,$fe45,$fe3f,$fe39
	dc.w	$fe34,$fe2e,$fe28,$fe23,$fe1d,$fe18,$fe12,$fe0d
	dc.w	$fe07,$fe02,$fdfc,$fdf7,$fdf2,$fdec,$fde7,$fde1
	dc.w	$fddc,$fdd7,$fdd2,$fdcc,$fdc7,$fdc2,$fdbd,$fdb7
	dc.w	$fdb2,$fdad,$fda8,$fda3,$fd9e,$fd99,$fd94,$fd8f
	dc.w	$fd8a,$fd85,$fd80,$fd7b,$fd76,$fd71,$fd6c,$fd68
	dc.w	$fd63,$fd5e,$fd59,$fd55,$fd50,$fd4b,$fd47,$fd42
	dc.w	$fd3e,$fd39,$fd35,$fd30,$fd2c,$fd27,$fd23,$fd1e
	dc.w	$fd1a,$fd16,$fd11,$fd0d,$fd09,$fd05,$fd01,$fcfc
	dc.w	$fcf8,$fcf4,$fcf0,$fcec,$fce8,$fce4,$fce0,$fcdc
	dc.w	$fcd8,$fcd4,$fcd1,$fccd,$fcc9,$fcc5,$fcc2,$fcbe
	dc.w	$fcba,$fcb7,$fcb3,$fcb0,$fcac,$fca9,$fca5,$fca2
	dc.w	$fc9e,$fc9b,$fc98,$fc94,$fc91,$fc8e,$fc8b,$fc88
	dc.w	$fc85,$fc82,$fc7e,$fc7b,$fc78,$fc76,$fc73,$fc70
	dc.w	$fc6d,$fc6a,$fc67,$fc65,$fc62,$fc5f,$fc5d,$fc5a
	dc.w	$fc57,$fc55,$fc52,$fc50,$fc4e,$fc4b,$fc49,$fc46
	dc.w	$fc44,$fc42,$fc40,$fc3e,$fc3b,$fc39,$fc37,$fc35
	dc.w	$fc33,$fc31,$fc2f,$fc2e,$fc2c,$fc2a,$fc28,$fc26
	dc.w	$fc25,$fc23,$fc21,$fc20,$fc1e,$fc1d,$fc1b,$fc1a
	dc.w	$fc19,$fc17,$fc16,$fc15,$fc13,$fc12,$fc11,$fc10
	dc.w	$fc0f,$fc0e,$fc0d,$fc0c,$fc0b,$fc0a,$fc09,$fc08
	dc.w	$fc08,$fc07,$fc06,$fc05,$fc05,$fc04,$fc04,$fc03
	dc.w	$fc03,$fc02,$fc02,$fc01,$fc01,$fc01,$fc01,$fc00
	dc.w	$fc00,$fc00,$fc00,$fc00,$fc00,$fc00,$fc00,$fc00
	dc.w	$fc00,$fc01,$fc01,$fc01,$fc01,$fc02,$fc02,$fc02
	dc.w	$fc03,$fc03,$fc04,$fc05,$fc05,$fc06,$fc06,$fc07
	dc.w	$fc08,$fc09,$fc0a,$fc0a,$fc0b,$fc0c,$fc0d,$fc0e
	dc.w	$fc0f,$fc11,$fc12,$fc13,$fc14,$fc15,$fc17,$fc18
	dc.w	$fc19,$fc1b,$fc1c,$fc1e,$fc1f,$fc21,$fc22,$fc24
	dc.w	$fc26,$fc27,$fc29,$fc2b,$fc2d,$fc2f,$fc31,$fc32
	dc.w	$fc34,$fc36,$fc38,$fc3b,$fc3d,$fc3f,$fc41,$fc43
	dc.w	$fc45,$fc48,$fc4a,$fc4c,$fc4f,$fc51,$fc54,$fc56
	dc.w	$fc59,$fc5b,$fc5e,$fc61,$fc63,$fc66,$fc69,$fc6c
	dc.w	$fc6f,$fc71,$fc74,$fc77,$fc7a,$fc7d,$fc80,$fc83
	dc.w	$fc86,$fc89,$fc8d,$fc90,$fc93,$fc96,$fc9a,$fc9d
	dc.w	$fca0,$fca4,$fca7,$fcab,$fcae,$fcb2,$fcb5,$fcb9
	dc.w	$fcbc,$fcc0,$fcc4,$fcc7,$fccb,$fccf,$fcd3,$fcd7
	dc.w	$fcdb,$fcde,$fce2,$fce6,$fcea,$fcee,$fcf2,$fcf6
	dc.w	$fcfb,$fcff,$fd03,$fd07,$fd0b,$fd10,$fd14,$fd18
	dc.w	$fd1d,$fd21,$fd25,$fd2a,$fd2e,$fd33,$fd37,$fd3c
	dc.w	$fd40,$fd45,$fd49,$fd4e,$fd53,$fd57,$fd5c,$fd61
	dc.w	$fd66,$fd6a,$fd6f,$fd74,$fd79,$fd7e,$fd83,$fd88
	dc.w	$fd8d,$fd92,$fd97,$fd9c,$fda1,$fda6,$fdab,$fdb0
	dc.w	$fdb5,$fdba,$fdc0,$fdc5,$fdca,$fdcf,$fdd5,$fdda
	dc.w	$fddf,$fde4,$fdea,$fdef,$fdf5,$fdfa,$fdff,$fe05
	dc.w	$fe0a,$fe10,$fe15,$fe1b,$fe21,$fe26,$fe2c,$fe31
	dc.w	$fe37,$fe3d,$fe42,$fe48,$fe4e,$fe53,$fe59,$fe5f
	dc.w	$fe64,$fe6a,$fe70,$fe76,$fe7c,$fe81,$fe87,$fe8d
	dc.w	$fe93,$fe99,$fe9f,$fea5,$feab,$feb1,$feb7,$febd
	dc.w	$fec3,$fec9,$fecf,$fed5,$fedb,$fee1,$fee7,$feed
	dc.w	$fef3,$fef9,$feff,$ff05,$ff0b,$ff11,$ff17,$ff1e
	dc.w	$ff24,$ff2a,$ff30,$ff36,$ff3c,$ff42,$ff49,$ff4f
	dc.w	$ff55,$ff5b,$ff61,$ff68,$ff6e,$ff74,$ff7a,$ff81
	dc.w	$ff87,$ff8d,$ff93,$ff9a,$ffa0,$ffa6,$ffac,$ffb3
	dc.w	$ffb9,$ffbf,$ffc6,$ffcc,$ffd2,$ffd8,$ffdf,$ffe5
	dc.w	$ffeb,$fff2,$fff8,$fffe,4


CharsData:	; Vector-Characters definitions (x0,y0,y1,y1, ... ,-1)
Ch:
	dc.w	-1
ChEscl:
	dc.w	3,0,4,0, 4,0,4,3, 4,3,3,3, 3,3,3,0
	dc.w	3,5,4,5, 4,5,4,6, 4,6,3,6, 3,6,3,5, -1
ChVirgtt:
	dc.w	2,0,2,1, 4,0,4,1, -1
ChNumb:
	dc.w	2,0,2,6, 4,0,4,6, 0,2,6,2, 0,4,6,4, -1
ChString:
	dc.w	-1
ChPercent:
	dc.w	0,6,6,0, 0,0,1,0, 1,0,1,1, 1,1,0,1, 0,1,0,0, 6,6,5,6
	dc.w	5,6,5,5, 5,5,6,5, 6,5,6,6, -1
ChAnd:
	dc.w	-1
ChApice:
	dc.w	3,0,4,0, 4,0,4,1, 4,1,3,2, -1
ChAperta:
	dc.w	4,0,3,0, 3,0,2,1, 2,1,2,5, 2,5,3,6, 3,6,5,6, -1
ChChiusa:
	dc.w	2,0,3,0, 3,0,4,1, 4,1,4,5, 4,5,3,6, 3,6,2,6, -1
ChPer:
	dc.w	0,3,6,3, 3,0,3,6, 1,1,5,5, 1,5,5,1, -1
ChPiu:
	dc.w	3,1,3,5, 0,3,5,3, -1
ChVirgola:
	dc.w	3,5,4,5, 4,5,4,6, 4,6,3,7, -1
ChMeno:
	dc.w	0,3,5,3, -1
ChPunto:
	dc.w	3,5,4,5, 4,5,4,6, 4,6,3,6, 3,6,3,5, -1
ChSlash:
	dc.w	0,6,6,0, -1
Ch0:
	dc.w	0,1,1,0, 1,0,5,0, 5,0,6,1, 6,1,6,5, 6,5,5,6, 5,6,1,6
	dc.w	1,6,0,5, 0,5,0,1, 3,2,3,4, -1
Ch1:
	dc.w	3,0,3,6, 1,6,5,6, 1,2,3,0, -1
Ch2:
	dc.w	6,6,0,6, 0,6,0,4, 0,4,1,3, 1,3,5,3, 5,3,6,2, 6,2,6,1
	dc.w	6,1,5,0, 5,0,1,0, 1,0,0,1, -1
Ch3:
	dc.w	0,5,1,6, 1,6,5,6, 5,6,6,5, 6,5,6,4, 6,4,5,3, 5,3,3,3
	dc.w	5,3,6,2, 6,2,6,1, 6,1,5,0, 5,0,1,0, 1,0,0,1, -1
Ch4:
	dc.w	5,0,5,6, 6,4,0,4, 0,4,5,0, -1
Ch5:
	dc.w	6,0,0,0, 0,0,0,2, 0,2,5,2, 5,2,6,3, 6,3,6,5, 0,4,0,5
	dc.w	0,5,1,6, 1,6,5,6, 5,6,6,5, -1
Ch6:
	dc.w	6,1,5,0, 5,0,1,0, 1,0,0,1, 0,1,0,5, 0,5,1,6, 1,6,5,6
	dc.w	5,6,6,5, 6,5,6,4, 6,4,5,3, 5,3,0,3, -1
Ch7:
	dc.w	0,0,6,0, 6,0,6,1, 6,1,2,5, 2,5,6,5, -1
Ch8:
	dc.w	1,0,5,0, 5,0,6,1, 6,1,6,2, 6,2,5,3, 5,3,6,4, 6,4,6,5
	dc.w	6,5,5,6, 5,6,1,6, 1,6,0,5, 0,5,0,4, 0,4,1,3, 1,3,0,2
	dc.w	0,2,0,1, 0,1,1,0, 1,3,5,3, -1
Ch9:
	dc.w	0,5,1,6, 1,6,5,6, 5,6,6,5, 6,5,6,1, 6,1,5,0, 5,0,1,0
	dc.w	1,0,0,1, 0,1,0,2, 0,2,1,3, 1,3,6,3, -1
ChDueP:
	dc.w	3,5,4,5, 4,5,4,6, 4,6,4,6, 3,6,3,5
	dc.w	3,0,3,1, 3,1,4,1, 4,1,4,0, 4,0,3,0, -1
ChPuntEV:
	dc.w	3,5,4,5, 4,5,4,6, 4,6,3,7
	dc.w	3,1,3,2, 3,2,4,2, 4,2,4,1, 4,1,3,1, -1
ChMin:
	dc.w	4,1,2,3, 2,3,4,5, -1
ChUgual:
	dc.w	1,2,5,2, 1,4,5,4, -1
ChMag:
	dc.w	2,1,4,3, 4,3,2,5, -1
ChInterr:
	dc.w	-1
ChAt:
	dc.w	-1
ChA:
	dc.w	3,0,0,3, 0,3,0,6, 3,0,6,3, 6,3,6,6, 0,4,6,4, -1
ChB:
	dc.w	0,0,0,6, 0,0,5,0, 5,0,6,1, 6,1,6,2, 6,2,5,3, 5,3,6,4, 6,4,6,5
	dc.w	6,5,5,6, 5,6,0,6, 0,3,5,3, -1
ChC:
	dc.w	6,1,5,0, 5,0,1,0, 1,0,0,1, 0,1,0,5, 0,5,1,6, 1,6,5,6, 5,6,6,5, -1
ChD:
	dc.w	0,0,0,6, 0,6,4,6, 4,6,6,4, 6,4,6,2, 6,2,4,0, 4,0,0,0, -1
ChE:
	dc.w	0,0,0,6, 0,0,6,0, 0,3,5,3, 0,6,6,6, -1
ChF:
	dc.w	0,0,0,6, 0,0,6,0, 0,3,5,3, -1
ChG:
	dc.w	6,1,5,0, 5,0,1,0, 1,0,0,1, 0,1,0,5, 0,5,1,6, 1,6,5,6, 5,6,6,5
	dc.w	6,5,6,3, 6,3,4,3, -1
ChH:
	dc.w	0,0,0,6, 0,3,6,3, 6,0,6,6, -1
ChI:
	dc.w	1,0,5,0, 1,6,5,6, 3,0,3,6, -1
ChJ:
	dc.w	0,5,1,6, 1,6,5,6, 5,6,6,5, 6,5,6,0, 6,0,4,0, -1
ChK:
	dc.w	0,0,0,6, 0,3,3,3, 3,3,6,0, 3,3,6,6, -1
ChL:
	dc.w	0,0,0,6, 0,6,6,6, -1
ChM:
	dc.w	0,0,0,6, 0,0,3,3, 3,3,6,0, 6,0,6,6, -1
ChN:
	dc.w	0,0,0,6, 0,0,6,6, 6,6,6,0, -1
ChO:
	dc.w	6,1,5,0, 5,0,1,0, 1,0,0,1, 0,1,0,5, 0,5,1,6, 1,6,5,6, 5,6,6,5
	dc.w	6,5,6,1, -1
ChP:
	dc.w	0,0,0,6, 0,0,5,0, 5,0,6,1, 6,1,6,2, 6,2,5,3, 5,3,0,3, -1
ChQ:
	dc.w	6,1,5,0, 5,0,1,0, 1,0,0,1, 0,1,0,5, 0,5,1,6, 1,6,5,6, 5,6,6,5
	dc.w	6,5,6,1, 5,5,7,7,  -1
ChR:
	dc.w	0,0,0,6, 0,0,5,0, 5,0,6,1, 6,1,6,2, 6,2,5,3, 5,3,0,3
	dc.w	4,3,6,6, -1
ChS:
	dc.w	5,0,1,0, 1,0,0,1, 0,1,0,2, 0,2,1,3, 1,3,5,3, 5,3,6,4
	dc.w	6,4,6,5, 6,5,5,6, 5,6,0,6, -1
ChT:
	dc.w	0,0,6,0, 3,0,3,6, -1
ChU:
	dc.w	0,0,0,5, 0,5,1,6, 1,6,5,6, 5,6,6,5, 6,5,6,0, -1
ChV:
	dc.w	0,0,3,6, 3,6,6,0, -1
ChW:
	dc.w	0,0,0,5, 0,5,1,6, 1,6,3,4, 3,4,5,6, 5,6,6,5, 6,5,6,0, -1
ChX:
	dc.w	6,0,0,6, 0,0,6,6, -1
ChY:
	dc.w	0,0,3,3, 3,3,3,6, 3,3,6,0, -1
ChZ:
	dc.w	6,6,0,6, 0,6,6,0, 6,0,0,0, -1
ChQAperta:
	dc.w	4,0,2,0, 2,0,2,6, 2,6,4,6, -1
ChBSlash:
	dc.w	0,0,6,6, -1
ChQChiusa:
	dc.w	4,0,2,0, 4,0,4,6, 2,6,4,6, -1


	cnop	0,4

CharsOffs:
	dc.l	Ch
	dc.l	ChEscl
	dc.l	ChVirgtt
	dc.l	ChNumb
	dc.l	ChString
	dc.l	ChPercent
	dc.l	ChAnd
	dc.l	ChApice
	dc.l	ChAperta
	dc.l	ChChiusa
	dc.l	ChPer
	dc.l	ChPiu
	dc.l	ChVirgola
	dc.l	ChMeno
	dc.l	ChPunto
	dc.l	ChSlash
	dc.l	Ch0
	dc.l	Ch1
	dc.l	Ch2
	dc.l	Ch3
	dc.l	Ch4
	dc.l	Ch5
	dc.l	Ch6
	dc.l	Ch7
	dc.l	Ch8
	dc.l	Ch9
	dc.l	ChDueP
	dc.l	ChPuntEV
	dc.l	ChMin
	dc.l	ChUgual
	dc.l	ChMag
	dc.l	ChInterr
	dc.l	ChAt
	dc.l	ChA
	dc.l	ChB
	dc.l	ChC
	dc.l	ChD
	dc.l	ChE
	dc.l	ChF
	dc.l	ChG
	dc.l	ChH
	dc.l	ChI
	dc.l	ChJ
	dc.l	ChK
	dc.l	ChL
	dc.l	ChM
	dc.l	ChN
	dc.l	ChO
	dc.l	ChP
	dc.l	ChQ
	dc.l	ChR
	dc.l	ChS
	dc.l	ChT
	dc.l	ChU
	dc.l	ChV
	dc.l	ChW
	dc.l	ChX
	dc.l	ChY
	dc.l	ChZ
	dc.l	ChQAperta
	dc.l	ChBSlash
	dc.l	ChQChiusa

;------------------------------------------------------
;	0	: End Of Page
;	1 to 9	: stretchvals
;	10	: CR
;	11,x,y	: Set cursor x,y pos (pixels)

;------------------------------------------------------

Text:
	dc.b	11,0,0
	dc.b	2," MOST ORIGINAL BBS",10
	dc.b	11,0,200,2,"5 - PUBLIC ENEMY",10
	DC.B	11,64,220,1,"[INDEPENDENT]",10
	dc.b	11,0,160,2,"4 - STRANGELAND",10
	DC.B	11,64,180,1,"(HERESY)",10
	dc.b	11,0,120,2,"3 - HEART OF NOWHERE",10
	DC.B	11,64,140,1,"(MOTION)",10
	dc.b	11,0,80,2,"2 - ASYLUM",10
	DC.B	11,64,100,1,"(COPYRIGHT DESTROYERS INC.)",10
	dc.b	11,0,40,2,"1 - INFINTE DREAMS",10
	DC.B	11,64,60,1,"(HALF-BRAINS TEAM) ",10
	dc.b	0

Text1:
	dc.b	11,0,0
	dc.b	3," BEST BBS",10
	dc.b	11,0,200,2,"5 - ASYLUM",10
	DC.B	11,64,220,1,"(COPYRIGHT DESTROYERS INC.)",10
	dc.b	11,0,160,2,"4 - TEMPLE OF GURUS",10
	DC.B	11,64,180,1,"(TECHNOBRAINS)",10
	dc.b	11,0,120,2,"3 - STRANGE LAND",10
	DC.B	11,64,140,1,"(HERESY)",10
	dc.b	11,0,80,2,"2 - TEMPLE OF DESTR.",10
	DC.B	11,64,100,1,"(DIVINA)",10
	dc.b	11,0,40,2,"1 - THE HOUSE",10
	DC.B	11,64,60,1,"(ITALIAN BAD BOYS) ",10
	dc.b	0

	dc.b	-1


	cnop	0,4

LinesData:	; dc.w	X0,Y0,X1,Y1,dX0,dY0,dX1,dY1,sX0,sY0,sX1,sY1
		dcb.w	12*(Frames+1),-1

*****************************************************************************

	SECTION	miacopper,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DiwStart
	dc.w	$90,$2cc1			; DiwStop
	dc.w	$92,$38				; DdfStart
	dc.w	$94,$d0				; DdfStop
	dc.w	$102,0				; BplCon1
	dc.w	$104,$24			; BplCon2
	dc.w	$108,0				; Bpl1Mod
	dc.w	$10a,0				; Bpl2Mod

	dc.w	$100,$2200			; BPLCON0 - 5 BitPlanes

BplPointers:
	dc.w    $e0,0,$e2,0
	dc.w	$e4,0,$e6,0

; Set color registers:

	dc.w	$0180,$0000			; COLOR00 - schwarz (Hintergrund)
	dc.w	$0182,$0ff0			; COLOR01 - gelb (cursor und gunwriter)
	dc.w	$0184,$0fff			; color2 - wei (Buchstabe gestoppt)
	dc.w	$0186,$0ff0			; color3 - gelb (gunwriter+Buchstabe)

	dc.w    $ffff,$fffe			; end of CList

*****************************************************************************

	SECTION	straplane,BSS_C

plane1:
	ds.b	40*256
plane2:
	ds.b	40*256
plane5:
	ds.b	40*256


	end

