
; Listing17c5.s = plasma5.s
; Plasma5.s	Plasma RGB mit 2-Bitplanes und Welligkeit
; linke Taste zum Beenden

	SECTION	PLASMA,CODE

;	Include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Copper,Bitplane,Blitter DMA

WaitDisk	equ	10

WidthPlasma	equ	36				; Plasmabreite ausgedrckt
								; als Anzahl der Gruppen von 8 Pixeln

; Anzahl der von jeder Plasmazeile belegten Bytes in der Copperliste:
; Der copperbefehl bentigt 4 Bytes. Jede Reihe besteht aus 1 "Copper move" in
; BPLCON1, 1 WAIT, Width_plasm "Copper move" fr Plasma (einschlielich
; letzter "Copper move" in COLOR00, um den Hintergrund schwarz zu machen.

BytesPerLine	equ	(WidthPlasma+2)*4

HighPlasma	equ	235				; Plasmahhe ausgedrckt
								; als Anzahl der Zeilen

NewLineR	equ	6				; Wert hinzufgen zum Index R in der
								; SinTab zwischen einer Zeile und einer anderen
								; Es kann zum Erhalten von verschiedener Plasmen 
								; variiert werden, aber es MUSS IMMER GERADE SEIN !!

NewFrameR	equ	2				; Wert abziehen vom Index R in der
								; SinTab zwischen einem Frame und einem anderen
								; Es kann zum Erhalten von verschiedener Plasmen 
								; variiert werden, aber es MUSS IMMER GERADE SEIN !!

NewLineG	equ	2				; wie "NewLineR" aber fr Komponente G
NewFrameG	equ	8				; wie "NewFrameR" aber fr Komponente G

NewLineB	equ	-12				; wie "NewLineR" aber fr Komponente B
NewFrameB	equ	-6				; wie "NewFrameR" aber fr Komponente B

NewLineO	equ	12				; wie "NewLineR" aber fr Oszillation
NewFrameO	equ	-4				; wie "NewFrameR" aber fr Oszillation


Start:

;	Zeiger Bitplanes in Copperlist

	move.l	#Bitplane,d0		; Bitplane 1 (Plasma)
	lea	Copperlist1,a1			; Zeiger Copperlist 1
	lea	Copperlist2,a2			; Zeiger Copperlist 2
	move.w	d0,6(a1)			; schreibt in Copperlist 1 
	move.w	d0,6(a2)			; schreibt in Copperlist 2
	swap	d0
	move.w	d0,2(a1)			; schreibt in Copperlist 1
	move.w	d0,2(a2)			; schreibt in Copperlist 2

	move.l	#Pic,d0				; Bitplane 2 (Maske)
	move.w	d0,14(a1)			; schreibt in Copperlist 1 
	move.w	d0,14(a2)			; schreibt in Copperlist 2
	swap	d0	
	move.w	d0,10(a1)			; schreibt in Copperlist 1
	move.w	d0,10(a2)			; schreibt in Copperlist 2


	lea	$dff000,a5				; Custom Register Base in a5

	bsr	InitPlasma				; initialisiert die Copperlist

; Blitter Register initialisieren

	btst	#6,2(a5)
WaitBlitInit:
	btst	#6,2(a5)			; auf den Blitter warten
	bne.s	WaitBlitInit

	move.l	#$4ffe8000,$40(a5)	; BLTCON0/1 - D=A+B+C
								; shift A = 4 pixel
								; shift B = 8 pixel
					
	moveq	#-1,d0				; d0 = $FFFFFFFF
	move.l	d0,$44(a5)			; BLTAFWM/BLTALWM

mod_A	set	0					; modulo Kanal A
mod_D	set	BytesPerLine-2		; modulo Kanal D: geht zur nchsten Zeile

	move.l	#mod_A<<16+mod_D,$64(a5)	; Modulo Register laden

; modulo Kanle B und C = 0

	moveq	#0,d0
	move.l	d0,$60(a5)			; schreibt BLTBMOD und BLTCMOD

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist1,$80(a5) ; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist

; Hardware-Register initialisieren
; d0=0
	move.w	d0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"
	move.l	d0,$180(a5)			; COLOR00 und COLOR01 - schwarz
	move.w	#$3e90,$8e(a5)		; DIWSTRT - Wir benutzen ein weiteres Fenster
								; kleiner Bildschirm
	move.w	#$e6b1,$90(a5)		; DIWSTOP
	move.w	#$0036,$92(a5)		; DDFSTRT - sind geholt 40 bytes
	move.w	#$00ce,$94(a5)		; DDFSTOP
	move.l	d0,$102(a5)			; BPLCON1/2
	move.w	#-40,$108(a5)		; BPL1MOD = -40 wiederholt immer die gleiche
								; Zeile
	move.w	#0,$10a(a5)			; BPL2MOD = 0 normal
	move.w	#$2200,$100(a5)		; BPLCON0 - 2 Bitplane aktiv

Mouse2:
	move.l	#$1ff00,d1			; Bits durch UND auswhlen
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WaitY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	D2,d0				; warte auf Zeile $130 (304)
	bne.s	WaitY2

	bsr	SwapClists				; Copperlist austauschen

	bsr	DoHoriz					; horizontaler Welleneffekt
	bsr	DoPlasma

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse2

	rts

;****************************************************************************
; Diese Routine realisiert den horizontalen Schwingeffekt.
; Der Effekt wird durch ndern des Hardware-Scroll-Werts in jeder Zeile
; der Bitebene 1 erreicht. Die Werte werden aus einer Tabelle gelesen und in
; die Copperliste geschrieben.
;****************************************************************************

DoHoriz:
	lea	HorizTab(pc),a0			; Adresse Tabelle Oszillation
	move.l	DrawClist(pc),a1	; Adresse Copperlist schreiben
	lea	19(a1),a1				; Adresse zweites Byte des zweiten
								; Wortes des "Copper moves" in BPLCON1
								; liest und ndert den Index

	move.w	IndexO(pc),d4		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameO,d4		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$007f,d4			; hlt den Index im Bereich
								; 0 - 127 (Offset in einer Tabelle von
								; 128 Byte)
	move.w	d4,IndexO			; speichert den Startindex fr
								; den nchsten frame

	move.w	#HighPlasma-1,d3	; Schleife fr jede Zeile
HorizLoop:
	move.b	0(a0,d4.w),d0		; Oszillationswert ablesen

	move.b	d0,(a1)				; schreibt den Scroll-Wert in den
								; "Copper move" in BPLCON1

	lea	BytesPerLine(a1),a1		; zeigt auf die nchste Zeile
								; in der Copperliste
								; Index fr nchste Zeile bearbeiten

	add.w	#NewLineO,d4		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$007f,d4			; hlt den Index im Bereich
								; 0 - 127 (Offset in einer Tabelle von
								; 128 Byte)

	dbra	d3,HorizLoop

	rts

;****************************************************************************
; Diese Routine realisiert den "double buffer" zwischen den Copperlisten.
; In der Praxis beginnt es, wo es gezeichnet wird, und visualisiert
; es durch Kopieren der Adresse in COP1LC. Tauschen Sie die Variablen so aus,
; dass im folgenden frame auf der anderen Copperlist gezeichnet wird. 
;****************************************************************************

SwapClists:
	move.l	DrawClist(pc),d0	; Adresse clist auf dem es geschrieben steht
	move.l	ViewClist(pc),DrawClist	; austauschen clists
	move.l	d0,ViewClist

	move.l	d0,$80(a5)			; kopiere die Adresse der Copperlist
								; in COP1LC damit es
								; im nchsten Frame angezeigt wird
	rts


;****************************************************************************
; Diese Routine initialisiert die Copperliste, die das Plasma erzeugt. System
; WAIT-Anweisungen und die erste Hlfte der COPPERMOVE.
;****************************************************************************

InitPlasma:
	lea	Plasma1,a0				; Adresse Plasma 1
	lea	Plasma2,a1				; Adresse Plasma 2
	move.l	#$3e43fffe,d0		; ldt die erste wait-Anweisung in d0.
								; warte auf Zeile $3e und Position
								; horizontal $42
	move.w	#$184,d1			; setzt die erste Hlfte einer Anweisung in d1
								; "Copper move" in COLOR02 (=$dff184)
	move.w	#$186,d4			; setzt die erste Hlfte einer Anweisung in D4
								; "Copper move" in COLOR03 (=$dff186)
	move.w	#$102,d5			; setzt die erste Hlfte einer Anweisung in D5 
								; "Copper move" in BPLCON1 (=$dff102)

	move.w	#HighPlasma-1,d3		; Schleife fr jede Zeile
InitLoop1:
	move.w	d5,(a0)+			; schreibt den ersten Teil des
								; "Copper move" in BPLCON1 - clist 1
	addq.w	#2,a0				; Platz fr den zweiten Teil
								; des "Copper move" - clist 1
	
	move.w	d5,(a1)+			; schreibt den ersten Teil des
								; "Copper move" in BPLCON1 - clist 2
	addq.w	#2,a1				; Platz fr den zweiten Teil
								; des "Copper move" - clist 2

	move.l	d0,(a0)+			; schreibe WAIT - (clist 1)
	move.l	d0,(a1)+			; schreibe WAIT - (clist 2)
	add.l	#$01000000,d0		; ndere das WAIT, um in
								; der folgenden Zeile zu warten

	moveq	#WidthPlasma/2-1,d2	;  Schleife ber die gesamte Breite

InitLoop2:
	move.w	d4,(a0)+			; schreibt den ersten Teil des
								; "Copper move" in COLOR02 - clist 1
	addq.w	#2,a0				; Platz fr den zweiten Teil
								; des "Copper move" - clist 1

	move.w	d4,(a1)+			; schreibt den ersten Teil des
								; "Copper move" in COLOR02 - clist 2
	addq.w	#2,a1				; Platz fr den zweiten Teil
								; des "Copper move" - clist 2

	move.w	d1,(a0)+			; schreibt den ersten Teil des
								; "Copper move" in COLOR03 - clist 1
	addq.w	#2,a0				; Platz fr den zweiten Teil
								; des "Copper move" - clist 1

	move.w	d1,(a1)+			; schreibt den ersten Teil des
								; "Copper move" in COLOR03 - clist 2
	addq.w	#2,a1				; Platz fr den zweiten Teil
								; des "Copper move" - clist 2
	dbra	d2,InitLoop2
	dbra	d3,InitLoop1
	rts


;****************************************************************************
; Diese Routine macht das Plasma. Es macht jeweils eine Schleife von Blitts
; bei denen es eine "Spalte" des Plasmas schreibt, das heit, es schreibt
; die Farben in die COPPERMOVES-Spalte.
; Die in jeder Spalte geschriebenen Farben werden aus einer Tabelle gelesen,
; beginnend mit einer Adresse, die von einer Spalte zur anderen variiert,
; basierend auf Offsets die aus einer anderen Tabelle gelesen werden.
; Auch zwischen einem frame und einem anderen variieren die Offsets um
; den Effekt der Bewegung zu realisieren.
;****************************************************************************

DoPlasma:
	lea	Color,a0				; Adresse Farben
	lea	SinTab,a6				; Adresse Tabelle Offsets
	move.l	DrawClist(pc),a1	; Adresse Copperlist schreiben
	lea	26(a1),a1				; Adresse des ersten Wortes der ersten
								; Plasmasule
; liest und ndert den Index Komponente R

	move.w	IndexR(pc),d4		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameR,d4		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00ff,d4			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 words)
	move.w	d4,IndexR			; speichert den Startindex fr
								; das nchste Bild
; liest und ndert den Index Komponente G

	move.w	IndexG(pc),d5		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameG,d5		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00ff,d5			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 words)
	move.w	d5,IndexG			; speichert den Startindex fr
								; das nchste Bild
; liest und ndert den Index Komponente B

	move.w	IndexB(pc),d6		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameB,d6		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00FF,d6			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 words)
	move.w	d6,IndexB			; speichert den Startindex fr
								; das nchste Bild

	move.w	#HighPlasma<<6+1,d3	; Gre Blitt
								; Breite 1 word, Hhe gesamtes Plasma

	moveq	#WidthPlasma-1,d2	; die Schleife wird NICHT ber die Breite durchgehend
								; wiederholt. Die letzten 2 Spalten
								; werden in Ruhe gelassen, damit
								; wird die Farbe schwarz in die
								; Register COLOR01 und COLOR00 geschrieben 

PlasmaLoop:						; Startschleife Blitt

; Berechnung der Startadresse der Komponente R

	move.w	(a6,d4.w),d1		; liest Offset aus der Tabelle

	lea	(a0,d1.w),a2			; Startadresse = Farben
								; mehr Offset

; Berechnung der Startadresse der Komponente G

	move.w	(a6,d5.w),d1		; liest Offset aus der Tabelle

	lea	(a0,d1.w),a3			; Startadresse = Farben
								; mehr Offset

; Berechnung der Startadresse der Komponente B

	move.w	(a6,d6.w),d1		; liest Offset aus der Tabelle

	lea	(a0,d1.w),a4			; Startadresse = Farben
								; mehr Offset

	btst	#6,2(a5)
WaitBlit:
	btst	#6,2(a5)			; auf den Blitter warten
	bne.s	WaitBlit

	move.l	a2,$48(a5)			; BLTCPT - Adresse Quelle R
	move.l	a3,$50(a5)			; BLTAPT - Adresse Quelle G
	move.l	a4,$4c(a5)			; BLTBPT - Adresse Quelle B
	move.l	a1,$54(a5)			; BLTDPT - Adresse Ziel
	move.w	d3,$58(a5)			; BLTSIZE

	addq.w	#4,a1				; zeigt auf die nchste Spalte von
								; "Copper moves" in der Copperliste

; ndern Index Komponente R fr die nchste Zeile

	add.w	#NewLineR,d4		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00ff,d4			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 Wrter)

; ndern Index Komponente G fr die nchste Zeile

	add.w	#NewLineG,d5		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00ff,d5			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 Wrter)

; ndern Index Komponente B fr die nchste Zeile

	add.w	#NewLineB,d6		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00FF,d6			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 Wrter)
	dbra	d2,PlasmaLoop
	rts


; Diese 2 Variablen enthalten die Adressen der 2 Copperlisten

ViewClist:	dc.l	Copperlist1	; Adresse clist Visualisierung
DrawClist:	dc.l	Copperlist2	; Adresse clist wo soll man zeichnen

; Diese Variable enthlt den Wert des Index in der Tabelle von
; Oszillationen (horizontale Positionen der WAITs)

IndexO:	dc.w	0

; Diese Tabelle enthlt die Werte der Schwingungen (Scrollwerte von
; Bitebene 1)

HorizTab:
	DC.B	$03,$03,$03,$03,$04,$04,$04,$04,$04,$04,$04,$05,$05,$05,$05,$05
	DC.B	$05,$05,$05,$05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06
	DC.B	$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05,$05,$05
	DC.B	$05,$05,$05,$05,$05,$05,$04,$04,$04,$04,$04,$04,$04,$03,$03,$03
	DC.B	$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01
	DC.B	$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01
	DC.B	$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$03,$03,$03

; Diese Variablen enthalten die Indexwerte fr die erste Spalte

IndexR:	dc.w	0
IndexG:	dc.w	0
IndexB:	dc.w	0

; Diese Tabelle enthlt die Offsets fr die Startadresse in der
; Farbtabelle

SinTab:
	dc.w	$0034,$0036,$0038,$003a,$003c,$0040,$0042,$0044,$0046,$0048
	dc.w	$004a,$004c,$004e,$0050,$0052,$0054,$0056,$0058,$005a,$005a
	dc.w	$005c,$005e,$005e,$0060,$0060,$0062,$0062,$0062,$0064,$0064
	dc.w	$0064,$0064,$0064,$0064,$0064,$0064,$0062,$0062,$0062,$0060
	dc.w	$0060,$005e,$005e,$005c,$005a,$005a,$0058,$0056,$0054,$0052
	dc.w	$0050,$004e,$004c,$004a,$0048,$0046,$0044,$0042,$0040,$003c
	dc.w	$003a,$0038,$0036,$0034,$0030,$002e,$002c,$002a,$0028,$0024
	dc.w	$0022,$0020,$001e,$001c,$001a,$0018,$0016,$0014,$0012,$0010
	dc.w	$000e,$000c,$000a,$000a,$0008,$0006,$0006,$0004,$0004,$0002
	dc.w	$0002,$0002,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0002,$0002,$0002,$0004,$0004,$0006,$0006,$0008,$000a,$000a
	dc.w	$000c,$000e,$0010,$0012,$0014,$0016,$0018,$001a,$001c,$001e
	dc.w	$0020,$0022,$0024,$0028,$002a,$002c,$002e,$0030
EndSinTab:

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

; Wir haben 2 copperlists 

Copperlist1:
	dc.w	$e0,$0000,$e2,$0000	; Bitplane 1
	dc.w	$e4,$0000,$e6,$0000	; Bitplane 2

; Hier bleibt etwas Platz fr das Stck Copperliste, dass das Plasma erzeugt.
; Dieser Raum wird von den Routinen die den Effekt erstellen ausgefllt.

Plasma1:
	dcb.b	HighPlasma*BytesPerLine,0
	dc.w	$ffff,$fffe			; Ende der Copperlist

;****************************************************************************

Copperlist2:
	dc.w	$e0,$0000,$e2,$0000	; Bitplane 1
	dc.w	$e4,$0000,$e6,$0000	; Bitplane 2

; Hier bleibt etwas Platz fr das Stck Copperliste, dass das Plasma erzeugt.
; Dieser Raum wird von den Routinen die den Effekt erstellen ausgefllt.

Plasma2:
	dcb.b	HighPlasma*BytesPerLine,0
	dc.w	$ffff,$fffe			; Ende der Copperlist
	
;****************************************************************************
; Hier ist die Farbtabelle, die in das Plasma geschrieben wird.
; Es mssen gengend Farben vorhanden sein, um die Adresse des Starts
; lesen zu knnen. In diesem Beispiel kann die Startadresse von 
; der "Farbe" (erste Farbe) bis "Farbe + 100" (50. Farbe) abweichen, weil
; 100 der maximale Offset ist, der in der "SinTab" enthalten ist.
; Wenn Alt_plasm = 190 ist, bedeutet dies, dass jeder Blitt 190 Farben liest.
; Insgesamt mssen also 240 Farben vorhanden sein.
;****************************************************************************

Color:
	dc.w	$0f00,$0f00,$0e00,$0e00,$0e00,$0d00,$0d00,$0d00
	dc.w	$0c00,$0c00,$0c00,$0b00,$0b00,$0b00,$0a00,$0a00,$0a00
	dc.w	$0900,$0900,$0900,$0800,$0800,$0800,$0700,$0700,$0700
	dc.w	$0600,$0600,$0600,$0500,$0500,$0500,$0400,$0400,$0400
	dc.w	$0300,$0300,$0300,$0200,$0200,$0200,$0100,$0100,$0100
	dcb.w	18,0
	dc.w	$0100,$0100,$0100,$0100,$0200,$0200,$0200,$0200
	dc.w	$0300,$0300,$0300,$0300,$0400,$0400,$0400,$0400
	dc.w	$0500,$0500,$0500,$0500,$0600,$0600,$0600,$0600
	dc.w	$0700,$0700,$0700,$0700,$0800,$0800,$0800,$0800
	dc.w	$0900,$0900,$0900,$0900,$0a00,$0a00,$0a00,$0a00
	dc.w	$0b00,$0b00,$0b00,$0b00,$0c00,$0c00,$0c00,$0c00
	dc.w	$0d00,$0d00,$0d00,$0d00,$0e00,$0e00,$0e00,$0e00
	dc.w	$0f00,$0f00,$0f00,$0f00

	dc.w	$0f00,$0f00,$0f00,$0f00,$0e00,$0e00,$0e00,$0e00
	dc.w	$0d00,$0d00,$0d00,$0d00,$0c00,$0c00,$0c00,$0c00
	dc.w	$0b00,$0b00,$0b00,$0b00,$0a00,$0a00,$0a00,$0a00
	dc.w	$0900,$0900,$0900,$0800,$0800,$0800,$0800
	dc.w	$0700,$0700,$0700,$0700,$0600,$0600,$0600,$0600
	dc.w	$0500,$0500,$0500,$0500,$0400,$0400,$0400,$0400
	dc.w	$0300,$0300,$0300,$0300,$0200,$0200,$0200,$0200
	dc.w	$0100,$0100,$0100
	dcb.w	18,0
	dc.w	$0100,$0100,$0100,$0200,$0200,$0200,$0300,$0300,$0300
	dc.w	$0400,$0400,$0400,$0500,$0500,$0500,$0600,$0600,$0600
	dc.w	$0700,$0700,$0700,$0800,$0800,$0900,$0900,$0900
	dc.w	$0a00,$0a00,$0a00,$0b00,$0b00,$0b00,$0c00,$0c00,$0c00
	dc.w	$0d00,$0d00,$0d00,$0e00,$0e00,$0e00,$0f00

; Bildzeile, die mit dem BPLMOD1 wiederholt wird
; es besteht aus 40 Bytes alternativ zu 0 oder zu $FF

Bitplane:	
	dcb.w	20,$00ff

; Plasmamaske: Dies ist ein 320 * 168 Pixel 1 Bitplane-Bild

Pic:	
	incbin	"/Sources/plasm_msk.raw"

	end

;****************************************************************************

In diesem Beispiel sehen wir ein Plasma mit 2 Bitebenen. Es geht um eine
einfache Variante von Plasma mit 2 Bitebenen. Bitebene 1 wird verwendet, um das
Plasma zu erstellen und Bitplane 2 als Maske. Das Plasma verwendet die
Farben 2 und 3. Dann erscheint das Plasma bei den Pixeln mit dem Wert 1 von
Bitplane-Maske.
Diese Technik hat auch den Vorteil, dass kein schwarz am Ende der Zeile
geschrieben werden muss, da die Farbe 0 (Hintergrund) nicht berhrt wird. Auf
diese Weise knnen wir ein schmaleres Plasma verwenden, als es im Beispiel
plasm4.s verwendet wird, obwohl die sichtbare Breite gleich ist.
(Wir sparen die letzten 2 "copper moves" jeder Zeile. Vergleichen Sie die
verschiedenen Werte des Parameters "Largh_plasm"). Offensichtlich wird die
Masken-Bitebene dann normal angezeigt ohne Bildlauf und mit Reset-Modulo.

