
; Listing15e.s		Wir visualisieren das erste Bild in ham8 mit 256000 mglichen Farben.
; HINWEIS, ES SIND NUR 64 FARBREGISTER FR DIE PALETTE,
; die verbleibenden 192 werden ignoriert.

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	Bplpointers,a1
	moveq	#8-1,d7				; Anzahl Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addi.l	#80*100,d0			; Lnge Bitplane
	addq.w	#8,a1
	dbra	d7,PointBp			; d7-mal wiederholen (d7 = Anzahl Bitplanes)

	bsr.s	PutColors

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts


; Diese Routine, die auch in meinem WORLD OF MANGA-Demo enthalten ist, wird 
; zum Lesen der 24-Bit-Palette bentigt. In diesem Fall wird sie durch ein incbin erhalten.
; Grundstzlich konvertiert es jede Farbe in 24-Bit, die im Format von 
; ein langes $00RrGgBb kommt, wobei R = hohes Nibble von rot, r = niedriges Nibble von rot,
; G = hohes Nibble von grn usw., im copperlistenformat aga, das heit
; in zwei Worten $0RGB mit hohen Nibble und $0rgb mit niedrigen Nibble.

PutColors:
	lea	LogoPal(pc),a0			; Adresse der Farbpalette 
	lea	ColP0+2,a1				; Adresse des ersten Registers
								; auf hohes Nibble eingestellt
	lea	ColP0b+2,a2				; Adresse des ersten Registers
								; auf niedriges Nibble eingestellt
	moveq	#2-1,d7				; 2 Banken mit jeweils 32 Registern
								; * HINWEIS: in HAM8 DEFINIEREN SIE NUR EINE
								; PALETTE VON 64 FARBEN! DIE ANDEREN
								; FARBREGISTER VON 65 BIS 255 SIND
								; VOLLSTNDIG ignoriert!
ConvPaletteBank:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#32-1,d6			; 32 Farbregister pro Bank

ConvLongReg:					; Schleife, die die Farben $00RrGgBb.l in die 2 
								; Wrter $0RGB, $0rgb geeignet fr
								; Copperregister umwandelt.

; Konvertieren niedriger Nibbles von $00RrGgBb (long) in die Farbe AGA $0rgb (word)

	move.b	1(a0),(a2)			; Hohes Byte der Farbe $00Rr0000 kopiert
								; in das Cop-Register fr niedriges Nibble
	andi.b	#%00001111,(a2)		; auswhlen nur niedriges Nibble ($0r)
	move.b	2(a0),d2			; Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	lsl.b	#4,d2				; verschiebt das niedrige Halbbyte um 4 Bit nach links
								; des GRNEN, "umwandeln" in ein hohes Nibble
								; des niedrigen Bytes von d2 ($g0)
	move.b	3(a0),d3			; Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%00001111,d3		; auswhlen nur niedriges Nibble ($0b)
	or.b	d2,d3				; "MISCHEN" der niedrigen Nibble von grn und blau...
	move.b	d3,1(a2)			; Bilden des nachfolgenden Low-Bytes $gb zum Setzen
								; im Farbregister nach dem Byte $0r fr
								; das word $0rgb der niedrigen Nibble

; Konvertieren hohe Nibbles von $00RrGgBb (long) in die Farbe AGA $0RGB (word)

	move.b	1(a0),d0			; Hohes Byte der Farbe $00Rr0000 in d0
	andi.b	#%11110000,d0		; auswhlen nur hohes Nibble ($R0)
	lsr.b	#4,d0				; verschiebt das Nibble um 4 Bit nach rechts, also
								; dadurch wird es zum Low-Byte-Nibble ($0R).
	move.b	d0,(a1)				; das High-Byte $0R in das Farbregister kopieren
	move.b	2(a0),d2			; das Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d2		; auswhlen nur hohes Nibble ($G0)
	move.b	3(a0),d3			; das Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d3		; auswhlen nur hohes Nibble ($B0)
	lsr.b	#4,d3				; verschiebt es um 4 Bit nach rechts
								; dadurch wird es zum Low-Byte-Nibble d3 ($0B)
	or.b	d2,d3				; Mischen der hohen Nibble von Grn und Blau ($G0+$0B)
	move.b	d3,1(a1)			; Bilden des letzten Low-Bytes $GB zum Setzen
								; im Farbregister nach dem Byte $0R fr
								; das Wort $0RGB der hohen Nibble

	addq.w	#4,a0				; zur nchsten Farbe .l der Palette springen
								; am unteren Rand des Bildes angebracht
	addq.w	#4,a1				; zum nchsten Farbregister springen
								; fr hohes Nibble in Copperlist
	addq.w	#4,a2				; zum nchsten Farbregister springen
								; fr niedriges Nibble in Copperlist

	dbra	d6,ConvLongReg

	add.w	#(128+8),a1			; Farbregister berspringen + dc.w $106,xxx
								; des hohen Nibble
	add.w	#(128+8),a2			; Farbregister berspringen + dc.w $106,xxx
								; des niedrigen Nibble

	dbra	d7,ConvPaletteBank	; Konvertiert eine Bank mit 32 Farben von
	rts							; Schleife. 8 Schleifen fr 256 Farben.

; Palette mit PicCon als Binrdatei gespeichert (Option: save as binary, nicht als cop)
; HINWEIS: Da es sich um die Palette eines HAM Bild handelt, enthlt es nur 64 Farben, nicht 256.

LogoPal:
	incbin	"/Sources/pic640x100xham8.pal"

;*****************************************************************************
;*				COPPERLIST													 *
;*****************************************************************************

	cnop	0,8					; auf 64 Bit ausrichten

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP

; Hinweis: Die ddfstart/stop HIRES wren $003c und $00d4, aber mit dem Burst aktiv
; der gleiche Wert wie bei LOWRES ist in Ordnung, dh $0038 und $00d0.

	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,-8				; BPL1MOD (burst 64bit, modulo=modulo-8)
	dc.w	$10a,-8				; BPL2MOD (wie oben)

				; 5432109876543210
	dc.w	$100,%1000101000010001	; 8 Bitplane HIRES 640x256 HAM8. Zum
								; Setzen von 8 planes, Bit 4 setzen
								; Bit 12,13,14 zurcksetzen. Bit 0 ist gesetzt,
								; da es viele AGA-Funktionen ermglicht
								; die wir spter sehen werden.
								; durch Setzen von Bit 11 wird HAM8 aktiv 

	dc.w	$1fc,3				; Burst mode 64 bit

; RAW wird mit PicCon gespeichert, sodass Sie normal darauf zeigen knnen.

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste 	Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte	   "
	dc.w	$ec,0,$ee,0			; vierte	   "
	dc.w	$f0,0,$f2,0			; fnfte	   "
	dc.w	$f4,0,$f6,0			; sechste	   "
	dc.w	$f8,0,$fa,0			; siebte	   "
	dc.w	$fc,0,$fe,0			; achte		   "

; Dies ist die Reihenfolge der Bitebenen, wenn Sie die RAW mit AgaConv speichern
;
;	dc.w	$e8,0,$ea,0			; dritte    Bitplane
;	dc.w	$ec,0,$ee,0			; vierte	   "
;	dc.w	$f0,0,$f2,0			; fnfte	   "
;	dc.w	$f4,0,$f6,0			; sechste	   "
;	dc.w	$f8,0,$fa,0			; siebte	   "
;	dc.w	$fc,0,$fe,0			; achte		   "
;	dc.w	$e0,0,$e2,0			; erste 	   "
;	dc.w	$e4,0,$e6,0			; zweite	   "

; In diesem Fall wird die Palette durch eine Routine aktualisiert, daher
; reicht es aus, die Registerwerte gelscht zu lassen.

; *HINWEIS: in HAM8 DEFINIEREN SIE NUR 64 FARBEN, NICHT ALLE 255 !!!!!

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2c00	; Auswahl Palette 1 (32-63), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2e00	; Auswahl Palette 1 (32-63), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$9007,$fffe	; auf das Ende des Logos warten
	dc.w	$100,$200	; null Bitplanes

	dc.w	$ffff,$fffe	; Ende Copperlist

;******************************************************************************

; Bild RAW mit 8 Bitplanes, in HAM8.

	cnop	0,8			; auf 64 Bit ausrichten

Picture:
	incbin	"/Sources/pic640x100xham8.raw"

	end

Die Besonderheit, die Sie bemerkt haben werden, ist, dass die Palette von selbst
64 Farben zusammengesetzt ist. Setzen Sie einfach Bit 11 von bplcon0, das von HAM
und das Spiel ist fertig. Vergessen Sie nicht das Detail des Austauschs der Bitebenen
(Zeigen Sie sie wie im Beispiel in der Copperliste), falls Sie die RAW mit einem
Iffconverter speichern, der sie nicht alleine austauscht, wie es der PicCon tut.
