
; Listing14-8b.s:	* MISCHEN VON 2 SAMPLES UND VERSTRKEN DER LAUTSTRKE *

	SECTION	MIX,CODE

Start:

_LVODisable	equ	-120
_LVOEnable	equ	-126

	move.l	4.w,a6
	jsr	_LVODisable(a6)
	bset	#1,$bfe001			; schaltet den Tiefpassfilter aus
	lea	$dff000,a6
	move.w	$2(a6),d7			; speichern DMA von OS
	
	move.l	#Sample1,$a0(a6)
	move.l	#Sample2,$b0(a6)
	move.w	#(Sample1End-Sample1)/2,$a4(a6)
	move.w	#(Sample2End-Sample2)/2,$b4(a6)
CLOCK equ 3546895
	move.w	#CLOCK/21056,$a6(a6)
	move.w	#CLOCK/21056,$b6(a6)
	move.w	#64,$a8(a6)
	move.w	#64,$b8(a6)
	move.w	#$8003,$96(a6)		; einschalten AUD0-AUD1 DMA in DMACONW

Mouse:	
	btst	#6,$bfe001
	bne.s	Mouse

	lea	Sample0,a0
	move.l	#Sample0End-Sample0,d0
	lea	Sample1,a1
	move.l	#Sample1End-Sample1,d1
	lea	Sample2,a2
	move.l	#Sample2End-Sample2,d2
	bsr.s	BoostMixSamples

	lea	$dff000,a6
	move.l	#Sample0,$a0(a6)
	move.l	#Sample0,$b0(a6)
	move.w	#(Sample0End-Sample0)/2,$a4(a6)
	move.w	#(Sample0End-Sample0)/2,$b4(a6)
	move.w	#$8003,$96(a6)

WRMB:	
	btst	#10,$dff016
	bne.s	WRMB

	move.w	#$0003,$96(a6)		; DMA ausschalten
	or.w	#$8000,d7			; Bit 15 (SET/CLR) schaltet ein
	move.w	d7,$96(a6)			; wiederherstellen DMA von OS
	move.l	4.w,a6
	jsr	_LVOEnable(a6)
	rts


BoostMixSamples:
		; [a0=dst Sample, a1=src Sample 1, a2=source Sample 2]
		; [d0.l=dst length.b, d1.l=src1 length.b, d2.l=src2 length.b]
	movem.l	d0-d3/a0-a4,-(sp)
	lea	(a1,d1.l),a3			; a3=Ende des Sample 1
	lea	(a2,d2.l),a4			; a4=Ende des Sample 2
	moveq	#0,d3				; d3.w=0=MAX Startsample
.Lp1:	
	move.w	#$f00,$dff180
	move.b	(a1)+,d1			; d1.b= Meister von Sample 1
	ext.w	d1					; d1.w=d1.b erweitert zum word
	move.b	(a2)+,d2			; d2.b= Meister von Sample 2
	ext.w	d2					; d2.w=d2.b erweitert zum word
	add.w	d1,d2				; d2.w= ADDIEREN der Samples 1 und 2 zusammen
	bpl.s	.NoAbs
	neg.w	d2
.NoAbs:	
	cmp.w	d3,d2				; d2.w=absoluter Wert von d2
	bls.s	.NoMax
	move.w	d2,d3				; wenn d2>d3: d3(MAX)=d2
.NoMax:	
	cmp.l	a3,a1				; endete am Sample 1 ?
	bhs.s	.Quit1				; wenn ja: exit
	cmp.l	a4,a2				; endete am Sample 2 ?
	bhs.s	.Quit1				; wenn ja: exit
	subq.l	#1,d0
	bhi.s	.Lp1
.Quit1:	
	move.l	(sp),d0				; wiederherstellen d0 
	movem.l	5*4(sp),a1-a2		; wiederherstellen a1 und a2
	move.w	d3,$7ff0000
								; d3.w=durch die Summen erreicht
.Lp2:	
	move.w	#$00f,$dff180
	move.b	(a1)+,d1			; d1.b= Meister von Sample 1
	ext.w	d1					; d1.w=d1.b erweitert zum word
	move.b	(a2)+,d2			; d2.b= Meister von Sample 2
	ext.w	d2					; d2.w=d2.b erweitert zum word
	add.w	d1,d2				; d2.w=ADDIEREN der Samples 1 und 2 zusammen

	muls.w	#127,d2				; ANTEIL: d3(MAX)/127=d2/x
	divs.w	d3,d2
	move.b	d2,(a0)+

	cmp.l	a3,a1				; endete am Sample 1 ?
	bhs.s	.Quit2				; wenn ja: exit
	cmp.l	a4,a2				; endete am Sample 2 ?
	bhs.s	.Quit2				; wenn ja: exit
	subq.l	#1,d0				; dekrementiert lungh0.b bis 0...ohne
	bhi.s	.Lp2
.Quit2:	
	movem.l	(sp)+,d0-d3/a0-a4
	rts


	SECTION	SAMPLE,DATA_C

Sample1:
	incbin	"/Sources/carrasco.21056"
Sample1End:

Sample2:
	incbin	"/Sources/lee3.21056"
Sample2End:

Sample0:blk.b	Sample1End-Sample1
Sample0End:

	end


Theoretisch sollte echtes Mischen nur durch algebraisches Addieren von 
Samples erfolgen, jedoch aus offensichtlichen Grnden fallen sie hufig aus
dem 8-Bit-Bereich mit Vorzeichen und um die Wellenform direkt gleichmssig zu
verstrken mssen wir immer durch 2 teilen. 
Ergebnis: Die endgltige Intensittsausbeute betrgt weniger als das der
2 Samples, die unabhngig voneinander auf zwei verschiedenen Kanlen gespielt
wrden. Um den normalen Mischalgorithmus verwenden zu knnen, wre es
erforderlich, dass die Summe niemals 127 ber- oder -128 unterschreitet, also
niemals die Bereichsgrenzen verlsst.
Da es nicht sinnvoll ist, Samples niedrig abzutasten, weil 8-Bit-Audio keine
groe Przision hat, sind wir gezwungen, die Lautstrke der Samples bis zum 
Anschlag zu mischen: es gilt das hchste erreichte Volumen das durch die 
Summe erreicht werden kann und es wird als maximaler Bereich proportional zu 
127 verwendet (absoluter Wert maximal erreichbar):
NICHT 128, denn nur der negative Teil erreicht -128 und das Positive zu stark
zu verstrken - ber 127 hinaus - wren wir am Punkt des ersten)
Die Proportionen - die ich persnlich normalerweise "den Zoom " in der
Mathematik nenne - sind in diesem Fall ntzlich, um das Feld / den Bereich
einzugrenzen. Innerhalb der Grenzen ist es proportional und fr alle Samples
gleich.
*** Grundstzlich haben wir bis zum hchsten Wert verstrkt. Die Summen
waren nicht gleich 127 (oder -127) und alles andere ist proportional***.


N.B.: Obwohl es angemessen gewesen sein knnte, wurde keine Rundung angewendet: 
	Es htte eine Art Annherung verwendet werden sollen neben dem Kommas
	mehrerer Bits, die beim Inkrementieren - auch wenn nicht tatschlich
	sprbar - die Qualitt des Mischens htte viele Probleme beim Verstehen
	der Quelle und vor allem der Geschwindigkeit verursacht:
	Nach Multiplikation mit 127 htten wir alles nach rechts verschieben knnen
	von 16 Bit (Multiplikation der Zahl mit viel zum Simulieren des Kommas
	mit sehr groen Zahlen, um es dann zu teilen.) wodurch ein 32-Bit-Wert
	erhalten wird.
	Wert, der geteilt werden musste fr MAX und dann um 16 Bit nach links
	verschoben und mit dem das hchstwertige Bit des verschobenen Teils
	gerundet um zur	Originalgre zurckzukehren. All dies wrde jedoch ein
	notwendiges Problem mit sich bringen wegen einer Begrenzung von 68000:
	Teilen des 32-Bit-Werts durch MAX, das Ergebnis - wenn MAX nahe am
	aktuellen Summenwert liegt - knnte	immer noch bei 32 sein, und die
	DIVS-Anweisung gibt - leider - das 16-Bit-Ergebnis im unteren Teil des
	Registers und den Rest im hohen zurck, das Wort lschen, das fr uns
	so ntzlich ist. Das Problem htte fr jede andere Annherung
	prsentieren knnen ...