
; Listing14-8.s:	* MISCHEN 2 SAMPLE *

	SECTION	MIX,CODE

Start:

_LVODisable	equ	-120
_LVOEnable	equ	-126

	move.l	4.w,a6
	jsr	_LVODisable(a6)
	bset	#1,$bfe001			; schaltet den Tiefpassfilter aus
	lea	$dff000,a6
	move.w	$2(a6),d7			; speichern DMA von OS

	move.l	#Sample1,$a0(a6)
	move.l	#Sample2,$b0(a6)
	move.w	#(Sample1End-Sample1)/2,$a4(a6)
	move.w	#(Sample2End-Sample2)/2,$b4(a6)
CLOCK equ 3546895
	move.w	#CLOCK/21056,$a6(a6)
	move.w	#CLOCK/21056,$b6(a6)
	move.w	#64,$a8(a6)
	move.w	#64,$b8(a6)
	move.w	#$8003,$96(a6)		; einschalten AUD0-AUD1 DMA in DMACONW

Mouse:	
	btst	#6,$bfe001
	bne.s	Mouse

	lea	Sample0,a0
	move.l	#Sample0End-Sample0,d0
	lea	Sample1,a1
	move.l	#Sample1End-Sample1,d1
	lea	Sample2,a2
	move.l	#Sample2End-Sample2,d2
	bsr.s	MixSamples
	move.l	#Sample0,$a0(a6)	; wird am Ende von Samples 1 gespielt
	move.l	#Sample0,$b0(a6)	; und 2: Erinnern sie sich warum?
	move.w	#(Sample0End-Sample0)/2,$a4(a6)
	move.w	#(Sample0End-Sample0)/2,$b4(a6)

WRMB:	
	btst	#10,$dff016
	bne.s	WRMB

	move.w	#$0003,$96(a6)		; DMA ausschalten
	or.w	#$8000,d7			; Bit 15 (SET/CLR) schaltet ein
	move.w	d7,$96(a6)			; wiederherstellen DMA von OS
	move.l	4.w,a6
	jsr	_LVOEnable(a6)
	rts


MixSamples:	;[a0=dst Sample, a1=src Sample 1, a2=soruce Sample 2]
		;[d0.l=dst length.b, d1.l=src1 length.b, d2.l=src2 length.b]
	movem.l	d0-d3/a0-a4,-(sp)
	lea	(a1,d1.l),a3			; a3=Ende von Sample 1
	lea	(a2,d2.l),a4			; a4=Ende von Sample 2
	moveq	#0,d3				; d3.b=0 fr ADDX
.Lp:	
	move.w	#$f00,$dff180
	move.b	(a1)+,d1			; d1.b=campione del Sample 1
	ext.w	d1					; d1.w=d1.b erweitert Vorzeichen zu word
	move.b	(a2)+,d2			; d2.b=campione del Sample 2
	ext.w	d2					; d2.w=d2.b erweitert Vorzeichen zu word
	add.w	d1,d2				; d2.w=Summe von sampel 1 und 2 mit Vorzeichen 
	asr.w	#1,d2				; d2.w=Mittelwert Sample (Summe/2)
	addx.b	d3,d2				; d2.w=gerundeter gemischter Sample
								; ber oder unter
								; von ASR
	move.b	d2,(a0)+			; speichern gemischter Sample
	cmp.l	a3,a1				; Ende Sample 1 ?
	bhs.s	.Quit				; wenn ja: exit
	cmp.l	a4,a2				; Ende Sample 2 ?
	bhs.s	.Quit				; wenn ja: exit
	subq.l	#1,d0				; verringert die Lnge 0.b auf 0 ... ohne
								; DBRA, weil es nur in Word funktioniert...
	bhi.s	.Lp
.Quit:	
	movem.l	(sp)+,d0-d3/a0-a4
	rts


	SECTION	SAMPLE,DATA_C

Sample1:
	incbin	"/Sources/carrasco.21056"
Sample1End:

Sample2:
	incbin	"/Sources/lee3.21056"
Sample2End:

Sample0: 
	blk.b	Sample1End-Sample1
Sample0End:

	end


Was haben wir diesmal gemacht? Wir konnten 2 verschiedene Samples auf 
dem gleichen Kanal spielen! Wie? Mischen Sie sie per Software mit der CPU!
Sie kennen die Struktur der Wellenform eines Samples und wissen das jeder
Sample von 1 Byte von -128 bis 127 variieren kann. Daher handelt es sich um
ein BYTE MIT VORZEICHEN mit denen man arbeiten kann, indem man sie entsprechend
ihrer Natur als 8-Bit Zahlen behandelt, von denen das hchste (MSB) als
Vorzeichen dient. Gibt es einen besseren Weg zwei Stze von Zahlen zu erhalten,
wenn man eine bekommt, die dem Trend von beiden folgt?
Machen Sie den ARITHMETISCHEN DURCHSCHNITT zwischen jedem Paar einzelner Bytes
/ Samples: Nimm 2 entsprechende Samples beider Proben.
Addiere sie algebraisch (* BERCKSICHTIGUNG DES VORZEICHENS *) und teile das
Ergebnis durch 2: MIX = (SAMP1 + SAMP2) / 2.

Wenn zwei Bytes algebraisch addiert werden, kann das Ergebnis grer als 127
sein (wenn zum Beispiel beide 127 sind, betrgt die Summe 254) und daher kann
es nicht mit einer vorzeichenbehafteten 8-Bit-Zahl ausgedrckt werden. Es ist
notwendig, mit Wrtern zu arbeiten um den Durchschnitt zu berechnen und die
Wrter mssen auch das Vorzeichen der ursprnglichen Bytes wiederspiegeln: Aus
diesem Grund haben wir das Vorzeichen des Bytes zum Word erweitert, um die
algebraische Summe mit ADD.W. In der "MixSamples"-Schleife haben wir ein
weiteres Detail fr das Erhhen der Qualitt und Przision des Mischens
bernommen: RUNDEN.
Sobald Sie die Summe gemacht haben, mssen Sie durch 2 teilen, damit die
Rckgabewerte im Bereich von 8 Bit mit Vorzeichen sind (* Sie mssen alle Werte
durch 2 dividieren und lassen Sie diejenigen nicht aus, die zwischen -128 und
127 liegen, auch wenn Sie nur ADD erledigt haben: Die Sample wren nicht mehr
proportional! *)
Eine solche Division wird schnell durch das ASR ausgefhrt, die es nach rechts
verschiebt (in diesem Fall um 1). * So BEHALTEN Sie das Vorzeichen links *: 
Das letzte verschobene Bit, das rechts aus dem Register herauskommt ist im
Flag X (eXtend) der CPU enthalten. Das "bisschen" ist wie eine Art "Wert
jenseits des Kommas", der die Annherung der im  Register enthaltenen
"Ganzzahl" ausdrckt:
Durch Hinzufgen des Inhalts von Flag X auf die ganze Zahl werden alle Zahlen
gerundet.
Zum Beispiel: 17 + 6 = 23, 23/2 = 11,5 (=% x 1) = 12 (gerundet);
oder noch einmal: 11 + 23 = 34, 34/2 = 17 (% x.0) = 17 (gerundet).

N.B.:	Haben Sie bemerkt, dass das Volumen (als Durchschnittswert der Sample
gedacht) der gemischten Sample niedriger ist als die Ausbeute der 2
gleichzeitig gelesenen Sample? Warum?  Die Antwort in der nchsten Folge ...