
; Listing14-3a.s	** PRZISIONSTNE UND HALBTNE **

	SECTION	HARMONIC,CODE

Start:
	move.l	4.w,a6
	jsr	-$78(a6)				; _LVODisable
	bset	#1,$bfe001			; Schaltet den Tiefpassfilter aus
	lea	$dff000,a6
	move.w	$2(a6),d7			; DMACONR - speichern DMA fr OS

	move.l	#Harmonic,$a0(a6)	; AUD0LCH.w+AUD0LCL.w=AUD0LC.l
	move.w	#16/2,$a4(a6)		; 16 bytes/2=8 word der Daten (AUD0LEN)

	move.l	#12*2+2,d0			; RE3
	moveq	#16,d1
	bsr.s	HalfTone2Per
	move.w	d0,$a6(a6)			; AUD0PER

	move.w	#64,$a8(a6)			; AUD0VOL maximal (0 dB)
	move.w	#$8001,$96(a6)		; einschalten AUD0 DMA in DMACONW

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	ori.w	#$8000,d7			; Bit 15 schaltet ein (SET/CLR)
	move.w	#$0001,$96(a6)		; DMACON - ausschalten AUD0
	move.w	d7,$96(a6)			; DMACON - reset DMA von OS
	move.l	4.w,a6
	jsr	-$7e(a6)				; _LVOEnable
	rts

******************************************************************************
;			  Periode der Halbtne 
;
; Berechnen Sie die Periode, die in AUDxPER eingefgt werden soll, wenn der 
; Halbton von DO1 ausgeht
; d0.w   = Halbton (ab DO1 = 0)
; d1.w   = Lnge Harmonische (in byte)
******************************************************************************

CLOCK	equ	3546895
DO1	equ	131				; Frequenz [Hz] fr DO1  ; C3 = 130,81HZ

HalfTone2Per:
	divu.w	#12,d0
	move.w	#DO1,d2
	lsl.w	d0,d2
	swap	d0
	add.w	d0,d0
	add.w	d0,d0
	mulu.w	HalfTones(pc,d0.w),d2
	divu.w	HalfTones+2(pc,d0.w),d2
	move.l	#CLOCK,d0
	mulu.w	d2,d1
	divu.w	d1,d0
	rts					; [d0.w=Periode fr Sampling]

HalfTones:									; deutsche Notennamen
	dc.w	10000,10000	; DO=1.0			; C
	dc.w	10595,10000	; DO#=1.0595		; CIS/DES
	dc.w	11225,10000	; RE=1.1225			; D
	dc.w	11892,10000	; RE#=1.1892		; DIS/ES
	dc.w	12599,10000	; MI=1.2599			; E
	dc.w	13348,10000	; FA=1.3348			; F
	dc.w	14142,10000	; FA#=1.4142		; FIS/GES	
	dc.w	14983,10000	; SOL=1.4983		; G
	dc.w	15874,10000	; SOL#=1.5874		; GIS/AS
	dc.w	16818,10000	; LA=1.6818			; A
	dc.w	17818,10000	; LA#=1.7818		; AIS/B
	dc.w	18877,10000	; SI=1.8877			; H

******************************************************************************

	SECTION	SAMPLE,DATA_C	; Wird es von der DMA gelesen, muss es sich in CHIP befinden

	; Harmonische von 16 Werten, die mit dem IS von trash'm-one erzeugt wurden

Harmonic:	
	dc.b	$19,$46,$69,$7c,$7d,$6a,$47,$1a,$e8,$bb,$97,$84,$83,$95,$b8,$e5

	end

******************************************************************************

Diese Listing unterscheidet sich nicht wesentlich vom Vorherigen.
Es beinhaltet eine kleine Routine, die die Abtastperiode einer Note berechnet.
Der einzige unterschied ist, dass man jetzt nicht nur 7 Noten einer Skala von
verschiedenen Oktaven erzeugen kann, sondern auch die Noten der "schwarzen
Tasten" eines Klaviers oder die DIESIS (#) / BEMOLLE (b): 
Kurz gesagt, Sie haben auch die Mglichkeit die HALBTNE zu spielen.
Zunchst fllt ein Unterschied auf: Die Werte der Tabelle "HalfTones" sind viel
grer als die in der Tabelle "Notes" im vorherigen Beispiel und dies, um eine
grere Przision zu gewhrleisten: In der Tat die zwei Wrter bezeichnen
jeweils Zhler und Nenner des Bruchs, der die Beziehung zwischen einer Note und
dem C auf einer Skala angibt und in der Tat ndert sich die Beziehung nicht.
Nehmen Sie zum Beispiel das SOL: In "Notes" ist der Wert 3/2 = 1.5, in
"HalfTones" ist es gleich 14983/10000 = 1.4983. Wie Sie am Wert sehen ist es
fast das gleiche (der Unterschied ist vernachlssigbar). In "Notes" habe ich
ber die "klassischen" Brche berichtet, die in vielen Bcher ber akustische
Physik gefunden werden knnen, die den Vorteil haben, kleine und leicht zu
merkende Zhler und Nenner zu haben.
Die Werte der "Halbtne" haben stattdessen zustzlich zu den Verhltnissen
aller Noten auf der Halbtonskala eine Genauigkeit von 4 Nachkommastellen. Es
wird erreicht, indem mit sehr groen Zahlen multipliziert und dann durch 
10^ Anzahl der Nachkommastellen dividiert wird oder bis zum Zehntausendstel.
Das Unterprogramm "HalfTone2Per" funktioniert ungefhr wie das Unterprogramm 
"Note2Per". Der einzige Unterschied besteht in der Angabe des Eingabeparameters:
Einmal muss der gewnschte Halbton ab DO1 angegeben werden. Wenn wir also ein
FA1 spielen wollen, mssen wir in d0.w = 5 setzen. Zwischen dem DO1 und dem FA1
gibt es 5 Halbtne Unterschied. In der Musik ist 1 Ton = 2 Halbtne, und jede
Tonleiter hat 6 Tne = 12 Halbtne. Zwischen einer Note und der anderen liegt
1 Ton, ohne die Frequenzintervalle zwischen MI und FA und zwischen SI und DO
der Oktave, danach sind sie nur noch gleich 1 Halbton.
Da es bei jeder Oktave notwendig ist, die Frequenz zu verdoppeln, erhht sich
die Frequenz der Noten - innerhalb einer Skala und darber hinaus - ist es
nicht konstant, aber EXPONENTIEL mit Basis 2. Also die Berechnung der
Verhltnisse der Noten innerhalb einer Skala ist dann so einfach wie es
scheint: 
Es gilt zu wissen, dass das Intervall von Verhltnissen in einer Skala von 
12 Halbtnen gleich 1 ist (von 1 des ersten DO bis 2 des DO der nchsten
Oktave). Jeder Halbton ist 1/12 in der Abszissen-Achse eines kartesischen
Graphen (x, y) zum Nchsten, der die Funktion darstellt. exponentiell: Y = 2^X.
Betrachten Sie das Intervall 0 <= X <= 1, in dem wir uns befinden. Ordne einen
Kurvenzweig 2^0<=Y<=2^1 = 1<=Y<=2 zu. Jetzt werden alle 12 relativen Werte von
Y beginnend von X = 0 berechnet. 
12 mal: Y=2^(1/12), Y=2^(2/12), Y=2^(3/12) und so weiter bis zu Y=2^(12/12) = 2,
was dem Verhltnis des 12. Halbtons oder des DO der nchsten Oktave entspricht.
Jeder erhaltene Dezimalwert entspricht dem Wert mit dem multipliziert werden 
muss, um die die Frequenz der gewnschten Note in der Oktave zu erhalten.
Dieser Dezimalwert muss in einen Bruch umgewandelt werden. In der Tat MUSS es
zu einem Bruch mit Zahlen zurckverfolgt werden (nicht dezimal), da der 68000
nur ganze Zahlen "simulieren" kann (d.h. ohne Komma). Um zum Beispiel die
Beziehung zwischen einem LA# und DO (= 1/1) zu kennen:
Y = 2^(10/12) = 2^0.8333 (...periodisch...) = 1.7818 (Runden).
Diese Dezimalstellen der Zahl lassen sich leicht auf den Bruch 17818/10000 
zurckfhren. (Es ist eigentlich 17818 zehntausendstel.)
Nun, wenn wir zum Beispiel eine LA3# wollen: DO3 = 131 * 2^(3-1) = 
131*2*2=131*4=524 Hz. LA3# =(524*17818)/10000 = 933 Hz.