
; Listing14-10f.s	Verwenden der Routine player6.1a fr ein komprimiertes Modul
; Routine P61_Music die vom interrupt VERTB ($6c) Level 3 aufgerufen wird

; Weiterhin ist die Sprungroutine an den verschiedenen Punkten des Moduls aktiviert.
; Fr die Funktion einfach jump = 1 setzen und rufen Sie die Routine P61_SetPosition 
; mit der Position in d0.l auf.

; Drcken Sie abwechselnd die linke und die rechte Taste, aber denken sie daran,
; dass die nderungen am Ende des Patterns nicht sofort stattfinden !!!

	SECTION	USEPLAY61A,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:

;
; Call P61_Init to initialize the playroutine	
; d0 --> Timer detection (for CIA-version)	
; A0 --> Address to the module			
; a1 --> Address to Samples/0			
; a2 --> Address to Sample buffer		
; d0 <-- 0 if succeeded			
; a6 <-- $DFF000				
;

	movem.l	d0-d7/a0-a6,-(sp)
	lea	P61_Data,a0				; Adresse des Moduls in a0
	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	sub.l	a1,a1				; die Samples sind nicht getrennt, wir setzen Null
	lea	Samples,a2				; Modul komprimiert! Zeiger auf Zielpuffer fr
								; die Samples (in chip ram) !
	bsr.w	P61_Init			; Hinweis: das Dekomprimieren dauert einige Sekunden!
	movem.l	(sp)+,d0-d7/a0-a6

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - nur Copper aktivieren
								; + Bitplane und Sprites (%1000001111000000)

	move.l	BaseVBR(PC),a0
	move.l	#MyInt6c,$6c(a0)	; meine interrupt routine

	move.w	#$e020,$9a(a5)		; INTENA - aktivieren Master und lev6
								; und VERTB (lev3).

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	clr.w	ModPos				; Von vorn anfangen
	st.b	ChangePos

Mouse2:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse2

	move.w	#16,ModPos			; gehe zu pos 16
	st.b	ChangePos

Mouse3:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse3

	move.w	#30,ModPos			; Gehe zu Position 30 
	st.b	ChangePos			; (dies ist die letzte).

Mouse4:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse4

;
; Call P61_End to stop the music		
;   a6 --> Customchip baseaddress ($DFF000)	
;		Uses d0/d1/A0/a1/a3		
;

	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	bsr.w	P61_End

	rts

*****************************************************************************
*		Routine in interrupt Level 3 ($6c)								*
*****************************************************************************

MyInt6c:
	btst	#5,$dff01f			; INTREQR - int VERTB?
	beq.s	NoInt				; wenn nein, exit!

	movem.l	d0-d7/a0-a6,-(sp)
	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	tst.b	ChangePos			; mssen wir zur pos springen?
	beq.s	NoChangePos
	cmp.w	#63,P61_Crow		; sind wir am Ende des Patterns?
	bne.s	NoChangePos		; Wenn noch nicht, fange nicht von vorne an!
	clr.b	ChangePos
	moveq	#0,d0
	move.w	ModPos(PC),d0		; zu welcher pos. springen wir?
	bsr.w	P61_SetPosition		; Position ndern
NoChangePos:
	bsr.w	P61_Music			; wir spielen
	movem.l	(sp)+,d0-d7/a0-a6
NoInt:	
	move.w	#$70,$dff09c		; INTENAR
	rte

ModPos:
	dc.w	0
ChangePos:
	dc.w	0

*****************************************************************************
*		 The Player 6.1A for Asm-One 1.09 and later 						*
*****************************************************************************

fade  = 0	; 0 = Normal, NO master volume control possible
			; 1 = Use master volume (P61_Master)

jump = 1	; 0 = do NOT include position jump code (P61_SetPosition)
			; 1 = include

system = 0	; 0 = killer
			; 1 = friendly

CIA = 0		; 0 = CIA disabled
			; 1 = CIA enabled

exec = 1	; 0 = ExecBase destroyed
			; 1 = ExecBase valid

opt020 = 0	; 0 = MC680x0 code
			; 1 = MC68020+ or better

use = $b55a	; Usecode (Setzen Sie den von p61con angegebenen Wert zum Speichern
			; fr jedes Modul unterschiedlich!)

*****************************************************************************
	include	"/Sources/play.s"	; die wahre Routine!
*****************************************************************************


*****************************************************************************
;	Copperlist
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$003			; COLOR00 schwarz
	dc.w	$ffff,$fffe			; Ende Copperlist

*****************************************************************************
;	Musikmodul in P61-Format konvertiert, KOMPRIMIERT! (Option pack!)
*****************************************************************************

	SECTION	MODUL,DATA	; Es muss nicht im Chip-RAM sein, weil es ist
							; komprimiert ist und woanders entpackt wird!

; Modul von Jester/Sanity. Original 153676, gepackt 71950

P61_Data:
	incbin	"/Sources/P61.stardust"	; komprimiert, (Option PACK SAMPLES)
				; Sie knnen es auch in den FAST RAM legen: es wird verwendet
				; zum Entpacken der Samples in den Puffer Samples
				; und wird nicht direkt "gespielt".
				; Es geht also nicht direkt ber die Audio DMA-Kanle
				; sondern nur ber die Depack-Routine durch den Prozessor.
				; Also nur DATEN (nicht _C!)


*****************************************************************************
;	Wo die Samples entpackt werden werden (SECTION bss in chip ram!)
*****************************************************************************

	SECTION	SMP,BSS_C

Samples:
	ds.b	132112	; Lnge gemeldet von p61con

	end

Seien Sie vorsichtig, wenn Sie die berspringroutine hier und da im Modul verwenden!
Wenn Sie in die Mitte eines Patterns springen, ist zunchst alles nicht mehr synchron.
Ich wei nicht, ob es sich um einen Playerfehler oder etwas anderes handelt. Also mssen
Sie auf das Ende des aktuellen Patterns warten, bevor Sie zu einem anderen springen. Wir
knnen zu jedem Zeitpunkt durch lesen dieser 3 Variablen wissen wo wir im Modul sind:
 
	P61_Pos: 	Current song position
	P61_Patt:	Current pattern
	P61_CRow:	Current row in pattern

Die Ntzlichkeit dieser Routine kann nur gefunden werden, wenn sie in einer Form
durchgefhrt wird, in der Sie freiwillig niemals eine bestimmte Position erreichen,
die wir mit dieser Routine berspringen sollten. Zum Beispiel fr ein Spiel knnen Sie
einfache die Musik "leise" machen, die sich immer wiederholt und die ersten 
40 Positionen besetzen. An den Positionen 40 bis 50 gibt es jedoch einen anderen Grund:
dramatischer, auf die nur zugegriffen werden kann, wenn Sie springen.
Hier ist also unser Ort, bei der wir mit Musik und einem sorgenfreien Hintergrund um
die Welt gehen... dann finden wir den Bsewicht und springen zu einer anderen Melodie,
die von selbst in einer eigenen Schleife spielt... ist das Monster gettet, 
kehren wir zur ruhigen Musik zurck.                                