
; Listing14-10a.s	Verwendung der Routine player6.1a fr ein unkomprimiertes Modul
; die Routine P61_Music wird bei jedem vertical blank aufgerufen

	SECTION	USEPLAY61A,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA  

WaitDisk	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:

;
; Call P61_Init to initialize the playroutine	
; d0 --> Timer detection (for CIA-version)	
; A0 --> Address to the module			
; a1 --> Address to Samples/0			
; a2 --> Address to Sample buffer		
; d0 <-- 0 if succeeded			
; a6 <-- $DFF000				
;

	movem.l	d0-d7/a0-a6,-(sp)
	lea	P61_Data,a0				; Adresse des Moduls in a0
	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	sub.l	a1,a1				; die Sample sind nicht getrennt, wir setzen Null
	sub.l	a2,a2				; keine Samples -> modul unkomprimiert
	bsr.w	P61_Init
	movem.l	(sp)+,d0-d7/a0-a6

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - nur Copper aktivieren
								; + Bitplane und Sprites (%1000001111000000)

	move.w	#$e000,$9a(a5)		; INTENA - aktivieren Master und lev6
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$08000,d2			; warte auf Zeile $80
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whle nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whle nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	beq.s	WarteY2

;
; Call P61_Music every frame to play the music	
;	  _NOT_ if CIA-version is used!		
; a6 --> Customchip baseaddress ($DFF000)	
;

	move.w	#$f00,$180(a5)		; COLOR00 rot -> fr Copper monitor

	movem.l	d0-d7/a0-a6,-(sp)
	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	bsr.w	P61_Music
	movem.l	(sp)+,d0-d7/a0-a6

	move.w	#$003,$180(a5)		; COLOR00 schwarz

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

;
; Call P61_End to stop the music		
;   a6 --> Customchip baseaddress ($DFF000)	
;		Uses d0/d1/A0/a1/a3		
;

	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	bsr.w	P61_End

	rts


*****************************************************************************
*		 The Player 6.1A for Asm-One 1.09 and later 						*
*****************************************************************************

fade  = 0	; 0 = Normal, NO master volume control possible
			; 1 = Use master volume (P61_Master)

jump = 0	; 0 = do NOT include position jump code (P61_SetPosition)
			; 1 = include

system = 0	; 0 = killer
			; 1 = friendly

CIA = 0		; 0 = CIA disabled
			; 1 = CIA enabled

exec = 1	; 0 = ExecBase destroyed
			; 1 = ExecBase valid

opt020 = 0	; 0 = MC680x0 code
			; 1 = MC68020+ or better

use = $2009559	; Usecode (Setze den von p61con angegebenen Wert zum Speichern
				; fr jedes Modul unterschiedlich!)

*****************************************************************************
	include	"/Sources/play.s"	; die wahre Routine!
*****************************************************************************


*****************************************************************************
;	Copperlist
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - no Bitplanes
	dc.w	$180,$003			; COLOR00 schwarz
	dc.w	$ffff,$fffe			; Ende Copperlist

*****************************************************************************
;	Musikmodul in P61-Format konvertiert, unkomprimiert
*****************************************************************************

	SECTION	MODUL,DATA_C

; Modul von DreamFish. Original 42684, konvertiert 31628 (nicht gepackt!)

P61_Data:
	incbin	"/Sources/P61.technochild"	; unkomprimiert, nur konvertiert.

	end

Ich erinnere Sie an die Schritte zum Spielen eines Moduls mit dieser Wiedergaberoutine:
Als erstes mssen Sie das Modul mit dem entsprechenden Dienstprogramm P61CON in das
P61-Format konvertieren, wobei die verschiedenen Optionen "delta", "pack Samples" in 
den Programmeinstellungen verbleiben, ... alle zurckgesetzt, auer "tempo".
Auf diese Weise erhalten Sie das konvertierte Modul, das fr die Wiedergabe dieser 
Routine geeignet ist. Normalerweise wird bei der Konvertierung auch Platz gespart,
aber es ist keine "Komprimierung", sondern eine Optimierung.
Notieren Sie sich den Usecode, da Sie ihn im Listing unter dem equate "use"
einfgen mssen.
Dies wird verwendet, um Platz zu sparen: Es gibt an, welche Effekte aus dem Modul
verwendet werden, um nicht verwendete nicht zu assemblieren.
Fgen Sie zu diesem Zeitpunkt einfach das Modul in den Chip-RAM ein und rufen Sie
die Routinen zur richtigen Zeit auf: P61_Init vor dem Spielen, wie wir es getan haben
mt_init, P61_Music einmal zu jedem vertical blank (Warten mit dff004/6 oder
setzen Sie es in den Interrupt $6c) und bevor Sie beenden P61_End.
VERGESSEN SIE NICHT, DEN INTERRUPT-LEVEL 6 ZU AKTIVIEREN!!!! Manchmal werden die 
Timings mit dem CIAB-Timer A Interrupt gemacht. Sie knnen den CIAB-Timer A also
nicht verwenden, whrend Sie diese Routine verwenden ... Um die Wahrheit zu sagen,
kann die Verwendung des CIAB-Timers B ebenfalls Probleme verursachen... Also
aufgepasst! Setzen Sie zustzlich zu den Bits 15, 14, 13 des $dff09a (intena)
zustzlich Bits 5 oder 4 (VERTB und COPER) und verwenden Sie nicht den A/CIAB-Timer.
Natrlich gibt es noch andere Details, wie zum Beispiel daran zu denken, die 
richtigen Werte in die Register ($dff000 in a6 usw.) zu setzen und setzen Sie
die equates "fade", "jump", "system", "cia", "exec", "opt020", "use" auf die
richtige Weise. In dieser Hinsicht gibt es verschiedene Beispiele, bei denen die
equates auf die verschiedenen Bedrfnisse gesetzt sind. Insbesondere in diesem
Beispiel haben wir CIA = 0, weil wir jedes Mal P61_music aufrufen.
