
; Listing11l6b.s	Interlaced Mode Management-Routinen (640x512)
; ber das bit 15 (LOF) des VPOSR ($dff004).
; Wenn Sie die rechte Taste drcken, wird diese Prozedur nicht ausgefhrt
; und Sie bemerken, wie die geraden Linien oder sogar Linien manchmal 
; seltsam in "pseudo-non-lace" bleiben.

	SECTION	INTERLACE,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include "/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

WAITDISK	equ	30

SCRBYTES	= 40				; Anzahl der Bytes fr jede horizontale Zeile.
								; Daraus berechnen wir die Bildschirmbreite,
								; Multiplizieren von Bytes mit 8: normaler Bildschirm 320/8 = 40
								; z.B. fr einen 336 Pixel breiten Bildschirm 336/8 = 42
								; Beispielbreiten:
								; 264 pixel = 33 / 272 pixel = 34 / 280 pixel = 35
								; 360 pixel = 45 / 368 pixel = 46 / 376 pixel = 47
								; ... 640 pixel = 80 / 648 pixel = 81 ...

SCR_H		= 256				; Bildschirmhhe in Zeilen
SCR_X		= $81				; Startbildschirm, XX-Position (normal $xx81) (129)
SCR_Y		= $2c				; Startbildschirm, YY-Position (normal $2cxx) (44)
SCR_RES		= 1					; 2 = HighRes (640*xxx) / 1 = LowRes (320*xxx)
SCR_LACE	= 1					; 0 = non interlace (xxx*256) / 1 = interlace (xxx*512)
HAM			= 0					; 0 = nicht HAM / 1 = HAM
SCR_BPL		= 4					; Anzahl Bitplanes

; Parameter automatisch berechnet

SCR_W		= SCRBYTES*8		; Bildschirmbreite
SCR_SIZE	= SCRBYTES*SCR_H	; Gre des Bildschirms in Bytes 
BPLC0		= ((SCR_RES&2)<<14)+(SCR_BPL<<12)+$200+(SCR_LACE<<2)+(HAM<<11)		; BPLCON0
DIWS		= (SCR_Y<<8)+SCR_X													; DIWSTRT
DIWST		= ((SCR_Y+SCR_H/(SCR_LACE+1))&255)<<8+(SCR_X+SCR_W/SCR_RES)&255		; DIWSTOP
DDFS		= (SCR_X-(16/SCR_RES+1))/2											; DDFSTRT
DDFST		= DDFS+(8/SCR_RES)*(SCRBYTES/2-SCR_RES)								; DDFSTOP


Start:
;	Zeiger Bild

	move.l	#Logo,d0			; Zeiger Bild
	lea	Bplpointers,a1			; Zeiger Copperlist
	moveq	#4-1,d1				; Anzahl Bitplanes (hier sind es 4)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*84,d0			; + Lnge der Bitplane (hier sind es 84 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp
	
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper								
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$01000,d2			; warte auf Zeile $010
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $010
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $010
	beq.s	WarteY2

	btst	#2,$16(a5)			; rechte Maustaste gedrckt?
	beq.s	NoLaceInt

	bsr.s	LaceInt				; Routine-Zeiger ungerade oder gerade Linien
								; je nach LOF-Bit fr das Interlace
NoLaceInt:
	btst.b	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

******************************************************************************
; INTERLACE Routine - Testen des Bit LOF (Long Frame) um zu wissen, ob Sie
; gerade oder ungerade Zeilen anzeigen und entsprechend wechseln mssen.
******************************************************************************

LaceInt:
	move.l	#Logo,d0			; Adresse Bitplanes
	btst.b	#15-8,4(a5)			; VPOSR LOF bit?
	beq.s	MakeOdd				; wenn ja, zeigen Sie auf ungerade Zeilen
	add.l	#40,d0				; Oder fgen Sie die Lnge einer Zeile hinzu,
								; Starten der Ansicht von den geraden Zeilen!
								; gerade Zeilen werden angezeigt!
MakeOdd:
	lea	Bplpointers,a1			; Bitplanepointer in Copperlist
	moveq	#4-1,d7				; Anzahl der Bitplanes -1
LaceLoop:
	move.w	d0,6(a1)			; Zeiger auf das Bild
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*84,d0			; Lnge Bitplane
	addq.w	#8,a1				; nchste Zeiger
	dbra	d7,LaceLoop
	rts

*****************************************************************************
;			Copperlist
*****************************************************************************
	
	SECTION	GRAPHIC,DATA_C		; Chip data

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT
	dc.w	$90,DIWST			; DIWSTOP
	dc.w	$92,DDFS			; DDFSTRT
	dc.w	$94,DDFST			; DDFSTOP

	dc.w	$102,0				; BPLCON1 - Scroll register
	dc.w	$104,0				; BPLCON2 - priority register
	dc.w	$108,40				; BPL1MOD - \ INTERLACE: Lnge einer Zeile
	dc.w	$10a,40				; BPL2MOD - / um gerade Zeilen zu berspringen oder anzuzeigen

; Bitplane pointers

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste	 Bitplane
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane
	dc.w	$ec,$0000,$ee,$0000	; vierte Bitplane

;				; 5432109876543210
;	dc.w	$100,%0100001000000100	; BPLCON0 - 4 planes lowres (16 Farben)
;								; INTERLACE (bit 2!)

	dc.w	$100,BPLC0			; BPLCON0 - automatisch berechnet
	
; die ersten 16 Farben sind fr das LOGO

	dc.w	$180,$000,$182,$fff,$184,$200,$186,$310
	dc.w	$188,$410,$18a,$620,$18c,$841,$18e,$a73
	dc.w	$190,$b95,$192,$db6,$194,$dc7,$196,$111
	dc.w	$198,$222,$19a,$334,$19c,$99b,$19e,$446

;	Lassen Sie uns eine kleine Nuance fr das Bild setzen...

	dc.w	$5607,$fffe			; Wait - $2c+84=$80
	dc.w	$100,$204			; BPLCON0 - keine Bitplanes, ABER BIT LACE IST GESETZT!
	dc.w	$8007,$fffe			; wait
	dc.w	$180,$003			; COLOR00
	dc.w	$8207,$fffe			; wait
	dc.w	$180,$005			; COLOR00
	dc.w	$8507,$fffe			; wait
	dc.w	$180,$007			; COLOR00
	dc.w	$8a07,$fffe			; wait
	dc.w	$180,$009			; COLOR00
	dc.w	$9207,$fffe			; wait
	dc.w	$180,$00b			; COLOR00

	dc.w	$9e07,$fffe			; wait
	dc.w	$180,$999			; COLOR00
	dc.w	$a007,$fffe			; wait
	dc.w	$180,$666			; COLOR00
	dc.w	$a207,$fffe			; wait
	dc.w	$180,$222			; COLOR00
	dc.w	$a407,$fffe			; wait
	dc.w	$180,$001			; COLOR00

	dc.l	$ffff,$fffe			; Ende Copperlist


*****************************************************************************
;				DESIGN
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

; Design Gre 320 pixel, Hhe 84, mit 4 Bitplanes (16 Farben).

Logo:
	incbin	"/Sources/logo320x84x16c.raw"

	end

Haben Sie bemerkt, dass bei allen BPLCON0's in der Copperliste das Bit 2, das
Interlace, gesetzt sein muss? Wenn der letzte BPLCON0 nicht das Bit-Set hat,
auch wenn es andere auf dem Bildschirm haben, wre es nicht Interlaced!
