
;  Listing11l3c.s - Wir schwenken ein Bild mit einer "Live" -Bewegung.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

NUMLINES	equ	53				; Anzahl der Zeilen, die der Effekt enthalten soll.

SCRBYTES	= 40				; Anzahl der Bytes fr jede horizontale Linie.
								; Daraus berechnen wir die Bildschirmbreite,
								; Multiplizieren von Bytes mit 8: normaler Bildschirm 320/8 = 40
								; z.B. fr einen 336 Pixel breiten Bildschirm 336/8 = 42
								; Beispielbreiten:
								; 264 pixel = 33 / 272 pixel = 34 / 280 pixel = 35
								; 360 pixel = 45 / 368 pixel = 46 / 376 pixel = 47
								; ... 640 pixel = 80 / 648 pixel = 81 ...

SCR_H		= 256				; Bildschirmhhe in Zeilen
SCR_X		= $81				; Startbildschirm, XX-Position (normal $xx81) (129)
SCR_Y		= $2c				; Startbildschirm, YY-Position (normal $2cxx) (44)
SCR_RES		= 1					; 2 = HighRes (640*xxx) / 1 = LowRes (320*xxx)
SCR_LACE	= 0					; 0 = non interlace (xxx*256) / 1 = interlace (xxx*512)
HAM			= 1					; 0 = nicht HAM / 1 = HAM
SCR_BPL		= 6					; Anzahl Bitplanes

; Parameter automatisch berechnet

SCR_W		= SCRBYTES*8		; Bildschirmbreite
SCR_SIZE	= SCRBYTES*SCR_H	; Gre des Bildschirms in Bytes
BPLC0		= ((SCR_RES&2)<<14)+(SCR_BPL<<12)+$200+(SCR_LACE<<2)+(HAM<<11)		; BPLCON0
DIWS		= (SCR_Y<<8)+SCR_X													; DIWSTRT
DIWST		= ((SCR_Y+SCR_H/(SCR_LACE+1))&255)<<8+(SCR_X+SCR_W/SCR_RES)&255		; DIWSTOP
DDFS		= (SCR_X-(16/SCR_RES+1))/2											; DDFSTRT
DDFST		= DDFS+(8/SCR_RES)*(SCRBYTES/2-SCR_RES)								; DDFSTOP


Start:

; Zeiger Bitplanes

	lea	Bplpointers,a0
	move.l	#Logo+40*40,d0		; Adresse Logo (ein wenig gesenkt)
	moveq	#6-1,d7				; 6 Bitplanes HAM
BpLoop:
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	addq.w	#8,a0
	add.l	#176*40,d0			; Lnge Bitplane
	dbra	d7,BpLoop

	bsr.s	PrepCopEff			; vorbereiten Coppereffekt

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $110
	bne.s	WarteY1

	bsr.w	LogoEff				; "dehne" das Bild mit den Modulos
	bsr.w	UpDown				; bewege dich runter und rauf
	bsr.w	LefRig				; bewege dich nach rechts und links

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $110
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts							; Exit


*****************************************************************************
;		Routine die den Coppereffekt erstellt	    *
*****************************************************************************

;	_____________
;	\         __/____
;	 \______________/
;	  |_''__``_|
;	__(___)(___)__
;	\__  (__)  __/
;	  /  ____  \
;	  \ (____) /
;	   \______/ gm

PrepCopEff:

; Copperlist erstellen

	lea	CopyEff,a0				; Adresse, in der der Copperlist Effekt erstellt werden soll 
	move.l	#$1080000,d0		; BPL1MOD
	move.l	#$10A0000,d1		; BPL2MOD
	move.l	#$2e07fffe,d2		; wait (von der Zeile $2e beginnen)
	move.l	#$01000000,d3		; Wert, der jedes Mal zur Wartezeit hinzugefgt werden soll
	moveq	#(NUMLINES*2)-1,d7	; 53 Zeilen zu erstellen
MakeCop:
	move.l	d2,(a0)+			; Setzen Sie das WAIT
	move.l	d0,(a0)+			; Setzen Sie das BPL1MOD
	move.l	d1,(a0)+			; Setzen Sie das BPL2MOD
	add.l	d3,d2				; Warten Sie eine Zeile tiefer als die Wartezeit
	dbra	d7,MakeCop

; Multiplizieren Sie die Werte in der Tabelle mit der Formel,
; wird als Wert zum Einfgen von BPL1MOD und BPL2MOD verwendet.

	lea	TabY2,a0				; Adresse Tabelle
	move.w	#200-1,d7			; Anzahl der in der Tabelle enthaltenen Werte
Tab2Mul:
	move.w	(a0),d0				; Nimm den Wert aus der Tabelle
	mulu.w	#40,d0				; Multipliziere es mit der Lnge. 1 Zeile (mod.)
	move.w	d0,(a0)+			; den multiplizierten Wert zurckgeben und weiterschalten
	dbra	d7,Tab2Mul
	rts


; Tabelle mit 200 .word-Werten, die mit 40 multipliziert werden 

TabY2:
	dc.w	0,1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0
	dc.w	0,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,-1,0,0,0
	dc.w	0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0
	dc.w	-1,0,0,-1,0,0,0,-1,0,0,-1,0,0,-1,0
	dc.w	0,-1,0,0,0,-1,0,0,-1,0,0,-1,0,0,0
	dc.w	-1,0,0,0,-1,0,0,0,-1,0,0,0,0,0,-1,0,0
	dc.w	0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0
	dc.w	0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0
Tab2End:

*****************************************************************************
;			Routine Copperlist EFFEKT DES LOGOS				    *
*****************************************************************************

;	         _
;	     .--' `-.
;	     |.  _  |
;	     |___/  |
;	     `------'
;	    ./  _  \.
;	 _  |   | | |
;	| |_|___| |_|
;	|     | |_||
;	|_____| (_)|
;	      |    |
;	     (_____|gm
;

; Der copperlisteneffekt ist so strukturiert:
;
;	dc.w	$2e07,$fffe			; wait
;	dc.w	$108				; Register BPL1MOD
;CopperEffY:
;	dc.w	xxx					; Wert BPL1MOD
;	dc.w	$10a,xxx			; Register und Wert BPL2MOD
;	wait... eccetera.

LogoEff
	lea	CopyEff+6,a0			; Adresse Copper effect BPL1MOD
	lea	TabY2Pointer(pc),a4		; Adresszeiger auf die Tabelle
	lea	Tab2End(pc),a3			; Adresse Ende Tabelle
	move.l	TabY2Pointer(pc),a1	; Wo wir uns aktuell in der Tabelle befinden
	moveq	#10,d0
	moveq	#(NUMLINES*2)-1,d7	; Anzahl der Zeilen fr den Effekt
LogoEffLoop:
	move.w	(a1),(a0)+			; Kopieren Sie den Wert BPL1MOD von der Tabelle auf den Cop
	move.w	(a1)+,2(a0)			;  "		 "			BPL2MOD		"			"
	adda.l	d0,a0				; Gehe zum nchsten $dff108 (BPL1MOD) in der Coplist
	cmpa.l	a3,a1				; War es der letzte Wert der Tabelle?
	bne.s	NoRestart			; Wenn noch nicht, geh nicht
	lea	TabY2(pc),a1			; Ansonsten wieder gehen!
NoRestart:
	dbra	d7,LogoEffLoop
	addq.l	#4,(a4)				; berspringen Sie 2 Werte in der Coplist (wenn Sie #2 setzen
								; "verlangsamt" es den Effekt, indem er alle zum Lesen bringt
								; die 200 Werte der Tabelle).
	cmpa.l	(a4),a3				; Ende Tabelle?
	bne.s	NoTabEndY			; Wenn noch nicht, ok
	move.l	#TabY2,(a4)			; Andernfalls starten Sie erneut
NoTabEndY:
	rts

; Zeiger auf die Tabelle zum Lesen der Werte

TabY2Pointer:
	dc.l	TabY2

*****************************************************************************
;	Routine des Logos hoch runter (lsst die Bplpointers vorwrts oder 
;	rckwrts zeigen, nichts auergewhnliches)
*****************************************************************************

UpDownFlag:
	dc.w	0

UpDown:
	lea	Bplpointers,a1			; nimm die Adresse, auf die gerade gezeigt wird
	move.w	2(a1),d0			; Bitplanes und lege es in d0
	swap	d0
	move.w	6(a1),d0

	btst.b	#1,UpDownFlag		; soll ich rauf oder runter gehen
	beq.s	Down

; Ich gehe nach oben

Up:
	move.l	UpDownTabP(pc),a0	; Tabelle mit Vielfachen von 40 (des Modulos)
	subq.l	#2,UpDownTabP		; Ich nehme den Wert "vor"
	cmpa.l	#UpDownTab+4,a0
	bne.s	NobStart
	bchg.b	#1,UpDownFlag		; Wenn ich fertig bin, ndere die Richtung (gehe runter)
	addq.l	#2,UpDownTabP		; ausgleichen
NobStart:
	bra.s	NobEnd

; Ich gehe runter

Down:
	move.l	UpDownTabP(pc),a0	; Tabelle mit Vielfachen von 40
	addq.l	#2,UpDownTabP		; Ich nehme den Wert "nach"
	cmpa.l	#EndUpDownTab-4,a0
	bne.s	NobEnd
	bchg.b	#1,UpDownFlag		; Wenn ich fertig bin, ndere die Richtung
NobEnd:
	moveq	#0,d1
	move.w	(a0),d1				; Werte aus der Tabelle in d1
	btst.b	#1,UpDownFlag
	beq.s	Sub
Add:
	add.l	d1,d0				; Wenn ich nach oben gehe, werde ich es hinzufgen
	bra.s	MoveLogo
Sub:
	sub.l	d1,d0				; wenn ich nach unten gehe, subtrahiere ich es
MoveLogo:
	lea	Bplpointers,a1			; und an die neue Adresse gebracht
	moveq	#6-1,d1				; Anzahl der Bitplanes -1 (HAM 6 Bitplanes)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#176*40,d0			; Lnge einer Bitplane
	addq.w	#8,a1
	dbra	d1,PointBp			; Wiederholen Sie d1-mal (d1=Anzahl Bitplanes)
NoMove:
	rts

UpDownTabP:
	dc.l	UpDownTab

; Tabelle mit der Anzahl der zu berspringenden Bytes ... natrlich sind sie ein 
; Vielfaches von 40. Das ist die Lnge einer Zeile.

UpDownTab:
	dc.w	0*40,0*40,0*40,1*40,0*40,0*40,1*40,0*40,1*40
	dc.w	0*40,0*40,1*40,0*40,1*40,0*40,1*40,1*40,0*40
	dc.w	0*40,0*40,1*40,0*40,1*40,0*40,1*40,0*40,0*40
	dc.w	0*40,1*40,1*40,0*40,1*40,0*40,1*40,1*40,1*40
	dc.w	1*40,0*40,1*40,1*40,1*40,1*40,0*40
	dc.w	1*40,0*40,1*40,0*40,1*40,0*40,0*40,1*40,0*40
	dc.w	0*40,1*40,0*40,1*40,0*40,0*40,1*40,0*40,0*40
EndUpDownTab:

*****************************************************************************
;	Routine ZIEL DES LOGOS (benutze das BPLCON1, nichts besonderes)
*****************************************************************************

DestSinFlag:
	dc.w	0

LefRig:
	btst.b	#1,DestSinFlag		; soll ich nach rechts oder links gehen
	beq.s	ScrollRight
ScrollLeft:
	move.l	LeftRigTabP(pc),a0	; Tabelle mit Werten fr BPLCON1
	subq.l	#2,LeftRigTabP		; Ich gehe nach links
	cmpa.l	#LefRigTAB+4,a0		; Ende tabella?
	bne.s	NobStart2			; Wenn noch nicht, fahren Sie fort
	bchg.b	#1,DestSinFlag		; Andernfalls ndern Sie die Richtung
	addq.l	#2,LeftRigTabP		; ausgleichen
NobStart2:
	bra.s	NobEnd2

ScrollRight:
	move.l	LeftRigTabP(pc),a0	; Tabelle mit Werten fr BPLCON1
	addq.l	#2,LeftRigTabP		; Ich gehe nach rechts
	cmpa.l	#LefRigEND-4,a0		; Ende Tabelle?
	bne.s	NobEnd2				; Wenn noch nicht, fahren Sie fort
	bchg.b	#1,DestSinFlag		; Andernfalls ndern Sie die Richtung
NobEnd2:
	move.w	(a0),Con1			; setze den Wert in den BPLCON1 in der
NoMoves2:						; Copperlist
	rts

LeftRigTabP:
	dc.l	LefRigTab

; Dies sind Werte, die fr BPLCON1 ($dff102) zum Scrollen nach rechts / links geeignet sind.

LefRigTab:
	dc.w	0,0,0,0,0,0,0,$11,$11,$11,$11,$11
	dc.w	$22,$22,$22,$22,$22
	dc.w	$33,$33,$33
	dc.w	$44,$44
	dc.w	$55,$55,$55
	dc.w	$66,$66,$66,$66,$66
	dc.w	$77,$77,$77,$77,$77,$77,$77
	dc.w	$88,$88,$88,$88,$88,$88,$88,$88
	dc.w	$99,$99,$99,$99,$99,$99
	dc.w	$aa,$aa,$aa,$aa,$aa
	dc.w	$bb,$bb,$bb,$bb
	dc.w	$cc,$cc,$cc,$cc
	dc.w	$dd,$dd,$dd,$dd,$dd
	dc.w	$ee,$ee,$ee,$ee,$ee,$ee
	dc.w	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
LefRigEnd:

******************************************************************************
;		Copperlist:
******************************************************************************

	SECTION	GRAPHIC,DATA_C	

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT
	dc.w	$90,DIWST			; DIWSTOP
	dc.w	$92,DDFS			; DDFSTRT
	dc.w	$94,DDFST			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste     Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte       "
	dc.w	$ec,0,$ee,0			; vierte       "
	dc.w	$f0,0,$f2,0			; fnfte       "
	dc.w	$f4,0,$f6,0			; sechste      "

	dc.w	$180,0				; COLOR00 schwarz

	dc.w	$100,BPLC0			; BPLCON0 - 320*256 HAM

	dc.w	$180,$0000,$182,$134,$184,$531,$186,$443
	dc.w	$188,$0455,$18a,$664,$18c,$466,$18e,$973
	dc.w	$190,$0677,$192,$886,$194,$898,$196,$a96
	dc.w	$198,$0ca6,$19a,$9a9,$19c,$bb9,$19e,$dc9
	dc.w	$1a0,$0666

	dc.w	$102				; BPLCON1
Con1:
	dc.w	0

CopyEff:
	dcb.w	12*NUMLINES

	dc.w	$9707,$fffe			; wait Zeile $97
	dc.w	$100,$200			; no Bitplanes
	dc.w	$180,$110			; COLOR00
	dc.w	$9807,$fffe			; wait
	dc.w	$180,$120			; COLOR00
	dc.w	$9a07,$fffe
	dc.w	$180,$130
	dc.w	$9b07,$fffe
	dc.w	$180,$240
	dc.w	$9c07,$fffe
	dc.w	$180,$250
	dc.w	$9d07,$fffe
	dc.w	$180,$370
	dc.w	$9e07,$fffe
	dc.w	$180,$390
	dc.w	$9f07,$fffe
	dc.w	$180,$4b0
	dc.w	$a007,$fffe
	dc.w	$180,$5d0
	dc.w	$a107,$fffe
	dc.w	$180,$4a0
	dc.w	$a207,$fffe
	dc.w	$180,$380
	dc.w	$a307,$fffe
	dc.w	$180,$360
	dc.w	$a407,$fffe
	dc.w	$180,$240
	dc.w	$a507,$fffe
	dc.w	$180,$120
	dc.w	$a607,$fffe
	dc.w	$180,$110
	dc.w	$a70f,$fffe
	dc.w	$180,$000

	dc.w	$ffff,$fffe			; Ende Copperlist


	SECTION	LOGO,CODE_C

Logo:
	incbin "/Sources/amiet.raw"		; 6 Bitplanes * 176 lines * 40 bytes (HAM)

	end

Dies ist eine Fusion von Listing11l3a.s und Listing11l3b.s, die zum "bekannten"
Effekt des Logos im Intro der Disk 1 fhren.
Wie Sie sehen, ist es ganz einfach, obwohl Sie sich wahrscheinlich Gedanken ber 
wer was wei fr Routinen machen.
Beachten Sie, dass das UpDownTab aus einem Vielfachen von 40 aus der Tabelle 
"TabY2" bestehen muss: 
Whrend TabY2 Werte wie 0, 1, -1 hat, die dann mit einer Routine mit 40 multipliziert 
werden, zeigt UpDownTab die bereits multiplizierten Werte fr 40, in der
Form 1 * 40, 2 * 40 usw. an.  Sie knnten auch in diesen Fall nur die nicht
multiplizierten Werte setzen und sie mit der Lnge einer Zeile multiplizieren,
dh das Modulo durch eine Routine berechnen. Auf diese Weise knnten Sie leicht
ein equ definieren:

LengthLine	equ	40

Wenn Sie zum Beispiel eine Figur in hires schwingen mchten, reicht es aus
das equ auf 80 zu ndern, und die Werte in den Tabellen wren richtig
multipliziert.                         