
;  Listing11l3a.s - Bewegen Sie ein Bild nach oben / unten - rechts / links

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

SCRBYTES	= 40				; Anzahl der Bytes fr jede horizontale Zeile
								; Daraus berechnen wir die Bildschirmbreite,
								; Multiplizieren von Bytes mit 8: normaler Bildschirm 320/8 = 40
								; z.B. fr einen 336 Pixel breiten Bildschirm 336/8 = 42
								; Beispielbreiten:
								; 264 pixel = 33 / 272 pixel = 34 / 280 pixel = 35
								; 360 pixel = 45 / 368 pixel = 46 / 376 pixel = 47
								; ... 640 pixel = 80 / 648 pixel = 81 ...

SCR_H		= 256				; Bildschirmhhe in Zeilen
SCR_X		= $81				; Startbildschirm, XX-Position (normal $xx81) (129)
SCR_Y		= $2c				; Startbildschirm, YY-Position (normal $2cxx) (44)
SCR_RES		= 1					; 2 = HighRes (640*xxx) / 1 = LowRes (320*xxx)
SCR_LACE	= 0					; 0 = non interlace (xxx*256) / 1 = interlace (xxx*512)
HAM			= 1					; 0 = nicht HAM / 1 = HAM
SCR_BPL		= 6					; Anzahl Bitplanes

; Parameter automatisch berechnet

SCR_W		= SCRBYTES*8		; Bildschirmbreite
SCR_SIZE	= SCRBYTES*SCR_H	; Gre des Bildschirms in Bytes 
BPLC0		= ((SCR_RES&2)<<14)+(SCR_BPL<<12)+$200+(SCR_LACE<<2)+(HAM<<11)		; BPLCON0
DIWS		= (SCR_Y<<8)+SCR_X													; DIWSTRT
DIWST		= ((SCR_Y+SCR_H/(SCR_LACE+1))&255)<<8+(SCR_X+SCR_W/SCR_RES)&255		; DIWSTOP
DDFS		= (SCR_X-(16/SCR_RES+1))/2											; DDFSTRT
DDFST		= DDFS+(8/SCR_RES)*(SCRBYTES/2-SCR_RES)								; DDFSTOP


Start:
	; Zeiger Bitplanes

	move.l	#Logo+40*40,d0		; Logo-Adresse (etwas abgesenkt)
	lea	Bplpointers,a0	
	moveq	#6-1,d7				; 6 Bitplanes HAM
BpLoop:
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	addq.w	#8,a0
	add.l	#176*40,d0			; Lnge Bitplane
	dbra	d7,BpLoop

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	bne.s	WarteY1

	bsr.w	UpDown				; bewege dich runter und rauf
	bsr.w	LefRig				; bewege dich nach rechts und links

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts							; Exit


*****************************************************************************
;	Routine des Logos hoch runter (lsst die Bplpointers vorwrts oder 
;	rckwrts zeigen, nichts auergewhnliches)
*****************************************************************************

;	  _________________
;	  \               /
;	   \_____________/_
;	    | \___________/
;	    |__  ..  _:
;	    | \_____/ :
;	  __`---------'__
;	./               \.
;	|  _           _  |
;	|  |           |  |

UpFlag:
	dc.w	0

UpDown:
	lea	Bplpointers,a1			; nimm die Adresse der Bitplanes, auf die gerade 
	move.w	2(a1),d0			; gezeigt wird und packe es in d0
	swap	d0
	move.w	6(a1),d0

	btst.b	#1,UpFlag			; soll ich rauf oder runter gehen?
	beq.s	Down

; NACH OBEN

Up:
	move.l	UpDownTabP(pc),a0	; Tabelle mit Vielfachen von 40 (des Modulos)
	subq.l	#2,UpDownTabP		; Ich nehme den Wert "vor"
	cmpa.l	#UpDownTab+4,a0
	bne.s	NobStart
	bchg.b	#1,UpFlag			; Wenn fertig, ndere die Richtung (gehe runter)
	addq.l	#2,UpDownTabP		; ausgleichen
NobStart:
	bra.s	NobEnd

; NACH UNTEN

Down:
	move.l	UpDownTabP(pc),a0	; Tabelle mit Vielfachen von 40
	addq.l	#2,UpDownTabP		; Ich nehme den Wert "nach"
	cmpa.l	#EndUpDownTab-4,a0
	bne.s	NobEnd
	bchg.b	#1,UpFlag			; Wenn ich fertig bin, ndere die Richtung
NobEnd:
	moveq	#0,d1
	move.w	(a0),d1				; Tabellenwert in d1
	btst.b	#1,UpFlag
	beq.s	Sub
Add:
	add.l	d1,d0				; Wenn ich nach oben gehe, werde ich es hinzufgen
	bra.s	MoveLogo
Sub:
	sub.l	d1,d0				; wenn ich nach unten gehe, subtrahiere ich es
MoveLogo:
	lea	Bplpointers,a1			; und an die neue Adresse gebracht
	moveq	#6-1,d1				; Anzahl der Bitplanes -1 (HAM 6 Bitplanes)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#176*40,d0			; Lnge von einer Bitplane
	addq.w	#8,a1
	dbra	d1,PointBp			; Wiederholen Sie d1-mal (d1=Anzahl der Bitplanes)
NoMove:
	rts

UpDownTabP:
	dc.l	UpDownTab

; Tabelle mit der Anzahl der zu berspringenden Bytes ...
; natrlich sind sie ein Vielfaches von 40,
; Das ist die Lnge einer Zeile.

UpDownTab:
	dc.w	0*40,0*40,0*40,1*40,0*40,0*40,1*40,0*40,1*40
	dc.w	0*40,0*40,1*40,0*40,1*40,0*40,1*40,1*40,0*40
	dc.w	0*40,0*40,1*40,0*40,1*40,0*40,1*40,0*40,0*40
	dc.w	0*40,1*40,1*40,0*40,1*40,0*40,1*40,1*40,1*40
	dc.w	1*40,0*40,1*40,1*40,1*40,1*40,0*40
	dc.w	1*40,0*40,1*40,0*40,1*40,0*40,0*40,1*40,0*40
	dc.w	0*40,1*40,0*40,1*40,0*40,0*40,1*40,0*40,0*40
EndUpDownTab:

*****************************************************************************
;	Routine Ziel Logo LINKSSEITIG (benutze das BPLCON1, nichts besonderes)
*****************************************************************************

;	    ____
;	____/____\_____
;	_)_  _  ______/
;	\_()()(__\%
;	 \(___     //
;	  \V V\_____/ st!
;	  

DestSinFlag:
	dc.w	0

LefRig:
	btst.b	#1,DestSinFlag		; soll ich nach rechts oder links gehen
	beq.s	ScrollRight
ScrollLeft:
	move.l	LefRigTabP(pc),a0	; Tabelle mit Werten fr BPLCON1
	subq.l	#2,LefRigTabP		; gehe nach links
	cmpa.l	#LefRigTAB+4,a0		; Ende Tabelle?
	bne.s	NobStart2			; Wenn noch nicht, fahren Sie fort
	bchg.b	#1,DestSinFlag		; Andernfalls ndern Sie die Richtung
	addq.l	#2,LefRigTabP		; ausgleichen
NobStart2:
	bra.s	NobEnd2

ScrollRight:
	move.l	LefRigTabP(pc),a0	; Tabelle mit Werten fr BPLCON1
	addq.l	#2,LefRigTabP		; gehe nach rechts
	cmpa.l	#LefRigEnd-4,a0		; Ende Tabelle?
	bne.s	NobEnd2				; Wenn noch nicht, fahren Sie fort
	bchg.b	#1,DestSinFlag		; Andernfalls ndern Sie die Richtung
NobEnd2:
	move.w	(a0),Con1			; setze den Wert in den BPLCON1 in den
NoMove2:						; Copperlist
	rts

LefRigTabP:
	dc.l	LefRigTab

; Dies sind Werte, die fr BPLCON1 ($dff102) zum Scrollen nach rechts / links geeignet sind.

LefRigTab:
	dc.w	0,0,0,0,0,0,0,$11,$11,$11,$11,$11
	dc.w	$22,$22,$22,$22,$22
	dc.w	$33,$33,$33
	dc.w	$44,$44
	dc.w	$55,$55,$55
	dc.w	$66,$66,$66,$66,$66
	dc.w	$77,$77,$77,$77,$77,$77,$77
	dc.w	$88,$88,$88,$88,$88,$88,$88,$88
	dc.w	$99,$99,$99,$99,$99,$99
	dc.w	$aa,$aa,$aa,$aa,$aa
	dc.w	$bb,$bb,$bb,$bb
	dc.w	$cc,$cc,$cc,$cc
	dc.w	$dd,$dd,$dd,$dd,$dd
	dc.w	$ee,$ee,$ee,$ee,$ee,$ee
	dc.w	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
LefRigEnd:


******************************************************************************
;		Copperlist:
******************************************************************************

	SECTION	GRAPHIC,DATA_C	

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT
	dc.w	$90,DIWST			; DIWSTOP
	dc.w	$92,DDFS			; DDFSTRT
	dc.w	$94,DDFST			; DDFSTOP
	dc.w	$100,BPLC0			; BPLCON0 - 320*256 HAM
	dc.w	$102				; BPLCON1
Con1:
	dc.w	0
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste Bitplane
	dc.w	$e4,0,$e6,0			; zweite   "
	dc.w	$e8,0,$ea,0			; dritte   "
	dc.w	$ec,0,$ee,0			; vierte   "
	dc.w	$f0,0,$f2,0			; fnfte   "
	dc.w	$f4,0,$f6,0			; sechste  "

	dc.w	$180,$0000,$182,$134,$184,$531,$186,$443
	dc.w	$188,$0455,$18a,$664,$18c,$466,$18e,$973
	dc.w	$190,$0677,$192,$886,$194,$898,$196,$a96
	dc.w	$198,$0ca6,$19a,$9a9,$19c,$bb9,$19e,$dc9
	dc.w	$1a0,$0666
	
	dc.w	$9707,$fffe			; wait Zeile $97
	dc.w	$100,$200			; no Bitplanes
	dc.w	$180,$110			; COLOR00
	dc.w	$9807,$fffe			; wait
	dc.w	$180,$120			; COLOR00
	dc.w	$9a07,$fffe
	dc.w	$180,$130
	dc.w	$9b07,$fffe
	dc.w	$180,$240
	dc.w	$9c07,$fffe
	dc.w	$180,$250
	dc.w	$9d07,$fffe
	dc.w	$180,$370
	dc.w	$9e07,$fffe
	dc.w	$180,$390
	dc.w	$9f07,$fffe
	dc.w	$180,$4b0
	dc.w	$a007,$fffe
	dc.w	$180,$5d0
	dc.w	$a107,$fffe
	dc.w	$180,$4a0
	dc.w	$a207,$fffe
	dc.w	$180,$380
	dc.w	$a307,$fffe
	dc.w	$180,$360
	dc.w	$a407,$fffe
	dc.w	$180,$240
	dc.w	$a507,$fffe
	dc.w	$180,$120
	dc.w	$a607,$fffe
	dc.w	$180,$110
	dc.w	$a70f,$fffe
	dc.w	$180,$000

	dc.w	$ffff,$fffe			; Ende Copperlist


	SECTION	LOGO,CODE_C

Logo:
	incbin	"/Sources/amiet.raw"	; 6 Bitplanes * 176 lines * 40 bytes (HAM)

	end

                                                                                                                                                                                                                                                                                 

*****************************************************************************
;	Routine ZIEL DES LOGOS (benutze das BPLCON1, nichts besonderes)
*****************************************************************************

DestSinFlag:
	dc.w	0

LefRig:
	btst.b	#1,DestSinFlag		; soll ich nach rechts oder links gehen
	beq.s	ScrollRight
ScrollLeft:
	move.l	LeftRigTabP(pc),a0	; Tabelle mit Werten fr BPLCON1
	subq.l	#2,LeftRigTabP		; Ich gehe nach links
	cmpa.l	#LefRigTAB+4,a0		; Ende tabella?
	bne.s	NobStart2			; Wenn noch nicht, fahren Sie fort
	bchg.b	#1,DestSinFlag		; Andernfalls ndern Sie die Richtung
	addq.l	#2,LeftRigTabP		; ausgleichen
NobStart2:
	bra.s	NobEnd2

ScrollRight:
	move.l	LeftRigTabP(pc),a0	; Tabelle mit Werten fr BPLCON1
	addq.l	#2,LeftRigTabP		; Ich gehe nach rechts
	cmpa.l	#LefRigEND-4,a0		; Ende Tabelle?
	bne.s	NobEnd2				; Wenn noch nicht, fahren Sie fort
	bchg.b	#1,DestSinFlag		; Andernfalls ndern Sie die Richtung
NobEnd2:
	move.w	(a0),Con1			; setze den Wert in den BPLCON1 in der
NoMoves2:						; Copperlist
	rts

LeftRigTabP:
	dc.l	LefRigTab

; Dies sind Werte, die fr BPLCON1 ($dff102) zum Scrollen nach rechts / links geeignet sind.

LefRigTab:
	dc.w	0,0,0,0,0,0,0,$11,$11,$11,$11,$11
	dc.w	$22,$22,$22,$22,$22
	dc.w	$33,$33,$33
	dc.w	$44,$44
	dc.w	$55,$55,$55
	dc.w	$66,$66,$66,$66,$66
	dc.w	$77,$77,$77,$77,$77,$77,$77
	dc.w	$88,$88,$88,$88,$88,$88,$88,$88
	dc.w	$99,$99,$99,$99,$99,$99
	dc.w	$aa,$aa,$aa,$aa,$aa
	dc.w	$bb,$bb,$bb,$bb
	dc.w	$cc,$cc,$cc,$cc
	dc.w	$dd,$dd,$dd,$dd,$dd
	dc.w	$ee,$ee,$ee,$ee,$ee,$ee
	dc.w	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
LefRigEnd:

******************************************************************************
;		Copperlist:
******************************************************************************

	SECTION	GRAPHIC,DATA_C	

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT
	dc.w	$90,DIWST			; DIWSTOP
	dc.w	$92,DDFS			; DDFSTRT
	dc.w	$94,DDFST			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste     Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte       "
	dc.w	$ec,0,$ee,0			; vierte       "
	dc.w	$f0,0,$f2,0			; fnfte       "
	dc.w	$f4,0,$f6,0			; sechste      "

	dc.w	$180,0				; COLOR00 schwarz

	dc.w	$100,BPLC0			; BPLCON0 - 320*256 HAM

	dc.w	$180,$0000,$182,$134,$184,$531,$186,$443
	dc.w	$188,$0455,$18a,$664,$18c,$466,$18e,$973
	dc.w	$190,$0677,$192,$886,$194,$898,$196,$a96
	dc.w	$198,$0ca6,$19a,$9a9,$19c,$bb9,$19e,$dc9
	dc.w	$1a0,$0666

	dc.w	$102				; BPLCON1
Con1:
	dc.w	0

CopyEff1:
	dcb.w	12*NUMLINES

	dc.w	$9707,$fffe			; wait Zeile $97
	dc.w	$100,$200			; no Bitplanes
	dc.w	$180,$110			; COLOR00
	dc.w	$9807,$fffe			; wait
	dc.w	$180,$120			; COLOR00
	dc.w	$9a07,$fffe
	dc.w	$180,$130
	dc.w	$9b07,$fffe
	dc.w	$180,$240
	dc.w	$9c07,$fffe
	dc.w	$180,$250
	dc.w	$9d07,$fffe
	dc.w	$180,$370
	dc.w	$9e07,$fffe
	dc.w	$180,$390
	dc.w	$9f07,$fffe
	dc.w	$180,$4b0
	dc.w	$a007,$fffe
	dc.w	$180,$5d0
	dc.w	$a107,$fffe
	dc.w	$180,$4a0
	dc.w	$a207,$fffe
	dc.w	$180,$380
	dc.w	$a307,$fffe
	dc.w	$180,$360
	dc.w	$a407,$fffe
	dc.w	$180,$240
	dc.w	$a507,$fffe
	dc.w	$180,$120
	dc.w	$a607,$fffe
	dc.w	$180,$110
	dc.w	$a70F,$fffe
	dc.w	$180,$000

	dc.w	$ffff,$fffe			; Ende Copperlist


	SECTION	LOGO,CODE_C

Logo:
	incbin "/Sources/amiet.raw"		; 6 Bitplanes * 176 lines * 40 bytes (HAM)

	end

                                                                 