
;  Listing11l2.s - Fr jede Zeile werden 3 von 4 Farben (2 Bitebenen) gendert.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

SCRBYTES	= 40				; Anzahl der Bytes fr jede horizontale Zeile.
								; Daraus berechnen wir die Bildschirmbreite,
								; Multiplizieren von Bytes mit 8: normaler Bildschirm 320/8 = 40
								; z.B. fr einen 336 Pixel breiten Bildschirm 336/8 = 42
								; Beispielbreiten:
								; 264 pixel = 33 / 272 pixel = 34 / 280 pixel = 35
								; 360 pixel = 45 / 368 pixel = 46 / 376 pixel = 47
								; ... 640 pixel = 80 / 648 pixel = 81 ...

SCR_H		= 256				; Bildschirmhhe in Zeilen
SCR_X		= $81				; Startbildschirm, XX-Position (normal $xx81) (129)
SCR_Y		= $2c				; Startbildschirm, YY-Position (normal $2cxx) (44)
SCR_RES		= 1					; 2 = HighRes (640*xxx) / 1 = LowRes (320*xxx)
SCR_LACE	= 0					; 0 = non interlace (xxx*256) / 1 = interlace (xxx*512)
HAM			= 0					; 0 = nicht HAM / 1 = HAM
SCR_BPL		= 2					; Anzahl Bitplanes

; Parameter automatisch berechnet

SCR_W		= SCRBYTES*8		; Bildschirmbreite
SCR_SIZE	= SCRBYTES*SCR_H	; Gre des Bildschirms in Bytes 
BPLC0		= ((SCR_RES&2)<<14)+(SCR_BPL<<12)+$200+(SCR_LACE<<2)+(HAM<<11)		; BPLCON0
DIWS		= (SCR_Y<<8)+SCR_X													; DIWSTRT
DIWST		= ((SCR_Y+SCR_H/(SCR_LACE+1))&255)<<8+(SCR_X+SCR_W/SCR_RES)&255		; DIWSTOP
DDFS		= (SCR_X-(16/SCR_RES+1))/2											; DDFSTRT
DDFST		= DDFS+(8/SCR_RES)*(SCRBYTES/2-SCR_RES)								; DDFSTOP


Start:
	move.l	#Bitplane1,d0
	lea	Bplpointers,a0
	moveq	#2-1,d7				; 2 Bitplanes
BpLoop:
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a0
	dbra	d7,BpLoop

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	bsr.s	CreaCopper			; Copperlist erstellen

	lea	Text(pc),a0				; zu druckender Text
	lea	Bitplane1,a3			; Ziel
	bsr.w	Print				; drucken

	lea	Text2(pc),a0			; zu druckender Text
	lea	Bitplane2,a3			; Ziel
	bsr.w	Print				; drucken

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; warte auf Zeile $12c
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	beq.s	WarteY2

	bsr.w	RasterMagic			; Kopie der Tabelle in Copperlist
	bsr.w	CycleBlue			; zyklisch die blaue Tab (nach oben)
	bsr.w	CycleRed			; zyklisch die rote Tab (nach oben)
	bsr.w	CycleGreen			; zyklisch die grne Tab (nach oben)

	btst.b	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

*****************************************************************************
; Diese Routine erstellt die Copperliste
*****************************************************************************

;	            _____
;	           /   _/
;	          /_____\
;	 _        \ o.O /
;	/ )________\_-_/_________
;	\__/      _  Y  _       /__
;	 _/______/   :   \_____/__ \
;	       _/    :    \_  .--(_/
;	       \_____:_____/.
;	       /    ___   :\ :
;	      /      |   :..:
;	    _/       |       \
;	   _\________|        \_
;	  (__________l_________/_ _ _
;	             (___________))

CreaCopper:
	lea	CopperEffyz,a1
	move.l	#$180,d2			; Farbe 0
	move.l	#$182,d3			; Farbe 1
	move.l	#$186,d4			; Farbe 3
	moveq	#-2,d5				; $fffe	; wait command
	move.w	#$0100,d6			; WAIT ADD: 0107fffe, 0207fffe....
	move.w	#$2c07,d1			; start Zeile
	moveq	#7-1,d7				; Anzahl loops
Again:
	lea	ColTabBlue(pc),a0
	lea	ColTabRed(pc),a2
	lea	ColTabGreen(pc),a3

	REPT	28					; Anzahl Zeilen: 28*d7
	move.w	d1,(a1)+			; warte auf Zeile ...
	move.w	d5,(a1)+			; $fffe wait command
	move.w	d2,(a1)+			; Farbregister 0
	move.w	(a0)+,(a1)+			; Farbwert blauer Tab
	move.w	d3,(a1)+			; Farbregister 1
	move.w	(a2)+,(a1)+			; Farbwert roter Tab
	move.w	d4,(a1)+			; Farbregister 3
	move.w	(a3)+,(a1)+			; Farbwert grner Tab
	add.w	d6,d1				; eine Zeile tiefer warten
	ENDR

	dbra	d7,Again
	rts

*****************************************************************************

;	              __ ___
;		     (______)
;		    __||||||__
;		   (__________)
;		     |      |
;		     _ __   |
;		    (.(._) (((
;		   (__ __   __)
;		   ./    \  |
;	magico!	   `----( \ |
;		  __ \____/ /\__
;		 /  /__\___/__\ \
;		/   __   o  __    gm


RasterMagic:
	lea	CopperEffyz,a1
	moveq	#7-1,d7				; Anzahl loops
Again2:
	lea	ColTabBlue(pc),a0
	lea	ColTabRed(pc),a2
	lea	ColTabGreen(pc),a3

	REPT	28					; Anzahl Zeilen: 28*d7
	addq.w	#2+4,a1				; berspringe das Warten und das Farbregister 0
	move.w	(a0)+,(a1)+			; Farbwert blauer Tab
	addq.w	#2,a1				; berspringe Farbregister 1
	move.w	(a2)+,(a1)+			; Farbwert roter Tab
	addq.w	#2,a1				; berspringe Farbregister 3
	move.w	(a3)+,(a1)+			; Farbwert grner Tab
	add.w	d6,d1				; eine Zeile tiefer warten
	ENDR

	dbra	d7,Again2
	rts

*****************************************************************************

;	    _))_
;	  ./    \.
;	  |      |
;	 \_ __/  |
;	 (-(--)  |
;	(__ __  (((
;	 /__  \  __)
;  Ue'..  __)  \ | gm
;	 (_____/ |

CycleBlue:
	lea	ColTabBlue+54(pc),a0
	lea	ColTabBlue+52(pc),a1
	move.w	ColTabBlue+54(pc),d1; Speichere die letzte Farbe

	REPT	27
	move.w	(a1),(a0)			; Zyklus 2
	subq.w 	#2,a0
	subq.w	#2,a1
	ENDR

	move.w	d1,ColTabBlue		; Lege den letzten zurck
	rts

*****************************************************************************

CycleRed:
 	lea	ColTabRed(pc),a0
	lea	ColTabRed+2(pc),a1
	move.w	(a0),56(a0)

	REPT	29		; Zyklus 2
	move.w	(a1)+,(a0)+
	ENDR

	rts
		
CycleGreen:
 	lea	ColTabGreen(pc),a0
	lea	ColTabGreen+2(pc),a1
	move.w	(a0),56(a0)

	REPT	29		; Zyklus 3
	move.w	(a1)+,(a0)+
	ENDR

	rts		

ColTabBlue:
	dc.w	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
	dc.w	15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0,0,0,0

ColTabRed:
	dc.w	$100,$200,$300,$400,$500,$600,$700,$800,$900
	dc.w	$a00,$b00,$c00,$d00,$e00,$f00,$f00,$e00,$c00
	dc.w	$b00,$a00,$900,$800,$700,$600,$500,$400,$300
	dc.w	$200,$100,0,0,0,0

ColTabGreen:
	dc.w	$010,$020,$030,$040,$050,$060,$070,$080,$090
	dc.w	$0a0,$0b0,$0c0,$0d0,$0e0,$0f0,$0f0,$0e0,$0d0,$0c0
	dc.w	$0b0,$0a0,$090,$080,$070,$060,$050,$040,$030,$020
	dc.w	$010,0,0,0,0


*****************************************************************************
;	Routine, die 8 x 8 Pixel breite Zeichen druckt
*****************************************************************************

Print:
	moveq	#23-1,d3			; ANZAHL DER ZU DRUCKENDEN ZEILEN: 23
PrintLine:
	moveq	#40-1,d0			; ANZAHL DER SPALTEN PRO REIHE: 40
PrintChar2:
	moveq	#0,d2				; d2 lschen
	move.b	(a0)+,d2			; Nchstes Zeichen in d2
	sub.b	#$20,d2				; ENTFERNEN SIE 32 VOM ASCII-WERT DES CHARAKTERS
	lsl.w	#3,d2				; MULTIPLIZIEREN DIE VORHERIGE ZAHL MIT 8 
	move.l	d2,a2
	add.l	#Font,a2			; Finden Sie den gewnschten Charakter im Font...
	move.b	(a2)+,(a3)			; Drucke Zeile 1 des Zeichens
	move.b	(a2)+,40(a3)		; Drucke Zeile  2  " "
	move.b	(a2)+,40*2(a3)		; Drucke Zeile  3  " "
	move.b	(a2)+,40*3(a3)		; Drucke Zeile  4  " "
	move.b	(a2)+,40*4(a3)		; Drucke Zeile  5  " "
	move.b	(a2)+,40*5(a3)		; Drucke Zeile  6  " "
	move.b	(a2)+,40*6(a3)		; Drucke Zeile  7  " "
	move.b	(a2)+,40*7(a3)		; Drucke Zeile  8  " "

	addq.w	#1,a3				; a1+1, wir rcken 8 Bits vor (NCHSTES ZEICHEN)
	dbra	d0,PrintChar2		; Wir drucken d0 (40) Zeichen pro Zeile
	add.w	#40*7,a3			; Lass uns gehen		
	dbra	d3,PrintLine		; wir machen d3 Zeilen
	rts


		 ; Anzahl der Zeichen pro Zeile: 40
Text:	     ;		  1111111111222222222233333333334
	     ;	 1234567890123456789012345678901234567890
	dc.b	'   PRIMA RIGA (solo in testo1)          ' ; 1
	dc.b	'                                        ' ; 2
	dc.b	'     /\  /          # #                 ' ; 3
	dc.b	'    /  \/           # #                 ' ; 4
	dc.b	'                    # #                 ' ; 5
	dc.b	'        SESTA RIGA (entrambi i Bitplane)' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO CIUCCI               INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1  4 6 89  !@ $ ^& () +| =- ]{       ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	'     LA  A I G N T C  OBLITERAZIONE     ' ; 15
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 16
	dc.b	'  Nel mezzo del cammin di nostra vita   ' ; 17
	dc.b	'                                        ' ; 18
	dc.b	'    Mi RitRoVaI pEr UnA sELva oScuRa    ' ; 19
	dc.b	'                                        ' ; 20
	dc.b	'    CHE LA DIRITTA VIA ERA              ' ; 21
	dc.b	'                                        ' ; 22
	dc.b	'  AHI Quanto a DIR QUAL ERA...          ' ; 23
	dc.b	'                                        ' ; 24
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ; 27

	even

		; Anzahl der Zeichen pro Zeile
Text2:	     ;		  1111111111222222222233333333334
	     ;	 1234567890123456789012345678901234567890
	dc.b	'                                        ' ; 1
	dc.b	'  SECONDA RIGA (solo in testo2)         ' ; 2
	dc.b	'     /\  /          ##                  ' ; 3
	dc.b	'    /  \/           ##                  ' ; 4
	dc.b	'                    ##                  ' ; 5
	dc.b	'        SESTA RIGA (entrambi i Bitplane)' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO        COMMUNICATION INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1234567 90  @#$%^&*( _+|\=-[]{}      ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	'     LA PALINGENETICA  B I E A I N      ' ; 15
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 16
	dc.b	'  Nel       del cammin di        vita   ' ; 17
	dc.b	'                                        ' ; 18
	dc.b	'    Mi          pEr UnA       oScuRa    ' ; 19
	dc.b	'                                        ' ; 20
	dc.b	'    CHE LA         VIA ERA SMARRITA     ' ; 21
	dc.b	'                                        ' ; 22
	dc.b	'  AHI Quanto a     QUAL ERA...          ' ; 23
	dc.b	'                                        ' ; 24
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ; 27

	even

; Die Font 8x8-Zeichen, die in CHIP von der CPU und nicht vom Blitter kopiert wurden,
; so kann es auch im FAST RAM sein. In der Tat wre es besser!

Font:
	incbin	"/Sources/nice.fnt"

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT
	dc.w	$90,DIWST			; DIWSTOP
	dc.w	$92,DDFS			; DDFSTRT
	dc.w	$94,DDFST			; DDFSTOP

	dc.w	$102,$0				; BPLCON1
	dc.w	$104,$0				; BPLCON2
	dc.w	$108,$0				; BPL1MOD
	dc.w	$10a,$0				; BPL2MOD

Bplpointers:
	dc.w	$e0,0,$e2,0,$e4,0,$e6,0
	dc.w	$100,BPLC0			; BPLCON0 - 2 Bitplanes lowres
	dc.w	$184,$fff			; COLOR02 gelb (der feste)

CopperEffyz:
	dcb.w	28*8*7				; Platz fr den Effekt
	dc.w	$ffff,$fffe

*****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane1:
	ds.b	40*256
Bitplane2:
	ds.b	40*256

	end

Haben Sie die italienische Flagge bemerkt?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 