
; Listing11i4.s - originaler Schatten- / Elektronen-Effekt modifiziert.
; drcken sie die rechte Taste, um von Schatten zu Schatten zu ndern...

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

RANGE		equ	20
NUMBERLINES	equ	257

Start:
	bsr.w	InitCopBuf			; Copperlist vorbereiten

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; warte auf Zeile $12c
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	beq.s	WarteY2

	bsr.w	CopMove				; Haupteffekt - Schatten der Farben
	bsr.w	Cycle				; scrollt die Farben

	btst.b	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	DoNotChangeMask
	move.w	6(a6),MaskColors	; VHPOSR - setze einen Wert nach dem Zufallsprinzip
	move.b	7(a6),d0			; HPOSR
	and.w	#%011001110011,MaskColors

DoNotChangeMask:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse

	rts


*****************************************************************
; Diese Routine bewirkt, dass die Farben von der Mitte zu den Rndern "scrollen"
*****************************************************************

;	       ####
;	       :00:
;	       |--|
;	    ___||___
;	  _/  _\/_  \_
;	  \___|    |___/
;	 __/ _|    |  \_/_
;	  /\ |______\   \
;	     "|     \
;	      |  V  |
;	      |  |  |
;	      |  |  |
;	     :/__|__|
;	      __| |__
;	*******************

ClearStep:
	dc.w	10

Cycle:
	lea	CopBuf+6+8,a0			; erste Farbe oben
	lea	CopBuf+6-8+[256*8],a1	; letzte Farbe unten

	moveq 	#128-1,d0			; Anzahl der Zyklen
CycleLoop:
	subq.w	#01,Count			; jeder "step" hellt die Farbe auf.
	bne.s	GoCycle
	add.w	#$101,(a0)			; die Farbe 1 alle 10 aufhellen
	move.w	ClearStep(pc),Count
GoCycle:
	move.w 	(a0),-8(a0)			; Scrolle nach oben
	move.w 	(a0),8(a1)			; Scrolle nach unten
	addq.w	#8,a0
	subq.w	#8,a1
	dbra	d0,CycleLoop
	rts

Count:
	dc.w	10

***************************************************************
; Diese Routine verwischt die Farben
***************************************************************

CopMove:
	lea	CopBuf+6+[128*8],a1		; halber Bildschirm
Smooth
	move.w 	ColorOld(pc),d0
	move.w 	ColorNewCase(pc),d1
	cmp.w	d0,d1				; alte Farbe wie neu?
	beq.s	NewCol				; dann nimm eine neue Farbe "zufllig"

	subq.w	#01,Counter			; Counter = 0?
	beq.s	GoSmooth			; wenn es "verblasst" ...
	bra.s	Draw				; sonst einfach zeichnen

; "Nuance" der Farben - Add und Sub einfach die Komponenten

GoSmooth:
	move.w	#RANGE,Counter 

	move.w 	d0,d2
	move.w 	d1,d3
	and.w	#$000f,d2			; nur Komponente blau
	and.w	#$000f,d3
	cmp.w	d2,d3
	beq.s	BlueReady
	bgt.s	AddBlue
subblue:
	sub.w	#$0001,d0			; - blau
	bra.s	BlueReady
AddBlue:
	add.w	#$0001,d0			; + blau
BlueReady:	
	move.w 	d0,d2
	move.w 	d1,d3
	and.w	#$00f0,d2			; nur Komponente grn
	and.w	#$00f0,d3
	cmp.w	d2,d3
	beq.s	GreenReady
	bgt.s	AddGreen
SubGreen:
	sub.w	#$0010,d0			; - grn
	bra.s	GreenReady
AddGreen:
	add.w	#$0010,d0			; + grn
GreenReady:	
	move.w 	d0,d2
	move.w 	d1,d3
	and.w	#$0f00,d2			; nur Komponente rot
	and.w	#$0f00,d3
	cmp.w	d2,d3
	beq.s	RedReady
	bgt.s	AddRed
SubRed:
	sub.w	#$0100,d0			; - rot
	bra.s	RedReady
AddRed:
	add.w	#$0100,d0			; + rot
RedReady:
	move.w 	d0,ColorOld
Draw:
	move.w 	d0,(a1)
	rts

;-----------------------------------------------------------------------------
; Es nimmt eine zufllige Farbe an, indem es mit der horizontalen Position des
; Elektronenstrahls spielt. Es ist keine groe Routine, aber es funktioniert 
; fr "pseudo-zufllige" Werte.
;----------------------------------------------------------------------------

NewCol:
	move.w 	ColorNewCase(pc),ColorOld		

	move.b 	$05(a6),d1			; $dff006 - Farbe RANDOM...
	muls.w	#$71,d1
	eor.w	#$ed,d1
	muls.w	$06(a6),d1			; $dff006 - Farbe RANDOM
	and.w	MaskColors(pc),d1	; Whlen Sie nur die Farbbits aus
	move.w 	d1,ColorNewCase

	cmp.w 	ColorOld(pc),d1
	bne.w	Smooth
	add.b	#$08,ColorNewCase
	bra.w	Smooth
	

MaskColors:		dc.w	$012
ColorOld:		dc.w	0
ColorNewCase:	dc.w	0
Counter:		dc.w	RANGE

*************************************************************
;	Copperlist erstellen
*************************************************************

InitCopBuf:
	lea	CopBuf,a0
	move.l 	#$29e1fffe,d0		; erste wait Zeile

	move.w 	#NUMBERLINES-1,d1
CopLoop:
	move.l 	d0,(a0)+			; das wait ablegen
	move.l 	#$01800000,(a0)+	; COLOR00
	add.l	#$01000000,d0		; Lass eine Zeile unten warten
	dbra	d1,CopLoop
	rts

***************************************************************
;	Copperlist
***************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
		dc.w	$100,$200		; BPLCON0 - keine Bitplanes
CopBuf:
		ds.b	NUMBERLINES*8	; Platz fr den Coppereffekt 

		dc.w	$ffff,$fffe		; Ende Copperlist
	end

           8*6(a1)
	move.w	YLINES*14(a0),8*7(a1)
	move.w	YLINES*16(a0),8*8(a1)
	move.w	YLINES*18(a0),8*9(a1)
	lea	8*10(a1),a1
	addq.w	#2,a0
	dbra	d0,CoLoop
	rts

*****************************************************************************
;			Farb-TABELLE
*****************************************************************************

ColorTable:
	dc.w	$001,$002,$003,$004,$005,$006,$007,$008,$009,$00a
	dc.w	$00b,$00c,$00d,$00e,$00f
	dc.w	$01f,$02f,$03f,$04f,$05f
	dc.w	$06f,$07f,$08f,$09f,$0af,$0bf,$0cf,$0df,$0ef,$0ff
	dc.w	$0fe,$0fd,$0fc,$0fb,$0fa,$0f9,$0f8,$0f7,$0f6,$0f5
	dc.w	$0f4,$0f3,$0f2,$0f1,$0f0,$1f0,$2f0,$3f0,$4f0,$5f0
	dc.w	$6f0,$7f0,$8f0,$9f0,$af0,$bf0,$cf0,$df0,$ef0,$ff0
	dc.w	$fe0,$fd0,$fc0,$fb0,$fa0,$f90,$f80,$f70,$f60,$f50
	dc.w	$f40,$f30,$f20,$f10,$f00,$f01,$f02,$f03,$f04,$f05
	dc.w	$f06,$f07,$f08,$f09,$f0a,$f0b,$f0c,$f0d,$f0e,$f0f
	dc.w	$e0e,$d0d,$c0c,$b0b,$a0a,$909,$808,$707,$606
	dc.w	$505,$404,$303,$202,$101,$000
ColorEnd:
	dc.w	$001,$002,$003,$004,$005,$006,$007,$008,$009,$00a
	dc.w	$00b,$00c,$00d,$00e,$00f
	dc.w	$01f,$02f,$03f,$04f,$05f
	dc.w	$06f,$07f,$08f,$09f,$0af,$0bf,$0cf,$0df,$0ef,$0ff
	dc.w	$0fe,$0fd,$0fc,$0fb,$0fa,$0f9,$0f8,$0f7,$0f6,$0f5
	dc.w	$0f4,$0f3,$0f2,$0f1,$0f0,$1f0,$2f0,$3f0,$4f0,$5f0
	dc.w	$6f0,$7f0,$8f0,$9f0,$af0,$bf0,$cf0,$df0,$ef0,$ff0
	dc.w	$fe0,$fd0,$fc0,$fb0,$fa0,$f90,$f80,$f70,$f60,$f50
	dc.w	$f40,$f30,$f20,$f10,$f00,$f01,$f02,$f03,$f04,$f05
	dc.w	$f06,$f07,$f08,$f09,$f0a,$f0b,$f0c,$f0d,$f0e,$f0f
	dc.w	$e0e,$d0d,$c0c,$b0b,$a0a,$909,$808,$707,$606
	dc.w	$505,$404,$303,$202,$101,$000
	dc.w	$001,$002,$003,$004,$005,$006,$007,$008,$009,$00a
	dc.w	$00b,$00c,$00d,$00e,$00f
	dc.w	$01f,$02f,$03f,$04f,$05f
	dc.w	$06f,$07f,$08f,$09f,$0af,$0bf,$0cf,$0df,$0ef,$0ff
	dc.w	$0fe,$0fd,$0fc,$0fb,$0fa,$0f9,$0f8,$0f7,$0f6,$0f5
	dc.w	$0f4,$0f3,$0f2,$0f1,$0f0,$1f0,$2f0,$3f0,$4f0,$5f0
	dc.w	$6f0,$7f0,$8f0,$9f0,$af0,$bf0,$cf0,$df0,$ef0,$ff0
	dc.w	$fe0,$fd0,$fc0,$fb0,$fa0,$f90,$f80,$f70,$f60,$f50
	dc.w	$f40,$f30,$f20,$f10,$f00,$f01,$f02,$f03,$f04,$f05
	dc.w	$f06,$f07,$f08,$f09,$f0a,$f0b,$f0c,$f0d,$f0e,$f0f
	dc.w	$e0e,$d0d,$c0c,$b0b,$a0a,$909,$808,$707,$606
	dc.w	$505,$404,$303,$202,$101,$000
	dc.w	$001,$002,$003,$004,$005,$006,$007,$008,$009,$00a
	dc.w	$00b,$00c,$00d,$00e,$00f
	dc.w	$01f,$02f,$03f,$04f,$05f
	dc.w	$06f,$07f,$08f,$09f,$0af,$0bf,$0cf,$0df,$0ef,$0ff
	dc.w	$0fe,$0fd,$0fc,$0fb,$0fa,$0f9,$0f8,$0f7,$0f6,$0f5
	dc.w	$0f4,$0f3,$0f2,$0f1,$0f0,$1f0,$2f0,$3f0,$4f0,$5f0
	dc.w	$6f0,$7f0,$8f0,$9f0,$af0,$bf0,$cf0,$df0,$ef0,$ff0
	dc.w	$fe0,$fd0,$fc0,$fb0,$fa0,$f90,$f80,$f70,$f60,$f50
	dc.w	$f40,$f30,$f20,$f10,$f00,$f01,$f02,$f03,$f04,$f05
	dc.w	$f06,$f07,$f08,$f09,$f0a,$f0b,$f0c,$f0d,$f0e,$f0f
	dc.w	$e0e,$d0d,$c0c,$b0b,$a0a,$909,$808,$707,$606
	dc.w	$505,$404,$303,$202,$101,$000


Pointer1:
	dcb.w	10,0

Pointer2:
	dcb.w	10,0

AddTable:
	dc.b	$c4,$a2,$44,$a0,$24,$42,$a0,$22,$a4,$c2

; ColorSequColorEnd-ColorTable

NUMCTAB		equ	512

Stripe:
	dc.w	NUMCTAB*4

; Die graue Leiste, die die Farbigen "kreuzt"

Stable:
	dc.w	$000,$111,$222,$444,$555,$666,$777,$888,$888,$999,$999
	dc.w	$aaa,$aaa,$bbb,$bbb,$ccc,$ccc,$ddd,$ddd,$eee,$eee,$eee
	dc.w	$fff,$fff,$fff,$fff,$fff,$eee,$eee,$eee,$ddd,$ddd,$ccc
	dc.w	$ccc,$bbb,$bbb,$aaa,$aaa,$999,$999,$888,$888,$777,$666
	dc.w	$555,$444,$333,$222,$111,$000
Stend:

STLINES	equ	Stend-Stable

*****************************************************************************
;			Puffer viele
*****************************************************************************

	SECTION	BUFFER,BSS

CLSIZE		equ	2*XLINES*YLINES

ColBuf:
	ds.b	CLSIZE


*****************************************************************************
;			Copperlist
*****************************************************************************

	SECTION	BUFFER2,BSS_C

CSIZE		equ	XLINES*YLINES*8+12

Copperlist:
	ds.b	CSIZE

	end

Man wrde nicht sagen, dass keine Bitplanes aktiviert sind, oder?
                                                                                                                                                                                                                                                 234567890123456789012345678901234567890
	dc.b	'                                        ' ; 1
	dc.b	'  SECONDA RIGA (solo in testo2)         ' ; 2
	dc.b	'     /\  /          ##                  ' ; 3
	dc.b	'    /  \/           ##                  ' ; 4
	dc.b	'                    ##                  ' ; 5
	dc.b	'        SESTA RIGA (entrambi i Bitplane)' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO        COMMUNICATION INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1234567 90  @#$%^&*( _+|\=-[]{}      ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	'     LA PALINGENETICA  B I E A I N      ' ; 15
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 16
	dc.b	'  Nel       del cammin di        vita   ' ; 17
	dc.b	'                                        ' ; 18
	dc.b	'    Mi          pEr UnA       oScuRa    ' ; 19
	dc.b	'                                        ' ; 20
	dc.b	'    CHE LA         VIA ERA SMARRITA     ' ; 21
	dc.b	'                                        ' ; 22
	dc.b	'  AHI Quanto a     QUAL ERA...          ' ; 23
	dc.b	'                                        ' ; 24
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ; 27

	even

; Die Font 8x8-Zeichen, die in CHIP von der CPU und nicht vom Blitter kopiert wurden,
; so kann es auch im FAST RAM sein. In der Tat wre es besser!

Font:
	incbin	"/Sources/nice.fnt"

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT
	dc.w	$90,DIWST			; DIWSTOP
	dc.w	$92,DDFS			; DDFSTRT
	dc.w	$94,DDFST			; DDFSTOP

	dc.w	$102,$0				; BPLCON1
	dc.w	$104,$0				; BPLCON2
	dc.w	$108,$0				; BPL1MOD
	dc.w	$10a,$0				; BPL2MOD

Bplpointers:
	dc.w	$E0,0,$E2,0,$E4,0,$E6,0
	dc.w	$100,BPLC0			; BPLCON0 - 2 Bitplanes lowres
	dc.w	$184,$fff			; COLOR02 gelb (der feste)

CopperEffyz:
	dcb.w	28*8*7				; Platz fr den Effekt
	dc.w	$ffff,$fffe

*****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane1:
	ds.b	40*256
Bitplane2:
	ds.b	40*256

	end

Haben Sie die italienische Flagge bemerkt?

                                                                                                                                                                                   N WEG
								; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
								; (Das $20 entspricht), IN $00, DAS
								; AUSRUFUNGSZEICHEN ($21) IN $01...
	lsl.w	#3,d2				; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
								; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2			; FINDE DEN GEWNSCHTEN BUCHSTABEN IM FONT...

	move.l	PointerBitplane(pc),a3 ; Adresse Ziel-Bitplane in a3

								; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)			; Drucke Zeile 1 des Zeichens
	move.b	(a2)+,40(a3)		; Drucke Zeile  2  " "
	move.b	(a2)+,40*2(a3)		; Drucke Zeile  3  " "
	move.b	(a2)+,40*3(a3)		; Drucke Zeile  4  " "
	move.b	(a2)+,40*4(a3)		; Drucke Zeile  5  " "
	move.b	(a2)+,40*5(a3)		; Drucke Zeile  6  " "
	move.b	(a2)+,40*6(a3)		; Drucke Zeile  7  " "
	move.b	(a2)+,40*7(a3)		; Drucke Zeile  8  " "

	addq.l	#1,PointerBitplane	; wir rcken 8 Bits vor (NCHSTES ZEICHEN)
	addq.l	#1,PointerText		; nchstes zu druckendes Zeichen

EndText:
	movem.l	(sp)+,d2/a0/a2-a3
	rts


PointerText:
	dc.l	Text

PointerBitplane:
	dc.l	Bitplane

;	$00 fr "Zeilenende" - $ff fr "Textende"

		; Anzahl der Zeichen pro Zeile: 40
Text:	     ;		  1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'                                        ',0 ; 1
	dc.b	'    Questo listato cambia ad ogni       ',0 ; 2	Dieses Listing ndert mit jeder
	dc.b	'                                        ',0 ; 3
	dc.b	'    linea sia il COLOR01 ($dff184),     ',0 ; 4	Zeile COLOR01 ($dff184),
	dc.b	'                                        ',0 ; 5
	dc.b	'    che il BPLCON1 ($dff102). Notate    ',0 ; 6	sowie die BPLCON1 ($dff102). Notiz
	dc.b	'                                        ',0 ; 7
	dc.b	'    come si possano "unire" listati     ',0 ; 8	wie Sie Eintrge "zusammenfhren" knnen
	dc.b	'                                        ',0 ; 9
	dc.b	'    visti in precedenza in un solo      ',0 ; 10	zuvor in einem Effekt gesehen
	dc.b	'                                        ',0 ; 11
	dc.b	'    effetto. Si potrebbero cambiare     ',0 ; 12	Sie knnten 
	dc.b	'                                        ',0 ; 13
	dc.b	'    anche altri colori e i moduli per   ',0 ; 14   auch andere Farben und Modulo
	dc.b	'                                        ',0 ; 15
	dc.b	'    ogni linea, se avete voglia         ',0 ; 16   jede Zeile ndern, wenn Sie Lust dazu haben
	dc.b	'                                        ',0 ; 17
	dc.b	'    provate!                            ',$ff ; 18 Versuchen Sie es!

	even

; Die Font-Zeichen 8x8 (in CHIP von der CPU und nicht vom Blitter kopiert,
; so kann es auch im FAST RAM sein. In der Tat wre es besser!

Font:
	incbin	"/Sources/nice.fnt"

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,DIWS			; DIWSTRT	($cC81)
	dc.w	$90,DIWST			; DIWSTOP	($cc1)
	dc.w	$92,DDFS			; DDFSTRT	($38)
	dc.w	$94,DDFST			; DDFSTOP	($d0)
	dc.w	$100,BPLC0			; BPLCON0	($1200)
	dc.w	$180,$000			; COLOR00 schwarz
	dc.w	$182,$eee			; COLOR01 wei
Bplpointers:
	dc.w	$e0,$0000			; Bpl0h
	dc.w	$e2,$0000			; Bpl0l
	dc.w	$102,$0				; BPLCON1
	dc.w	$104,$0				; BPLCON2
	dc.w	$108,$0				; BPL1MOD
	dc.w	$10a,$0				; BPL2MOD
		
CopperEffect:
	dcb.l	801,0				; Platz fr den Effekt (Achtung! bei
								; nderungen kann der Effekt
								; grer oder kleiner werden)
	dc.w	$ffff,$fffe			; Ende Copperlist

*****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256				; eine Bitplane lowres 320x256

	end

Mglicherweise haben Sie bemerkt, dass Verwicklungen und viele seltsame 
Schleifen durch Zhlern in den Routinen reguliert werden. 
Dies wird verwendet um diesen Farbeffekt zu erzeugen.
Es ist ein einfacher Bildlauf nach oben oder unten, aber "das Durcheinander"
wird durch verschiedene Passagen erzeugt.
